// Auto-generated by Stone, do not modify.
/**
 * An Error object returned from a route.
 * @typedef {Object} Error
 * @property {string} error_summary - Text summary of the error.
 * @property {T} error - The error object.
 * @property {UserMessage} user_message - An optional field. If present, it includes a
    message that can be shown directly to the end user of your app. You should show this message
    if your app is unprepared to programmatically handle the error returned by an endpoint.
 * @template T
 */

/**
 * User-friendly error message.
 * @typedef {Object} UserMessage
 * @property {string} text - The message.
 * @property {string} locale
 */

 /**
  * @typedef {string} Timestamp
  */

/**
 * Result returned by methods that may either launch an asynchronous job or
 * complete synchronously. Upon synchronous completion of the job, no additional
 * information is returned.
 * @typedef {Object} AsyncLaunchEmptyResult
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by methods that launch an asynchronous job. A method who may
 * either launch an asynchronous job, or complete the request synchronously, can
 * use this union by extending it, and adding a 'complete' field with the type
 * of the synchronous response. See LaunchEmptyResult for an example.
 * @typedef {Object} AsyncLaunchResultBase
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {'async_job_id'} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for methods that poll the status of an asynchronous job.
 * @typedef {Object} AsyncPollArg
 * @property {string} async_job_id - Id of the asynchronous job. This is the
 * value of a response returned from the method that launched the job.
 */

/**
 * Result returned by methods that poll for the status of an asynchronous job.
 * Upon completion of the job, no additional information is returned.
 * @typedef {Object} AsyncPollEmptyResult
 * @property {('in_progress'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * Error returned by methods for polling the status of asynchronous job.
 * @typedef {Object} AsyncPollError
 * @property {('invalid_async_job_id'|'internal_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by methods that poll for the status of an asynchronous job.
 * Unions that extend this union should add a 'complete' field with a type of
 * the information returned upon job completion. See PollEmptyResult for an
 * example.
 * @typedef {Object} AsyncPollResultBase
 * @property {'in_progress'} .tag - Tag identifying the union variant.
 */

/**
 * Error occurred because the account doesn't have permission to access the
 * resource.
 * @typedef {Object} AuthAccessError
 * @property {AuthInvalidAccountTypeError} [invalid_account_type] - Available if
 * .tag is invalid_account_type. Current account type cannot access the
 * resource.
 * @property {AuthPaperAccessError} [paper_access_denied] - Available if .tag is
 * paper_access_denied. Current account cannot access Paper.
 * @property {('invalid_account_type'|'paper_access_denied'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Errors occurred during authentication.
 * @typedef {Object} AuthAuthError
 * @property {AuthTokenScopeError} [missing_scope] - Available if .tag is
 * missing_scope. The access token does not have the required scope to access
 * the route.
 * @property {('invalid_access_token'|'invalid_select_user'|'invalid_select_admin'|'user_suspended'|'expired_access_token'|'missing_scope'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} AuthInvalidAccountTypeError
 * @property {('endpoint'|'feature'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} AuthPaperAccessError
 * @property {('paper_disabled'|'not_paper_user'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Error occurred because the app is being rate limited.
 * @typedef {Object} AuthRateLimitError
 * @property {AuthRateLimitReason} reason - The reason why the app is being rate
 * limited.
 * @property {number} retry_after - The number of seconds that the app should
 * wait before making another request.
 */

/**
 * @typedef {Object} AuthRateLimitReason
 * @property {('too_many_requests'|'too_many_write_operations'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} AuthTokenFromOAuth1Arg
 * @property {string} oauth1_token - The supplied OAuth 1.0 access token.
 * @property {string} oauth1_token_secret - The token secret associated with the
 * supplied access token.
 */

/**
 * @typedef {Object} AuthTokenFromOAuth1Error
 * @property {('invalid_oauth1_token_info'|'app_id_mismatch'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} AuthTokenFromOAuth1Result
 * @property {string} oauth2_token - The OAuth 2.0 token generated from the
 * supplied OAuth 1.0 token.
 */

/**
 * @typedef {Object} AuthTokenScopeError
 * @property {string} required_scope - The required scope to access the route.
 */

/**
 * @typedef {Object} CommonPathRoot
 * @property {string} [root] - Available if .tag is root. Paths are relative to
 * the authenticating user's root namespace (This results in
 * :field:`PathRootError.invalid_root` if the user's root namespace has
 * changed.).
 * @property {string} [namespace_id] - Available if .tag is namespace_id. Paths
 * are relative to given namespace id (This results in
 * :field:`PathRootError.no_permission` if you don't have access to this
 * namespace.).
 * @property {('home'|'root'|'namespace_id'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} CommonPathRootError
 * @property {(CommonTeamRootInfo|CommonUserRootInfo|CommonRootInfo)}
 * [invalid_root] - Available if .tag is invalid_root. The root namespace id in
 * Dropbox-API-Path-Root header is not valid. The value of this error is use's
 * latest root info.
 * @property {('invalid_root'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about current user's root.
 * @typedef {Object} CommonRootInfo
@property {("team"|"user")} .tag - Tag identifying the subtype variant.
 * @property {string} root_namespace_id - The namespace ID for user's root
 * namespace. It will be the namespace ID of the shared team root if the user is
 * member of a team with a separate team root. Otherwise it will be same as
 * RootInfo.home_namespace_id.
 * @property {string} home_namespace_id - The namespace ID for user's home
 * namespace.
 */

/**
 * Root info when user is member of a team with a separate root namespace ID.
 * @typedef {Object} CommonTeamRootInfo
@property {'team'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} root_namespace_id - The namespace ID for user's root
 * namespace. It will be the namespace ID of the shared team root if the user is
 * member of a team with a separate team root. Otherwise it will be same as
 * RootInfo.home_namespace_id.
 * @property {string} home_namespace_id - The namespace ID for user's home
 * namespace.
 * @property {string} home_path - The path for user's home directory under the
 * shared team root.
 */

/**
 * Root info when user is not member of a team or the user is a member of a team
 * and the team does not have a separate root namespace.
 * @typedef {Object} CommonUserRootInfo
@property {'user'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} root_namespace_id - The namespace ID for user's root
 * namespace. It will be the namespace ID of the shared team root if the user is
 * member of a team with a separate team root. Otherwise it will be same as
 * RootInfo.home_namespace_id.
 * @property {string} home_namespace_id - The namespace ID for user's home
 * namespace.
 */

/**
 * @typedef {Object} ContactsDeleteManualContactsArg
 * @property {Array.<Object>} email_addresses - List of manually added contacts
 * to be deleted.
 */

/**
 * @typedef {Object} ContactsDeleteManualContactsError
 * @property {Array.<Object>} [contacts_not_found] - Available if .tag is
 * contacts_not_found. Can't delete contacts from this list. Make sure the list
 * only has manually added contacts. The deletion was cancelled.
 * @property {('contacts_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesAddPropertiesArg
 * @property {string} path - A unique identifier for the file or folder.
 * @property {Array.<FilePropertiesPropertyGroup>} property_groups - The
 * property groups which are to be added to a Dropbox file.
 */

/**
 * @typedef {Object} FilePropertiesAddPropertiesError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {FilePropertiesLookupError} [path] - Available if .tag is path.
 * @property {('template_not_found'|'restricted_content'|'other'|'path'|'unsupported_folder'|'property_field_too_large'|'does_not_fit_template'|'property_group_already_exists')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesAddTemplateArg
 * @property {string} name - Display name for the template. Template names can
 * be up to 256 bytes.
 * @property {string} description - Description for the template. Template
 * descriptions can be up to 1024 bytes.
 * @property {Array.<FilePropertiesPropertyFieldTemplate>} fields - Definitions
 * of the property fields associated with this template. There can be up to 32
 * properties in a single template.
 */

/**
 * @typedef {Object} FilePropertiesAddTemplateResult
 * @property {string} template_id - An identifier for template added by  See
 * templates/add_for_user or templates/add_for_team.
 */

/**
 * @typedef {Object} FilePropertiesGetTemplateArg
 * @property {string} template_id - An identifier for template added by route
 * See templates/add_for_user or templates/add_for_team.
 */

/**
 * @typedef {Object} FilePropertiesGetTemplateResult
 * @property {string} name - Display name for the template. Template names can
 * be up to 256 bytes.
 * @property {string} description - Description for the template. Template
 * descriptions can be up to 1024 bytes.
 * @property {Array.<FilePropertiesPropertyFieldTemplate>} fields - Definitions
 * of the property fields associated with this template. There can be up to 32
 * properties in a single template.
 */

/**
 * @typedef {Object} FilePropertiesInvalidPropertyGroupError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {FilePropertiesLookupError} [path] - Available if .tag is path.
 * @property {('template_not_found'|'restricted_content'|'other'|'path'|'unsupported_folder'|'property_field_too_large'|'does_not_fit_template')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesListTemplateResult
 * @property {Array.<Object>} template_ids - List of identifiers for templates
 * added by  See templates/add_for_user or templates/add_for_team.
 */

/**
 * Logical operator to join search queries together.
 * @typedef {Object} FilePropertiesLogicalOperator
 * @property {('or_operator'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesLookUpPropertiesError
 * @property {('property_group_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesLookupError
 * @property {string} [malformed_path] - Available if .tag is malformed_path.
 * @property {('malformed_path'|'not_found'|'not_file'|'not_folder'|'restricted_content'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesModifyTemplateError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {('template_not_found'|'restricted_content'|'other'|'conflicting_property_names'|'too_many_properties'|'too_many_templates'|'template_attribute_too_large')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesOverwritePropertyGroupArg
 * @property {string} path - A unique identifier for the file or folder.
 * @property {Array.<FilePropertiesPropertyGroup>} property_groups - The
 * property groups "snapshot" updates to force apply.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {FilePropertiesLookupError} [path] - Available if .tag is path.
 * @property {('template_not_found'|'restricted_content'|'other'|'path'|'unsupported_folder')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchArg
 * @property {Array.<FilePropertiesPropertiesSearchQuery>} queries - Queries to
 * search.
 * @property {FilePropertiesTemplateFilter} template_filter - Filter results to
 * contain only properties associated with these template IDs.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchContinueArg
 * @property {string} cursor - The cursor returned by your last call to
 * properties/search or properties/search/continue.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchContinueError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchError
 * @property {FilePropertiesLookUpPropertiesError} [property_group_lookup] -
 * Available if .tag is property_group_lookup.
 * @property {('property_group_lookup'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchMatch
 * @property {string} id - The ID for the matched file or folder.
 * @property {string} path - The path for the matched file or folder.
 * @property {boolean} is_deleted - Whether the file or folder is deleted.
 * @property {Array.<FilePropertiesPropertyGroup>} property_groups - List of
 * custom property groups associated with the file.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchMode
 * @property {string} [field_name] - Available if .tag is field_name. Search for
 * a value associated with this field name.
 * @property {('field_name'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchQuery
 * @property {string} query - The property field value for which to search
 * across templates.
 * @property {FilePropertiesPropertiesSearchMode} mode - The mode with which to
 * perform the search.
 * @property {FilePropertiesLogicalOperator} logical_operator - The logical
 * operator with which to append the query.
 */

/**
 * @typedef {Object} FilePropertiesPropertiesSearchResult
 * @property {Array.<FilePropertiesPropertiesSearchMatch>} matches - A list
 * (possibly empty) of matches for the query.
 * @property {string} [cursor] - Pass the cursor into properties/search/continue
 * to continue to receive search results. Cursor will be null when there are no
 * more results.
 */

/**
 * Raw key/value data to be associated with a Dropbox file. Property fields are
 * added to Dropbox files as a PropertyGroup.
 * @typedef {Object} FilePropertiesPropertyField
 * @property {string} name - Key of the property field associated with a file
 * and template. Keys can be up to 256 bytes.
 * @property {string} value - Value of the property field associated with a file
 * and template. Values can be up to 1024 bytes.
 */

/**
 * Defines how a single property field may be structured. Used exclusively by
 * PropertyGroupTemplate.
 * @typedef {Object} FilePropertiesPropertyFieldTemplate
 * @property {string} name - Key of the property field being described. Property
 * field keys can be up to 256 bytes.
 * @property {string} description - Description of the property field. Property
 * field descriptions can be up to 1024 bytes.
 * @property {FilePropertiesPropertyType} type - Data type of the value of this
 * property field. This type will be enforced upon property creation and
 * modifications.
 */

/**
 * A subset of the property fields described by the corresponding
 * PropertyGroupTemplate. Properties are always added to a Dropbox file as a
 * PropertyGroup. The possible key names and value types in this group are
 * defined by the corresponding PropertyGroupTemplate.
 * @typedef {Object} FilePropertiesPropertyGroup
 * @property {string} template_id - A unique identifier for the associated
 * template.
 * @property {Array.<FilePropertiesPropertyField>} fields - The actual
 * properties associated with the template. There can be up to 32 property types
 * per template.
 */

/**
 * Defines how a property group may be structured.
 * @typedef {Object} FilePropertiesPropertyGroupTemplate
 * @property {string} name - Display name for the template. Template names can
 * be up to 256 bytes.
 * @property {string} description - Description for the template. Template
 * descriptions can be up to 1024 bytes.
 * @property {Array.<FilePropertiesPropertyFieldTemplate>} fields - Definitions
 * of the property fields associated with this template. There can be up to 32
 * properties in a single template.
 */

/**
 * @typedef {Object} FilePropertiesPropertyGroupUpdate
 * @property {string} template_id - A unique identifier for a property template.
 * @property {Array.<FilePropertiesPropertyField>} [add_or_update_fields] -
 * Property fields to update. If the property field already exists, it is
 * updated. If the property field doesn't exist, the property group is added.
 * @property {Array.<string>} [remove_fields] - Property fields to remove (by
 * name), provided they exist.
 */

/**
 * Data type of the given property field added.
 * @typedef {Object} FilePropertiesPropertyType
 * @property {('string'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesRemovePropertiesArg
 * @property {string} path - A unique identifier for the file or folder.
 * @property {Array.<Object>} property_template_ids - A list of identifiers for
 * a template created by templates/add_for_user or templates/add_for_team.
 */

/**
 * @typedef {Object} FilePropertiesRemovePropertiesError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {FilePropertiesLookupError} [path] - Available if .tag is path.
 * @property {FilePropertiesLookUpPropertiesError} [property_group_lookup] -
 * Available if .tag is property_group_lookup.
 * @property {('template_not_found'|'restricted_content'|'other'|'path'|'unsupported_folder'|'property_group_lookup')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesRemoveTemplateArg
 * @property {string} template_id - An identifier for a template created by
 * templates/add_for_user or templates/add_for_team.
 */

/**
 * @typedef {Object} FilePropertiesTemplateError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {('template_not_found'|'restricted_content'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesTemplateFilter
 * @property {Array.<Object>} [filter_some] - Available if .tag is filter_some.
 * Only templates with an ID in the supplied list will be returned (a subset of
 * templates will be returned).
 * @property {('filter_some'|'other'|'filter_none')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesTemplateFilterBase
 * @property {Array.<Object>} [filter_some] - Available if .tag is filter_some.
 * Only templates with an ID in the supplied list will be returned (a subset of
 * templates will be returned).
 * @property {('filter_some'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesTemplateOwnerType
 * @property {('user'|'team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesUpdatePropertiesArg
 * @property {string} path - A unique identifier for the file or folder.
 * @property {Array.<FilePropertiesPropertyGroupUpdate>} update_property_groups
 * - The property groups "delta" updates to apply.
 */

/**
 * @typedef {Object} FilePropertiesUpdatePropertiesError
 * @property {string} [template_not_found] - Available if .tag is
 * template_not_found. Template does not exist for the given identifier.
 * @property {FilePropertiesLookupError} [path] - Available if .tag is path.
 * @property {FilePropertiesLookUpPropertiesError} [property_group_lookup] -
 * Available if .tag is property_group_lookup.
 * @property {('template_not_found'|'restricted_content'|'other'|'path'|'unsupported_folder'|'property_field_too_large'|'does_not_fit_template'|'property_group_lookup')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilePropertiesUpdateTemplateArg
 * @property {string} template_id - An identifier for template added by  See
 * templates/add_for_user or templates/add_for_team.
 * @property {string} [name] - A display name for the template. template names
 * can be up to 256 bytes.
 * @property {string} [description] - Description for the new template. Template
 * descriptions can be up to 1024 bytes.
 * @property {Array.<FilePropertiesPropertyFieldTemplate>} [add_fields] -
 * Property field templates to be added to the group template. There can be up
 * to 32 properties in a single template.
 */

/**
 * @typedef {Object} FilePropertiesUpdateTemplateResult
 * @property {string} template_id - An identifier for template added by route
 * See templates/add_for_user or templates/add_for_team.
 */

/**
 * There was an error counting the file requests.
 * @typedef {Object} FileRequestsCountFileRequestsError
 * @property {('disabled_for_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result for count.
 * @typedef {Object} FileRequestsCountFileRequestsResult
 * @property {number} file_request_count - The number file requests owner by
 * this user.
 */

/**
 * Arguments for create.
 * @typedef {Object} FileRequestsCreateFileRequestArgs
 * @property {string} title - The title of the file request. Must not be empty.
 * @property {string} destination - The path of the folder in the Dropbox where
 * uploaded files will be sent. For apps with the app folder permission, this
 * will be relative to the app folder.
 * @property {FileRequestsFileRequestDeadline} [deadline] - The deadline for the
 * file request. Deadlines can only be set by Professional and Business
 * accounts.
 * @property {boolean} open - Whether or not the file request should be open. If
 * the file request is closed, it will not accept any file submissions, but it
 * can be opened later.
 */

/**
 * There was an error creating the file request.
 * @typedef {Object} FileRequestsCreateFileRequestError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error'|'invalid_location'|'rate_limit')} .tag - Tag identifying the union variant.
 */

/**
 * There was an error deleting all closed file requests.
 * @typedef {Object} FileRequestsDeleteAllClosedFileRequestsError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error')} .tag - Tag identifying the union variant.
 */

/**
 * Result for delete_all_closed.
 * @typedef {Object} FileRequestsDeleteAllClosedFileRequestsResult
 * @property {Array.<FileRequestsFileRequest>} file_requests - The file requests
 * deleted for this user.
 */

/**
 * Arguments for delete.
 * @typedef {Object} FileRequestsDeleteFileRequestArgs
 * @property {Array.<Object>} ids - List IDs of the file requests to delete.
 */

/**
 * There was an error deleting these file requests.
 * @typedef {Object} FileRequestsDeleteFileRequestError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error'|'file_request_open')} .tag - Tag identifying the union variant.
 */

/**
 * Result for delete.
 * @typedef {Object} FileRequestsDeleteFileRequestsResult
 * @property {Array.<FileRequestsFileRequest>} file_requests - The file requests
 * deleted by the request.
 */

/**
 * A file request https://www.dropbox.com/help/9090 for receiving files into the
 * user's Dropbox account.
 * @typedef {Object} FileRequestsFileRequest
 * @property {string} id - The ID of the file request.
 * @property {string} url - The URL of the file request.
 * @property {string} title - The title of the file request.
 * @property {Timestamp} created - When this file request was created.
 * @property {boolean} is_open - Whether or not the file request is open. If the
 * file request is closed, it will not accept any more file submissions.
 * @property {number} file_count - The number of files this file request has
 * received.
 * @property {string} [destination] - The path of the folder in the Dropbox
 * where uploaded files will be sent. This can be null if the destination was
 * removed. For apps with the app folder permission, this will be relative to
 * the app folder.
 * @property {FileRequestsFileRequestDeadline} [deadline] - The deadline for
 * this file request. Only set if the request has a deadline.
 */

/**
 * @typedef {Object} FileRequestsFileRequestDeadline
 * @property {Timestamp} deadline - The deadline for this file request.
 * @property {FileRequestsGracePeriod} [allow_late_uploads] - If set, allow
 * uploads after the deadline has passed. These     uploads will be marked
 * overdue.
 */

/**
 * There is an error with the file request.
 * @typedef {Object} FileRequestsFileRequestError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error')} .tag - Tag identifying the union variant.
 */

/**
 * There is an error accessing the file requests functionality.
 * @typedef {Object} FileRequestsGeneralFileRequestsError
 * @property {('disabled_for_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for get.
 * @typedef {Object} FileRequestsGetFileRequestArgs
 * @property {string} id - The ID of the file request to retrieve.
 */

/**
 * There was an error retrieving the specified file request.
 * @typedef {Object} FileRequestsGetFileRequestError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FileRequestsGracePeriod
 * @property {('one_day'|'two_days'|'seven_days'|'thirty_days'|'always'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for list:2.
 * @typedef {Object} FileRequestsListFileRequestsArg
 * @property {number} limit - The maximum number of file requests that should be
 * returned per request.
 */

/**
 * @typedef {Object} FileRequestsListFileRequestsContinueArg
 * @property {string} cursor - The cursor returned by the previous API call
 * specified in the endpoint description.
 */

/**
 * There was an error retrieving the file requests.
 * @typedef {Object} FileRequestsListFileRequestsContinueError
 * @property {('disabled_for_team'|'other'|'invalid_cursor')} .tag - Tag identifying the union variant.
 */

/**
 * There was an error retrieving the file requests.
 * @typedef {Object} FileRequestsListFileRequestsError
 * @property {('disabled_for_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result for list.
 * @typedef {Object} FileRequestsListFileRequestsResult
 * @property {Array.<FileRequestsFileRequest>} file_requests - The file requests
 * owned by this user. Apps with the app folder permission will only see file
 * requests in their app folder.
 */

/**
 * Result for list:2 and list/continue.
 * @typedef {Object} FileRequestsListFileRequestsV2Result
 * @property {Array.<FileRequestsFileRequest>} file_requests - The file requests
 * owned by this user. Apps with the app folder permission will only see file
 * requests in their app folder.
 * @property {string} cursor - Pass the cursor into list/continue to obtain
 * additional file requests.
 * @property {boolean} has_more - Is true if there are additional file requests
 * that have not been returned yet. An additional call to :route:list/continue`
 * can retrieve them.
 */

/**
 * Arguments for update.
 * @typedef {Object} FileRequestsUpdateFileRequestArgs
 * @property {string} id - The ID of the file request to update.
 * @property {string} [title] - The new title of the file request. Must not be
 * empty.
 * @property {string} [destination] - The new path of the folder in the Dropbox
 * where uploaded files will be sent. For apps with the app folder permission,
 * this will be relative to the app folder.
 * @property {FileRequestsUpdateFileRequestDeadline} deadline - The new deadline
 * for the file request. Deadlines can only be set by Professional and Business
 * accounts.
 * @property {boolean} [open] - Whether to set this file request as open or
 * closed.
 */

/**
 * @typedef {Object} FileRequestsUpdateFileRequestDeadline
 * @property {FileRequestsFileRequestDeadline} [update] - Available if .tag is
 * update. If :val:`null`, the file request's deadline is cleared.
 * @property {('no_update'|'update'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * There is an error updating the file request.
 * @typedef {Object} FileRequestsUpdateFileRequestError
 * @property {('disabled_for_team'|'other'|'not_found'|'not_a_folder'|'app_lacks_access'|'no_permission'|'email_unverified'|'validation_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesAlphaGetMetadataArg
 * @property {string} path - The path of a file or folder on Dropbox.
 * @property {boolean} include_media_info - If true, FileMetadata.media_info is
 * set for photo and video.
 * @property {boolean} include_deleted - If true, DeletedMetadata will be
 * returned for deleted file or folder, otherwise LookupError.not_found will be
 * returned.
 * @property {boolean} include_has_explicit_shared_members - If true, the
 * results will include a flag for each file indicating whether or not  that
 * file has any explicit members.
 * @property {FilePropertiesTemplateFilterBase} [include_property_groups] - If
 * set to a valid list of template IDs, FileMetadata.property_groups is set if
 * there exists property data associated with the file and each of the listed
 * templates.
 * @property {Array.<Object>} [include_property_templates] - If set to a valid
 * list of template IDs, FileMetadata.property_groups is set for files with
 * custom properties.
 */

/**
 * @typedef {Object} FilesAlphaGetMetadataError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {FilePropertiesLookUpPropertiesError} [properties_error] -
 * Available if .tag is properties_error.
 * @property {('path'|'properties_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCommitInfo
 * @property {Object} contents - The file contents to be uploaded.
 * @property {string} path - Path in the user's Dropbox to save the file.
 * @property {FilesWriteMode} mode - Selects what to do if the file already
 * exists.
 * @property {boolean} autorename - If there's a conflict, as determined by
 * mode, have the Dropbox server try to autorename the file to avoid conflict.
 * @property {Timestamp} [client_modified] - The value to store as the
 * client_modified timestamp. Dropbox automatically records the time at which
 * the file was written to the Dropbox servers. It can also record an additional
 * timestamp, provided by Dropbox desktop clients, mobile clients, and API apps
 * of when the file was actually created or modified.
 * @property {boolean} mute - Normally, users are made aware of any file
 * modifications in their Dropbox account via notifications in the client
 * software. If true, this tells the clients that this modification shouldn't
 * result in a user notification.
 * @property {Array.<FilePropertiesPropertyGroup>} [property_groups] - List of
 * custom properties to add to file.
 * @property {boolean} strict_conflict - Be more strict about how each WriteMode
 * detects conflict. For example, always return a conflict error when mode =
 * WriteMode.update and the given "rev" doesn't match the existing file's "rev",
 * even if the existing file has been deleted.
 */

/**
 * @typedef {Object} FilesCommitInfoWithProperties
 * @property {Object} contents - The file contents to be uploaded.
 * @property {string} path - Path in the user's Dropbox to save the file.
 * @property {FilesWriteMode} mode - Selects what to do if the file already
 * exists.
 * @property {boolean} autorename - If there's a conflict, as determined by
 * mode, have the Dropbox server try to autorename the file to avoid conflict.
 * @property {Timestamp} [client_modified] - The value to store as the
 * client_modified timestamp. Dropbox automatically records the time at which
 * the file was written to the Dropbox servers. It can also record an additional
 * timestamp, provided by Dropbox desktop clients, mobile clients, and API apps
 * of when the file was actually created or modified.
 * @property {boolean} mute - Normally, users are made aware of any file
 * modifications in their Dropbox account via notifications in the client
 * software. If true, this tells the clients that this modification shouldn't
 * result in a user notification.
 * @property {Array.<FilePropertiesPropertyGroup>} [property_groups] - List of
 * custom properties to add to file.
 * @property {boolean} strict_conflict - Be more strict about how each WriteMode
 * detects conflict. For example, always return a conflict error when mode =
 * WriteMode.update and the given "rev" doesn't match the existing file's "rev",
 * even if the existing file has been deleted.
 */

/**
 * @typedef {Object} FilesContentSyncSetting
 * @property {string} id - Id of the item this setting is applied to.
 * @property {FilesSyncSetting} sync_setting - Setting for this item.
 */

/**
 * @typedef {Object} FilesContentSyncSettingArg
 * @property {string} id - Id of the item this setting is applied to.
 * @property {FilesSyncSettingArg} sync_setting - Setting for this item.
 */

/**
 * @typedef {Object} FilesCreateFolderArg
 * @property {string} path - Path in the user's Dropbox to create.
 * @property {boolean} autorename - If there's a conflict, have the Dropbox
 * server try to autorename the folder to avoid the conflict.
 */

/**
 * @typedef {Object} FilesCreateFolderBatchArg
 * @property {Array.<Object>} paths - List of paths to be created in the user's
 * Dropbox. Duplicate path arguments in the batch are considered only once.
 * @property {boolean} autorename - If there's a conflict, have the Dropbox
 * server try to autorename the folder to avoid the conflict.
 * @property {boolean} force_async - Whether to force the create to happen
 * asynchronously.
 */

/**
 * @typedef {Object} FilesCreateFolderBatchError
 * @property {('too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCreateFolderBatchJobStatus
 * @property {FilesCreateFolderBatchResult} [complete] - Available if .tag is
 * complete. The batch create folder has finished.
 * @property {FilesCreateFolderBatchError} [failed] - Available if .tag is
 * failed. The batch create folder has failed.
 * @property {('in_progress'|'complete'|'failed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by create_folder_batch that may either launch an asynchronous
 * job or complete synchronously.
 * @typedef {Object} FilesCreateFolderBatchLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesCreateFolderBatchResult} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCreateFolderBatchResult
 * @property {Array.<FilesCreateFolderBatchResultEntry>} entries - Each entry in
 * CreateFolderBatchArg.paths will appear at the same position inside
 * CreateFolderBatchResult.entries.
 */

/**
 * @typedef {Object} FilesCreateFolderBatchResultEntry
 * @property {FilesCreateFolderEntryResult} [success] - Available if .tag is
 * success.
 * @property {FilesCreateFolderEntryError} [failure] - Available if .tag is
 * failure.
 * @property {('success'|'failure')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCreateFolderEntryError
 * @property {FilesWriteError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCreateFolderEntryResult
 * @property {FilesFolderMetadata} metadata - Metadata of the created folder.
 */

/**
 * @typedef {Object} FilesCreateFolderError
 * @property {FilesWriteError} [path] - Available if .tag is path.
 * @property {'path'} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesCreateFolderResult
 * @property {FilesFolderMetadata} metadata - Metadata of the created folder.
 */

/**
 * @typedef {Object} FilesDeleteArg
 * @property {string} path - Path in the user's Dropbox to delete.
 * @property {string} [parent_rev] - Perform delete if given "rev" matches the
 * existing file's latest "rev". This field does not support deleting a folder.
 */

/**
 * @typedef {Object} FilesDeleteBatchArg
 * @property {Array.<FilesDeleteArg>} entries
 */

/**
 * @typedef {Object} FilesDeleteBatchError
 * @property {('too_many_write_operations'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDeleteBatchJobStatus
 * @property {FilesDeleteBatchResult} [complete] - Available if .tag is
 * complete. The batch delete has finished.
 * @property {FilesDeleteBatchError} [failed] - Available if .tag is failed. The
 * batch delete has failed.
 * @property {('in_progress'|'complete'|'failed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by delete_batch that may either launch an asynchronous job or
 * complete synchronously.
 * @typedef {Object} FilesDeleteBatchLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesDeleteBatchResult} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDeleteBatchResult
 * @property {Array.<FilesDeleteBatchResultEntry>} entries - Each entry in
 * DeleteBatchArg.entries will appear at the same position inside
 * DeleteBatchResult.entries.
 */

/**
 * @typedef {Object} FilesDeleteBatchResultData
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - Metadata of the deleted object.
 */

/**
 * @typedef {Object} FilesDeleteBatchResultEntry
 * @property {FilesDeleteBatchResultData} [success] - Available if .tag is
 * success.
 * @property {FilesDeleteError} [failure] - Available if .tag is failure.
 * @property {('success'|'failure')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDeleteError
 * @property {FilesLookupError} [path_lookup] - Available if .tag is
 * path_lookup.
 * @property {FilesWriteError} [path_write] - Available if .tag is path_write.
 * @property {('path_lookup'|'path_write'|'too_many_write_operations'|'too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDeleteResult
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - Metadata of the deleted object.
 */

/**
 * Indicates that there used to be a file or folder at this path, but it no
 * longer exists.
 * @typedef {Object} FilesDeletedMetadata
@property {'deleted'} [.tag] - Tag identifying this subtype variant. This field
is only present when needed to discriminate between multiple possible subtypes.
 * @property {string} name - The last component of the path (including
 * extension). This never contains a slash.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will be null if the file
 * or folder is not mounted.
 * @property {string} [path_display] - The cased path to be used for display
 * purposes only. In rare instances the casing will not correctly match the
 * user's filesystem, but this behavior will match the path provided in the Core
 * API v1, and at least the last path component will have the correct casing.
 * Changes to only the casing of paths won't be returned by
 * list_folder/continue. This field will be null if the file or folder is not
 * mounted.
 * @property {string} [parent_shared_folder_id] - Please use
 * FileSharingInfo.parent_shared_folder_id or
 * FolderSharingInfo.parent_shared_folder_id instead.
 */

/**
 * Dimensions for a photo or video.
 * @typedef {Object} FilesDimensions
 * @property {number} height - Height of the photo/video.
 * @property {number} width - Width of the photo/video.
 */

/**
 * @typedef {Object} FilesDownloadArg
 * @property {string} path - The path of the file to download.
 * @property {string} [rev] - Please specify revision in path instead.
 */

/**
 * @typedef {Object} FilesDownloadError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'unsupported_file'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDownloadZipArg
 * @property {string} path - The path of the folder to download.
 */

/**
 * @typedef {Object} FilesDownloadZipError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'too_large'|'too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesDownloadZipResult
 * @property {FilesFolderMetadata} metadata
 */

/**
 * @typedef {Object} FilesExportArg
 * @property {string} path - The path of the file to be exported.
 */

/**
 * @typedef {Object} FilesExportError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'non_exportable'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Export information for a file.
 * @typedef {Object} FilesExportInfo
 * @property {string} [export_as] - Format to which the file can be exported to.
 */

/**
 * @typedef {Object} FilesExportMetadata
 * @property {string} name - The last component of the path (including
 * extension). This never contains a slash.
 * @property {number} size - The file size in bytes.
 * @property {string} [export_hash] - A hash based on the exported file content.
 * This field can be used to verify data integrity. Similar to content hash. For
 * more information see our Content hash
 * https://www.dropbox.com/developers/reference/content-hash page.
 */

/**
 * @typedef {Object} FilesExportResult
 * @property {FilesExportMetadata} export_metadata - Metadata for the exported
 * version of the file.
 * @property {FilesFileMetadata} file_metadata - Metadata for the original file.
 */

/**
 * @typedef {Object} FilesFileMetadata
@property {'file'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} name - The last component of the path (including
 * extension). This never contains a slash.
 * @property {string} id - A unique identifier for the file.
 * @property {Timestamp} client_modified - For files, this is the modification
 * time set by the desktop client when the file was added to Dropbox. Since this
 * time is not verified (the Dropbox server stores whatever the desktop client
 * sends up), this should only be used for display purposes (such as sorting)
 * and not, for example, to determine if a file has changed or not.
 * @property {Timestamp} server_modified - The last time the file was modified
 * on Dropbox.
 * @property {string} rev - A unique identifier for the current revision of a
 * file. This field is the same rev as elsewhere in the API and can be used to
 * detect changes and avoid conflicts.
 * @property {number} size - The file size in bytes.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will be null if the file
 * or folder is not mounted.
 * @property {string} [path_display] - The cased path to be used for display
 * purposes only. In rare instances the casing will not correctly match the
 * user's filesystem, but this behavior will match the path provided in the Core
 * API v1, and at least the last path component will have the correct casing.
 * Changes to only the casing of paths won't be returned by
 * list_folder/continue. This field will be null if the file or folder is not
 * mounted.
 * @property {string} [parent_shared_folder_id] - Please use
 * FileSharingInfo.parent_shared_folder_id or
 * FolderSharingInfo.parent_shared_folder_id instead.
 * @property {FilesMediaInfo} [media_info] - Additional information if the file
 * is a photo or video. This field will not be set on entries returned by
 * list_folder, list_folder/continue, or get_thumbnail_batch, starting December
 * 2, 2019.
 * @property {FilesSymlinkInfo} [symlink_info] - Set if this file is a symlink.
 * @property {FilesFileSharingInfo} [sharing_info] - Set if this file is
 * contained in a shared folder.
 * @property {boolean} is_downloadable - If true, file can be downloaded
 * directly; else the file must be exported.
 * @property {FilesExportInfo} [export_info] - Information about format this
 * file can be exported to. This filed must be set if is_downloadable is set to
 * false.
 * @property {Array.<FilePropertiesPropertyGroup>} [property_groups] -
 * Additional information if the file has custom properties with the property
 * template specified.
 * @property {boolean} [has_explicit_shared_members] - This flag will only be
 * present if include_has_explicit_shared_members  is true in list_folder or
 * get_metadata. If this  flag is present, it will be true if this file has any
 * explicit shared  members. This is different from sharing_info in that this
 * could be true  in the case where a file has explicit members but is not
 * contained within  a shared folder.
 * @property {string} [content_hash] - A hash of the file content. This field
 * can be used to verify data integrity. For more information see our Content
 * hash https://www.dropbox.com/developers/reference/content-hash page.
 */

/**
 * @typedef {Object} FilesFileOpsResult
 */

/**
 * Sharing info for a file which is contained by a shared folder.
 * @typedef {Object} FilesFileSharingInfo
 * @property {boolean} read_only - True if the file or folder is inside a
 * read-only shared folder.
 * @property {string} parent_shared_folder_id - ID of shared folder that holds
 * this file.
 * @property {string} [modified_by] - The last user who modified the file. This
 * field will be null if the user's account has been deleted.
 */

/**
 * @typedef {Object} FilesFolderMetadata
@property {'folder'} [.tag] - Tag identifying this subtype variant. This field
is only present when needed to discriminate between multiple possible subtypes.
 * @property {string} name - The last component of the path (including
 * extension). This never contains a slash.
 * @property {string} id - A unique identifier for the folder.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will be null if the file
 * or folder is not mounted.
 * @property {string} [path_display] - The cased path to be used for display
 * purposes only. In rare instances the casing will not correctly match the
 * user's filesystem, but this behavior will match the path provided in the Core
 * API v1, and at least the last path component will have the correct casing.
 * Changes to only the casing of paths won't be returned by
 * list_folder/continue. This field will be null if the file or folder is not
 * mounted.
 * @property {string} [parent_shared_folder_id] - Please use
 * FileSharingInfo.parent_shared_folder_id or
 * FolderSharingInfo.parent_shared_folder_id instead.
 * @property {string} [shared_folder_id] - Please use sharing_info instead.
 * @property {FilesFolderSharingInfo} [sharing_info] - Set if the folder is
 * contained in a shared folder or is a shared folder mount point.
 * @property {Array.<FilePropertiesPropertyGroup>} [property_groups] -
 * Additional information if the file has custom properties with the property
 * template specified. Note that only properties associated with user-owned
 * templates, not team-owned templates, can be attached to folders.
 */

/**
 * Sharing info for a folder which is contained in a shared folder or is a
 * shared folder mount point.
 * @typedef {Object} FilesFolderSharingInfo
 * @property {boolean} read_only - True if the file or folder is inside a
 * read-only shared folder.
 * @property {string} [parent_shared_folder_id] - Set if the folder is contained
 * by a shared folder.
 * @property {string} [shared_folder_id] - If this folder is a shared folder
 * mount point, the ID of the shared folder mounted at this location.
 * @property {boolean} traverse_only - Specifies that the folder can only be
 * traversed and the user can only see a limited subset of the contents of this
 * folder because they don't have read access to this folder. They do, however,
 * have access to some sub folder.
 * @property {boolean} no_access - Specifies that the folder cannot be accessed
 * by the user.
 */

/**
 * @typedef {Object} FilesGetCopyReferenceArg
 * @property {string} path - The path to the file or folder you want to get a
 * copy reference to.
 */

/**
 * @typedef {Object} FilesGetCopyReferenceError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesGetCopyReferenceResult
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - Metadata of the file or folder.
 * @property {string} copy_reference - A copy reference to the file or folder.
 * @property {Timestamp} expires - The expiration date of the copy reference.
 * This value is currently set to be far enough in the future so that expiration
 * is effectively not an issue.
 */

/**
 * @typedef {Object} FilesGetMetadataArg
 * @property {string} path - The path of a file or folder on Dropbox.
 * @property {boolean} include_media_info - If true, FileMetadata.media_info is
 * set for photo and video.
 * @property {boolean} include_deleted - If true, DeletedMetadata will be
 * returned for deleted file or folder, otherwise LookupError.not_found will be
 * returned.
 * @property {boolean} include_has_explicit_shared_members - If true, the
 * results will include a flag for each file indicating whether or not  that
 * file has any explicit members.
 * @property {FilePropertiesTemplateFilterBase} [include_property_groups] - If
 * set to a valid list of template IDs, FileMetadata.property_groups is set if
 * there exists property data associated with the file and each of the listed
 * templates.
 */

/**
 * @typedef {Object} FilesGetMetadataError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {'path'} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesGetTemporaryLinkArg
 * @property {string} path - The path to the file you want a temporary link to.
 */

/**
 * @typedef {Object} FilesGetTemporaryLinkError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'email_not_verified'|'unsupported_file'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesGetTemporaryLinkResult
 * @property {FilesFileMetadata} metadata - Metadata of the file.
 * @property {string} link - The temporary link which can be used to stream
 * content the file.
 */

/**
 * @typedef {Object} FilesGetTemporaryUploadLinkArg
 * @property {FilesCommitInfo} commit_info - Contains the path and other
 * optional modifiers for the future upload commit. Equivalent to the parameters
 * provided to upload.
 * @property {number} duration - How long before this link expires, in seconds.
 * Attempting to start an upload with this link longer than this period  of time
 * after link creation will result in an error.
 */

/**
 * @typedef {Object} FilesGetTemporaryUploadLinkResult
 * @property {string} link - The temporary link which can be used to stream a
 * file to a Dropbox location.
 */

/**
 * Arguments for get_thumbnail_batch.
 * @typedef {Object} FilesGetThumbnailBatchArg
 * @property {Array.<FilesThumbnailArg>} entries - List of files to get
 * thumbnails.
 */

/**
 * @typedef {Object} FilesGetThumbnailBatchError
 * @property {('too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesGetThumbnailBatchResult
 * @property {Array.<FilesGetThumbnailBatchResultEntry>} entries - List of files
 * and their thumbnails.
 */

/**
 * @typedef {Object} FilesGetThumbnailBatchResultData
 * @property {FilesFileMetadata} metadata
 * @property {string} thumbnail - A string containing the base64-encoded
 * thumbnail data for this file.
 */

/**
 * @typedef {Object} FilesGetThumbnailBatchResultEntry
 * @property {FilesGetThumbnailBatchResultData} [success] - Available if .tag is
 * success.
 * @property {FilesThumbnailError} [failure] - Available if .tag is failure. The
 * result for this file if it was an error.
 * @property {('success'|'failure'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * GPS coordinates for a photo or video.
 * @typedef {Object} FilesGpsCoordinates
 * @property {number} latitude - Latitude of the GPS coordinates.
 * @property {number} longitude - Longitude of the GPS coordinates.
 */

/**
 * @typedef {Object} FilesListFolderArg
 * @property {string} path - A unique identifier for the file.
 * @property {boolean} recursive - If true, the list folder operation will be
 * applied recursively to all subfolders and the response will contain contents
 * of all subfolders.
 * @property {boolean} include_media_info - If true, FileMetadata.media_info is
 * set for photo and video. This parameter will no longer have an effect
 * starting December 2, 2019.
 * @property {boolean} include_deleted - If true, the results will include
 * entries for files and folders that used to exist but were deleted.
 * @property {boolean} include_has_explicit_shared_members - If true, the
 * results will include a flag for each file indicating whether or not  that
 * file has any explicit members.
 * @property {boolean} include_mounted_folders - If true, the results will
 * include entries under mounted folders which includes app folder, shared
 * folder and team folder.
 * @property {number} [limit] - The maximum number of results to return per
 * request. Note: This is an approximate number and there can be slightly more
 * entries returned in some cases.
 * @property {FilesSharedLink} [shared_link] - A shared link to list the
 * contents of. If the link is password-protected, the password must be
 * provided. If this field is present, ListFolderArg.path will be relative to
 * root of the shared link. Only non-recursive mode is supported for shared
 * link.
 * @property {FilePropertiesTemplateFilterBase} [include_property_groups] - If
 * set to a valid list of template IDs, FileMetadata.property_groups is set if
 * there exists property data associated with the file and each of the listed
 * templates.
 * @property {boolean} include_non_downloadable_files - If true, include files
 * that are not downloadable, i.e. Google Docs.
 */

/**
 * @typedef {Object} FilesListFolderContinueArg
 * @property {string} cursor - The cursor returned by your last call to
 * list_folder or list_folder/continue.
 */

/**
 * @typedef {Object} FilesListFolderContinueError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesListFolderError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesListFolderGetLatestCursorResult
 * @property {string} cursor - Pass the cursor into list_folder/continue to see
 * what's changed in the folder since your previous query.
 */

/**
 * @typedef {Object} FilesListFolderLongpollArg
 * @property {string} cursor - A cursor as returned by list_folder or
 * list_folder/continue. Cursors retrieved by setting
 * ListFolderArg.include_media_info to true are not supported.
 * @property {number} timeout - A timeout in seconds. The request will block for
 * at most this length of time, plus up to 90 seconds of random jitter added to
 * avoid the thundering herd problem. Care should be taken when using this
 * parameter, as some network infrastructure does not support long timeouts.
 */

/**
 * @typedef {Object} FilesListFolderLongpollError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesListFolderLongpollResult
 * @property {boolean} changes - Indicates whether new changes are available. If
 * true, call list_folder/continue to retrieve the changes.
 * @property {number} [backoff] - If present, backoff for at least this many
 * seconds before calling list_folder/longpoll again.
 */

/**
 * @typedef {Object} FilesListFolderResult
 * @property
 * {Array.<(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)>}
 * entries - The files and (direct) subfolders in the folder.
 * @property {string} cursor - Pass the cursor into list_folder/continue to see
 * what's changed in the folder since your previous query.
 * @property {boolean} has_more - If true, then there are more entries
 * available. Pass the cursor to list_folder/continue to retrieve the rest.
 */

/**
 * @typedef {Object} FilesListRevisionsArg
 * @property {string} path - The path to the file you want to see the revisions
 * of.
 * @property {FilesListRevisionsMode} mode - Determines the behavior of the API
 * in listing the revisions for a given file path or id.
 * @property {number} limit - The maximum number of revision entries returned.
 */

/**
 * @typedef {Object} FilesListRevisionsError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesListRevisionsMode
 * @property {('path'|'id'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesListRevisionsResult
 * @property {boolean} is_deleted - If the file identified by the latest
 * revision in the response is either deleted or moved.
 * @property {Array.<FilesFileMetadata>} entries - The revisions for the file.
 * Only revisions that are not deleted will show up here.
 * @property {Timestamp} [server_deleted] - The time of deletion if the file was
 * deleted.
 */

/**
 * @typedef {Object} FilesLookupError
 * @property {string} [malformed_path] - Available if .tag is malformed_path.
 * The given path does not satisfy the required path format. Please refer to the
 * :link:`Path formats documentation
 * https://www.dropbox.com/developers/documentation/http/documentation#path-formats`
 * for more information.
 * @property {('malformed_path'|'not_found'|'not_file'|'not_folder'|'restricted_content'|'unsupported_content_type'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesMediaInfo
 * @property {(FilesPhotoMetadata|FilesVideoMetadata)} [metadata] - Available if
 * .tag is metadata. The metadata for the photo/video.
 * @property {('pending'|'metadata')} .tag - Tag identifying the union variant.
 */

/**
 * Metadata for a photo or video.
 * @typedef {Object} FilesMediaMetadata
@property {("photo"|"video")} .tag - Tag identifying the subtype variant.
 * @property {FilesDimensions} [dimensions] - Dimension of the photo/video.
 * @property {FilesGpsCoordinates} [location] - The GPS coordinate of the
 * photo/video.
 * @property {Timestamp} [time_taken] - The timestamp when the photo/video is
 * taken.
 */

/**
 * Metadata for a file or folder.
 * @typedef {Object} FilesMetadata
@property {("file"|"folder"|"deleted")} .tag - Tag identifying the subtype
variant.
 * @property {string} name - The last component of the path (including
 * extension). This never contains a slash.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will be null if the file
 * or folder is not mounted.
 * @property {string} [path_display] - The cased path to be used for display
 * purposes only. In rare instances the casing will not correctly match the
 * user's filesystem, but this behavior will match the path provided in the Core
 * API v1, and at least the last path component will have the correct casing.
 * Changes to only the casing of paths won't be returned by
 * list_folder/continue. This field will be null if the file or folder is not
 * mounted.
 * @property {string} [parent_shared_folder_id] - Please use
 * FileSharingInfo.parent_shared_folder_id or
 * FolderSharingInfo.parent_shared_folder_id instead.
 */

/**
 * @typedef {Object} FilesMoveBatchArg
 * @property {Array.<FilesRelocationPath>} entries - List of entries to be moved
 * or copied. Each entry is RelocationPath.
 * @property {boolean} autorename - If there's a conflict with any file, have
 * the Dropbox server try to autorename that file to avoid the conflict.
 * @property {boolean} allow_ownership_transfer - Allow moves by owner even if
 * it would result in an ownership transfer for the content being moved. This
 * does not apply to copies.
 */

/**
 * Metadata for a photo.
 * @typedef {Object} FilesPhotoMetadata
@property {'photo'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {FilesDimensions} [dimensions] - Dimension of the photo/video.
 * @property {FilesGpsCoordinates} [location] - The GPS coordinate of the
 * photo/video.
 * @property {Timestamp} [time_taken] - The timestamp when the photo/video is
 * taken.
 */

/**
 * @typedef {Object} FilesPreviewArg
 * @property {string} path - The path of the file to preview.
 * @property {string} [rev] - Please specify revision in path instead.
 */

/**
 * @typedef {Object} FilesPreviewError
 * @property {FilesLookupError} [path] - Available if .tag is path. An error
 * occurs when downloading metadata for the file.
 * @property {('path'|'in_progress'|'unsupported_extension'|'unsupported_content')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationArg
 * @property {string} from_path - Path in the user's Dropbox to be copied or
 * moved.
 * @property {string} to_path - Path in the user's Dropbox that is the
 * destination.
 * @property {boolean} allow_shared_folder - If true, copy will copy contents in
 * shared folder, otherwise RelocationError.cant_copy_shared_folder will be
 * returned if from_path contains shared folder. This field is always true for
 * move.
 * @property {boolean} autorename - If there's a conflict, have the Dropbox
 * server try to autorename the file to avoid the conflict.
 * @property {boolean} allow_ownership_transfer - Allow moves by owner even if
 * it would result in an ownership transfer for the content being moved. This
 * does not apply to copies.
 */

/**
 * @typedef {Object} FilesRelocationBatchArg
 * @property {Array.<FilesRelocationPath>} entries - List of entries to be moved
 * or copied. Each entry is RelocationPath.
 * @property {boolean} autorename - If there's a conflict with any file, have
 * the Dropbox server try to autorename that file to avoid the conflict.
 * @property {boolean} allow_shared_folder - If true, copy_batch will copy
 * contents in shared folder, otherwise RelocationError.cant_copy_shared_folder
 * will be returned if RelocationPath.from_path contains shared folder. This
 * field is always true for move_batch.
 * @property {boolean} allow_ownership_transfer - Allow moves by owner even if
 * it would result in an ownership transfer for the content being moved. This
 * does not apply to copies.
 */

/**
 * @typedef {Object} FilesRelocationBatchArgBase
 * @property {Array.<FilesRelocationPath>} entries - List of entries to be moved
 * or copied. Each entry is RelocationPath.
 * @property {boolean} autorename - If there's a conflict with any file, have
 * the Dropbox server try to autorename that file to avoid the conflict.
 */

/**
 * @typedef {Object} FilesRelocationBatchError
 * @property {FilesLookupError} [from_lookup] - Available if .tag is
 * from_lookup.
 * @property {FilesWriteError} [from_write] - Available if .tag is from_write.
 * @property {FilesWriteError} [to] - Available if .tag is to.
 * @property {('from_lookup'|'from_write'|'to'|'cant_copy_shared_folder'|'cant_nest_shared_folder'|'cant_move_folder_into_itself'|'too_many_files'|'duplicated_or_nested_paths'|'cant_transfer_ownership'|'insufficient_quota'|'internal_error'|'cant_move_shared_folder'|'other'|'too_many_write_operations')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationBatchErrorEntry
 * @property {FilesRelocationError} [relocation_error] - Available if .tag is
 * relocation_error. User errors that retry won't help.
 * @property {('relocation_error'|'internal_error'|'too_many_write_operations'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationBatchJobStatus
 * @property {FilesRelocationBatchResult} [complete] - Available if .tag is
 * complete. The copy or move batch job has finished.
 * @property {FilesRelocationBatchError} [failed] - Available if .tag is failed.
 * The copy or move batch job has failed with exception.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by copy_batch or move_batch that may either launch an
 * asynchronous job or complete synchronously.
 * @typedef {Object} FilesRelocationBatchLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesRelocationBatchResult} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationBatchResult
 * @property {Array.<FilesRelocationBatchResultData>} entries
 */

/**
 * @typedef {Object} FilesRelocationBatchResultData
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - Metadata of the relocated object.
 */

/**
 * @typedef {Object} FilesRelocationBatchResultEntry
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * [success] - Available if .tag is success.
 * @property {FilesRelocationBatchErrorEntry} [failure] - Available if .tag is
 * failure.
 * @property {('success'|'failure'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by copy_batch/check:2 or move_batch/check:2 that may either
 * be in progress or completed with result for each entry.
 * @typedef {Object} FilesRelocationBatchV2JobStatus
 * @property {FilesRelocationBatchV2Result} [complete] - Available if .tag is
 * complete. The copy or move batch job has finished.
 * @property {('in_progress'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by copy_batch:2 or move_batch:2 that may either launch an
 * asynchronous job or complete synchronously.
 * @typedef {Object} FilesRelocationBatchV2Launch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesRelocationBatchV2Result} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationBatchV2Result
 * @property {Array.<FilesRelocationBatchResultEntry>} entries - Each entry in
 * CopyBatchArg.entries or MoveBatchArg.entries will appear at the same position
 * inside RelocationBatchV2Result.entries.
 */

/**
 * @typedef {Object} FilesRelocationError
 * @property {FilesLookupError} [from_lookup] - Available if .tag is
 * from_lookup.
 * @property {FilesWriteError} [from_write] - Available if .tag is from_write.
 * @property {FilesWriteError} [to] - Available if .tag is to.
 * @property {('from_lookup'|'from_write'|'to'|'cant_copy_shared_folder'|'cant_nest_shared_folder'|'cant_move_folder_into_itself'|'too_many_files'|'duplicated_or_nested_paths'|'cant_transfer_ownership'|'insufficient_quota'|'internal_error'|'cant_move_shared_folder'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesRelocationPath
 * @property {string} from_path - Path in the user's Dropbox to be copied or
 * moved.
 * @property {string} to_path - Path in the user's Dropbox that is the
 * destination.
 */

/**
 * @typedef {Object} FilesRelocationResult
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - Metadata of the relocated object.
 */

/**
 * @typedef {Object} FilesRestoreArg
 * @property {string} path - The path to save the restored file.
 * @property {string} rev - The revision to restore.
 */

/**
 * @typedef {Object} FilesRestoreError
 * @property {FilesLookupError} [path_lookup] - Available if .tag is
 * path_lookup. An error occurs when downloading metadata for the file.
 * @property {FilesWriteError} [path_write] - Available if .tag is path_write.
 * An error occurs when trying to restore the file to that path.
 * @property {('path_lookup'|'path_write'|'invalid_revision'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSaveCopyReferenceArg
 * @property {string} copy_reference - A copy reference returned by
 * copy_reference/get.
 * @property {string} path - Path in the user's Dropbox that is the destination.
 */

/**
 * @typedef {Object} FilesSaveCopyReferenceError
 * @property {FilesWriteError} [path] - Available if .tag is path.
 * @property {('path'|'invalid_copy_reference'|'no_permission'|'not_found'|'too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSaveCopyReferenceResult
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - The metadata of the saved file or folder in the user's Dropbox.
 */

/**
 * @typedef {Object} FilesSaveUrlArg
 * @property {string} path - The path in Dropbox where the URL will be saved to.
 * @property {string} url - The URL to be saved.
 */

/**
 * @typedef {Object} FilesSaveUrlError
 * @property {FilesWriteError} [path] - Available if .tag is path.
 * @property {('path'|'download_failed'|'invalid_url'|'not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSaveUrlJobStatus
 * @property {FilesFileMetadata} [complete] - Available if .tag is complete.
 * Metadata of the file where the URL is saved to.
 * @property {FilesSaveUrlError} [failed] - Available if .tag is failed.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSaveUrlResult
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesFileMetadata} [complete] - Available if .tag is complete.
 * Metadata of the file where the URL is saved to.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSearchArg
 * @property {string} path - The path in the user's Dropbox to search. Should
 * probably be a folder.
 * @property {string} query - The string to search for. The search string is
 * split on spaces into multiple tokens. For file name searching, the last token
 * is used for prefix matching (i.e. "bat c" matches "bat cave" but not "batman
 * car").
 * @property {number} start - The starting index within the search results (used
 * for paging).
 * @property {number} max_results - The maximum number of search results to
 * return.
 * @property {FilesSearchMode} mode - The search mode (filename,
 * filename_and_content, or deleted_filename). Note that searching file content
 * is only available for Dropbox Business accounts.
 */

/**
 * @typedef {Object} FilesSearchError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSearchMatch
 * @property {FilesSearchMatchType} match_type - The type of the match.
 * @property {(FilesFileMetadata|FilesFolderMetadata|FilesDeletedMetadata)}
 * metadata - The metadata for the matched file or folder.
 */

/**
 * Indicates what type of match was found for a given item.
 * @typedef {Object} FilesSearchMatchType
 * @property {('filename'|'content'|'both')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSearchMode
 * @property {('filename'|'filename_and_content'|'deleted_filename')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSearchResult
 * @property {Array.<FilesSearchMatch>} matches - A list (possibly empty) of
 * matches for the query.
 * @property {boolean} more - Used for paging. If true, indicates there is
 * another page of results available that can be fetched by calling search
 * again.
 * @property {number} start - Used for paging. Value to set the start argument
 * to when calling search to fetch the next page of results.
 */

/**
 * @typedef {Object} FilesSharedLink
 * @property {string} url - Shared link url.
 * @property {string} [password] - Password for the shared link.
 */

/**
 * Sharing info for a file or folder.
 * @typedef {Object} FilesSharingInfo
 * @property {boolean} read_only - True if the file or folder is inside a
 * read-only shared folder.
 */

/**
 * @typedef {Object} FilesSymlinkInfo
 * @property {string} target - The target this symlink points to.
 */

/**
 * @typedef {Object} FilesSyncSetting
 * @property {('default'|'not_synced'|'not_synced_inactive'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSyncSettingArg
 * @property {('default'|'not_synced'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesSyncSettingsError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'unsupported_combination'|'unsupported_configuration'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesThumbnailArg
 * @property {string} path - The path to the image file you want to thumbnail.
 * @property {FilesThumbnailFormat} format - The format for the thumbnail image,
 * jpeg (default) or png. For  images that are photos, jpeg should be preferred,
 * while png is  better for screenshots and digital arts.
 * @property {FilesThumbnailSize} size - The size for the thumbnail image.
 * @property {FilesThumbnailMode} mode - How to resize and crop the image to
 * achieve the desired size.
 */

/**
 * @typedef {Object} FilesThumbnailError
 * @property {FilesLookupError} [path] - Available if .tag is path. An error
 * occurs when downloading metadata for the image.
 * @property {('path'|'unsupported_extension'|'unsupported_image'|'conversion_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesThumbnailFormat
 * @property {('jpeg'|'png')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesThumbnailMode
 * @property {('strict'|'bestfit'|'fitone_bestfit')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesThumbnailSize
 * @property {('w32h32'|'w64h64'|'w128h128'|'w256h256'|'w480h320'|'w640h480'|'w960h640'|'w1024h768'|'w2048h1536')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadError
 * @property {FilesUploadWriteFailed} [path] - Available if .tag is path. Unable
 * to save the uploaded contents to a file.
 * @property {FilePropertiesInvalidPropertyGroupError} [properties_error] -
 * Available if .tag is properties_error. The supplied property group is
 * invalid. The file has uploaded without property groups.
 * @property {('path'|'properties_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadErrorWithProperties
 * @property {FilesUploadWriteFailed} [path] - Available if .tag is path. Unable
 * to save the uploaded contents to a file.
 * @property {FilePropertiesInvalidPropertyGroupError} [properties_error] -
 * Available if .tag is properties_error. The supplied property group is
 * invalid. The file has uploaded without property groups.
 * @property {('path'|'properties_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadSessionAppendArg
 * @property {Object} contents - The file contents to be uploaded.
 * @property {FilesUploadSessionCursor} cursor - Contains the upload session ID
 * and the offset.
 * @property {boolean} close - If true, the current session will be closed, at
 * which point you won't be able to call upload_session/append:2 anymore with
 * the current session.
 */

/**
 * @typedef {Object} FilesUploadSessionCursor
 * @property {Object} contents - The file contents to be uploaded.
 * @property {string} session_id - The upload session ID (returned by
 * upload_session/start).
 * @property {number} offset - The amount of data that has been uploaded so far.
 * We use this to make sure upload data isn't lost or duplicated in the event of
 * a network error.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishArg
 * @property {Object} contents - The file contents to be uploaded.
 * @property {FilesUploadSessionCursor} cursor - Contains the upload session ID
 * and the offset.
 * @property {FilesCommitInfo} commit - Contains the path and other optional
 * modifiers for the commit.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishBatchArg
 * @property {Array.<FilesUploadSessionFinishArg>} entries - Commit information
 * for each file in the batch.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishBatchJobStatus
 * @property {FilesUploadSessionFinishBatchResult} [complete] - Available if
 * .tag is complete. The :route:`upload_session/finish_batch` has finished.
 * @property {('in_progress'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by upload_session/finish_batch that may either launch an
 * asynchronous job or complete synchronously.
 * @typedef {Object} FilesUploadSessionFinishBatchLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {FilesUploadSessionFinishBatchResult} [complete] - Available if
 * .tag is complete.
 * @property {('async_job_id'|'complete'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishBatchResult
 * @property {Array.<FilesUploadSessionFinishBatchResultEntry>} entries - Each
 * entry in UploadSessionFinishBatchArg.entries will appear at the same position
 * inside UploadSessionFinishBatchResult.entries.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishBatchResultEntry
 * @property {FilesFileMetadata} [success] - Available if .tag is success.
 * @property {FilesUploadSessionFinishError} [failure] - Available if .tag is
 * failure.
 * @property {('success'|'failure')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadSessionFinishError
 * @property {FilesUploadSessionLookupError} [lookup_failed] - Available if .tag
 * is lookup_failed. The session arguments are incorrect; the value explains the
 * reason.
 * @property {FilesWriteError} [path] - Available if .tag is path. Unable to
 * save the uploaded contents to a file. Data has already been appended to the
 * upload session. Please retry with empty data body and updated offset.
 * @property {FilePropertiesInvalidPropertyGroupError} [properties_error] -
 * Available if .tag is properties_error. The supplied property group is
 * invalid. The file has uploaded without property groups.
 * @property {('lookup_failed'|'path'|'properties_error'|'too_many_shared_folder_targets'|'too_many_write_operations'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadSessionLookupError
 * @property {FilesUploadSessionOffsetError} [incorrect_offset] - Available if
 * .tag is incorrect_offset. The specified offset was incorrect. See the value
 * for the correct offset. This error may occur when a previous request was
 * received and processed successfully but the client did not receive the
 * response, e.g. due to a network error.
 * @property {('not_found'|'incorrect_offset'|'closed'|'not_closed'|'too_large'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesUploadSessionOffsetError
 * @property {number} correct_offset - The offset up to which data has been
 * collected.
 */

/**
 * @typedef {Object} FilesUploadSessionStartArg
 * @property {Object} contents - The file contents to be uploaded.
 * @property {boolean} close - If true, the current session will be closed, at
 * which point you won't be able to call upload_session/append:2 anymore with
 * the current session.
 */

/**
 * @typedef {Object} FilesUploadSessionStartResult
 * @property {string} session_id - A unique identifier for the upload session.
 * Pass this to upload_session/append:2 and upload_session/finish.
 */

/**
 * @typedef {Object} FilesUploadWriteFailed
 * @property {FilesWriteError} reason - The reason why the file couldn't be
 * saved.
 * @property {string} upload_session_id - The upload session ID; data has
 * already been uploaded to the corresponding upload session and this ID may be
 * used to retry the commit with upload_session/finish.
 */

/**
 * Metadata for a video.
 * @typedef {Object} FilesVideoMetadata
@property {'video'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {FilesDimensions} [dimensions] - Dimension of the photo/video.
 * @property {FilesGpsCoordinates} [location] - The GPS coordinate of the
 * photo/video.
 * @property {Timestamp} [time_taken] - The timestamp when the photo/video is
 * taken.
 * @property {number} [duration] - The duration of the video in milliseconds.
 */

/**
 * @typedef {Object} FilesWriteConflictError
 * @property {('file'|'folder'|'file_ancestor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} FilesWriteError
 * @property {string} [malformed_path] - Available if .tag is malformed_path.
 * The given path does not satisfy the required path format. Please refer to the
 * :link:`Path formats documentation
 * https://www.dropbox.com/developers/documentation/http/documentation#path-formats`
 * for more information.
 * @property {FilesWriteConflictError} [conflict] - Available if .tag is
 * conflict. Couldn't write to the target path because there was something in
 * the way.
 * @property {('malformed_path'|'conflict'|'no_write_permission'|'insufficient_space'|'disallowed_name'|'team_folder'|'too_many_write_operations'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Your intent when writing a file to some path. This is used to determine what
 * constitutes a conflict and what the autorename strategy is. In some
 * situations, the conflict behavior is identical: (a) If the target path
 * doesn't refer to anything, the file is always written; no conflict. (b) If
 * the target path refers to a folder, it's always a conflict. (c) If the target
 * path refers to a file with identical contents, nothing gets written; no
 * conflict. The conflict checking differs in the case where there's a file at
 * the target path with contents different from the contents you're trying to
 * write.
 * @typedef {Object} FilesWriteMode
 * @property {string} [update] - Available if .tag is update. Overwrite if the
 * given "rev" matches the existing file's "rev". The autorename strategy is to
 * append the string "conflicted copy" to the file name. For example,
 * "document.txt" might become "document (conflicted copy).txt" or "document
 * (Panda's conflicted copy).txt".
 * @property {('add'|'overwrite'|'update')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperAddMember
 * @property {SharingMemberSelector} member - User which should be added to the
 * Paper doc. Specify only email address or Dropbox account ID.
 * @property {PaperPaperDocPermissionLevel} permission_level - Permission for
 * the user.
 */

/**
 * @typedef {Object} PaperAddPaperDocUser
 * @property {string} doc_id - The Paper doc ID.
 * @property {Array.<PaperAddMember>} members - User which should be added to
 * the Paper doc. Specify only email address or Dropbox account ID.
 * @property {string} [custom_message] - A personal message that will be emailed
 * to each successfully added member.
 * @property {boolean} quiet - Clients should set this to true if no email
 * message shall be sent to added users.
 */

/**
 * Per-member result for docs/users/add.
 * @typedef {Object} PaperAddPaperDocUserMemberResult
 * @property {SharingMemberSelector} member - One of specified input members.
 * @property {PaperAddPaperDocUserResult} result - The outcome of the action on
 * this member.
 */

/**
 * @typedef {Object} PaperAddPaperDocUserResult
 * @property {('success'|'unknown_error'|'sharing_outside_team_disabled'|'daily_limit_reached'|'user_is_owner'|'failed_user_data_retrieval'|'permission_already_granted'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperCursor
 * @property {string} value - The actual cursor value.
 * @property {Timestamp} [expiration] - Expiration time of value. Some cursors
 * might have expiration time assigned. This is a UTC value after which the
 * cursor is no longer valid and the API starts returning an error. If cursor
 * expires a new one needs to be obtained and pagination needs to be restarted.
 * Some cursors might be short-lived some cursors might be long-lived. This
 * really depends on the sorting type and order, e.g.: 1. on one hand, listing
 * docs created by the user, sorted by the created time ascending will have
 * undefinite expiration because the results cannot change while the iteration
 * is happening. This cursor would be suitable for long term polling. 2. on the
 * other hand, listing docs sorted by the last modified time will have a very
 * short expiration as docs do get modified very often and the modified time can
 * be changed while the iteration is happening thus altering the results.
 */

/**
 * @typedef {Object} PaperDocLookupError
 * @property {('insufficient_permissions'|'other'|'doc_not_found')} .tag - Tag identifying the union variant.
 */

/**
 * The subscription level of a Paper doc.
 * @typedef {Object} PaperDocSubscriptionLevel
 * @property {('default'|'ignore'|'every'|'no_email')} .tag - Tag identifying the union variant.
 */

/**
 * The desired export format of the Paper doc.
 * @typedef {Object} PaperExportFormat
 * @property {('html'|'markdown'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Data structure representing a Paper folder.
 * @typedef {Object} PaperFolder
 * @property {string} id - Paper folder ID. This ID uniquely identifies the
 * folder.
 * @property {string} name - Paper folder name.
 */

/**
 * The sharing policy of a Paper folder.  Note: The sharing policy of subfolders
 * is inherited from the root folder.
 * @typedef {Object} PaperFolderSharingPolicyType
 * @property {('team'|'invite_only')} .tag - Tag identifying the union variant.
 */

/**
 * The subscription level of a Paper folder.
 * @typedef {Object} PaperFolderSubscriptionLevel
 * @property {('none'|'activity_only'|'daily_emails'|'weekly_emails')} .tag - Tag identifying the union variant.
 */

/**
 * Metadata about Paper folders containing the specififed Paper doc.
 * @typedef {Object} PaperFoldersContainingPaperDoc
 * @property {PaperFolderSharingPolicyType} [folder_sharing_policy_type] - The
 * sharing policy of the folder containing the Paper doc.
 * @property {Array.<PaperFolder>} [folders] - The folder path. If present the
 * first folder is the root folder.
 */

/**
 * The import format of the incoming data.
 * @typedef {Object} PaperImportFormat
 * @property {('html'|'markdown'|'plain_text'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperInviteeInfoWithPermissionLevel
 * @property {SharingInviteeInfo} invitee - Email address invited to the Paper
 * doc.
 * @property {PaperPaperDocPermissionLevel} permission_level - Permission level
 * for the invitee.
 */

/**
 * @typedef {Object} PaperListDocsCursorError
 * @property {PaperPaperApiCursorError} [cursor_error] - Available if .tag is
 * cursor_error.
 * @property {('cursor_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperListPaperDocsArgs
 * @property {PaperListPaperDocsFilterBy} filter_by - Allows user to specify how
 * the Paper docs should be filtered.
 * @property {PaperListPaperDocsSortBy} sort_by - Allows user to specify how the
 * Paper docs should be sorted.
 * @property {PaperListPaperDocsSortOrder} sort_order - Allows user to specify
 * the sort order of the result.
 * @property {number} limit - Size limit per batch. The maximum number of docs
 * that can be retrieved per batch is 1000. Higher value results in invalid
 * arguments error.
 */

/**
 * @typedef {Object} PaperListPaperDocsContinueArgs
 * @property {string} cursor - The cursor obtained from docs/list or
 * docs/list/continue. Allows for pagination.
 */

/**
 * @typedef {Object} PaperListPaperDocsFilterBy
 * @property {('docs_accessed'|'docs_created'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperListPaperDocsResponse
 * @property {Array.<Object>} doc_ids - The list of Paper doc IDs that can be
 * used to access the given Paper docs or supplied to other API methods. The
 * list is sorted in the order specified by the initial call to docs/list.
 * @property {PaperCursor} cursor - Pass the cursor into docs/list/continue to
 * paginate through all files. The cursor preserves all properties as specified
 * in the original call to docs/list.
 * @property {boolean} has_more - Will be set to True if a subsequent call with
 * the provided cursor to docs/list/continue returns immediately with some
 * results. If set to False please allow some delay before making another call
 * to docs/list/continue.
 */

/**
 * @typedef {Object} PaperListPaperDocsSortBy
 * @property {('accessed'|'modified'|'created'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperListPaperDocsSortOrder
 * @property {('ascending'|'descending'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperListUsersCursorError
 * @property {PaperPaperApiCursorError} [cursor_error] - Available if .tag is
 * cursor_error.
 * @property {('insufficient_permissions'|'other'|'doc_not_found'|'cursor_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperListUsersOnFolderArgs
 * @property {string} doc_id - The Paper doc ID.
 * @property {number} limit - Size limit per batch. The maximum number of users
 * that can be retrieved per batch is 1000. Higher value results in invalid
 * arguments error.
 */

/**
 * @typedef {Object} PaperListUsersOnFolderContinueArgs
 * @property {string} doc_id - The Paper doc ID.
 * @property {string} cursor - The cursor obtained from docs/folder_users/list
 * or docs/folder_users/list/continue. Allows for pagination.
 */

/**
 * @typedef {Object} PaperListUsersOnFolderResponse
 * @property {Array.<SharingInviteeInfo>} invitees - List of email addresses
 * that are invited on the Paper folder.
 * @property {Array.<SharingUserInfo>} users - List of users that are invited on
 * the Paper folder.
 * @property {PaperCursor} cursor - Pass the cursor into
 * docs/folder_users/list/continue to paginate through all users. The cursor
 * preserves all properties as specified in the original call to
 * docs/folder_users/list.
 * @property {boolean} has_more - Will be set to True if a subsequent call with
 * the provided cursor to docs/folder_users/list/continue returns immediately
 * with some results. If set to False please allow some delay before making
 * another call to docs/folder_users/list/continue.
 */

/**
 * @typedef {Object} PaperListUsersOnPaperDocArgs
 * @property {string} doc_id - The Paper doc ID.
 * @property {number} limit - Size limit per batch. The maximum number of users
 * that can be retrieved per batch is 1000. Higher value results in invalid
 * arguments error.
 * @property {PaperUserOnPaperDocFilter} filter_by - Specify this attribute if
 * you want to obtain users that have already accessed the Paper doc.
 */

/**
 * @typedef {Object} PaperListUsersOnPaperDocContinueArgs
 * @property {string} doc_id - The Paper doc ID.
 * @property {string} cursor - The cursor obtained from docs/users/list or
 * docs/users/list/continue. Allows for pagination.
 */

/**
 * @typedef {Object} PaperListUsersOnPaperDocResponse
 * @property {Array.<PaperInviteeInfoWithPermissionLevel>} invitees - List of
 * email addresses with their respective permission levels that are invited on
 * the Paper doc.
 * @property {Array.<PaperUserInfoWithPermissionLevel>} users - List of users
 * with their respective permission levels that are invited on the Paper folder.
 * @property {SharingUserInfo} doc_owner - The Paper doc owner. This field is
 * populated on every single response.
 * @property {PaperCursor} cursor - Pass the cursor into
 * docs/users/list/continue to paginate through all users. The cursor preserves
 * all properties as specified in the original call to docs/users/list.
 * @property {boolean} has_more - Will be set to True if a subsequent call with
 * the provided cursor to docs/users/list/continue returns immediately with some
 * results. If set to False please allow some delay before making another call
 * to docs/users/list/continue.
 */

/**
 * @typedef {Object} PaperPaperApiBaseError
 * @property {('insufficient_permissions'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperPaperApiCursorError
 * @property {('expired_cursor'|'invalid_cursor'|'wrong_user_in_cursor'|'reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperPaperDocCreateArgs
 * @property {Object} contents - The file contents to be uploaded.
 * @property {PaperImportFormat} import_format - The format of provided data.
 * @property {string} [parent_folder_id] - The Paper folder ID where the Paper
 * document should be created. The API user has to have write access to this
 * folder or error is thrown.
 */

/**
 * @typedef {Object} PaperPaperDocCreateError
 * @property {('insufficient_permissions'|'other'|'content_malformed'|'folder_not_found'|'doc_length_exceeded'|'image_size_exceeded')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperPaperDocCreateUpdateResult
 * @property {string} doc_id - Doc ID of the newly created doc.
 * @property {number} revision - The Paper doc revision. Simply an ever
 * increasing number.
 * @property {string} title - The Paper doc title.
 */

/**
 * @typedef {Object} PaperPaperDocExport
 * @property {string} doc_id - The Paper doc ID.
 * @property {PaperExportFormat} export_format
 */

/**
 * @typedef {Object} PaperPaperDocExportResult
 * @property {string} owner - The Paper doc owner's email address.
 * @property {string} title - The Paper doc title.
 * @property {number} revision - The Paper doc revision. Simply an ever
 * increasing number.
 * @property {string} mime_type - MIME type of the export. This corresponds to
 * ExportFormat specified in the request.
 */

/**
 * @typedef {Object} PaperPaperDocPermissionLevel
 * @property {('edit'|'view_and_comment'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperPaperDocSharingPolicy
 * @property {string} doc_id - The Paper doc ID.
 * @property {PaperSharingPolicy} sharing_policy - The default sharing policy to
 * be set for the Paper doc.
 */

/**
 * @typedef {Object} PaperPaperDocUpdateArgs
 * @property {Object} contents - The file contents to be uploaded.
 * @property {string} doc_id - The Paper doc ID.
 * @property {PaperPaperDocUpdatePolicy} doc_update_policy - The policy used for
 * the current update call.
 * @property {number} revision - The latest doc revision. This value must match
 * the head revision or an error code will be returned. This is to prevent
 * colliding writes.
 * @property {PaperImportFormat} import_format - The format of provided data.
 */

/**
 * @typedef {Object} PaperPaperDocUpdateError
 * @property {('insufficient_permissions'|'other'|'doc_not_found'|'content_malformed'|'revision_mismatch'|'doc_length_exceeded'|'image_size_exceeded'|'doc_archived'|'doc_deleted')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperPaperDocUpdatePolicy
 * @property {('append'|'prepend'|'overwrite_all'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperRefPaperDoc
 * @property {string} doc_id - The Paper doc ID.
 */

/**
 * @typedef {Object} PaperRemovePaperDocUser
 * @property {string} doc_id - The Paper doc ID.
 * @property {SharingMemberSelector} member - User which should be removed from
 * the Paper doc. Specify only email address or Dropbox account ID.
 */

/**
 * Sharing policy of Paper doc.
 * @typedef {Object} PaperSharingPolicy
 * @property {PaperSharingPublicPolicyType} [public_sharing_policy] - This value
 * applies to the non-team members.
 * @property {PaperSharingTeamPolicyType} [team_sharing_policy] - This value
 * applies to the team members only. The value is null for all personal
 * accounts.
 */

/**
 * @typedef {Object} PaperSharingPublicPolicyType
 * @property {('people_with_link_can_edit'|'people_with_link_can_view_and_comment'|'invite_only'|'disabled')} .tag - Tag identifying the union variant.
 */

/**
 * The sharing policy type of the Paper doc.
 * @typedef {Object} PaperSharingTeamPolicyType
 * @property {('people_with_link_can_edit'|'people_with_link_can_view_and_comment'|'invite_only')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} PaperUserInfoWithPermissionLevel
 * @property {SharingUserInfo} user - User shared on the Paper doc.
 * @property {PaperPaperDocPermissionLevel} permission_level - Permission level
 * for the user.
 */

/**
 * @typedef {Object} PaperUserOnPaperDocFilter
 * @property {('visited'|'shared'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Possible platforms on which a user may view content.
 * @typedef {Object} SeenStatePlatformType
 * @property {('web'|'desktop'|'mobile_ios'|'mobile_android'|'api'|'unknown'|'mobile'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about the inheritance policy of a shared folder.
 * @typedef {Object} SharingAccessInheritance
 * @property {('inherit'|'no_inherit'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Defines the access levels for collaborators.
 * @typedef {Object} SharingAccessLevel
 * @property {('owner'|'editor'|'viewer'|'viewer_no_comment'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Who can change a shared folder's access control list (ACL). In other words,
 * who can add, remove, or change the privileges of members.
 * @typedef {Object} SharingAclUpdatePolicy
 * @property {('owner'|'editors'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for add_file_member.
 * @typedef {Object} SharingAddFileMemberArgs
 * @property {string} file - File to which to add members.
 * @property {Array.<SharingMemberSelector>} members - Members to add. Note that
 * even an email address is given, this may result in a user being directy added
 * to the membership if that email is the user's main account email.
 * @property {string} [custom_message] - Message to send to added members in
 * their invitation.
 * @property {boolean} quiet - Whether added members should be notified via
 * device notifications of their invitation.
 * @property {SharingAccessLevel} access_level - AccessLevel union object,
 * describing what access level we want to give new members.
 * @property {boolean} add_message_as_comment - If the custom message should be
 * added as a comment on the file.
 */

/**
 * Errors for add_file_member.
 * @typedef {Object} SharingAddFileMemberError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('user_error'|'access_error'|'rate_limit'|'invalid_comment'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingAddFolderMemberArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {Array.<SharingAddMember>} members - The intended list of members
 * to add.  Added members will receive invites to join the shared folder.
 * @property {boolean} quiet - Whether added members should be notified via
 * email and device notifications of their invite.
 * @property {string} [custom_message] - Optional message to display to added
 * members in their invitation.
 */

/**
 * @typedef {Object} SharingAddFolderMemberError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error. Unable to access shared folder.
 * @property {SharingAddMemberSelectorError} [bad_member] - Available if .tag is
 * bad_member. :field:`AddFolderMemberArg.members` contains a bad invitation
 * recipient.
 * @property {number} [too_many_members] - Available if .tag is
 * too_many_members. The value is the member limit that was reached.
 * @property {number} [too_many_pending_invites] - Available if .tag is
 * too_many_pending_invites. The value is the pending invite limit that was
 * reached.
 * @property {('access_error'|'email_unverified'|'banned_member'|'bad_member'|'cant_share_outside_team'|'too_many_members'|'too_many_pending_invites'|'rate_limit'|'too_many_invitees'|'insufficient_plan'|'team_folder'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The member and type of access the member should have when added to a shared
 * folder.
 * @typedef {Object} SharingAddMember
 * @property {SharingMemberSelector} member - The member to add to the shared
 * folder.
 * @property {SharingAccessLevel} access_level - The access level to grant
 * member to the shared folder.  AccessLevel.owner is disallowed.
 */

/**
 * @typedef {Object} SharingAddMemberSelectorError
 * @property {string} [invalid_dropbox_id] - Available if .tag is
 * invalid_dropbox_id. The value is the ID that could not be identified.
 * @property {string} [invalid_email] - Available if .tag is invalid_email. The
 * value is the e-email address that is malformed.
 * @property {string} [unverified_dropbox_id] - Available if .tag is
 * unverified_dropbox_id. The value is the ID of the Dropbox user with an
 * unverified e-mail address.  Invite unverified users by e-mail address instead
 * of by their Dropbox ID.
 * @property {('automatic_group'|'invalid_dropbox_id'|'invalid_email'|'unverified_dropbox_id'|'group_deleted'|'group_not_on_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about the content that has a link audience different than that of
 * this folder.
 * @typedef {Object} SharingAudienceExceptionContentInfo
 * @property {string} name - The name of the content, which is either a file or
 * a folder.
 */

/**
 * The total count and truncated list of information of content inside this
 * folder that has a different audience than the link on this folder. This is
 * only returned for folders.
 * @typedef {Object} SharingAudienceExceptions
 * @property {number} count
 * @property {Array.<SharingAudienceExceptionContentInfo>} exceptions - A
 * truncated list of some of the content that is an exception. The length of
 * this list could be smaller than the count since it is only a sample but will
 * not be empty as long as count is not 0.
 */

/**
 * Information about the shared folder that prevents the link audience for this
 * link from being more restrictive.
 * @typedef {Object} SharingAudienceRestrictingSharedFolder
 * @property {string} shared_folder_id - The ID of the shared folder.
 * @property {string} name - The name of the shared folder.
 * @property {SharingLinkAudience} audience - The link audience of the shared
 * folder.
 */

/**
 * Arguments for change_file_member_access.
 * @typedef {Object} SharingChangeFileMemberAccessArgs
 * @property {string} file - File for which we are changing a member's access.
 * @property {SharingMemberSelector} member - The member whose access we are
 * changing.
 * @property {SharingAccessLevel} access_level - The new access level for the
 * member.
 */

/**
 * Metadata for a collection-based shared link.
 * @typedef {Object} SharingCollectionLinkMetadata
@property {'collection'} [.tag] - Tag identifying this subtype variant. This
field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} url - URL of the shared link.
 * @property {SharingVisibility} visibility - Who can access the link.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 */

/**
 * @typedef {Object} SharingCreateSharedLinkArg
 * @property {string} path - The path to share.
 * @property {boolean} short_url - Whether to return a shortened URL.
 * @property {SharingPendingUploadMode} [pending_upload] - If it's okay to share
 * a path that does not yet exist, set this to either PendingUploadMode.file or
 * PendingUploadMode.folder to indicate whether to assume it's a file or folder.
 */

/**
 * @typedef {Object} SharingCreateSharedLinkError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingCreateSharedLinkWithSettingsArg
 * @property {string} path - The path to be shared by the shared link.
 * @property {SharingSharedLinkSettings} [settings] - The requested settings for
 * the newly created shared link.
 */

/**
 * @typedef {Object} SharingCreateSharedLinkWithSettingsError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {SharingSharedLinkAlreadyExistsMetadata}
 * [shared_link_already_exists] - Available if .tag is
 * shared_link_already_exists. The shared link already exists. You can call
 * :route:`list_shared_links` to get the  existing link, or use the provided
 * metadata if it is returned.
 * @property {SharingSharedLinkSettingsError} [settings_error] - Available if
 * .tag is settings_error. There is an error with the given settings.
 * @property {('path'|'email_not_verified'|'shared_link_already_exists'|'settings_error'|'access_denied')} .tag - Tag identifying the union variant.
 */

/**
 * The expected metadata of a shared link for a file or folder when a link is
 * first created for the content. Absent if the link already exists.
 * @typedef {Object} SharingExpectedSharedContentLinkMetadata
 * @property {Array.<SharingLinkAudience>} audience_options - The audience
 * options that are available for the content. Some audience options may be
 * unavailable. For example, team_only may be unavailable if the content is not
 * owned by a user on a team. The 'default' audience option is always available
 * if the user can modify link settings.
 * @property {SharingLinkAudience} current_audience - The current audience of
 * the link.
 * @property {Array.<SharingLinkPermission>} link_permissions - A list of
 * permissions for actions you can perform on the link.
 * @property {boolean} password_protected - Whether the link is protected by a
 * password.
 * @property {SharingAccessLevel} [access_level] - The access level on the link
 * for this file.
 * @property {SharingAudienceRestrictingSharedFolder}
 * [audience_restricting_shared_folder] - The shared folder that prevents the
 * link audience for this link from being more restrictive.
 * @property {Timestamp} [expiry] - Whether the link has an expiry set on it. A
 * link with an expiry will have its  audience changed to members when the
 * expiry is reached.
 */

/**
 * Sharing actions that may be taken on files.
 * @typedef {Object} SharingFileAction
 * @property {('disable_viewer_info'|'edit_contents'|'enable_viewer_info'|'invite_viewer'|'invite_viewer_no_comment'|'invite_editor'|'unshare'|'relinquish_membership'|'share_link'|'create_link'|'create_view_link'|'create_edit_link'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingFileErrorResult
 * @property {string} [file_not_found_error] - Available if .tag is
 * file_not_found_error. File specified by id was not found.
 * @property {string} [invalid_file_action_error] - Available if .tag is
 * invalid_file_action_error. User does not have permission to take the
 * specified action on the file.
 * @property {string} [permission_denied_error] - Available if .tag is
 * permission_denied_error. User does not have permission to access file
 * specified by file.Id.
 * @property {('file_not_found_error'|'invalid_file_action_error'|'permission_denied_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The metadata of a file shared link.
 * @typedef {Object} SharingFileLinkMetadata
@property {'file'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} url - URL of the shared link.
 * @property {string} name - The linked file name (including extension). This
 * never contains a slash.
 * @property {SharingLinkPermissions} link_permissions - The link's access
 * permissions.
 * @property {Timestamp} client_modified - The modification time set by the
 * desktop client when the file was added to Dropbox. Since this time is not
 * verified (the Dropbox server stores whatever the desktop client sends up),
 * this should only be used for display purposes (such as sorting) and not, for
 * example, to determine if a file has changed or not.
 * @property {Timestamp} server_modified - The last time the file was modified
 * on Dropbox.
 * @property {string} rev - A unique identifier for the current revision of a
 * file. This field is the same rev as elsewhere in the API and can be used to
 * detect changes and avoid conflicts.
 * @property {number} size - The file size in bytes.
 * @property {string} [id] - A unique identifier for the linked file.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will only be present
 * only if the linked file is in the authenticated user's  dropbox.
 * @property {SharingTeamMemberInfo} [team_member_info] - The team membership
 * information of the link's owner.  This field will only be present  if the
 * link's owner is a team member.
 * @property {UsersTeam} [content_owner_team_info] - The team information of the
 * content's owner. This field will only be present if the content's owner is a
 * team member and the content's owner team is different from the link's owner
 * team.
 */

/**
 * @typedef {Object} SharingFileMemberActionError
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error. Specified file was invalid or user does not have access.
 * @property {SharingMemberAccessLevelResult} [no_explicit_access] - Available
 * if .tag is no_explicit_access. The action cannot be completed because the
 * target member does not have explicit access to the file. The return value is
 * the access that the member has to the file from a parent folder.
 * @property {('invalid_member'|'no_permission'|'access_error'|'no_explicit_access'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingFileMemberActionIndividualResult
 * @property {SharingAccessLevel} [success] - Available if .tag is success.
 * Member was successfully removed from this file. If AccessLevel is given, the
 * member still has access via a parent shared folder.
 * @property {SharingFileMemberActionError} [member_error] - Available if .tag
 * is member_error. User was not able to perform this action.
 * @property {('success'|'member_error')} .tag - Tag identifying the union variant.
 */

/**
 * Per-member result for add_file_member or change_file_member_access.
 * @typedef {Object} SharingFileMemberActionResult
 * @property {SharingMemberSelector} member - One of specified input members.
 * @property {SharingFileMemberActionIndividualResult} result - The outcome of
 * the action on this member.
 */

/**
 * @typedef {Object} SharingFileMemberRemoveActionResult
 * @property {SharingMemberAccessLevelResult} [success] - Available if .tag is
 * success. Member was successfully removed from this file.
 * @property {SharingFileMemberActionError} [member_error] - Available if .tag
 * is member_error. User was not able to remove this member.
 * @property {('success'|'member_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Whether the user is allowed to take the sharing action on the file.
 * @typedef {Object} SharingFilePermission
 * @property {SharingFileAction} action - The action that the user may wish to
 * take on the file.
 * @property {boolean} allow - True if the user is allowed to take the action.
 * @property {SharingPermissionDeniedReason} [reason] - The reason why the user
 * is denied the permission. Not present if the action is allowed.
 */

/**
 * Actions that may be taken on shared folders.
 * @typedef {Object} SharingFolderAction
 * @property {('change_options'|'disable_viewer_info'|'edit_contents'|'enable_viewer_info'|'invite_editor'|'invite_viewer'|'invite_viewer_no_comment'|'relinquish_membership'|'unmount'|'unshare'|'leave_a_copy'|'share_link'|'create_link'|'set_access_inheritance'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The metadata of a folder shared link.
 * @typedef {Object} SharingFolderLinkMetadata
@property {'folder'} [.tag] - Tag identifying this subtype variant. This field
is only present when needed to discriminate between multiple possible subtypes.
 * @property {string} url - URL of the shared link.
 * @property {string} name - The linked file name (including extension). This
 * never contains a slash.
 * @property {SharingLinkPermissions} link_permissions - The link's access
 * permissions.
 * @property {string} [id] - A unique identifier for the linked file.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will only be present
 * only if the linked file is in the authenticated user's  dropbox.
 * @property {SharingTeamMemberInfo} [team_member_info] - The team membership
 * information of the link's owner.  This field will only be present  if the
 * link's owner is a team member.
 * @property {UsersTeam} [content_owner_team_info] - The team information of the
 * content's owner. This field will only be present if the content's owner is a
 * team member and the content's owner team is different from the link's owner
 * team.
 */

/**
 * Whether the user is allowed to take the action on the shared folder.
 * @typedef {Object} SharingFolderPermission
 * @property {SharingFolderAction} action - The action that the user may wish to
 * take on the folder.
 * @property {boolean} allow - True if the user is allowed to take the action.
 * @property {SharingPermissionDeniedReason} [reason] - The reason why the user
 * is denied the permission. Not present if the action is allowed, or if no
 * reason is available.
 */

/**
 * A set of policies governing membership and privileges for a shared folder.
 * @typedef {Object} SharingFolderPolicy
 * @property {SharingAclUpdatePolicy} acl_update_policy - Who can add and remove
 * members from this shared folder.
 * @property {SharingSharedLinkPolicy} shared_link_policy - Who links can be
 * shared with.
 * @property {SharingMemberPolicy} [member_policy] - Who can be a member of this
 * shared folder, as set on the folder itself. The effective policy may differ
 * from this value if the team-wide policy is more restrictive. Present only if
 * the folder is owned by a team.
 * @property {SharingMemberPolicy} [resolved_member_policy] - Who can be a
 * member of this shared folder, taking into account both the folder and the
 * team-wide policy. This value may differ from that of member_policy if the
 * team-wide policy is more restrictive than the folder policy. Present only if
 * the folder is owned by a team.
 * @property {SharingViewerInfoPolicy} [viewer_info_policy] - Who can
 * enable/disable viewer info for this shared folder.
 */

/**
 * Arguments of get_file_metadata.
 * @typedef {Object} SharingGetFileMetadataArg
 * @property {string} file - The file to query.
 * @property {Array.<SharingFileAction>} [actions] - A list of `FileAction`s
 * corresponding to `FilePermission`s that should appear in the  response's
 * SharedFileMetadata.permissions field describing the actions the
 * authenticated user can perform on the file.
 */

/**
 * Arguments of get_file_metadata/batch.
 * @typedef {Object} SharingGetFileMetadataBatchArg
 * @property {Array.<Object>} files - The files to query.
 * @property {Array.<SharingFileAction>} [actions] - A list of `FileAction`s
 * corresponding to `FilePermission`s that should appear in the  response's
 * SharedFileMetadata.permissions field describing the actions the
 * authenticated user can perform on the file.
 */

/**
 * Per file results of get_file_metadata/batch.
 * @typedef {Object} SharingGetFileMetadataBatchResult
 * @property {string} file - This is the input file identifier corresponding to
 * one of GetFileMetadataBatchArg.files.
 * @property {SharingGetFileMetadataIndividualResult} result - The result for
 * this particular file.
 */

/**
 * Error result for get_file_metadata.
 * @typedef {Object} SharingGetFileMetadataError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('user_error'|'access_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingGetFileMetadataIndividualResult
 * @property {SharingSharedFileMetadata} [metadata] - Available if .tag is
 * metadata. The result for this file if it was successful.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error. The result for this file if it was an error.
 * @property {('metadata'|'access_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingGetMetadataArgs
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {Array.<SharingFolderAction>} [actions] - A list of `FolderAction`s
 * corresponding to `FolderPermission`s that should appear in the  response's
 * SharedFolderMetadata.permissions field describing the actions the
 * authenticated user can perform on the folder.
 */

/**
 * @typedef {Object} SharingGetSharedLinkFileError
 * @property {('shared_link_not_found'|'shared_link_access_denied'|'unsupported_link_type'|'other'|'shared_link_is_directory')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingGetSharedLinkMetadataArg
 * @property {string} url - URL of the shared link.
 * @property {string} [path] - If the shared link is to a folder, this parameter
 * can be used to retrieve the metadata for a specific file or sub-folder in
 * this folder. A relative path should be used.
 * @property {string} [link_password] - If the shared link has a password, this
 * parameter can be used.
 */

/**
 * @typedef {Object} SharingGetSharedLinksArg
 * @property {string} [path] - See get_shared_links description.
 */

/**
 * @typedef {Object} SharingGetSharedLinksError
 * @property {string} [path] - Available if .tag is path.
 * @property {('path'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingGetSharedLinksResult
 * @property
 * {Array.<(SharingPathLinkMetadata|SharingCollectionLinkMetadata|SharingLinkMetadata)>}
 * links - Shared links applicable to the path argument.
 */

/**
 * The information about a group. Groups is a way to manage a list of users  who
 * need same access permission to the shared folder.
 * @typedef {Object} SharingGroupInfo
 * @property {string} group_name
 * @property {string} group_id
 * @property {TeamCommonGroupManagementType} group_management_type - Who is
 * allowed to manage the group.
 * @property {TeamCommonGroupType} group_type - The type of group.
 * @property {boolean} is_member - If the current user is a member of the group.
 * @property {boolean} is_owner - If the current user is an owner of the group.
 * @property {boolean} same_team - If the group is owned by the current user's
 * team.
 * @property {string} [group_external_id] - External ID of group. This is an
 * arbitrary ID that an admin can attach to a group.
 * @property {number} [member_count] - The number of members in the group.
 */

/**
 * The information about a group member of the shared content.
 * @typedef {Object} SharingGroupMembershipInfo
 * @property {SharingAccessLevel} access_type - The access type for this member.
 * It contains inherited access type from parent folder, and acquired access
 * type from this folder.
 * @property {SharingGroupInfo} group - The information about the membership
 * group.
 * @property {Array.<SharingMemberPermission>} [permissions] - The permissions
 * that requesting user has on this member. The set of permissions corresponds
 * to the MemberActions in the request.
 * @property {string} [initials] - Never set.
 * @property {boolean} is_inherited - True if the member has access from a
 * parent folder.
 */

/**
 * @typedef {Object} SharingInsufficientPlan
 * @property {string} message - A message to tell the user to upgrade in order
 * to support expected action.
 * @property {string} [upsell_url] - A URL to send the user to in order to
 * obtain the account type they need, e.g. upgrading. Absent if there is no
 * action the user can take to upgrade.
 */

/**
 * @typedef {Object} SharingInsufficientQuotaAmounts
 * @property {number} space_needed - The amount of space needed to add the item
 * (the size of the item).
 * @property {number} space_shortage - The amount of extra space needed to add
 * the item.
 * @property {number} space_left - The amount of space left in the user's
 * Dropbox, less than space_needed.
 */

/**
 * Information about the recipient of a shared content invitation.
 * @typedef {Object} SharingInviteeInfo
 * @property {string} [email] - Available if .tag is email. E-mail address of
 * invited user.
 * @property {('email'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about an invited member of a shared content.
 * @typedef {Object} SharingInviteeMembershipInfo
 * @property {SharingAccessLevel} access_type - The access type for this member.
 * It contains inherited access type from parent folder, and acquired access
 * type from this folder.
 * @property {SharingInviteeInfo} invitee - Recipient of the invitation.
 * @property {Array.<SharingMemberPermission>} [permissions] - The permissions
 * that requesting user has on this member. The set of permissions corresponds
 * to the MemberActions in the request.
 * @property {string} [initials] - Never set.
 * @property {boolean} is_inherited - True if the member has access from a
 * parent folder.
 * @property {SharingUserInfo} [user] - The user this invitation is tied to, if
 * available.
 */

/**
 * Error occurred while performing an asynchronous job from unshare_folder or
 * remove_folder_member.
 * @typedef {Object} SharingJobError
 * @property {SharingUnshareFolderError} [unshare_folder_error] - Available if
 * .tag is unshare_folder_error. Error occurred while performing
 * :route:`unshare_folder` action.
 * @property {SharingRemoveFolderMemberError} [remove_folder_member_error] -
 * Available if .tag is remove_folder_member_error. Error occurred while
 * performing :route:`remove_folder_member` action.
 * @property {SharingRelinquishFolderMembershipError}
 * [relinquish_folder_membership_error] - Available if .tag is
 * relinquish_folder_membership_error. Error occurred while performing
 * :route:`relinquish_folder_membership` action.
 * @property {('unshare_folder_error'|'remove_folder_member_error'|'relinquish_folder_membership_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingJobStatus
 * @property {SharingJobError} [failed] - Available if .tag is failed. The
 * asynchronous job returned an error.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingLinkAccessLevel
 * @property {('viewer'|'editor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Actions that can be performed on a link.
 * @typedef {Object} SharingLinkAction
 * @property {('change_access_level'|'change_audience'|'remove_expiry'|'remove_password'|'set_expiry'|'set_password'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingLinkAudience
 * @property {('public'|'team'|'no_one'|'password'|'members'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingLinkExpiry
 * @property {Timestamp} [set_expiry] - Available if .tag is set_expiry. Set a
 * new expiry or change an existing expiry.
 * @property {('remove_expiry'|'set_expiry'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Metadata for a shared link. This can be either a PathLinkMetadata or
 * CollectionLinkMetadata.
 * @typedef {Object} SharingLinkMetadata
@property {("path"|"collection")} .tag - Tag identifying the subtype variant.
 * @property {string} url - URL of the shared link.
 * @property {SharingVisibility} visibility - Who can access the link.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 */

/**
 * @typedef {Object} SharingLinkPassword
 * @property {string} [set_password] - Available if .tag is set_password. Set a
 * new password or change an existing password.
 * @property {('remove_password'|'set_password'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Permissions for actions that can be performed on a link.
 * @typedef {Object} SharingLinkPermission
 * @property {SharingLinkAction} action
 * @property {boolean} allow
 * @property {SharingPermissionDeniedReason} [reason]
 */

/**
 * @typedef {Object} SharingLinkPermissions
 * @property {boolean} can_revoke - Whether the caller can revoke the shared
 * link.
 * @property {SharingResolvedVisibility} [resolved_visibility] - The current
 * visibility of the link after considering the shared links policies of the the
 * team (in case the link's owner is part of a team) and the shared folder (in
 * case the linked file is part of a shared folder). This field is shown only if
 * the caller has access to this info (the link's owner always has access to
 * this data). For some links, an effective_audience value is returned instead.
 * @property {SharingRequestedVisibility} [requested_visibility] - The shared
 * link's requested visibility. This can be overridden by the team and shared
 * folder policies. The final visibility, after considering these policies, can
 * be found in resolved_visibility. This is shown only if the caller is the
 * link's owner and resolved_visibility is returned instead of
 * effective_audience.
 * @property {SharingSharedLinkAccessFailureReason} [revoke_failure_reason] -
 * The failure reason for revoking the link. This field will only be present if
 * the can_revoke is false.
 * @property {SharingLinkAudience} [effective_audience] - The type of audience
 * who can benefit from the access level specified by the `link_access_level`
 * field.
 * @property {SharingLinkAccessLevel} [link_access_level] - The access level
 * that the link will grant to its users. A link can grant additional rights to
 * a user beyond their current access level. For example, if a user was invited
 * as a viewer to a file, and then opens a link with `link_access_level` set to
 * `editor`, then they will gain editor privileges. The `link_access_level` is a
 * property of the link, and does not depend on who is calling this API. In
 * particular, `link_access_level` does not take into account the API caller's
 * current permissions to the content.
 */

/**
 * Settings that apply to a link.
 * @typedef {Object} SharingLinkSettings
 * @property {SharingAccessLevel} [access_level] - The access level on the link
 * for this file. Currently, it only accepts 'viewer' and 'viewer_no_comment'.
 * @property {SharingLinkAudience} [audience] - The type of audience on the link
 * for this file.
 * @property {SharingLinkExpiry} [expiry] - An expiry timestamp to set on a
 * link.
 * @property {SharingLinkPassword} [password] - The password for the link.
 */

/**
 * Arguments for list_file_members.
 * @typedef {Object} SharingListFileMembersArg
 * @property {string} file - The file for which you want to see members.
 * @property {Array.<SharingMemberAction>} [actions] - The actions for which to
 * return permissions on a member.
 * @property {boolean} include_inherited - Whether to include members who only
 * have access from a parent shared folder.
 * @property {number} limit - Number of members to return max per query.
 * Defaults to 100 if no limit is specified.
 */

/**
 * Arguments for list_file_members/batch.
 * @typedef {Object} SharingListFileMembersBatchArg
 * @property {Array.<Object>} files - Files for which to return members.
 * @property {number} limit - Number of members to return max per query.
 * Defaults to 10 if no limit is specified.
 */

/**
 * Per-file result for list_file_members/batch.
 * @typedef {Object} SharingListFileMembersBatchResult
 * @property {string} file - This is the input file identifier, whether an ID or
 * a path.
 * @property {SharingListFileMembersIndividualResult} result - The result for
 * this particular file.
 */

/**
 * Arguments for list_file_members/continue.
 * @typedef {Object} SharingListFileMembersContinueArg
 * @property {string} cursor - The cursor returned by your last call to
 * list_file_members, list_file_members/continue, or list_file_members/batch.
 */

/**
 * Error for list_file_members/continue.
 * @typedef {Object} SharingListFileMembersContinueError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('user_error'|'access_error'|'invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingListFileMembersCountResult
 * @property {SharingSharedFileMembers} members - A list of members on this
 * file.
 * @property {number} member_count - The number of members on this file. This
 * does not include inherited members.
 */

/**
 * Error for list_file_members.
 * @typedef {Object} SharingListFileMembersError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('user_error'|'access_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingListFileMembersIndividualResult
 * @property {SharingListFileMembersCountResult} [result] - Available if .tag is
 * result. The results of the query for this file if it was successful.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error. The result of the query for this file if it was an error.
 * @property {('result'|'access_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for list_received_files.
 * @typedef {Object} SharingListFilesArg
 * @property {number} limit - Number of files to return max per query. Defaults
 * to 100 if no limit is specified.
 * @property {Array.<SharingFileAction>} [actions] - A list of `FileAction`s
 * corresponding to `FilePermission`s that should appear in the  response's
 * SharedFileMetadata.permissions field describing the actions the
 * authenticated user can perform on the file.
 */

/**
 * Arguments for list_received_files/continue.
 * @typedef {Object} SharingListFilesContinueArg
 * @property {string} cursor - Cursor in ListFilesResult.cursor.
 */

/**
 * Error results for list_received_files/continue.
 * @typedef {Object} SharingListFilesContinueError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error. User account had a problem.
 * @property {('user_error'|'invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Success results for list_received_files.
 * @typedef {Object} SharingListFilesResult
 * @property {Array.<SharingSharedFileMetadata>} entries - Information about the
 * files shared with current user.
 * @property {string} [cursor] - Cursor used to obtain additional shared files.
 */

/**
 * @typedef {Object} SharingListFolderMembersArgs
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {Array.<SharingMemberAction>} [actions] - This is a list indicating
 * whether each returned member will include a boolean value
 * MemberPermission.allow that describes whether the current user can perform
 * the MemberAction on the member.
 * @property {number} limit - The maximum number of results that include
 * members, groups and invitees to return per request.
 */

/**
 * @typedef {Object} SharingListFolderMembersContinueArg
 * @property {string} cursor - The cursor returned by your last call to
 * list_folder_members or list_folder_members/continue.
 */

/**
 * @typedef {Object} SharingListFolderMembersContinueError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingListFolderMembersCursorArg
 * @property {Array.<SharingMemberAction>} [actions] - This is a list indicating
 * whether each returned member will include a boolean value
 * MemberPermission.allow that describes whether the current user can perform
 * the MemberAction on the member.
 * @property {number} limit - The maximum number of results that include
 * members, groups and invitees to return per request.
 */

/**
 * @typedef {Object} SharingListFoldersArgs
 * @property {number} limit - The maximum number of results to return per
 * request.
 * @property {Array.<SharingFolderAction>} [actions] - A list of `FolderAction`s
 * corresponding to `FolderPermission`s that should appear in the  response's
 * SharedFolderMetadata.permissions field describing the actions the
 * authenticated user can perform on the folder.
 */

/**
 * @typedef {Object} SharingListFoldersContinueArg
 * @property {string} cursor - The cursor returned by the previous API call
 * specified in the endpoint description.
 */

/**
 * @typedef {Object} SharingListFoldersContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result for list_folders or list_mountable_folders, depending on which
 * endpoint was requested. Unmounted shared folders can be identified by the
 * absence of SharedFolderMetadata.path_lower.
 * @typedef {Object} SharingListFoldersResult
 * @property {Array.<SharingSharedFolderMetadata>} entries - List of all shared
 * folders the authenticated user has access to.
 * @property {string} [cursor] - Present if there are additional shared folders
 * that have not been returned yet. Pass the cursor into the corresponding
 * continue endpoint (either list_folders/continue or
 * list_mountable_folders/continue) to list additional folders.
 */

/**
 * @typedef {Object} SharingListSharedLinksArg
 * @property {string} [path] - See list_shared_links description.
 * @property {string} [cursor] - The cursor returned by your last call to
 * list_shared_links.
 * @property {boolean} [direct_only] - See list_shared_links description.
 */

/**
 * @typedef {Object} SharingListSharedLinksError
 * @property {FilesLookupError} [path] - Available if .tag is path.
 * @property {('path'|'reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingListSharedLinksResult
 * @property
 * {Array.<(SharingFileLinkMetadata|SharingFolderLinkMetadata|SharingSharedLinkMetadata)>}
 * links - Shared links applicable to the path argument.
 * @property {boolean} has_more - Is true if there are additional shared links
 * that have not been returned yet. Pass the cursor into list_shared_links to
 * retrieve them.
 * @property {string} [cursor] - Pass the cursor into list_shared_links to
 * obtain the additional links. Cursor is returned only if no path is given.
 */

/**
 * Contains information about a member's access level to content after an
 * operation.
 * @typedef {Object} SharingMemberAccessLevelResult
 * @property {SharingAccessLevel} [access_level] - The member still has this
 * level of access to the content through a parent folder.
 * @property {string} [warning] - A localized string with additional information
 * about why the user has this access level to the content.
 * @property {Array.<SharingParentFolderAccessInfo>} [access_details] - The
 * parent folders that a member has access to. The field is present if the user
 * has access to the first parent folder where the member gains access.
 */

/**
 * Actions that may be taken on members of a shared folder.
 * @typedef {Object} SharingMemberAction
 * @property {('leave_a_copy'|'make_editor'|'make_owner'|'make_viewer'|'make_viewer_no_comment'|'remove'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Whether the user is allowed to take the action on the associated member.
 * @typedef {Object} SharingMemberPermission
 * @property {SharingMemberAction} action - The action that the user may wish to
 * take on the member.
 * @property {boolean} allow - True if the user is allowed to take the action.
 * @property {SharingPermissionDeniedReason} [reason] - The reason why the user
 * is denied the permission. Not present if the action is allowed.
 */

/**
 * Policy governing who can be a member of a shared folder. Only applicable to
 * folders owned by a user on a team.
 * @typedef {Object} SharingMemberPolicy
 * @property {('team'|'anyone'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Includes different ways to identify a member of a shared folder.
 * @typedef {Object} SharingMemberSelector
 * @property {string} [dropbox_id] - Available if .tag is dropbox_id. Dropbox
 * account, team member, or group ID of member.
 * @property {string} [email] - Available if .tag is email. E-mail address of
 * member.
 * @property {('dropbox_id'|'email'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The information about a member of the shared content.
 * @typedef {Object} SharingMembershipInfo
 * @property {SharingAccessLevel} access_type - The access type for this member.
 * It contains inherited access type from parent folder, and acquired access
 * type from this folder.
 * @property {Array.<SharingMemberPermission>} [permissions] - The permissions
 * that requesting user has on this member. The set of permissions corresponds
 * to the MemberActions in the request.
 * @property {string} [initials] - Never set.
 * @property {boolean} is_inherited - True if the member has access from a
 * parent folder.
 */

/**
 * @typedef {Object} SharingModifySharedLinkSettingsArgs
 * @property {string} url - URL of the shared link to change its settings.
 * @property {SharingSharedLinkSettings} settings - Set of settings for the
 * shared link.
 * @property {boolean} remove_expiration - If set to true, removes the
 * expiration of the shared link.
 */

/**
 * @typedef {Object} SharingModifySharedLinkSettingsError
 * @property {SharingSharedLinkSettingsError} [settings_error] - Available if
 * .tag is settings_error. There is an error with the given settings.
 * @property {('shared_link_not_found'|'shared_link_access_denied'|'unsupported_link_type'|'other'|'settings_error'|'email_not_verified')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingMountFolderArg
 * @property {string} shared_folder_id - The ID of the shared folder to mount.
 */

/**
 * @typedef {Object} SharingMountFolderError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {SharingInsufficientQuotaAmounts} [insufficient_quota] - Available
 * if .tag is insufficient_quota. The current user does not have enough space to
 * mount the shared folder.
 * @property {('access_error'|'inside_shared_folder'|'insufficient_quota'|'already_mounted'|'no_permission'|'not_mountable'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Contains information about a parent folder that a member has access to.
 * @typedef {Object} SharingParentFolderAccessInfo
 * @property {string} folder_name - Display name for the folder.
 * @property {string} shared_folder_id - The identifier of the parent shared
 * folder.
 * @property {Array.<SharingMemberPermission>} permissions - The user's
 * permissions for the parent shared folder.
 * @property {string} path - The full path to the parent shared folder relative
 * to the acting user's root.
 */

/**
 * Metadata for a path-based shared link.
 * @typedef {Object} SharingPathLinkMetadata
@property {'path'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} url - URL of the shared link.
 * @property {SharingVisibility} visibility - Who can access the link.
 * @property {string} path - Path in user's Dropbox.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 */

/**
 * Flag to indicate pending upload default (for linking to not-yet-existing
 * paths).
 * @typedef {Object} SharingPendingUploadMode
 * @property {('file'|'folder')} .tag - Tag identifying the union variant.
 */

/**
 * Possible reasons the user is denied a permission.
 * @typedef {Object} SharingPermissionDeniedReason
 * @property {SharingInsufficientPlan} [insufficient_plan] - Available if .tag
 * is insufficient_plan.
 * @property {('user_not_same_team_as_owner'|'user_not_allowed_by_owner'|'target_is_indirect_member'|'target_is_owner'|'target_is_self'|'target_not_active'|'folder_is_limited_team_folder'|'owner_not_on_team'|'permission_denied'|'restricted_by_team'|'user_account_type'|'user_not_on_team'|'folder_is_inside_shared_folder'|'restricted_by_parent_folder'|'insufficient_plan'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRelinquishFileMembershipArg
 * @property {string} file - The path or id for the file.
 */

/**
 * @typedef {Object} SharingRelinquishFileMembershipError
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'group_access'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRelinquishFolderMembershipArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {boolean} leave_a_copy - Keep a copy of the folder's contents upon
 * relinquishing membership.
 */

/**
 * @typedef {Object} SharingRelinquishFolderMembershipError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'folder_owner'|'mounted'|'group_access'|'team_folder'|'no_permission'|'no_explicit_access'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for remove_file_member_2.
 * @typedef {Object} SharingRemoveFileMemberArg
 * @property {string} file - File from which to remove members.
 * @property {SharingMemberSelector} member - Member to remove from this file.
 * Note that even if an email is specified, it may result in the removal of a
 * user (not an invitee) if the user's main account corresponds to that email
 * address.
 */

/**
 * Errors for remove_file_member_2.
 * @typedef {Object} SharingRemoveFileMemberError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {SharingMemberAccessLevelResult} [no_explicit_access] - Available
 * if .tag is no_explicit_access. This member does not have explicit access to
 * the file and therefore cannot be removed. The return value is the access that
 * a user might have to the file from a parent folder.
 * @property {('user_error'|'access_error'|'no_explicit_access'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRemoveFolderMemberArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {SharingMemberSelector} member - The member to remove from the
 * folder.
 * @property {boolean} leave_a_copy - If true, the removed user will keep their
 * copy of the folder after it's unshared, assuming it was mounted. Otherwise,
 * it will be removed from their Dropbox. Also, this must be set to false when
 * kicking a group.
 */

/**
 * @typedef {Object} SharingRemoveFolderMemberError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {SharingSharedFolderMemberError} [member_error] - Available if .tag
 * is member_error.
 * @property {('access_error'|'member_error'|'folder_owner'|'group_access'|'team_folder'|'no_permission'|'too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRemoveMemberJobStatus
 * @property {SharingMemberAccessLevelResult} [complete] - Available if .tag is
 * complete. Removing the folder member has finished. The value is information
 * about whether the member has another form of access.
 * @property {SharingRemoveFolderMemberError} [failed] - Available if .tag is
 * failed.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRequestedLinkAccessLevel
 * @property {('viewer'|'editor'|'max'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The access permission that can be requested by the caller for the shared
 * link. Note that the final resolved visibility of the shared link takes into
 * account other aspects, such as team and shared folder settings. Check the
 * ResolvedVisibility for more info on the possible resolved visibility values
 * of shared links.
 * @typedef {Object} SharingRequestedVisibility
 * @property {('public'|'team_only'|'password')} .tag - Tag identifying the union variant.
 */

/**
 * The actual access permissions values of shared links after taking into
 * account user preferences and the team and shared folder settings. Check the
 * RequestedVisibility for more info on the possible visibility values that can
 * be set by the shared link's owner.
 * @typedef {Object} SharingResolvedVisibility
 * @property {('public'|'team_only'|'password'|'team_and_password'|'shared_folder_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingRevokeSharedLinkArg
 * @property {string} url - URL of the shared link.
 */

/**
 * @typedef {Object} SharingRevokeSharedLinkError
 * @property {('shared_link_not_found'|'shared_link_access_denied'|'unsupported_link_type'|'other'|'shared_link_malformed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSetAccessInheritanceArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {SharingAccessInheritance} access_inheritance - The access
 * inheritance settings for the folder.
 */

/**
 * @typedef {Object} SharingSetAccessInheritanceError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error. Unable to access shared folder.
 * @property {('access_error'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingShareFolderArg
 * @property {string} path - The path to the folder to share. If it does not
 * exist, then a new one is created.
 * @property {SharingAclUpdatePolicy} [acl_update_policy] - Who can add and
 * remove members of this shared folder.
 * @property {boolean} force_async - Whether to force the share to happen
 * asynchronously.
 * @property {SharingMemberPolicy} [member_policy] - Who can be a member of this
 * shared folder. Only applicable if the current user is on a team.
 * @property {SharingSharedLinkPolicy} [shared_link_policy] - The policy to
 * apply to shared links created for content inside this shared folder.  The
 * current user must be on a team to set this policy to
 * SharedLinkPolicy.members.
 * @property {SharingViewerInfoPolicy} [viewer_info_policy] - Who can
 * enable/disable viewer info for this shared folder.
 * @property {SharingAccessInheritance} access_inheritance - The access
 * inheritance settings for the folder.
 * @property {Array.<SharingFolderAction>} [actions] - A list of `FolderAction`s
 * corresponding to `FolderPermission`s that should appear in the  response's
 * SharedFolderMetadata.permissions field describing the actions the
 * authenticated user can perform on the folder.
 * @property {SharingLinkSettings} [link_settings] - Settings on the link for
 * this folder.
 */

/**
 * @typedef {Object} SharingShareFolderArgBase
 * @property {string} path - The path to the folder to share. If it does not
 * exist, then a new one is created.
 * @property {SharingAclUpdatePolicy} [acl_update_policy] - Who can add and
 * remove members of this shared folder.
 * @property {boolean} force_async - Whether to force the share to happen
 * asynchronously.
 * @property {SharingMemberPolicy} [member_policy] - Who can be a member of this
 * shared folder. Only applicable if the current user is on a team.
 * @property {SharingSharedLinkPolicy} [shared_link_policy] - The policy to
 * apply to shared links created for content inside this shared folder.  The
 * current user must be on a team to set this policy to
 * SharedLinkPolicy.members.
 * @property {SharingViewerInfoPolicy} [viewer_info_policy] - Who can
 * enable/disable viewer info for this shared folder.
 * @property {SharingAccessInheritance} access_inheritance - The access
 * inheritance settings for the folder.
 */

/**
 * @typedef {Object} SharingShareFolderError
 * @property {SharingSharePathError} [bad_path] - Available if .tag is bad_path.
 * :field:`ShareFolderArg.path` is invalid.
 * @property {('email_unverified'|'bad_path'|'team_policy_disallows_member_policy'|'disallowed_shared_link_policy'|'other'|'no_permission')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingShareFolderErrorBase
 * @property {SharingSharePathError} [bad_path] - Available if .tag is bad_path.
 * :field:`ShareFolderArg.path` is invalid.
 * @property {('email_unverified'|'bad_path'|'team_policy_disallows_member_policy'|'disallowed_shared_link_policy'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingShareFolderJobStatus
 * @property {SharingSharedFolderMetadata} [complete] - Available if .tag is
 * complete. The share job has finished. The value is the metadata for the
 * folder.
 * @property {SharingShareFolderError} [failed] - Available if .tag is failed.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingShareFolderLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {SharingSharedFolderMetadata} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSharePathError
 * @property {SharingSharedFolderMetadata} [already_shared] - Available if .tag
 * is already_shared. Folder is already shared. Contains metadata about the
 * existing shared folder.
 * @property {('is_file'|'inside_shared_folder'|'contains_shared_folder'|'contains_app_folder'|'contains_team_folder'|'is_app_folder'|'inside_app_folder'|'is_public_folder'|'inside_public_folder'|'already_shared'|'invalid_path'|'is_osx_package'|'inside_osx_package'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Metadata of a shared link for a file or folder.
 * @typedef {Object} SharingSharedContentLinkMetadata
 * @property {Array.<SharingLinkAudience>} audience_options - The audience
 * options that are available for the content. Some audience options may be
 * unavailable. For example, team_only may be unavailable if the content is not
 * owned by a user on a team. The 'default' audience option is always available
 * if the user can modify link settings.
 * @property {SharingLinkAudience} current_audience - The current audience of
 * the link.
 * @property {Array.<SharingLinkPermission>} link_permissions - A list of
 * permissions for actions you can perform on the link.
 * @property {boolean} password_protected - Whether the link is protected by a
 * password.
 * @property {string} url - The URL of the link.
 * @property {SharingAccessLevel} [access_level] - The access level on the link
 * for this file.
 * @property {SharingAudienceRestrictingSharedFolder}
 * [audience_restricting_shared_folder] - The shared folder that prevents the
 * link audience for this link from being more restrictive.
 * @property {Timestamp} [expiry] - Whether the link has an expiry set on it. A
 * link with an expiry will have its  audience changed to members when the
 * expiry is reached.
 * @property {SharingAudienceExceptions} [audience_exceptions] - The content
 * inside this folder with link audience different than this folder's. This is
 * only returned when an endpoint that returns metadata for a single shared
 * folder is called, e.g. /get_folder_metadata.
 */

/**
 * @typedef {Object} SharingSharedContentLinkMetadataBase
 * @property {Array.<SharingLinkAudience>} audience_options - The audience
 * options that are available for the content. Some audience options may be
 * unavailable. For example, team_only may be unavailable if the content is not
 * owned by a user on a team. The 'default' audience option is always available
 * if the user can modify link settings.
 * @property {SharingLinkAudience} current_audience - The current audience of
 * the link.
 * @property {Array.<SharingLinkPermission>} link_permissions - A list of
 * permissions for actions you can perform on the link.
 * @property {boolean} password_protected - Whether the link is protected by a
 * password.
 * @property {SharingAccessLevel} [access_level] - The access level on the link
 * for this file.
 * @property {SharingAudienceRestrictingSharedFolder}
 * [audience_restricting_shared_folder] - The shared folder that prevents the
 * link audience for this link from being more restrictive.
 * @property {Timestamp} [expiry] - Whether the link has an expiry set on it. A
 * link with an expiry will have its  audience changed to members when the
 * expiry is reached.
 */

/**
 * Shared file user, group, and invitee membership. Used for the results of
 * list_file_members and list_file_members/continue, and used as part of the
 * results for list_file_members/batch.
 * @typedef {Object} SharingSharedFileMembers
 * @property {Array.<SharingUserFileMembershipInfo>} users - The list of user
 * members of the shared file.
 * @property {Array.<SharingGroupMembershipInfo>} groups - The list of group
 * members of the shared file.
 * @property {Array.<SharingInviteeMembershipInfo>} invitees - The list of
 * invited members of a file, but have not logged in and claimed this.
 * @property {string} [cursor] - Present if there are additional shared file
 * members that have not been returned yet. Pass the cursor into
 * list_file_members/continue to list additional members.
 */

/**
 * Properties of the shared file.
 * @typedef {Object} SharingSharedFileMetadata
 * @property {string} id - The ID of the file.
 * @property {string} name - The name of this file.
 * @property {SharingFolderPolicy} policy - Policies governing this shared file.
 * @property {string} preview_url - URL for displaying a web preview of the
 * shared file.
 * @property {SharingAccessLevel} [access_type] - The current user's access
 * level for this shared file.
 * @property {SharingExpectedSharedContentLinkMetadata} [expected_link_metadata]
 * - The expected metadata of the link associated for the file when it is first
 * shared. Absent if the link already exists. This is for an unreleased feature
 * so it may not be returned yet.
 * @property {SharingSharedContentLinkMetadata} [link_metadata] - The metadata
 * of the link associated for the file. This is for an unreleased feature so it
 * may not be returned yet.
 * @property {Array.<string>} [owner_display_names] - The display names of the
 * users that own the file. If the file is part of a team folder, the display
 * names of the team admins are also included. Absent if the owner display names
 * cannot be fetched.
 * @property {UsersTeam} [owner_team] - The team that owns the file. This field
 * is not present if the file is not owned by a team.
 * @property {string} [parent_shared_folder_id] - The ID of the parent shared
 * folder. This field is present only if the file is contained within a shared
 * folder.
 * @property {string} [path_display] - The cased path to be used for display
 * purposes only. In rare instances the casing will not correctly match the
 * user's filesystem, but this behavior will match the path provided in the Core
 * API v1. Absent for unmounted files.
 * @property {string} [path_lower] - The lower-case full path of this file.
 * Absent for unmounted files.
 * @property {Array.<SharingFilePermission>} [permissions] - The sharing
 * permissions that requesting user has on this file. This corresponds to the
 * entries given in GetFileMetadataBatchArg.actions or
 * GetFileMetadataArg.actions.
 * @property {Timestamp} [time_invited] - Timestamp indicating when the current
 * user was invited to this shared file. If the user was not invited to the
 * shared file, the timestamp will indicate when the user was invited to the
 * parent shared folder. This value may be absent.
 */

/**
 * There is an error accessing the shared folder.
 * @typedef {Object} SharingSharedFolderAccessError
 * @property {('invalid_id'|'not_a_member'|'email_unverified'|'unmounted'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSharedFolderMemberError
 * @property {SharingMemberAccessLevelResult} [no_explicit_access] - Available
 * if .tag is no_explicit_access. The target member only has inherited access to
 * the shared folder.
 * @property {('invalid_dropbox_id'|'not_a_member'|'no_explicit_access'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Shared folder user and group membership.
 * @typedef {Object} SharingSharedFolderMembers
 * @property {Array.<SharingUserMembershipInfo>} users - The list of user
 * members of the shared folder.
 * @property {Array.<SharingGroupMembershipInfo>} groups - The list of group
 * members of the shared folder.
 * @property {Array.<SharingInviteeMembershipInfo>} invitees - The list of
 * invitees to the shared folder.
 * @property {string} [cursor] - Present if there are additional shared folder
 * members that have not been returned yet. Pass the cursor into
 * list_folder_members/continue to list additional members.
 */

/**
 * The metadata which includes basic information about the shared folder.
 * @typedef {Object} SharingSharedFolderMetadata
 * @property {SharingAccessLevel} access_type - The current user's access level
 * for this shared folder.
 * @property {boolean} is_inside_team_folder - Whether this folder is inside of
 * a team folder.
 * @property {boolean} is_team_folder - Whether this folder is a team folder
 * https://www.dropbox.com/en/help/986.
 * @property {string} name - The name of the this shared folder.
 * @property {SharingFolderPolicy} policy - Policies governing this shared
 * folder.
 * @property {string} preview_url - URL for displaying a web preview of the
 * shared folder.
 * @property {string} shared_folder_id - The ID of the shared folder.
 * @property {Timestamp} time_invited - Timestamp indicating when the current
 * user was invited to this shared folder.
 * @property {Array.<string>} [owner_display_names] - The display names of the
 * users that own the folder. If the folder is part of a team folder, the
 * display names of the team admins are also included. Absent if the owner
 * display names cannot be fetched.
 * @property {UsersTeam} [owner_team] - The team that owns the folder. This
 * field is not present if the folder is not owned by a team.
 * @property {string} [parent_shared_folder_id] - The ID of the parent shared
 * folder. This field is present only if the folder is contained within another
 * shared folder.
 * @property {string} [path_lower] - The lower-cased full path of this shared
 * folder. Absent for unmounted folders.
 * @property {SharingSharedContentLinkMetadata} [link_metadata] - The metadata
 * of the shared content link to this shared folder. Absent if there is no link
 * on the folder. This is for an unreleased feature so it may not be returned
 * yet.
 * @property {Array.<SharingFolderPermission>} [permissions] - Actions the
 * current user may perform on the folder and its contents. The set of
 * permissions corresponds to the FolderActions in the request.
 * @property {SharingAccessInheritance} access_inheritance - Whether the folder
 * inherits its members from its parent.
 */

/**
 * Properties of the shared folder.
 * @typedef {Object} SharingSharedFolderMetadataBase
 * @property {SharingAccessLevel} access_type - The current user's access level
 * for this shared folder.
 * @property {boolean} is_inside_team_folder - Whether this folder is inside of
 * a team folder.
 * @property {boolean} is_team_folder - Whether this folder is a team folder
 * https://www.dropbox.com/en/help/986.
 * @property {Array.<string>} [owner_display_names] - The display names of the
 * users that own the folder. If the folder is part of a team folder, the
 * display names of the team admins are also included. Absent if the owner
 * display names cannot be fetched.
 * @property {UsersTeam} [owner_team] - The team that owns the folder. This
 * field is not present if the folder is not owned by a team.
 * @property {string} [parent_shared_folder_id] - The ID of the parent shared
 * folder. This field is present only if the folder is contained within another
 * shared folder.
 * @property {string} [path_lower] - The lower-cased full path of this shared
 * folder. Absent for unmounted folders.
 */

/**
 * @typedef {Object} SharingSharedLinkAccessFailureReason
 * @property {('login_required'|'email_verify_required'|'password_required'|'team_only'|'owner_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSharedLinkAlreadyExistsMetadata
 * @property
 * {(SharingFileLinkMetadata|SharingFolderLinkMetadata|SharingSharedLinkMetadata)}
 * [metadata] - Available if .tag is metadata. Metadata of the shared link that
 * already exists.
 * @property {('metadata'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSharedLinkError
 * @property {('shared_link_not_found'|'shared_link_access_denied'|'unsupported_link_type'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The metadata of a shared link.
 * @typedef {Object} SharingSharedLinkMetadata
@property {("file"|"folder")} .tag - Tag identifying the subtype variant.
 * @property {string} url - URL of the shared link.
 * @property {string} name - The linked file name (including extension). This
 * never contains a slash.
 * @property {SharingLinkPermissions} link_permissions - The link's access
 * permissions.
 * @property {string} [id] - A unique identifier for the linked file.
 * @property {Timestamp} [expires] - Expiration time, if set. By default the
 * link won't expire.
 * @property {string} [path_lower] - The lowercased full path in the user's
 * Dropbox. This always starts with a slash. This field will only be present
 * only if the linked file is in the authenticated user's  dropbox.
 * @property {SharingTeamMemberInfo} [team_member_info] - The team membership
 * information of the link's owner.  This field will only be present  if the
 * link's owner is a team member.
 * @property {UsersTeam} [content_owner_team_info] - The team information of the
 * content's owner. This field will only be present if the content's owner is a
 * team member and the content's owner team is different from the link's owner
 * team.
 */

/**
 * Who can view shared links in this folder.
 * @typedef {Object} SharingSharedLinkPolicy
 * @property {('anyone'|'team'|'members'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingSharedLinkSettings
 * @property {SharingRequestedVisibility} [requested_visibility] - The requested
 * access for this shared link.
 * @property {string} [link_password] - If requested_visibility is
 * RequestedVisibility.password this is needed to specify the password to access
 * the link.
 * @property {Timestamp} [expires] - Expiration time of the shared link. By
 * default the link won't expire.
 * @property {SharingLinkAudience} [audience] - The new audience who can benefit
 * from the access level specified by the link's access level specified in the
 * `link_access_level` field of `LinkPermissions`. This is used in conjunction
 * with team policies and shared folder policies to determine the final
 * effective audience type in the `effective_audience` field of
 * `LinkPermissions.
 * @property {SharingRequestedLinkAccessLevel} [access] - Requested access level
 * you want the audience to gain from this link.
 */

/**
 * @typedef {Object} SharingSharedLinkSettingsError
 * @property {('invalid_settings'|'not_authorized')} .tag - Tag identifying the union variant.
 */

/**
 * User could not access this file.
 * @typedef {Object} SharingSharingFileAccessError
 * @property {('no_permission'|'invalid_file'|'is_folder'|'inside_public_folder'|'inside_osx_package'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User account had a problem preventing this action.
 * @typedef {Object} SharingSharingUserError
 * @property {('email_unverified'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about a team member.
 * @typedef {Object} SharingTeamMemberInfo
 * @property {UsersTeam} team_info - Information about the member's team.
 * @property {string} display_name - The display name of the user.
 * @property {string} [member_id] - ID of user as a member of a team. This field
 * will only be present if the member is in the same team as current user.
 */

/**
 * @typedef {Object} SharingTransferFolderArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {string} to_dropbox_id - A account or team member ID to transfer
 * ownership to.
 */

/**
 * @typedef {Object} SharingTransferFolderError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'invalid_dropbox_id'|'new_owner_not_a_member'|'new_owner_unmounted'|'new_owner_email_unverified'|'team_folder'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingUnmountFolderArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 */

/**
 * @typedef {Object} SharingUnmountFolderError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'no_permission'|'not_unmountable'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for unshare_file.
 * @typedef {Object} SharingUnshareFileArg
 * @property {string} file - The file to unshare.
 */

/**
 * Error result for unshare_file.
 * @typedef {Object} SharingUnshareFileError
 * @property {SharingSharingUserError} [user_error] - Available if .tag is
 * user_error.
 * @property {SharingSharingFileAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('user_error'|'access_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} SharingUnshareFolderArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {boolean} leave_a_copy - If true, members of this shared folder
 * will get a copy of this folder after it's unshared. Otherwise, it will be
 * removed from their Dropbox. The current user, who is an owner, will always
 * retain their copy.
 */

/**
 * @typedef {Object} SharingUnshareFolderError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'team_folder'|'no_permission'|'too_many_files'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Arguments for update_file_member.
 * @typedef {Object} SharingUpdateFileMemberArgs
 * @property {string} file - File for which we are changing a member's access.
 * @property {SharingMemberSelector} member - The member whose access we are
 * changing.
 * @property {SharingAccessLevel} access_level - The new access level for the
 * member.
 */

/**
 * @typedef {Object} SharingUpdateFolderMemberArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {SharingMemberSelector} member - The member of the shared folder to
 * update.  Only the MemberSelector.dropbox_id may be set at this time.
 * @property {SharingAccessLevel} access_level - The new access level for
 * member. AccessLevel.owner is disallowed.
 */

/**
 * @typedef {Object} SharingUpdateFolderMemberError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {SharingSharedFolderMemberError} [member_error] - Available if .tag
 * is member_error.
 * @property {SharingAddFolderMemberError} [no_explicit_access] - Available if
 * .tag is no_explicit_access. If updating the access type required the member
 * to be added to the shared folder and there was an error when adding the
 * member.
 * @property {('access_error'|'member_error'|'no_explicit_access'|'insufficient_plan'|'no_permission'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * If any of the policies are unset, then they retain their current setting.
 * @typedef {Object} SharingUpdateFolderPolicyArg
 * @property {string} shared_folder_id - The ID for the shared folder.
 * @property {SharingMemberPolicy} [member_policy] - Who can be a member of this
 * shared folder. Only applicable if the current user is on a team.
 * @property {SharingAclUpdatePolicy} [acl_update_policy] - Who can add and
 * remove members of this shared folder.
 * @property {SharingViewerInfoPolicy} [viewer_info_policy] - Who can
 * enable/disable viewer info for this shared folder.
 * @property {SharingSharedLinkPolicy} [shared_link_policy] - The policy to
 * apply to shared links created for content inside this shared folder. The
 * current user must be on a team to set this policy to
 * SharedLinkPolicy.members.
 * @property {SharingLinkSettings} [link_settings] - Settings on the link for
 * this folder.
 * @property {Array.<SharingFolderAction>} [actions] - A list of `FolderAction`s
 * corresponding to `FolderPermission`s that should appear in the  response's
 * SharedFolderMetadata.permissions field describing the actions the
 * authenticated user can perform on the folder.
 */

/**
 * @typedef {Object} SharingUpdateFolderPolicyError
 * @property {SharingSharedFolderAccessError} [access_error] - Available if .tag
 * is access_error.
 * @property {('access_error'|'not_on_team'|'team_policy_disallows_member_policy'|'disallowed_shared_link_policy'|'no_permission'|'team_folder'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The information about a user member of the shared content with an appended
 * last seen timestamp.
 * @typedef {Object} SharingUserFileMembershipInfo
 * @property {SharingAccessLevel} access_type - The access type for this member.
 * It contains inherited access type from parent folder, and acquired access
 * type from this folder.
 * @property {SharingUserInfo} user - The account information for the membership
 * user.
 * @property {Array.<SharingMemberPermission>} [permissions] - The permissions
 * that requesting user has on this member. The set of permissions corresponds
 * to the MemberActions in the request.
 * @property {string} [initials] - Never set.
 * @property {boolean} is_inherited - True if the member has access from a
 * parent folder.
 * @property {Timestamp} [time_last_seen] - The UTC timestamp of when the user
 * has last seen the content, if they have.
 * @property {SeenStatePlatformType} [platform_type] - The platform on which the
 * user has last seen the content, or unknown.
 */

/**
 * Basic information about a user. Use users.get_account and
 * users.get_account_batch to obtain more detailed information.
 * @typedef {Object} SharingUserInfo
 * @property {string} account_id - The account ID of the user.
 * @property {string} email - Email address of user.
 * @property {string} display_name - The display name of the user.
 * @property {boolean} same_team - If the user is in the same team as current
 * user.
 * @property {string} [team_member_id] - The team member ID of the shared folder
 * member. Only present if same_team is true.
 */

/**
 * The information about a user member of the shared content.
 * @typedef {Object} SharingUserMembershipInfo
 * @property {SharingAccessLevel} access_type - The access type for this member.
 * It contains inherited access type from parent folder, and acquired access
 * type from this folder.
 * @property {SharingUserInfo} user - The account information for the membership
 * user.
 * @property {Array.<SharingMemberPermission>} [permissions] - The permissions
 * that requesting user has on this member. The set of permissions corresponds
 * to the MemberActions in the request.
 * @property {string} [initials] - Never set.
 * @property {boolean} is_inherited - True if the member has access from a
 * parent folder.
 */

/**
 * @typedef {Object} SharingViewerInfoPolicy
 * @property {('enabled'|'disabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Who can access a shared link. The most open visibility is public. The default
 * depends on many aspects, such as team and user preferences and shared folder
 * settings.
 * @typedef {Object} SharingVisibility
 * @property {('public'|'team_only'|'password'|'team_and_password'|'shared_folder_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information on active web sessions.
 * @typedef {Object} TeamActiveWebSession
 * @property {string} session_id - The session id.
 * @property {string} user_agent - Information on the hosting device.
 * @property {string} os - Information on the hosting operating system.
 * @property {string} browser - Information on the browser used for this web
 * session.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session.
 * @property {string} [country] - The country from which the last activity from
 * this session was made.
 * @property {Timestamp} [created] - The time this session was created.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session.
 * @property {Timestamp} [expires] - The time this session expires.
 */

/**
 * Describes which team-related admin permissions a user has.
 * @typedef {Object} TeamAdminTier
 * @property {('team_admin'|'user_management_admin'|'support_admin'|'member_only')} .tag - Tag identifying the union variant.
 */

/**
 * Information on linked third party applications.
 * @typedef {Object} TeamApiApp
 * @property {string} app_id - The application unique id.
 * @property {string} app_name - The application name.
 * @property {boolean} is_app_folder - Whether the linked application uses a
 * dedicated folder.
 * @property {string} [publisher] - The application publisher name.
 * @property {string} [publisher_url] - The publisher's URL.
 * @property {Timestamp} [linked] - The time this application was linked.
 */

/**
 * Base report structure.
 * @typedef {Object} TeamBaseDfbReport
 * @property {string} start_date - First date present in the results as
 * 'YYYY-MM-DD' or None.
 */

/**
 * Base error that all errors for existing team folders should extend.
 * @typedef {Object} TeamBaseTeamFolderError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Error returned when getting member custom quota.
 * @typedef {Object} TeamCustomQuotaError
 * @property {('too_many_users'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User custom quota.
 * @typedef {Object} TeamCustomQuotaResult
 * @property {TeamUserCustomQuotaResult} [success] - Available if .tag is
 * success. User's custom quota.
 * @property {TeamUserSelectorArg} [invalid_user] - Available if .tag is
 * invalid_user. Invalid user (not in team).
 * @property {('success'|'invalid_user'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamCustomQuotaUsersArg
 * @property {Array.<TeamUserSelectorArg>} users - List of users.
 */

/**
 * Input arguments that can be provided for most reports.
 * @typedef {Object} TeamDateRange
 * @property {Timestamp} [start_date] - Optional starting date (inclusive).
 * @property {Timestamp} [end_date] - Optional ending date (exclusive).
 */

/**
 * Errors that can originate from problems in input arguments to reports.
 * @typedef {Object} TeamDateRangeError
 * @property {'other'} .tag - Tag identifying the union variant.
 */

/**
 * Information about linked Dropbox desktop client sessions.
 * @typedef {Object} TeamDesktopClientSession
 * @property {string} session_id - The session id.
 * @property {string} host_name - Name of the hosting desktop.
 * @property {TeamDesktopPlatform} client_type - The Dropbox desktop client
 * type.
 * @property {string} client_version - The Dropbox client version.
 * @property {string} platform - Information on the hosting platform.
 * @property {boolean} is_delete_on_unlink_supported - Whether it's possible to
 * delete all of the account files upon unlinking.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session.
 * @property {string} [country] - The country from which the last activity from
 * this session was made.
 * @property {Timestamp} [created] - The time this session was created.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session.
 */

/**
 * @typedef {Object} TeamDesktopPlatform
 * @property {('windows'|'mac'|'linux'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamDeviceSession
 * @property {string} session_id - The session id.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session.
 * @property {string} [country] - The country from which the last activity from
 * this session was made.
 * @property {Timestamp} [created] - The time this session was created.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session.
 */

/**
 * @typedef {Object} TeamDeviceSessionArg
 * @property {string} session_id - The session id.
 * @property {string} team_member_id - The unique id of the member owning the
 * device.
 */

/**
 * Each of the items is an array of values, one value per day. The value is the
 * number of devices active within a time window, ending with that day. If there
 * is no data for a day, then the value will be None.
 * @typedef {Object} TeamDevicesActive
 * @property {Array.<Object>} windows - Array of number of linked windows
 * (desktop) clients with activity.
 * @property {Array.<Object>} macos - Array of number of linked mac (desktop)
 * clients with activity.
 * @property {Array.<Object>} linux - Array of number of linked linus (desktop)
 * clients with activity.
 * @property {Array.<Object>} ios - Array of number of linked ios devices with
 * activity.
 * @property {Array.<Object>} android - Array of number of linked android
 * devices with activity.
 * @property {Array.<Object>} other - Array of number of other linked devices
 * (blackberry, windows phone, etc)  with activity.
 * @property {Array.<Object>} total - Array of total number of linked clients
 * with activity.
 */

/**
 * Excluded users list argument.
 * @typedef {Object} TeamExcludedUsersListArg
 * @property {number} limit - Number of results to return per call.
 */

/**
 * Excluded users list continue argument.
 * @typedef {Object} TeamExcludedUsersListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * users.
 */

/**
 * Excluded users list continue error.
 * @typedef {Object} TeamExcludedUsersListContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Excluded users list error.
 * @typedef {Object} TeamExcludedUsersListError
 * @property {('list_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Excluded users list result.
 * @typedef {Object} TeamExcludedUsersListResult
 * @property {Array.<TeamMemberProfile>} users
 * @property {boolean} has_more - Is true if there are additional excluded users
 * that have not been returned yet. An additional call to
 * member_space_limits/excluded_users/list/continue can retrieve them.
 * @property {string} [cursor] - Pass the cursor into
 * member_space_limits/excluded_users/list/continue to obtain additional
 * excluded users.
 */

/**
 * Argument of excluded users update operation. Should include a list of users
 * to add/remove (according to endpoint), Maximum size of the list is 1000
 * users.
 * @typedef {Object} TeamExcludedUsersUpdateArg
 * @property {Array.<TeamUserSelectorArg>} [users] - List of users to be
 * added/removed.
 */

/**
 * Excluded users update error.
 * @typedef {Object} TeamExcludedUsersUpdateError
 * @property {('users_not_in_team'|'too_many_users'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Excluded users update result.
 * @typedef {Object} TeamExcludedUsersUpdateResult
 * @property {TeamExcludedUsersUpdateStatus} status - Update status.
 */

/**
 * Excluded users update operation status.
 * @typedef {Object} TeamExcludedUsersUpdateStatus
 * @property {('success'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * A set of features that a Dropbox Business account may support.
 * @typedef {Object} TeamFeature
 * @property {('upload_api_rate_limit'|'has_team_shared_dropbox'|'has_team_file_events'|'has_team_selective_sync'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The values correspond to entries in Feature. You may get different value
 * according to your Dropbox Business plan.
 * @typedef {Object} TeamFeatureValue
 * @property {TeamUploadApiRateLimitValue} [upload_api_rate_limit] - Available
 * if .tag is upload_api_rate_limit.
 * @property {TeamHasTeamSharedDropboxValue} [has_team_shared_dropbox] -
 * Available if .tag is has_team_shared_dropbox.
 * @property {TeamHasTeamFileEventsValue} [has_team_file_events] - Available if
 * .tag is has_team_file_events.
 * @property {TeamHasTeamSelectiveSyncValue} [has_team_selective_sync] -
 * Available if .tag is has_team_selective_sync.
 * @property {('upload_api_rate_limit'|'has_team_shared_dropbox'|'has_team_file_events'|'has_team_selective_sync'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamFeaturesGetValuesBatchArg
 * @property {Array.<TeamFeature>} features - A list of features in Feature. If
 * the list is empty, this route will return FeaturesGetValuesBatchError.
 */

/**
 * @typedef {Object} TeamFeaturesGetValuesBatchError
 * @property {('empty_features_list'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamFeaturesGetValuesBatchResult
 * @property {Array.<TeamFeatureValue>} values
 */

/**
 * Activity Report Result. Each of the items in the storage report is an array
 * of values, one value per day. If there is no data for a day, then the value
 * will be None.
 * @typedef {Object} TeamGetActivityReport
 * @property {string} start_date - First date present in the results as
 * 'YYYY-MM-DD' or None.
 * @property {Array.<Object>} adds - Array of total number of adds by team
 * members.
 * @property {Array.<Object>} edits - Array of number of edits by team members.
 * If the same user edits the same file multiple times this is counted as a
 * single edit.
 * @property {Array.<Object>} deletes - Array of total number of deletes by team
 * members.
 * @property {Array.<Object>} active_users_28_day - Array of the number of users
 * who have been active in the last 28 days.
 * @property {Array.<Object>} active_users_7_day - Array of the number of users
 * who have been active in the last week.
 * @property {Array.<Object>} active_users_1_day - Array of the number of users
 * who have been active in the last day.
 * @property {Array.<Object>} active_shared_folders_28_day - Array of the number
 * of shared folders with some activity in the last 28 days.
 * @property {Array.<Object>} active_shared_folders_7_day - Array of the number
 * of shared folders with some activity in the last week.
 * @property {Array.<Object>} active_shared_folders_1_day - Array of the number
 * of shared folders with some activity in the last day.
 * @property {Array.<Object>} shared_links_created - Array of the number of
 * shared links created.
 * @property {Array.<Object>} shared_links_viewed_by_team - Array of the number
 * of views by team users to shared links created by the team.
 * @property {Array.<Object>} shared_links_viewed_by_outside_user - Array of the
 * number of views by users outside of the team to shared links created by the
 * team.
 * @property {Array.<Object>} shared_links_viewed_by_not_logged_in - Array of
 * the number of views by non-logged-in users to shared links created by the
 * team.
 * @property {Array.<Object>} shared_links_viewed_total - Array of the total
 * number of views to shared links created by the team.
 */

/**
 * Devices Report Result. Contains subsections for different time ranges of
 * activity. Each of the items in each subsection of the storage report is an
 * array of values, one value per day. If there is no data for a day, then the
 * value will be None.
 * @typedef {Object} TeamGetDevicesReport
 * @property {string} start_date - First date present in the results as
 * 'YYYY-MM-DD' or None.
 * @property {TeamDevicesActive} active_1_day - Report of the number of devices
 * active in the last day.
 * @property {TeamDevicesActive} active_7_day - Report of the number of devices
 * active in the last 7 days.
 * @property {TeamDevicesActive} active_28_day - Report of the number of devices
 * active in the last 28 days.
 */

/**
 * Membership Report Result. Each of the items in the storage report is an array
 * of values, one value per day. If there is no data for a day, then the value
 * will be None.
 * @typedef {Object} TeamGetMembershipReport
 * @property {string} start_date - First date present in the results as
 * 'YYYY-MM-DD' or None.
 * @property {Array.<Object>} team_size - Team size, for each day.
 * @property {Array.<Object>} pending_invites - The number of pending invites to
 * the team, for each day.
 * @property {Array.<Object>} members_joined - The number of members that joined
 * the team, for each day.
 * @property {Array.<Object>} suspended_members - The number of suspended team
 * members, for each day.
 * @property {Array.<Object>} licenses - The total number of licenses the team
 * has, for each day.
 */

/**
 * Storage Report Result. Each of the items in the storage report is an array of
 * values, one value per day. If there is no data for a day, then the value will
 * be None.
 * @typedef {Object} TeamGetStorageReport
 * @property {string} start_date - First date present in the results as
 * 'YYYY-MM-DD' or None.
 * @property {Array.<Object>} total_usage - Sum of the shared, unshared, and
 * datastore usages, for each day.
 * @property {Array.<Object>} shared_usage - Array of the combined size (bytes)
 * of team members' shared folders, for each day.
 * @property {Array.<Object>} unshared_usage - Array of the combined size
 * (bytes) of team members' root namespaces, for each day.
 * @property {Array.<Object>} shared_folders - Array of the number of shared
 * folders owned by team members, for each day.
 * @property {Array.<Array.<TeamStorageBucket>>} member_storage_map - Array of
 * storage summaries of team members' account sizes. Each storage summary is an
 * array of key, value pairs, where each pair describes a storage bucket. The
 * key indicates the upper bound of the bucket and the value is the number of
 * users in that bucket. There is one such summary per day. If there is no data
 * for a day, the storage summary will be empty.
 */

/**
 * Role of a user in group.
 * @typedef {Object} TeamGroupAccessType
 * @property {('member'|'owner')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupCreateArg
 * @property {string} group_name - Group name.
 * @property {string} [group_external_id] - The creator of a team can associate
 * an arbitrary external ID to the group.
 * @property {TeamCommonGroupManagementType} [group_management_type] - Whether
 * the team can be managed by selected users, or only by team admins.
 */

/**
 * @typedef {Object} TeamGroupCreateError
 * @property {('group_name_already_used'|'group_name_invalid'|'external_id_already_in_use'|'system_managed_group_disallowed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupDeleteError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'group_already_deleted')} .tag - Tag identifying the union variant.
 */

/**
 * Full description of a group.
 * @typedef {Object} TeamGroupFullInfo
 * @property {string} group_name
 * @property {string} group_id
 * @property {TeamCommonGroupManagementType} group_management_type - Who is
 * allowed to manage the group.
 * @property {number} created - The group creation time as a UTC timestamp in
 * milliseconds since the Unix epoch.
 * @property {string} [group_external_id] - External ID of group. This is an
 * arbitrary ID that an admin can attach to a group.
 * @property {number} [member_count] - The number of members in the group.
 * @property {Array.<TeamGroupMemberInfo>} [members] - List of group members.
 */

/**
 * Profile of group member, and role in group.
 * @typedef {Object} TeamGroupMemberInfo
 * @property {TeamMemberProfile} profile - Profile of group member.
 * @property {TeamGroupAccessType} access_type - The role that the user has in
 * the group.
 */

/**
 * Argument for selecting a group and a single user.
 * @typedef {Object} TeamGroupMemberSelector
 * @property {TeamGroupSelector} group - Specify a group.
 * @property {TeamUserSelectorArg} user - Identity of a user that is a member of
 * group.
 */

/**
 * Error that can be raised when GroupMemberSelector is used, and the user is
 * required to be a member of the specified group.
 * @typedef {Object} TeamGroupMemberSelectorError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'member_not_in_group')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupMemberSetAccessTypeError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'member_not_in_group'|'user_cannot_be_manager_of_company_managed_group')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupMembersAddArg
 * @property {TeamGroupSelector} group - Group to which users will be added.
 * @property {Array.<TeamMemberAccess>} members - List of users to be added to
 * the group.
 * @property {boolean} return_members - Whether to return the list of members in
 * the group.  Note that the default value will cause all the group members  to
 * be returned in the response. This may take a long time for large groups.
 */

/**
 * @typedef {Object} TeamGroupMembersAddError
 * @property {Array.<string>} [members_not_in_team] - Available if .tag is
 * members_not_in_team. These members are not part of your team. Currently, you
 * cannot add members to a group if they are not part of your team, though this
 * may change in a subsequent version. To add new members to your Dropbox
 * Business team, use the :route:`members/add` endpoint.
 * @property {Array.<string>} [users_not_found] - Available if .tag is
 * users_not_found. These users were not found in Dropbox.
 * @property {Array.<string>} [user_cannot_be_manager_of_company_managed_group]
 * - Available if .tag is user_cannot_be_manager_of_company_managed_group. A
 * company-managed group cannot be managed by a user.
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'duplicate_user'|'group_not_in_team'|'members_not_in_team'|'users_not_found'|'user_must_be_active_to_be_owner'|'user_cannot_be_manager_of_company_managed_group')} .tag - Tag identifying the union variant.
 */

/**
 * Result returned by groups/members/add and groups/members/remove.
 * @typedef {Object} TeamGroupMembersChangeResult
 * @property {TeamGroupFullInfo} group_info - The group info after member change
 * operation has been performed.
 * @property {string} async_job_id - An ID that can be used to obtain the status
 * of granting/revoking group-owned resources.
 */

/**
 * @typedef {Object} TeamGroupMembersRemoveArg
 * @property {TeamGroupSelector} group - Group from which users will be removed.
 * @property {Array.<TeamUserSelectorArg>} users - List of users to be removed
 * from the group.
 * @property {boolean} return_members - Whether to return the list of members in
 * the group.  Note that the default value will cause all the group members  to
 * be returned in the response. This may take a long time for large groups.
 */

/**
 * @typedef {Object} TeamGroupMembersRemoveError
 * @property {Array.<string>} [members_not_in_team] - Available if .tag is
 * members_not_in_team. These members are not part of your team.
 * @property {Array.<string>} [users_not_found] - Available if .tag is
 * users_not_found. These users were not found in Dropbox.
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'member_not_in_group'|'group_not_in_team'|'members_not_in_team'|'users_not_found')} .tag - Tag identifying the union variant.
 */

/**
 * Argument for selecting a group and a list of users.
 * @typedef {Object} TeamGroupMembersSelector
 * @property {TeamGroupSelector} group - Specify a group.
 * @property {TeamUsersSelectorArg} users - A list of users that are members of
 * group.
 */

/**
 * Error that can be raised when GroupMembersSelector is used, and the users are
 * required to be members of the specified group.
 * @typedef {Object} TeamGroupMembersSelectorError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'member_not_in_group')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupMembersSetAccessTypeArg
 * @property {TeamGroupSelector} group - Specify a group.
 * @property {TeamUserSelectorArg} user - Identity of a user that is a member of
 * group.
 * @property {TeamGroupAccessType} access_type - New group access type the user
 * will have.
 * @property {boolean} return_members - Whether to return the list of members in
 * the group.  Note that the default value will cause all the group members  to
 * be returned in the response. This may take a long time for large groups.
 */

/**
 * Argument for selecting a single group, either by group_id or by external
 * group ID.
 * @typedef {Object} TeamGroupSelector
 * @property {string} [group_id] - Available if .tag is group_id. Group ID.
 * @property {string} [group_external_id] - Available if .tag is
 * group_external_id. External ID of the group.
 * @property {('group_id'|'group_external_id')} .tag - Tag identifying the union variant.
 */

/**
 * Error that can be raised when GroupSelector is used.
 * @typedef {Object} TeamGroupSelectorError
 * @property {('group_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Error that can be raised when GroupSelector is used and team groups are
 * disallowed from being used.
 * @typedef {Object} TeamGroupSelectorWithTeamGroupError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupUpdateArgs
 * @property {TeamGroupSelector} group - Specify a group.
 * @property {boolean} return_members - Whether to return the list of members in
 * the group.  Note that the default value will cause all the group members  to
 * be returned in the response. This may take a long time for large groups.
 * @property {string} [new_group_name] - Optional argument. Set group name to
 * this if provided.
 * @property {string} [new_group_external_id] - Optional argument. New group
 * external ID. If the argument is None, the group's external_id won't be
 * updated. If the argument is empty string, the group's external id will be
 * cleared.
 * @property {TeamCommonGroupManagementType} [new_group_management_type] - Set
 * new group management type, if provided.
 */

/**
 * @typedef {Object} TeamGroupUpdateError
 * @property {('group_not_found'|'other'|'system_managed_group_disallowed'|'group_name_already_used'|'group_name_invalid'|'external_id_already_in_use')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupsGetInfoError
 * @property {('group_not_on_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupsGetInfoItem
 * @property {string} [id_not_found] - Available if .tag is id_not_found. An ID
 * that was provided as a parameter to :route:`groups/get_info`, and did not
 * match a corresponding group. The ID can be a group ID, or an external ID,
 * depending on how the method was called.
 * @property {TeamGroupFullInfo} [group_info] - Available if .tag is group_info.
 * Info about a group.
 * @property {('id_not_found'|'group_info')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupsListArg
 * @property {number} limit - Number of results to return per call.
 */

/**
 * @typedef {Object} TeamGroupsListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * groups.
 */

/**
 * @typedef {Object} TeamGroupsListContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupsListResult
 * @property {Array.<TeamCommonGroupSummary>} groups
 * @property {string} cursor - Pass the cursor into groups/list/continue to
 * obtain the additional groups.
 * @property {boolean} has_more - Is true if there are additional groups that
 * have not been returned yet. An additional call to groups/list/continue can
 * retrieve them.
 */

/**
 * @typedef {Object} TeamGroupsMembersListArg
 * @property {TeamGroupSelector} group - The group whose members are to be
 * listed.
 * @property {number} limit - Number of results to return per call.
 */

/**
 * @typedef {Object} TeamGroupsMembersListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * groups.
 */

/**
 * @typedef {Object} TeamGroupsMembersListContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamGroupsMembersListResult
 * @property {Array.<TeamGroupMemberInfo>} members
 * @property {string} cursor - Pass the cursor into groups/members/list/continue
 * to obtain additional group members.
 * @property {boolean} has_more - Is true if there are additional group members
 * that have not been returned yet. An additional call to
 * groups/members/list/continue can retrieve them.
 */

/**
 * @typedef {Object} TeamGroupsPollError
 * @property {('invalid_async_job_id'|'internal_error'|'other'|'access_denied')} .tag - Tag identifying the union variant.
 */

/**
 * Argument for selecting a list of groups, either by group_ids, or external
 * group IDs.
 * @typedef {Object} TeamGroupsSelector
 * @property {Array.<Object>} [group_ids] - Available if .tag is group_ids. List
 * of group IDs.
 * @property {Array.<string>} [group_external_ids] - Available if .tag is
 * group_external_ids. List of external IDs of groups.
 * @property {('group_ids'|'group_external_ids')} .tag - Tag identifying the union variant.
 */

/**
 * The value for Feature.has_team_file_events.
 * @typedef {Object} TeamHasTeamFileEventsValue
 * @property {boolean} [enabled] - Available if .tag is enabled. Does this team
 * have file events.
 * @property {('enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The value for Feature.has_team_selective_sync.
 * @typedef {Object} TeamHasTeamSelectiveSyncValue
 * @property {boolean} [has_team_selective_sync] - Available if .tag is
 * has_team_selective_sync. Does this team have team selective sync enabled.
 * @property {('has_team_selective_sync'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The value for Feature.has_team_shared_dropbox.
 * @typedef {Object} TeamHasTeamSharedDropboxValue
 * @property {boolean} [has_team_shared_dropbox] - Available if .tag is
 * has_team_shared_dropbox. Does this team have a shared team root.
 * @property {('has_team_shared_dropbox'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamIncludeMembersArg
 * @property {boolean} return_members - Whether to return the list of members in
 * the group.  Note that the default value will cause all the group members  to
 * be returned in the response. This may take a long time for large groups.
 */

/**
 * @typedef {Object} TeamListMemberAppsArg
 * @property {string} team_member_id - The team member id.
 */

/**
 * Error returned by linked_apps/list_member_linked_apps.
 * @typedef {Object} TeamListMemberAppsError
 * @property {('member_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamListMemberAppsResult
 * @property {Array.<TeamApiApp>} linked_api_apps - List of third party
 * applications linked by this team member.
 */

/**
 * @typedef {Object} TeamListMemberDevicesArg
 * @property {string} team_member_id - The team's member id.
 * @property {boolean} include_web_sessions - Whether to list web sessions of
 * the team's member.
 * @property {boolean} include_desktop_clients - Whether to list linked desktop
 * devices of the team's member.
 * @property {boolean} include_mobile_clients - Whether to list linked mobile
 * devices of the team's member.
 */

/**
 * @typedef {Object} TeamListMemberDevicesError
 * @property {('member_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamListMemberDevicesResult
 * @property {Array.<TeamActiveWebSession>} [active_web_sessions] - List of web
 * sessions made by this team member.
 * @property {Array.<TeamDesktopClientSession>} [desktop_client_sessions] - List
 * of desktop clients used by this team member.
 * @property {Array.<TeamMobileClientSession>} [mobile_client_sessions] - List
 * of mobile client used by this team member.
 */

/**
 * Arguments for linked_apps/list_members_linked_apps.
 * @typedef {Object} TeamListMembersAppsArg
 * @property {string} [cursor] - At the first call to the
 * linked_apps/list_members_linked_apps the cursor shouldn't be passed. Then, if
 * the result of the call includes a cursor, the following requests should
 * include the received cursors in order to receive the next sub list of the
 * team applications.
 */

/**
 * Error returned by linked_apps/list_members_linked_apps.
 * @typedef {Object} TeamListMembersAppsError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information returned by linked_apps/list_members_linked_apps.
 * @typedef {Object} TeamListMembersAppsResult
 * @property {Array.<TeamMemberLinkedApps>} apps - The linked applications of
 * each member of the team.
 * @property {boolean} has_more - If true, then there are more apps available.
 * Pass the cursor to linked_apps/list_members_linked_apps to retrieve the rest.
 * @property {string} [cursor] - Pass the cursor into
 * linked_apps/list_members_linked_apps to receive the next sub list of team's
 * applications.
 */

/**
 * @typedef {Object} TeamListMembersDevicesArg
 * @property {string} [cursor] - At the first call to the
 * devices/list_members_devices the cursor shouldn't be passed. Then, if the
 * result of the call includes a cursor, the following requests should include
 * the received cursors in order to receive the next sub list of team devices.
 * @property {boolean} include_web_sessions - Whether to list web sessions of
 * the team members.
 * @property {boolean} include_desktop_clients - Whether to list desktop clients
 * of the team members.
 * @property {boolean} include_mobile_clients - Whether to list mobile clients
 * of the team members.
 */

/**
 * @typedef {Object} TeamListMembersDevicesError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamListMembersDevicesResult
 * @property {Array.<TeamMemberDevices>} devices - The devices of each member of
 * the team.
 * @property {boolean} has_more - If true, then there are more devices
 * available. Pass the cursor to devices/list_members_devices to retrieve the
 * rest.
 * @property {string} [cursor] - Pass the cursor into
 * devices/list_members_devices to receive the next sub list of team's devices.
 */

/**
 * Arguments for linked_apps/list_team_linked_apps.
 * @typedef {Object} TeamListTeamAppsArg
 * @property {string} [cursor] - At the first call to the
 * linked_apps/list_team_linked_apps the cursor shouldn't be passed. Then, if
 * the result of the call includes a cursor, the following requests should
 * include the received cursors in order to receive the next sub list of the
 * team applications.
 */

/**
 * Error returned by linked_apps/list_team_linked_apps.
 * @typedef {Object} TeamListTeamAppsError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information returned by linked_apps/list_team_linked_apps.
 * @typedef {Object} TeamListTeamAppsResult
 * @property {Array.<TeamMemberLinkedApps>} apps - The linked applications of
 * each member of the team.
 * @property {boolean} has_more - If true, then there are more apps available.
 * Pass the cursor to linked_apps/list_team_linked_apps to retrieve the rest.
 * @property {string} [cursor] - Pass the cursor into
 * linked_apps/list_team_linked_apps to receive the next sub list of team's
 * applications.
 */

/**
 * @typedef {Object} TeamListTeamDevicesArg
 * @property {string} [cursor] - At the first call to the
 * devices/list_team_devices the cursor shouldn't be passed. Then, if the result
 * of the call includes a cursor, the following requests should include the
 * received cursors in order to receive the next sub list of team devices.
 * @property {boolean} include_web_sessions - Whether to list web sessions of
 * the team members.
 * @property {boolean} include_desktop_clients - Whether to list desktop clients
 * of the team members.
 * @property {boolean} include_mobile_clients - Whether to list mobile clients
 * of the team members.
 */

/**
 * @typedef {Object} TeamListTeamDevicesError
 * @property {('reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamListTeamDevicesResult
 * @property {Array.<TeamMemberDevices>} devices - The devices of each member of
 * the team.
 * @property {boolean} has_more - If true, then there are more devices
 * available. Pass the cursor to devices/list_team_devices to retrieve the rest.
 * @property {string} [cursor] - Pass the cursor into devices/list_team_devices
 * to receive the next sub list of team's devices.
 */

/**
 * Specify access type a member should have when joined to a group.
 * @typedef {Object} TeamMemberAccess
 * @property {TeamUserSelectorArg} user - Identity of a user.
 * @property {TeamGroupAccessType} access_type - Access type.
 */

/**
 * @typedef {Object} TeamMemberAddArg
 * @property {string} member_email
 * @property {string} [member_given_name] - Member's first name.
 * @property {string} [member_surname] - Member's last name.
 * @property {string} [member_external_id] - External ID for member.
 * @property {string} [member_persistent_id] - Persistent ID for member. This
 * field is only available to teams using persistent ID SAML configuration.
 * @property {boolean} send_welcome_email - Whether to send a welcome email to
 * the member. If send_welcome_email is false, no email invitation will be sent
 * to the user. This may be useful for apps using single sign-on (SSO) flows for
 * onboarding that want to handle announcements themselves.
 * @property {TeamAdminTier} role
 * @property {boolean} [is_directory_restricted] - Whether a user is directory
 * restricted.
 */

/**
 * Describes the result of attempting to add a single user to the team.
 * 'success' is the only value indicating that a user was indeed added to the
 * team - the other values explain the type of failure that occurred, and
 * include the email of the user for which the operation has failed.
 * @typedef {Object} TeamMemberAddResult
 * @property {TeamTeamMemberInfo} [success] - Available if .tag is success.
 * Describes a user that was successfully added to the team.
 * @property {string} [team_license_limit] - Available if .tag is
 * team_license_limit. Team is already full. The organization has no available
 * licenses.
 * @property {string} [free_team_member_limit_reached] - Available if .tag is
 * free_team_member_limit_reached. Team is already full. The free team member
 * limit has been reached.
 * @property {string} [user_already_on_team] - Available if .tag is
 * user_already_on_team. User is already on this team. The provided email
 * address is associated with a user who is already a member of (including in
 * recoverable state) or invited to the team.
 * @property {string} [user_on_another_team] - Available if .tag is
 * user_on_another_team. User is already on another team. The provided email
 * address is associated with a user that is already a member or invited to
 * another team.
 * @property {string} [user_already_paired] - Available if .tag is
 * user_already_paired. User is already paired.
 * @property {string} [user_migration_failed] - Available if .tag is
 * user_migration_failed. User migration has failed.
 * @property {string} [duplicate_external_member_id] - Available if .tag is
 * duplicate_external_member_id. A user with the given external member ID
 * already exists on the team (including in recoverable state).
 * @property {string} [duplicate_member_persistent_id] - Available if .tag is
 * duplicate_member_persistent_id. A user with the given persistent ID already
 * exists on the team (including in recoverable state).
 * @property {string} [persistent_id_disabled] - Available if .tag is
 * persistent_id_disabled. Persistent ID is only available to teams with
 * persistent ID SAML configuration. Please contact Dropbox for more
 * information.
 * @property {string} [user_creation_failed] - Available if .tag is
 * user_creation_failed. User creation has failed.
 * @property {('success'|'team_license_limit'|'free_team_member_limit_reached'|'user_already_on_team'|'user_on_another_team'|'user_already_paired'|'user_migration_failed'|'duplicate_external_member_id'|'duplicate_member_persistent_id'|'persistent_id_disabled'|'user_creation_failed')} .tag - Tag identifying the union variant.
 */

/**
 * Information on devices of a team's member.
 * @typedef {Object} TeamMemberDevices
 * @property {string} team_member_id - The member unique Id.
 * @property {Array.<TeamActiveWebSession>} [web_sessions] - List of web
 * sessions made by this team member.
 * @property {Array.<TeamDesktopClientSession>} [desktop_clients] - List of
 * desktop clients by this team member.
 * @property {Array.<TeamMobileClientSession>} [mobile_clients] - List of mobile
 * clients by this team member.
 */

/**
 * Information on linked applications of a team member.
 * @typedef {Object} TeamMemberLinkedApps
 * @property {string} team_member_id - The member unique Id.
 * @property {Array.<TeamApiApp>} linked_api_apps - List of third party
 * applications linked by this team member.
 */

/**
 * Basic member profile.
 * @typedef {Object} TeamMemberProfile
 * @property {string} team_member_id - ID of user as a member of a team.
 * @property {string} email - Email address of user.
 * @property {boolean} email_verified - Is true if the user's email is verified
 * to be owned by the user.
 * @property {TeamTeamMemberStatus} status - The user's status as a member of a
 * specific team.
 * @property {UsersName} name - Representations for a person's name.
 * @property {TeamTeamMembershipType} membership_type - The user's membership
 * type: full (normal team member) vs limited (does not use a license; no access
 * to the team's shared quota).
 * @property {string} [external_id] - External ID that a team can attach to the
 * user. An application using the API may find it easier to use their own IDs
 * instead of Dropbox IDs like account_id or team_member_id.
 * @property {string} [account_id] - A user's account identifier.
 * @property {Timestamp} [joined_on] - The date and time the user joined as a
 * member of a specific team.
 * @property {Timestamp} [suspended_on] - The date and time the user was
 * suspended from the team (contains value only when the member's status matches
 * TeamMemberStatus.suspended.
 * @property {string} [persistent_id] - Persistent ID that a team can attach to
 * the user. The persistent ID is unique ID to be used for SAML authentication.
 * @property {boolean} [is_directory_restricted] - Whether the user is a
 * directory restricted user.
 * @property {string} [profile_photo_url] - URL for the photo representing the
 * user, if one is set.
 */

/**
 * @typedef {Object} TeamMemberSelectorError
 * @property {('user_not_found'|'user_not_in_team')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersAddArg
 * @property {Array.<TeamMemberAddArg>} new_members - Details of new members to
 * be added to the team.
 * @property {boolean} force_async - Whether to force the add to happen
 * asynchronously.
 */

/**
 * @typedef {Object} TeamMembersAddJobStatus
 * @property {Array.<TeamMemberAddResult>} [complete] - Available if .tag is
 * complete. The asynchronous job has finished. For each member that was
 * specified in the parameter :type:`MembersAddArg` that was provided to
 * :route:`members/add`, a corresponding item is returned in this list.
 * @property {string} [failed] - Available if .tag is failed. The asynchronous
 * job returned an error. The string contains an error message.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersAddLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {Array.<TeamMemberAddResult>} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersDataTransferArg
 * @property {TeamUserSelectorArg} user - Identity of user to
 * remove/suspend/have their files moved.
 * @property {TeamUserSelectorArg} transfer_dest_id - Files from the deleted
 * member account will be transferred to this user.
 * @property {TeamUserSelectorArg} transfer_admin_id - Errors during the
 * transfer process will be sent via email to this user.
 */

/**
 * @typedef {Object} TeamMembersDeactivateArg
 * @property {TeamUserSelectorArg} user - Identity of user to
 * remove/suspend/have their files moved.
 * @property {boolean} wipe_data - If provided, controls if the user's data will
 * be deleted on their linked devices.
 */

/**
 * Exactly one of team_member_id, email, or external_id must be provided to
 * identify the user account.
 * @typedef {Object} TeamMembersDeactivateBaseArg
 * @property {TeamUserSelectorArg} user - Identity of user to
 * remove/suspend/have their files moved.
 */

/**
 * @typedef {Object} TeamMembersDeactivateError
 * @property {('user_not_found'|'user_not_in_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersGetInfoArgs
 * @property {Array.<TeamUserSelectorArg>} members - List of team members.
 */

/**
 * @typedef {Object} TeamMembersGetInfoError
 * @property {'other'} .tag - Tag identifying the union variant.
 */

/**
 * Describes a result obtained for a single user whose id was specified in the
 * parameter of members/get_info.
 * @typedef {Object} TeamMembersGetInfoItem
 * @property {string} [id_not_found] - Available if .tag is id_not_found. An ID
 * that was provided as a parameter to :route:`members/get_info`, and did not
 * match a corresponding user. This might be a team_member_id, an email, or an
 * external ID, depending on how the method was called.
 * @property {TeamTeamMemberInfo} [member_info] - Available if .tag is
 * member_info. Info about a team member.
 * @property {('id_not_found'|'member_info')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersListArg
 * @property {number} limit - Number of results to return per call.
 * @property {boolean} include_removed - Whether to return removed members.
 */

/**
 * @typedef {Object} TeamMembersListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * members.
 */

/**
 * @typedef {Object} TeamMembersListContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersListError
 * @property {'other'} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersListResult
 * @property {Array.<TeamTeamMemberInfo>} members - List of team members.
 * @property {string} cursor - Pass the cursor into members/list/continue to
 * obtain the additional members.
 * @property {boolean} has_more - Is true if there are additional team members
 * that have not been returned yet. An additional call to members/list/continue
 * can retrieve them.
 */

/**
 * Exactly one of team_member_id, email, or external_id must be provided to
 * identify the user account.
 * @typedef {Object} TeamMembersRecoverArg
 * @property {TeamUserSelectorArg} user - Identity of user to recover.
 */

/**
 * @typedef {Object} TeamMembersRecoverError
 * @property {('user_not_found'|'user_unrecoverable'|'user_not_in_team'|'team_license_limit'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersRemoveArg
 * @property {TeamUserSelectorArg} user - Identity of user to
 * remove/suspend/have their files moved.
 * @property {boolean} wipe_data - If provided, controls if the user's data will
 * be deleted on their linked devices.
 * @property {TeamUserSelectorArg} [transfer_dest_id] - If provided, files from
 * the deleted member account will be transferred to this user.
 * @property {TeamUserSelectorArg} [transfer_admin_id] - If provided, errors
 * during the transfer process will be sent via email to this user. If the
 * transfer_dest_id argument was provided, then this argument must be provided
 * as well.
 * @property {boolean} keep_account - Downgrade the member to a Basic account.
 * The user will retain the email address associated with their Dropbox  account
 * and data in their account that is not restricted to team members. In order to
 * keep the account the argument wipe_data should be set to False.
 */

/**
 * @typedef {Object} TeamMembersRemoveError
 * @property {('user_not_found'|'user_not_in_team'|'other'|'removed_and_transfer_dest_should_differ'|'removed_and_transfer_admin_should_differ'|'transfer_dest_user_not_found'|'transfer_dest_user_not_in_team'|'transfer_admin_user_not_in_team'|'transfer_admin_user_not_found'|'unspecified_transfer_admin_id'|'transfer_admin_is_not_admin'|'recipient_not_verified'|'remove_last_admin'|'cannot_keep_account_and_transfer'|'cannot_keep_account_and_delete_data'|'email_address_too_long_to_be_disabled'|'cannot_keep_invited_user_account')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersSendWelcomeError
 * @property {('user_not_found'|'user_not_in_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Exactly one of team_member_id, email, or external_id must be provided to
 * identify the user account.
 * @typedef {Object} TeamMembersSetPermissionsArg
 * @property {TeamUserSelectorArg} user - Identity of user whose role will be
 * set.
 * @property {TeamAdminTier} new_role - The new role of the member.
 */

/**
 * @typedef {Object} TeamMembersSetPermissionsError
 * @property {('user_not_found'|'last_admin'|'user_not_in_team'|'cannot_set_permissions'|'team_license_limit'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersSetPermissionsResult
 * @property {string} team_member_id - The member ID of the user to which the
 * change was applied.
 * @property {TeamAdminTier} role - The role after the change.
 */

/**
 * Exactly one of team_member_id, email, or external_id must be provided to
 * identify the user account. At least one of new_email, new_external_id,
 * new_given_name, and/or new_surname must be provided.
 * @typedef {Object} TeamMembersSetProfileArg
 * @property {TeamUserSelectorArg} user - Identity of user whose profile will be
 * set.
 * @property {string} [new_email] - New email for member.
 * @property {string} [new_external_id] - New external ID for member.
 * @property {string} [new_given_name] - New given name for member.
 * @property {string} [new_surname] - New surname for member.
 * @property {string} [new_persistent_id] - New persistent ID. This field only
 * available to teams using persistent ID SAML configuration.
 * @property {boolean} [new_is_directory_restricted] - New value for whether the
 * user is a directory restricted user.
 */

/**
 * @typedef {Object} TeamMembersSetProfileError
 * @property {('user_not_found'|'user_not_in_team'|'external_id_and_new_external_id_unsafe'|'no_new_data_specified'|'email_reserved_for_other_user'|'external_id_used_by_other_user'|'set_profile_disallowed'|'param_cannot_be_empty'|'persistent_id_disabled'|'persistent_id_used_by_other_user'|'directory_restricted_off'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersSuspendError
 * @property {('user_not_found'|'user_not_in_team'|'other'|'suspend_inactive_user'|'suspend_last_admin'|'team_license_limit')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersTransferFilesError
 * @property {('user_not_found'|'user_not_in_team'|'other'|'removed_and_transfer_dest_should_differ'|'removed_and_transfer_admin_should_differ'|'transfer_dest_user_not_found'|'transfer_dest_user_not_in_team'|'transfer_admin_user_not_in_team'|'transfer_admin_user_not_found'|'unspecified_transfer_admin_id'|'transfer_admin_is_not_admin'|'recipient_not_verified')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMembersTransferFormerMembersFilesError
 * @property {('user_not_found'|'user_not_in_team'|'other'|'removed_and_transfer_dest_should_differ'|'removed_and_transfer_admin_should_differ'|'transfer_dest_user_not_found'|'transfer_dest_user_not_in_team'|'transfer_admin_user_not_in_team'|'transfer_admin_user_not_found'|'unspecified_transfer_admin_id'|'transfer_admin_is_not_admin'|'recipient_not_verified'|'user_data_is_being_transferred'|'user_not_removed'|'user_data_cannot_be_transferred'|'user_data_already_transferred')} .tag - Tag identifying the union variant.
 */

/**
 * Exactly one of team_member_id, email, or external_id must be provided to
 * identify the user account.
 * @typedef {Object} TeamMembersUnsuspendArg
 * @property {TeamUserSelectorArg} user - Identity of user to unsuspend.
 */

/**
 * @typedef {Object} TeamMembersUnsuspendError
 * @property {('user_not_found'|'user_not_in_team'|'other'|'unsuspend_non_suspended_member'|'team_license_limit')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamMobileClientPlatform
 * @property {('iphone'|'ipad'|'android'|'windows_phone'|'blackberry'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about linked Dropbox mobile client sessions.
 * @typedef {Object} TeamMobileClientSession
 * @property {string} session_id - The session id.
 * @property {string} device_name - The device name.
 * @property {TeamMobileClientPlatform} client_type - The mobile application
 * type.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session.
 * @property {string} [country] - The country from which the last activity from
 * this session was made.
 * @property {Timestamp} [created] - The time this session was created.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session.
 * @property {string} [client_version] - The dropbox client version.
 * @property {string} [os_version] - The hosting OS version.
 * @property {string} [last_carrier] - last carrier used by the device.
 */

/**
 * Properties of a namespace.
 * @typedef {Object} TeamNamespaceMetadata
 * @property {string} name - The name of this namespace.
 * @property {string} namespace_id - The ID of this namespace.
 * @property {TeamNamespaceType} namespace_type - The type of this namespace.
 * @property {string} [team_member_id] - If this is a team member or app folder,
 * the ID of the owning team member. Otherwise, this field is not present.
 */

/**
 * @typedef {Object} TeamNamespaceType
 * @property {('app_folder'|'shared_folder'|'team_folder'|'team_member_folder'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User result for setting member custom quota.
 * @typedef {Object} TeamRemoveCustomQuotaResult
 * @property {TeamUserSelectorArg} [success] - Available if .tag is success.
 * Successfully removed user.
 * @property {TeamUserSelectorArg} [invalid_user] - Available if .tag is
 * invalid_user. Invalid user (not in team).
 * @property {('success'|'invalid_user'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRemovedStatus
 * @property {boolean} is_recoverable - True if the removed team member is
 * recoverable.
 * @property {boolean} is_disconnected - True if the team member's account was
 * converted to individual account.
 */

/**
 * @typedef {Object} TeamRevokeDesktopClientArg
 * @property {string} session_id - The session id.
 * @property {string} team_member_id - The unique id of the member owning the
 * device.
 * @property {boolean} delete_on_unlink - Whether to delete all files of the
 * account (this is possible only if supported by the desktop client and  will
 * be made the next time the client access the account).
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionArg
 * @property {TeamDeviceSessionArg} [web_session] - Available if .tag is
 * web_session. End an active session.
 * @property {TeamRevokeDesktopClientArg} [desktop_client] - Available if .tag
 * is desktop_client. Unlink a linked desktop device.
 * @property {TeamDeviceSessionArg} [mobile_client] - Available if .tag is
 * mobile_client. Unlink a linked mobile device.
 * @property {('web_session'|'desktop_client'|'mobile_client')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionBatchArg
 * @property {Array.<TeamRevokeDeviceSessionArg>} revoke_devices
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionBatchError
 * @property {'other'} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionBatchResult
 * @property {Array.<TeamRevokeDeviceSessionStatus>} revoke_devices_status
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionError
 * @property {('device_session_not_found'|'member_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRevokeDeviceSessionStatus
 * @property {boolean} success - Result of the revoking request.
 * @property {TeamRevokeDeviceSessionError} [error_type] - The error cause in
 * case of a failure.
 */

/**
 * @typedef {Object} TeamRevokeLinkedApiAppArg
 * @property {string} app_id - The application's unique id.
 * @property {string} team_member_id - The unique id of the member owning the
 * device.
 * @property {boolean} keep_app_folder - Whether to keep the application
 * dedicated folder (in case the application uses  one).
 */

/**
 * @typedef {Object} TeamRevokeLinkedApiAppBatchArg
 * @property {Array.<TeamRevokeLinkedApiAppArg>} revoke_linked_app
 */

/**
 * Error returned by linked_apps/revoke_linked_app_batch.
 * @typedef {Object} TeamRevokeLinkedAppBatchError
 * @property {'other'} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRevokeLinkedAppBatchResult
 * @property {Array.<TeamRevokeLinkedAppStatus>} revoke_linked_app_status
 */

/**
 * Error returned by linked_apps/revoke_linked_app.
 * @typedef {Object} TeamRevokeLinkedAppError
 * @property {('app_not_found'|'member_not_found'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamRevokeLinkedAppStatus
 * @property {boolean} success - Result of the revoking request.
 * @property {TeamRevokeLinkedAppError} [error_type] - The error cause in case
 * of a failure.
 */

/**
 * @typedef {Object} TeamSetCustomQuotaArg
 * @property {Array.<TeamUserCustomQuotaArg>} users_and_quotas - List of users
 * and their custom quotas.
 */

/**
 * Error returned when setting member custom quota.
 * @typedef {Object} TeamSetCustomQuotaError
 * @property {('too_many_users'|'other'|'some_users_are_excluded')} .tag - Tag identifying the union variant.
 */

/**
 * Describes the number of users in a specific storage bucket.
 * @typedef {Object} TeamStorageBucket
 * @property {string} bucket - The name of the storage bucket. For example, '1G'
 * is a bucket of users with storage size up to 1 Giga.
 * @property {number} users - The number of people whose storage is in the range
 * of this storage bucket.
 */

/**
 * @typedef {Object} TeamTeamFolderAccessError
 * @property {('invalid_team_folder_id'|'no_access'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderActivateError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderArchiveArg
 * @property {string} team_folder_id - The ID of the team folder.
 * @property {boolean} force_async_off - Whether to force the archive to happen
 * synchronously.
 */

/**
 * @typedef {Object} TeamTeamFolderArchiveError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderArchiveJobStatus
 * @property {TeamTeamFolderMetadata} [complete] - Available if .tag is
 * complete. The archive job has finished. The value is the metadata for the
 * resulting team folder.
 * @property {TeamTeamFolderArchiveError} [failed] - Available if .tag is
 * failed. Error occurred while performing an asynchronous job from
 * :route:`team_folder/archive`.
 * @property {('in_progress'|'complete'|'failed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderArchiveLaunch
 * @property {string} [async_job_id] - Available if .tag is async_job_id. This
 * response indicates that the processing is asynchronous. The string is an id
 * that can be used to obtain the status of the asynchronous job.
 * @property {TeamTeamFolderMetadata} [complete] - Available if .tag is
 * complete.
 * @property {('async_job_id'|'complete')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderCreateArg
 * @property {string} name - Name for the new team folder.
 * @property {FilesSyncSettingArg} [sync_setting] - The sync setting to apply to
 * this team folder. Only permitted if the team has team selective sync enabled.
 */

/**
 * @typedef {Object} TeamTeamFolderCreateError
 * @property {FilesSyncSettingsError} [sync_settings_error] - Available if .tag
 * is sync_settings_error. An error occurred setting the sync settings.
 * @property {('invalid_folder_name'|'folder_name_already_used'|'folder_name_reserved'|'sync_settings_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderGetInfoItem
 * @property {string} [id_not_found] - Available if .tag is id_not_found. An ID
 * that was provided as a parameter to :route:`team_folder/get_info` did not
 * match any of the team's team folders.
 * @property {TeamTeamFolderMetadata} [team_folder_metadata] - Available if .tag
 * is team_folder_metadata. Properties of a team folder.
 * @property {('id_not_found'|'team_folder_metadata')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderIdArg
 * @property {string} team_folder_id - The ID of the team folder.
 */

/**
 * @typedef {Object} TeamTeamFolderIdListArg
 * @property {Array.<Object>} team_folder_ids - The list of team folder IDs.
 */

/**
 * @typedef {Object} TeamTeamFolderInvalidStatusError
 * @property {('active'|'archived'|'archive_in_progress'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderListArg
 * @property {number} limit - The maximum number of results to return per
 * request.
 */

/**
 * @typedef {Object} TeamTeamFolderListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * team folders.
 */

/**
 * @typedef {Object} TeamTeamFolderListContinueError
 * @property {('invalid_cursor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderListError
 * @property {TeamTeamFolderAccessError} access_error
 */

/**
 * Result for team_folder/list and team_folder/list/continue.
 * @typedef {Object} TeamTeamFolderListResult
 * @property {Array.<TeamTeamFolderMetadata>} team_folders - List of all team
 * folders in the authenticated team.
 * @property {string} cursor - Pass the cursor into team_folder/list/continue to
 * obtain additional team folders.
 * @property {boolean} has_more - Is true if there are additional team folders
 * that have not been returned yet. An additional call to
 * team_folder/list/continue can retrieve them.
 */

/**
 * Properties of a team folder.
 * @typedef {Object} TeamTeamFolderMetadata
 * @property {string} team_folder_id - The ID of the team folder.
 * @property {string} name - The name of the team folder.
 * @property {TeamTeamFolderStatus} status - The status of the team folder.
 * @property {boolean} is_team_shared_dropbox - True if this team folder is a
 * shared team root.
 * @property {FilesSyncSetting} sync_setting - The sync setting applied to this
 * team folder.
 * @property {Array.<FilesContentSyncSetting>} content_sync_settings - Sync
 * settings applied to contents of this team folder.
 */

/**
 * @typedef {Object} TeamTeamFolderPermanentlyDeleteError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderRenameArg
 * @property {string} team_folder_id - The ID of the team folder.
 * @property {string} name - New team folder name.
 */

/**
 * @typedef {Object} TeamTeamFolderRenameError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other'|'invalid_folder_name'|'folder_name_already_used'|'folder_name_reserved')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderStatus
 * @property {('active'|'archived'|'archive_in_progress'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderTeamSharedDropboxError
 * @property {('disallowed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamFolderUpdateSyncSettingsArg
 * @property {string} team_folder_id - The ID of the team folder.
 * @property {FilesSyncSettingArg} [sync_setting] - Sync setting to apply to the
 * team folder itself. Only meaningful if the team folder is not a shared team
 * root.
 * @property {Array.<FilesContentSyncSettingArg>} [content_sync_settings] - Sync
 * settings to apply to contents of this team folder.
 */

/**
 * @typedef {Object} TeamTeamFolderUpdateSyncSettingsError
 * @property {TeamTeamFolderAccessError} [access_error] - Available if .tag is
 * access_error.
 * @property {TeamTeamFolderInvalidStatusError} [status_error] - Available if
 * .tag is status_error.
 * @property {TeamTeamFolderTeamSharedDropboxError} [team_shared_dropbox_error]
 * - Available if .tag is team_shared_dropbox_error.
 * @property {FilesSyncSettingsError} [sync_settings_error] - Available if .tag
 * is sync_settings_error. An error occurred setting the sync settings.
 * @property {('access_error'|'status_error'|'team_shared_dropbox_error'|'other'|'sync_settings_error')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamGetInfoResult
 * @property {string} name - The name of the team.
 * @property {string} team_id - The ID of the team.
 * @property {number} num_licensed_users - The number of licenses available to
 * the team.
 * @property {number} num_provisioned_users - The number of accounts that have
 * been invited or are already active members of the team.
 * @property {TeamPoliciesTeamMemberPolicies} policies
 */

/**
 * Information about a team member.
 * @typedef {Object} TeamTeamMemberInfo
 * @property {TeamTeamMemberProfile} profile - Profile of a user as a member of
 * a team.
 * @property {TeamAdminTier} role - The user's role in the team.
 */

/**
 * Profile of a user as a member of a team.
 * @typedef {Object} TeamTeamMemberProfile
 * @property {string} team_member_id - ID of user as a member of a team.
 * @property {string} email - Email address of user.
 * @property {boolean} email_verified - Is true if the user's email is verified
 * to be owned by the user.
 * @property {TeamTeamMemberStatus} status - The user's status as a member of a
 * specific team.
 * @property {UsersName} name - Representations for a person's name.
 * @property {TeamTeamMembershipType} membership_type - The user's membership
 * type: full (normal team member) vs limited (does not use a license; no access
 * to the team's shared quota).
 * @property {Array.<Object>} groups - List of group IDs of groups that the user
 * belongs to.
 * @property {string} member_folder_id - The namespace id of the user's root
 * folder.
 * @property {string} [external_id] - External ID that a team can attach to the
 * user. An application using the API may find it easier to use their own IDs
 * instead of Dropbox IDs like account_id or team_member_id.
 * @property {string} [account_id] - A user's account identifier.
 * @property {Timestamp} [joined_on] - The date and time the user joined as a
 * member of a specific team.
 * @property {Timestamp} [suspended_on] - The date and time the user was
 * suspended from the team (contains value only when the member's status matches
 * TeamMemberStatus.suspended.
 * @property {string} [persistent_id] - Persistent ID that a team can attach to
 * the user. The persistent ID is unique ID to be used for SAML authentication.
 * @property {boolean} [is_directory_restricted] - Whether the user is a
 * directory restricted user.
 * @property {string} [profile_photo_url] - URL for the photo representing the
 * user, if one is set.
 */

/**
 * The user's status as a member of a specific team.
 * @typedef {Object} TeamTeamMemberStatus
 * @property {TeamRemovedStatus} [removed] - Available if .tag is removed. User
 * is no longer a member of the team. Removed users are only listed when
 * include_removed is true in members/list.
 * @property {('active'|'invited'|'suspended'|'removed')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamMembershipType
 * @property {('full'|'limited')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamNamespacesListArg
 * @property {number} limit - Specifying a value here has no effect.
 */

/**
 * @typedef {Object} TeamTeamNamespacesListContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * team-accessible namespaces.
 */

/**
 * @typedef {Object} TeamTeamNamespacesListContinueError
 * @property {('invalid_arg'|'other'|'invalid_cursor')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamTeamNamespacesListError
 * @property {('invalid_arg'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Result for namespaces/list.
 * @typedef {Object} TeamTeamNamespacesListResult
 * @property {Array.<TeamNamespaceMetadata>} namespaces - List of all namespaces
 * the team can access.
 * @property {string} cursor - Pass the cursor into namespaces/list/continue to
 * obtain additional namespaces. Note that duplicate namespaces may be returned.
 * @property {boolean} has_more - Is true if there are additional namespaces
 * that have not been returned yet.
 */

/**
 * @typedef {Object} TeamTeamReportFailureReason
 * @property {('temporary_error'|'many_reports_at_once'|'too_much_data'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Error returned by token/get_authenticated_admin.
 * @typedef {Object} TeamTokenGetAuthenticatedAdminError
 * @property {('mapping_not_found'|'admin_not_active'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Results for token/get_authenticated_admin.
 * @typedef {Object} TeamTokenGetAuthenticatedAdminResult
 * @property {TeamTeamMemberProfile} admin_profile - The admin who authorized
 * the token.
 */

/**
 * The value for Feature.upload_api_rate_limit.
 * @typedef {Object} TeamUploadApiRateLimitValue
 * @property {number} [limit] - Available if .tag is limit. The number of upload
 * API calls allowed per month.
 * @property {('unlimited'|'limit'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User and their required custom quota in GB (1 TB = 1024 GB).
 * @typedef {Object} TeamUserCustomQuotaArg
 * @property {TeamUserSelectorArg} user
 * @property {number} quota_gb
 */

/**
 * User and their custom quota in GB (1 TB = 1024 GB).  No quota returns if the
 * user has no custom quota set.
 * @typedef {Object} TeamUserCustomQuotaResult
 * @property {TeamUserSelectorArg} user
 * @property {number} [quota_gb]
 */

/**
 * Argument for selecting a single user, either by team_member_id, external_id
 * or email.
 * @typedef {Object} TeamUserSelectorArg
 * @property {string} [team_member_id] - Available if .tag is team_member_id.
 * @property {string} [external_id] - Available if .tag is external_id.
 * @property {string} [email] - Available if .tag is email.
 * @property {('team_member_id'|'external_id'|'email')} .tag - Tag identifying the union variant.
 */

/**
 * Error that can be returned whenever a struct derived from UserSelectorArg is
 * used.
 * @typedef {Object} TeamUserSelectorError
 * @property {'user_not_found'} .tag - Tag identifying the union variant.
 */

/**
 * Argument for selecting a list of users, either by team_member_ids,
 * external_ids or emails.
 * @typedef {Object} TeamUsersSelectorArg
 * @property {Array.<Object>} [team_member_ids] - Available if .tag is
 * team_member_ids. List of member IDs.
 * @property {Array.<Object>} [external_ids] - Available if .tag is
 * external_ids. List of external user IDs.
 * @property {Array.<Object>} [emails] - Available if .tag is emails. List of
 * email addresses.
 * @property {('team_member_ids'|'external_ids'|'emails')} .tag - Tag identifying the union variant.
 */

/**
 * The group type determines how a group is managed.
 * @typedef {Object} TeamCommonGroupManagementType
 * @property {('user_managed'|'company_managed'|'system_managed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about a group.
 * @typedef {Object} TeamCommonGroupSummary
 * @property {string} group_name
 * @property {string} group_id
 * @property {TeamCommonGroupManagementType} group_management_type - Who is
 * allowed to manage the group.
 * @property {string} [group_external_id] - External ID of group. This is an
 * arbitrary ID that an admin can attach to a group.
 * @property {number} [member_count] - The number of members in the group.
 */

/**
 * The group type determines how a group is created and managed.
 * @typedef {Object} TeamCommonGroupType
 * @property {('team'|'user_managed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The type of the space limit imposed on a team member.
 * @typedef {Object} TeamCommonMemberSpaceLimitType
 * @property {('off'|'alert_only'|'stop_sync'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Time range.
 * @typedef {Object} TeamCommonTimeRange
 * @property {Timestamp} [start_time] - Optional starting time (inclusive).
 * @property {Timestamp} [end_time] - Optional ending time (exclusive).
 */

/**
 * Indicates the method in which the action was performed.
 * @typedef {Object} TeamLogAccessMethodLogInfo
 * @property
 * {(TeamLogWebSessionLogInfo|TeamLogDesktopSessionLogInfo|TeamLogMobileSessionLogInfo|TeamLogSessionLogInfo)}
 * [end_user] - Available if .tag is end_user. End user session details.
 * @property {TeamLogWebSessionLogInfo} [sign_in_as] - Available if .tag is
 * sign_in_as. Sign in as session details.
 * @property {TeamLogWebSessionLogInfo} [content_manager] - Available if .tag is
 * content_manager. Content manager session details.
 * @property {TeamLogWebSessionLogInfo} [admin_console] - Available if .tag is
 * admin_console. Admin console session details.
 * @property {TeamLogApiSessionLogInfo} [api] - Available if .tag is api. Api
 * session details.
 * @property {('end_user'|'sign_in_as'|'content_manager'|'admin_console'|'api'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureAvailability
 * @property {('unavailable'|'available'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Granted/revoked option to enable account capture on team domains.
 * @typedef {Object} TeamLogAccountCaptureChangeAvailabilityDetails
 * @property {TeamLogAccountCaptureAvailability} new_value - New account capture
 * availabilty value.
 * @property {TeamLogAccountCaptureAvailability} [previous_value] - Previous
 * account capture availabilty value. Might be missing due to historical data
 * gap.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureChangeAvailabilityType
 * @property {string} description
 */

/**
 * Changed account capture setting on team domain.
 * @typedef {Object} TeamLogAccountCaptureChangePolicyDetails
 * @property {TeamLogAccountCapturePolicy} new_value - New account capture
 * policy.
 * @property {TeamLogAccountCapturePolicy} [previous_value] - Previous account
 * capture policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureChangePolicyType
 * @property {string} description
 */

/**
 * Account-captured user migrated account to team.
 * @typedef {Object} TeamLogAccountCaptureMigrateAccountDetails
 * @property {string} domain_name - Domain name.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureMigrateAccountType
 * @property {string} description
 */

/**
 * Sent proactive account capture email to all unmanaged members.
 * @typedef {Object} TeamLogAccountCaptureNotificationEmailsSentDetails
 * @property {string} domain_name - Domain name.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureNotificationEmailsSentType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogAccountCapturePolicy
 * @property {('disabled'|'invited_users'|'all_users'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Account-captured user changed account email to personal email.
 * @typedef {Object} TeamLogAccountCaptureRelinquishAccountDetails
 * @property {string} domain_name - Domain name.
 */

/**
 * @typedef {Object} TeamLogAccountCaptureRelinquishAccountType
 * @property {string} description
 */

/**
 * Additional information indicating the action taken that caused status change.
 * @typedef {Object} TeamLogActionDetails
 * @property {TeamLogJoinTeamDetails} [team_join_details] - Available if .tag is
 * team_join_details. Additional information relevant when a new member joins
 * the team.
 * @property {TeamLogMemberRemoveActionType} [remove_action] - Available if .tag
 * is remove_action. Define how the user was removed from the team.
 * @property {('team_join_details'|'remove_action'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The entity who performed the action.
 * @typedef {Object} TeamLogActorLogInfo
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [user] - Available if .tag is user. The user who did the action.
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [admin] - Available if .tag is admin. The admin who did the action.
 * @property
 * {(TeamLogUserOrTeamLinkedAppLogInfo|TeamLogUserLinkedAppLogInfo|TeamLogTeamLinkedAppLogInfo|TeamLogAppLogInfo)}
 * [app] - Available if .tag is app. The application who did the action.
 * @property {TeamLogResellerLogInfo} [reseller] - Available if .tag is
 * reseller. Action done by reseller.
 * @property {('user'|'admin'|'app'|'reseller'|'dropbox'|'anonymous'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogAdminRole
 * @property {('team_admin'|'user_management_admin'|'support_admin'|'limited_admin'|'member_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Disabled downloads.
 * @typedef {Object} TeamLogAllowDownloadDisabledDetails
 */

/**
 * @typedef {Object} TeamLogAllowDownloadDisabledType
 * @property {string} description
 */

/**
 * Enabled downloads.
 * @typedef {Object} TeamLogAllowDownloadEnabledDetails
 */

/**
 * @typedef {Object} TeamLogAllowDownloadEnabledType
 * @property {string} description
 */

/**
 * Api session.
 * @typedef {Object} TeamLogApiSessionLogInfo
 * @property {string} request_id - Api request ID.
 */

/**
 * Linked app for team.
 * @typedef {Object} TeamLogAppLinkTeamDetails
 * @property
 * {(TeamLogUserOrTeamLinkedAppLogInfo|TeamLogUserLinkedAppLogInfo|TeamLogTeamLinkedAppLogInfo|TeamLogAppLogInfo)}
 * app_info - Relevant application details.
 */

/**
 * @typedef {Object} TeamLogAppLinkTeamType
 * @property {string} description
 */

/**
 * Linked app for member.
 * @typedef {Object} TeamLogAppLinkUserDetails
 * @property
 * {(TeamLogUserOrTeamLinkedAppLogInfo|TeamLogUserLinkedAppLogInfo|TeamLogTeamLinkedAppLogInfo|TeamLogAppLogInfo)}
 * app_info - Relevant application details.
 */

/**
 * @typedef {Object} TeamLogAppLinkUserType
 * @property {string} description
 */

/**
 * App's logged information.
 * @typedef {Object} TeamLogAppLogInfo
@property {("user_or_team_linked_app"|"user_linked_app"|"team_linked_app")} .tag
- Tag identifying the subtype variant.
 * @property {string} [app_id] - App unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - App display name. Might be missing due to
 * historical data gap.
 */

/**
 * Unlinked app for team.
 * @typedef {Object} TeamLogAppUnlinkTeamDetails
 * @property
 * {(TeamLogUserOrTeamLinkedAppLogInfo|TeamLogUserLinkedAppLogInfo|TeamLogTeamLinkedAppLogInfo|TeamLogAppLogInfo)}
 * app_info - Relevant application details.
 */

/**
 * @typedef {Object} TeamLogAppUnlinkTeamType
 * @property {string} description
 */

/**
 * Unlinked app for member.
 * @typedef {Object} TeamLogAppUnlinkUserDetails
 * @property
 * {(TeamLogUserOrTeamLinkedAppLogInfo|TeamLogUserLinkedAppLogInfo|TeamLogTeamLinkedAppLogInfo|TeamLogAppLogInfo)}
 * app_info - Relevant application details.
 */

/**
 * @typedef {Object} TeamLogAppUnlinkUserType
 * @property {string} description
 */

/**
 * Asset details.
 * @typedef {Object} TeamLogAssetLogInfo
 * @property {TeamLogFileLogInfo} [file] - Available if .tag is file. File's
 * details.
 * @property {TeamLogFolderLogInfo} [folder] - Available if .tag is folder.
 * Folder's details.
 * @property {TeamLogPaperDocumentLogInfo} [paper_document] - Available if .tag
 * is paper_document. Paper document's details.
 * @property {TeamLogPaperFolderLogInfo} [paper_folder] - Available if .tag is
 * paper_folder. Paper folder's details.
 * @property {TeamLogShowcaseDocumentLogInfo} [showcase_document] - Available if
 * .tag is showcase_document. Showcase document's details.
 * @property {('file'|'folder'|'paper_document'|'paper_folder'|'showcase_document'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policy for controlling if team members can activate camera uploads
 * @typedef {Object} TeamLogCameraUploadsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed camera uploads setting for team.
 * @typedef {Object} TeamLogCameraUploadsPolicyChangedDetails
 * @property {TeamLogCameraUploadsPolicy} new_value - New camera uploads
 * setting.
 * @property {TeamLogCameraUploadsPolicy} previous_value - Previous camera
 * uploads setting.
 */

/**
 * @typedef {Object} TeamLogCameraUploadsPolicyChangedType
 * @property {string} description
 */

/**
 * Certificate details.
 * @typedef {Object} TeamLogCertificate
 * @property {string} subject - Certificate subject.
 * @property {string} issuer - Certificate issuer.
 * @property {string} issue_date - Certificate issue date.
 * @property {string} expiration_date - Certificate expiration date.
 * @property {string} serial_number - Certificate serial number.
 * @property {string} sha1_fingerprint - Certificate sha1 fingerprint.
 * @property {string} [common_name] - Certificate common name.
 */

/**
 * Shared album.
 * @typedef {Object} TeamLogCollectionShareDetails
 * @property {string} album_name - Album name.
 */

/**
 * @typedef {Object} TeamLogCollectionShareType
 * @property {string} description
 */

/**
 * Policy for pemanent content deletion
 * @typedef {Object} TeamLogContentPermanentDeletePolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The primary entity on which the action was done.
 * @typedef {Object} TeamLogContextLogInfo
 * @property {TeamLogTeamMemberLogInfo} [team_member] - Available if .tag is
 * team_member. Action was done on behalf of a team member.
 * @property {TeamLogNonTeamMemberLogInfo} [non_team_member] - Available if .tag
 * is non_team_member. Action was done on behalf of a non team member.
 * @property {TeamLogTrustedNonTeamMemberLogInfo} [trusted_non_team_member] -
 * Available if .tag is trusted_non_team_member. Action was done on behalf of a
 * trusted non team member.
 * @property {('team_member'|'non_team_member'|'anonymous'|'team'|'trusted_non_team_member'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Created folders.
 * @typedef {Object} TeamLogCreateFolderDetails
 */

/**
 * @typedef {Object} TeamLogCreateFolderType
 * @property {string} description
 */

/**
 * Set restrictions on data center locations where team data resides.
 * @typedef {Object} TeamLogDataPlacementRestrictionChangePolicyDetails
 * @property {TeamLogPlacementRestriction} previous_value - Previous placement
 * restriction.
 * @property {TeamLogPlacementRestriction} new_value - New placement
 * restriction.
 */

/**
 * @typedef {Object} TeamLogDataPlacementRestrictionChangePolicyType
 * @property {string} description
 */

/**
 * Completed restrictions on data center locations where team data resides.
 * @typedef {Object} TeamLogDataPlacementRestrictionSatisfyPolicyDetails
 * @property {TeamLogPlacementRestriction} placement_restriction - Placement
 * restriction.
 */

/**
 * @typedef {Object} TeamLogDataPlacementRestrictionSatisfyPolicyType
 * @property {string} description
 */

/**
 * Information about linked Dropbox desktop client sessions
 * @typedef {Object} TeamLogDesktopDeviceSessionLogInfo
@property {'desktop_device_session'} [.tag] - Tag identifying this subtype
variant. This field is only present when needed to discriminate between multiple
possible subtypes.
 * @property {string} host_name - Name of the hosting desktop.
 * @property {TeamDesktopPlatform} client_type - The Dropbox desktop client
 * type.
 * @property {string} platform - Information on the hosting platform.
 * @property {boolean} is_delete_on_unlink_supported - Whether itu2019s possible
 * to delete all of the account files upon unlinking.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {Timestamp} [created] - The time this session was created. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session. Might be missing due to historical data gap.
 * @property {TeamLogDesktopSessionLogInfo} [session_info] - Desktop session
 * unique id. Might be missing due to historical data gap.
 * @property {string} [client_version] - The Dropbox client version.
 */

/**
 * Desktop session.
 * @typedef {Object} TeamLogDesktopSessionLogInfo
@property {'desktop'} [.tag] - Tag identifying this subtype variant. This field
is only present when needed to discriminate between multiple possible subtypes.
 * @property {string} [session_id] - Session ID. Might be missing due to
 * historical data gap.
 */

/**
 * Set/removed limit on number of computers member can link to team Dropbox
 * account.
 * @typedef {Object} TeamLogDeviceApprovalsChangeDesktopPolicyDetails
 * @property {TeamLogDeviceApprovalsPolicy} [new_value] - New desktop device
 * approvals policy. Might be missing due to historical data gap.
 * @property {TeamLogDeviceApprovalsPolicy} [previous_value] - Previous desktop
 * device approvals policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceApprovalsChangeDesktopPolicyType
 * @property {string} description
 */

/**
 * Set/removed limit on number of mobile devices member can link to team Dropbox
 * account.
 * @typedef {Object} TeamLogDeviceApprovalsChangeMobilePolicyDetails
 * @property {TeamLogDeviceApprovalsPolicy} [new_value] - New mobile device
 * approvals policy. Might be missing due to historical data gap.
 * @property {TeamLogDeviceApprovalsPolicy} [previous_value] - Previous mobile
 * device approvals policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceApprovalsChangeMobilePolicyType
 * @property {string} description
 */

/**
 * Changed device approvals setting when member is over limit.
 * @typedef {Object} TeamLogDeviceApprovalsChangeOverageActionDetails
 * @property {TeamPoliciesRolloutMethod} [new_value] - New over the limits
 * policy. Might be missing due to historical data gap.
 * @property {TeamPoliciesRolloutMethod} [previous_value] - Previous over the
 * limit policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceApprovalsChangeOverageActionType
 * @property {string} description
 */

/**
 * Changed device approvals setting when member unlinks approved device.
 * @typedef {Object} TeamLogDeviceApprovalsChangeUnlinkActionDetails
 * @property {TeamLogDeviceUnlinkPolicy} [new_value] - New device unlink policy.
 * Might be missing due to historical data gap.
 * @property {TeamLogDeviceUnlinkPolicy} [previous_value] - Previous device
 * unlink policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceApprovalsChangeUnlinkActionType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogDeviceApprovalsPolicy
 * @property {('unlimited'|'limited'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed IP address associated with active desktop session.
 * @typedef {Object} TeamLogDeviceChangeIpDesktopDetails
 * @property
 * {(TeamLogDesktopDeviceSessionLogInfo|TeamLogMobileDeviceSessionLogInfo|TeamLogWebDeviceSessionLogInfo|TeamLogLegacyDeviceSessionLogInfo|TeamLogDeviceSessionLogInfo)}
 * device_session_info - Device's session logged information.
 */

/**
 * @typedef {Object} TeamLogDeviceChangeIpDesktopType
 * @property {string} description
 */

/**
 * Changed IP address associated with active mobile session.
 * @typedef {Object} TeamLogDeviceChangeIpMobileDetails
 * @property
 * {(TeamLogDesktopDeviceSessionLogInfo|TeamLogMobileDeviceSessionLogInfo|TeamLogWebDeviceSessionLogInfo|TeamLogLegacyDeviceSessionLogInfo|TeamLogDeviceSessionLogInfo)}
 * [device_session_info] - Device's session logged information.
 */

/**
 * @typedef {Object} TeamLogDeviceChangeIpMobileType
 * @property {string} description
 */

/**
 * Changed IP address associated with active web session.
 * @typedef {Object} TeamLogDeviceChangeIpWebDetails
 * @property {string} user_agent - Web browser name.
 */

/**
 * @typedef {Object} TeamLogDeviceChangeIpWebType
 * @property {string} description
 */

/**
 * Failed to delete all files from unlinked device.
 * @typedef {Object} TeamLogDeviceDeleteOnUnlinkFailDetails
 * @property {number} num_failures - The number of times that remote file
 * deletion failed.
 * @property
 * {(TeamLogWebSessionLogInfo|TeamLogDesktopSessionLogInfo|TeamLogMobileSessionLogInfo|TeamLogSessionLogInfo)}
 * [session_info] - Session unique id. Might be missing due to historical data
 * gap.
 * @property {string} [display_name] - The device name. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceDeleteOnUnlinkFailType
 * @property {string} description
 */

/**
 * Deleted all files from unlinked device.
 * @typedef {Object} TeamLogDeviceDeleteOnUnlinkSuccessDetails
 * @property
 * {(TeamLogWebSessionLogInfo|TeamLogDesktopSessionLogInfo|TeamLogMobileSessionLogInfo|TeamLogSessionLogInfo)}
 * [session_info] - Session unique id. Might be missing due to historical data
 * gap.
 * @property {string} [display_name] - The device name. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceDeleteOnUnlinkSuccessType
 * @property {string} description
 */

/**
 * Failed to link device.
 * @typedef {Object} TeamLogDeviceLinkFailDetails
 * @property {TeamLogDeviceType} device_type - A description of the device used
 * while user approval blocked.
 * @property {string} [ip_address] - IP address. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceLinkFailType
 * @property {string} description
 */

/**
 * Linked device.
 * @typedef {Object} TeamLogDeviceLinkSuccessDetails
 * @property
 * {(TeamLogDesktopDeviceSessionLogInfo|TeamLogMobileDeviceSessionLogInfo|TeamLogWebDeviceSessionLogInfo|TeamLogLegacyDeviceSessionLogInfo|TeamLogDeviceSessionLogInfo)}
 * [device_session_info] - Device's session logged information.
 */

/**
 * @typedef {Object} TeamLogDeviceLinkSuccessType
 * @property {string} description
 */

/**
 * Disabled device management.
 * @typedef {Object} TeamLogDeviceManagementDisabledDetails
 */

/**
 * @typedef {Object} TeamLogDeviceManagementDisabledType
 * @property {string} description
 */

/**
 * Enabled device management.
 * @typedef {Object} TeamLogDeviceManagementEnabledDetails
 */

/**
 * @typedef {Object} TeamLogDeviceManagementEnabledType
 * @property {string} description
 */

/**
 * Device's session logged information.
 * @typedef {Object} TeamLogDeviceSessionLogInfo
@property
{("desktop_device_session"|"mobile_device_session"|"web_device_session"|"legacy_device_session")}
.tag - Tag identifying the subtype variant.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {Timestamp} [created] - The time this session was created. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceType
 * @property {('desktop'|'mobile'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Disconnected device.
 * @typedef {Object} TeamLogDeviceUnlinkDetails
 * @property {boolean} delete_data - True if the user requested to delete data
 * after device unlink, false otherwise.
 * @property
 * {(TeamLogWebSessionLogInfo|TeamLogDesktopSessionLogInfo|TeamLogMobileSessionLogInfo|TeamLogSessionLogInfo)}
 * [session_info] - Session unique id.
 * @property {string} [display_name] - The device name. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogDeviceUnlinkPolicy
 * @property {('remove'|'keep'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogDeviceUnlinkType
 * @property {string} description
 */

/**
 * Added members to directory restrictions list.
 * @typedef {Object} TeamLogDirectoryRestrictionsAddMembersDetails
 */

/**
 * @typedef {Object} TeamLogDirectoryRestrictionsAddMembersType
 * @property {string} description
 */

/**
 * Removed members from directory restrictions list.
 * @typedef {Object} TeamLogDirectoryRestrictionsRemoveMembersDetails
 */

/**
 * @typedef {Object} TeamLogDirectoryRestrictionsRemoveMembersType
 * @property {string} description
 */

/**
 * Disabled domain invites.
 * @typedef {Object} TeamLogDisabledDomainInvitesDetails
 */

/**
 * @typedef {Object} TeamLogDisabledDomainInvitesType
 * @property {string} description
 */

/**
 * Approved user's request to join team.
 * @typedef {Object} TeamLogDomainInvitesApproveRequestToJoinTeamDetails
 */

/**
 * @typedef {Object} TeamLogDomainInvitesApproveRequestToJoinTeamType
 * @property {string} description
 */

/**
 * Declined user's request to join team.
 * @typedef {Object} TeamLogDomainInvitesDeclineRequestToJoinTeamDetails
 */

/**
 * @typedef {Object} TeamLogDomainInvitesDeclineRequestToJoinTeamType
 * @property {string} description
 */

/**
 * Sent domain invites to existing domain accounts.
 * @typedef {Object} TeamLogDomainInvitesEmailExistingUsersDetails
 * @property {string} domain_name - Domain names.
 * @property {number} num_recipients - Number of recipients.
 */

/**
 * @typedef {Object} TeamLogDomainInvitesEmailExistingUsersType
 * @property {string} description
 */

/**
 * Requested to join team.
 * @typedef {Object} TeamLogDomainInvitesRequestToJoinTeamDetails
 */

/**
 * @typedef {Object} TeamLogDomainInvitesRequestToJoinTeamType
 * @property {string} description
 */

/**
 * Disabled "Automatically invite new users".
 * @typedef {Object} TeamLogDomainInvitesSetInviteNewUserPrefToNoDetails
 */

/**
 * @typedef {Object} TeamLogDomainInvitesSetInviteNewUserPrefToNoType
 * @property {string} description
 */

/**
 * Enabled "Automatically invite new users".
 * @typedef {Object} TeamLogDomainInvitesSetInviteNewUserPrefToYesDetails
 */

/**
 * @typedef {Object} TeamLogDomainInvitesSetInviteNewUserPrefToYesType
 * @property {string} description
 */

/**
 * Failed to verify team domain.
 * @typedef {Object} TeamLogDomainVerificationAddDomainFailDetails
 * @property {string} domain_name - Domain name.
 * @property {string} [verification_method] - Domain name verification method.
 * Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDomainVerificationAddDomainFailType
 * @property {string} description
 */

/**
 * Verified team domain.
 * @typedef {Object} TeamLogDomainVerificationAddDomainSuccessDetails
 * @property {Array.<string>} domain_names - Domain names.
 * @property {string} [verification_method] - Domain name verification method.
 * Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogDomainVerificationAddDomainSuccessType
 * @property {string} description
 */

/**
 * Removed domain from list of verified team domains.
 * @typedef {Object} TeamLogDomainVerificationRemoveDomainDetails
 * @property {Array.<string>} domain_names - Domain names.
 */

/**
 * @typedef {Object} TeamLogDomainVerificationRemoveDomainType
 * @property {string} description
 */

/**
 * Shared content downloads policy
 * @typedef {Object} TeamLogDownloadPolicyType
 * @property {('allow'|'disallow'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Represents a time duration: unit and amount
 * @typedef {Object} TeamLogDurationLogInfo
 * @property {TeamLogTimeUnit} unit - Time unit.
 * @property {number} amount - Amount of time.
 */

/**
 * Added members to EMM exception list.
 * @typedef {Object} TeamLogEmmAddExceptionDetails
 */

/**
 * @typedef {Object} TeamLogEmmAddExceptionType
 * @property {string} description
 */

/**
 * Enabled/disabled enterprise mobility management for members.
 * @typedef {Object} TeamLogEmmChangePolicyDetails
 * @property {TeamPoliciesEmmState} new_value - New enterprise mobility
 * management policy.
 * @property {TeamPoliciesEmmState} [previous_value] - Previous enterprise
 * mobility management policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogEmmChangePolicyType
 * @property {string} description
 */

/**
 * Created EMM-excluded users report.
 * @typedef {Object} TeamLogEmmCreateExceptionsReportDetails
 */

/**
 * @typedef {Object} TeamLogEmmCreateExceptionsReportType
 * @property {string} description
 */

/**
 * Created EMM mobile app usage report.
 * @typedef {Object} TeamLogEmmCreateUsageReportDetails
 */

/**
 * @typedef {Object} TeamLogEmmCreateUsageReportType
 * @property {string} description
 */

/**
 * Failed to sign in via EMM.
 * @typedef {Object} TeamLogEmmErrorDetails
 * @property {TeamLogFailureDetailsLogInfo} error_details - Error details.
 */

/**
 * @typedef {Object} TeamLogEmmErrorType
 * @property {string} description
 */

/**
 * Refreshed auth token used for setting up EMM.
 * @typedef {Object} TeamLogEmmRefreshAuthTokenDetails
 */

/**
 * @typedef {Object} TeamLogEmmRefreshAuthTokenType
 * @property {string} description
 */

/**
 * Removed members from EMM exception list.
 * @typedef {Object} TeamLogEmmRemoveExceptionDetails
 */

/**
 * @typedef {Object} TeamLogEmmRemoveExceptionType
 * @property {string} description
 */

/**
 * Enabled domain invites.
 * @typedef {Object} TeamLogEnabledDomainInvitesDetails
 */

/**
 * @typedef {Object} TeamLogEnabledDomainInvitesType
 * @property {string} description
 */

/**
 * Category of events in event audit log.
 * @typedef {Object} TeamLogEventCategory
 * @property {('apps'|'comments'|'devices'|'domains'|'file_operations'|'file_requests'|'groups'|'logins'|'members'|'paper'|'passwords'|'reports'|'sharing'|'showcase'|'sso'|'team_folders'|'team_policies'|'team_profile'|'tfa'|'trusted_teams'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Additional fields depending on the event type.
 * @typedef {Object} TeamLogEventDetails
 * @property {TeamLogAppLinkTeamDetails} [app_link_team_details] - Available if
 * .tag is app_link_team_details.
 * @property {TeamLogAppLinkUserDetails} [app_link_user_details] - Available if
 * .tag is app_link_user_details.
 * @property {TeamLogAppUnlinkTeamDetails} [app_unlink_team_details] - Available
 * if .tag is app_unlink_team_details.
 * @property {TeamLogAppUnlinkUserDetails} [app_unlink_user_details] - Available
 * if .tag is app_unlink_user_details.
 * @property {TeamLogIntegrationConnectedDetails}
 * [integration_connected_details] - Available if .tag is
 * integration_connected_details.
 * @property {TeamLogIntegrationDisconnectedDetails}
 * [integration_disconnected_details] - Available if .tag is
 * integration_disconnected_details.
 * @property {TeamLogFileAddCommentDetails} [file_add_comment_details] -
 * Available if .tag is file_add_comment_details.
 * @property {TeamLogFileChangeCommentSubscriptionDetails}
 * [file_change_comment_subscription_details] - Available if .tag is
 * file_change_comment_subscription_details.
 * @property {TeamLogFileDeleteCommentDetails} [file_delete_comment_details] -
 * Available if .tag is file_delete_comment_details.
 * @property {TeamLogFileEditCommentDetails} [file_edit_comment_details] -
 * Available if .tag is file_edit_comment_details.
 * @property {TeamLogFileLikeCommentDetails} [file_like_comment_details] -
 * Available if .tag is file_like_comment_details.
 * @property {TeamLogFileResolveCommentDetails} [file_resolve_comment_details] -
 * Available if .tag is file_resolve_comment_details.
 * @property {TeamLogFileUnlikeCommentDetails} [file_unlike_comment_details] -
 * Available if .tag is file_unlike_comment_details.
 * @property {TeamLogFileUnresolveCommentDetails}
 * [file_unresolve_comment_details] - Available if .tag is
 * file_unresolve_comment_details.
 * @property {TeamLogDeviceChangeIpDesktopDetails}
 * [device_change_ip_desktop_details] - Available if .tag is
 * device_change_ip_desktop_details.
 * @property {TeamLogDeviceChangeIpMobileDetails}
 * [device_change_ip_mobile_details] - Available if .tag is
 * device_change_ip_mobile_details.
 * @property {TeamLogDeviceChangeIpWebDetails} [device_change_ip_web_details] -
 * Available if .tag is device_change_ip_web_details.
 * @property {TeamLogDeviceDeleteOnUnlinkFailDetails}
 * [device_delete_on_unlink_fail_details] - Available if .tag is
 * device_delete_on_unlink_fail_details.
 * @property {TeamLogDeviceDeleteOnUnlinkSuccessDetails}
 * [device_delete_on_unlink_success_details] - Available if .tag is
 * device_delete_on_unlink_success_details.
 * @property {TeamLogDeviceLinkFailDetails} [device_link_fail_details] -
 * Available if .tag is device_link_fail_details.
 * @property {TeamLogDeviceLinkSuccessDetails} [device_link_success_details] -
 * Available if .tag is device_link_success_details.
 * @property {TeamLogDeviceManagementDisabledDetails}
 * [device_management_disabled_details] - Available if .tag is
 * device_management_disabled_details.
 * @property {TeamLogDeviceManagementEnabledDetails}
 * [device_management_enabled_details] - Available if .tag is
 * device_management_enabled_details.
 * @property {TeamLogDeviceUnlinkDetails} [device_unlink_details] - Available if
 * .tag is device_unlink_details.
 * @property {TeamLogEmmRefreshAuthTokenDetails}
 * [emm_refresh_auth_token_details] - Available if .tag is
 * emm_refresh_auth_token_details.
 * @property {TeamLogAccountCaptureChangeAvailabilityDetails}
 * [account_capture_change_availability_details] - Available if .tag is
 * account_capture_change_availability_details.
 * @property {TeamLogAccountCaptureMigrateAccountDetails}
 * [account_capture_migrate_account_details] - Available if .tag is
 * account_capture_migrate_account_details.
 * @property {TeamLogAccountCaptureNotificationEmailsSentDetails}
 * [account_capture_notification_emails_sent_details] - Available if .tag is
 * account_capture_notification_emails_sent_details.
 * @property {TeamLogAccountCaptureRelinquishAccountDetails}
 * [account_capture_relinquish_account_details] - Available if .tag is
 * account_capture_relinquish_account_details.
 * @property {TeamLogDisabledDomainInvitesDetails}
 * [disabled_domain_invites_details] - Available if .tag is
 * disabled_domain_invites_details.
 * @property {TeamLogDomainInvitesApproveRequestToJoinTeamDetails}
 * [domain_invites_approve_request_to_join_team_details] - Available if .tag is
 * domain_invites_approve_request_to_join_team_details.
 * @property {TeamLogDomainInvitesDeclineRequestToJoinTeamDetails}
 * [domain_invites_decline_request_to_join_team_details] - Available if .tag is
 * domain_invites_decline_request_to_join_team_details.
 * @property {TeamLogDomainInvitesEmailExistingUsersDetails}
 * [domain_invites_email_existing_users_details] - Available if .tag is
 * domain_invites_email_existing_users_details.
 * @property {TeamLogDomainInvitesRequestToJoinTeamDetails}
 * [domain_invites_request_to_join_team_details] - Available if .tag is
 * domain_invites_request_to_join_team_details.
 * @property {TeamLogDomainInvitesSetInviteNewUserPrefToNoDetails}
 * [domain_invites_set_invite_new_user_pref_to_no_details] - Available if .tag
 * is domain_invites_set_invite_new_user_pref_to_no_details.
 * @property {TeamLogDomainInvitesSetInviteNewUserPrefToYesDetails}
 * [domain_invites_set_invite_new_user_pref_to_yes_details] - Available if .tag
 * is domain_invites_set_invite_new_user_pref_to_yes_details.
 * @property {TeamLogDomainVerificationAddDomainFailDetails}
 * [domain_verification_add_domain_fail_details] - Available if .tag is
 * domain_verification_add_domain_fail_details.
 * @property {TeamLogDomainVerificationAddDomainSuccessDetails}
 * [domain_verification_add_domain_success_details] - Available if .tag is
 * domain_verification_add_domain_success_details.
 * @property {TeamLogDomainVerificationRemoveDomainDetails}
 * [domain_verification_remove_domain_details] - Available if .tag is
 * domain_verification_remove_domain_details.
 * @property {TeamLogEnabledDomainInvitesDetails}
 * [enabled_domain_invites_details] - Available if .tag is
 * enabled_domain_invites_details.
 * @property {TeamLogCreateFolderDetails} [create_folder_details] - Available if
 * .tag is create_folder_details.
 * @property {TeamLogFileAddDetails} [file_add_details] - Available if .tag is
 * file_add_details.
 * @property {TeamLogFileCopyDetails} [file_copy_details] - Available if .tag is
 * file_copy_details.
 * @property {TeamLogFileDeleteDetails} [file_delete_details] - Available if
 * .tag is file_delete_details.
 * @property {TeamLogFileDownloadDetails} [file_download_details] - Available if
 * .tag is file_download_details.
 * @property {TeamLogFileEditDetails} [file_edit_details] - Available if .tag is
 * file_edit_details.
 * @property {TeamLogFileGetCopyReferenceDetails}
 * [file_get_copy_reference_details] - Available if .tag is
 * file_get_copy_reference_details.
 * @property {TeamLogFileMoveDetails} [file_move_details] - Available if .tag is
 * file_move_details.
 * @property {TeamLogFilePermanentlyDeleteDetails}
 * [file_permanently_delete_details] - Available if .tag is
 * file_permanently_delete_details.
 * @property {TeamLogFilePreviewDetails} [file_preview_details] - Available if
 * .tag is file_preview_details.
 * @property {TeamLogFileRenameDetails} [file_rename_details] - Available if
 * .tag is file_rename_details.
 * @property {TeamLogFileRestoreDetails} [file_restore_details] - Available if
 * .tag is file_restore_details.
 * @property {TeamLogFileRevertDetails} [file_revert_details] - Available if
 * .tag is file_revert_details.
 * @property {TeamLogFileRollbackChangesDetails} [file_rollback_changes_details]
 * - Available if .tag is file_rollback_changes_details.
 * @property {TeamLogFileSaveCopyReferenceDetails}
 * [file_save_copy_reference_details] - Available if .tag is
 * file_save_copy_reference_details.
 * @property {TeamLogFileRequestChangeDetails} [file_request_change_details] -
 * Available if .tag is file_request_change_details.
 * @property {TeamLogFileRequestCloseDetails} [file_request_close_details] -
 * Available if .tag is file_request_close_details.
 * @property {TeamLogFileRequestCreateDetails} [file_request_create_details] -
 * Available if .tag is file_request_create_details.
 * @property {TeamLogFileRequestDeleteDetails} [file_request_delete_details] -
 * Available if .tag is file_request_delete_details.
 * @property {TeamLogFileRequestReceiveFileDetails}
 * [file_request_receive_file_details] - Available if .tag is
 * file_request_receive_file_details.
 * @property {TeamLogGroupAddExternalIdDetails} [group_add_external_id_details]
 * - Available if .tag is group_add_external_id_details.
 * @property {TeamLogGroupAddMemberDetails} [group_add_member_details] -
 * Available if .tag is group_add_member_details.
 * @property {TeamLogGroupChangeExternalIdDetails}
 * [group_change_external_id_details] - Available if .tag is
 * group_change_external_id_details.
 * @property {TeamLogGroupChangeManagementTypeDetails}
 * [group_change_management_type_details] - Available if .tag is
 * group_change_management_type_details.
 * @property {TeamLogGroupChangeMemberRoleDetails}
 * [group_change_member_role_details] - Available if .tag is
 * group_change_member_role_details.
 * @property {TeamLogGroupCreateDetails} [group_create_details] - Available if
 * .tag is group_create_details.
 * @property {TeamLogGroupDeleteDetails} [group_delete_details] - Available if
 * .tag is group_delete_details.
 * @property {TeamLogGroupDescriptionUpdatedDetails}
 * [group_description_updated_details] - Available if .tag is
 * group_description_updated_details.
 * @property {TeamLogGroupJoinPolicyUpdatedDetails}
 * [group_join_policy_updated_details] - Available if .tag is
 * group_join_policy_updated_details.
 * @property {TeamLogGroupMovedDetails} [group_moved_details] - Available if
 * .tag is group_moved_details.
 * @property {TeamLogGroupRemoveExternalIdDetails}
 * [group_remove_external_id_details] - Available if .tag is
 * group_remove_external_id_details.
 * @property {TeamLogGroupRemoveMemberDetails} [group_remove_member_details] -
 * Available if .tag is group_remove_member_details.
 * @property {TeamLogGroupRenameDetails} [group_rename_details] - Available if
 * .tag is group_rename_details.
 * @property {TeamLogEmmErrorDetails} [emm_error_details] - Available if .tag is
 * emm_error_details.
 * @property {TeamLogGuestAdminSignedInViaTrustedTeamsDetails}
 * [guest_admin_signed_in_via_trusted_teams_details] - Available if .tag is
 * guest_admin_signed_in_via_trusted_teams_details.
 * @property {TeamLogGuestAdminSignedOutViaTrustedTeamsDetails}
 * [guest_admin_signed_out_via_trusted_teams_details] - Available if .tag is
 * guest_admin_signed_out_via_trusted_teams_details.
 * @property {TeamLogLoginFailDetails} [login_fail_details] - Available if .tag
 * is login_fail_details.
 * @property {TeamLogLoginSuccessDetails} [login_success_details] - Available if
 * .tag is login_success_details.
 * @property {TeamLogLogoutDetails} [logout_details] - Available if .tag is
 * logout_details.
 * @property {TeamLogResellerSupportSessionEndDetails}
 * [reseller_support_session_end_details] - Available if .tag is
 * reseller_support_session_end_details.
 * @property {TeamLogResellerSupportSessionStartDetails}
 * [reseller_support_session_start_details] - Available if .tag is
 * reseller_support_session_start_details.
 * @property {TeamLogSignInAsSessionEndDetails} [sign_in_as_session_end_details]
 * - Available if .tag is sign_in_as_session_end_details.
 * @property {TeamLogSignInAsSessionStartDetails}
 * [sign_in_as_session_start_details] - Available if .tag is
 * sign_in_as_session_start_details.
 * @property {TeamLogSsoErrorDetails} [sso_error_details] - Available if .tag is
 * sso_error_details.
 * @property {TeamLogMemberAddExternalIdDetails}
 * [member_add_external_id_details] - Available if .tag is
 * member_add_external_id_details.
 * @property {TeamLogMemberAddNameDetails} [member_add_name_details] - Available
 * if .tag is member_add_name_details.
 * @property {TeamLogMemberChangeAdminRoleDetails}
 * [member_change_admin_role_details] - Available if .tag is
 * member_change_admin_role_details.
 * @property {TeamLogMemberChangeEmailDetails} [member_change_email_details] -
 * Available if .tag is member_change_email_details.
 * @property {TeamLogMemberChangeExternalIdDetails}
 * [member_change_external_id_details] - Available if .tag is
 * member_change_external_id_details.
 * @property {TeamLogMemberChangeMembershipTypeDetails}
 * [member_change_membership_type_details] - Available if .tag is
 * member_change_membership_type_details.
 * @property {TeamLogMemberChangeNameDetails} [member_change_name_details] -
 * Available if .tag is member_change_name_details.
 * @property {TeamLogMemberChangeStatusDetails} [member_change_status_details] -
 * Available if .tag is member_change_status_details.
 * @property {TeamLogMemberDeleteManualContactsDetails}
 * [member_delete_manual_contacts_details] - Available if .tag is
 * member_delete_manual_contacts_details.
 * @property {TeamLogMemberPermanentlyDeleteAccountContentsDetails}
 * [member_permanently_delete_account_contents_details] - Available if .tag is
 * member_permanently_delete_account_contents_details.
 * @property {TeamLogMemberRemoveExternalIdDetails}
 * [member_remove_external_id_details] - Available if .tag is
 * member_remove_external_id_details.
 * @property {TeamLogMemberSpaceLimitsAddCustomQuotaDetails}
 * [member_space_limits_add_custom_quota_details] - Available if .tag is
 * member_space_limits_add_custom_quota_details.
 * @property {TeamLogMemberSpaceLimitsChangeCustomQuotaDetails}
 * [member_space_limits_change_custom_quota_details] - Available if .tag is
 * member_space_limits_change_custom_quota_details.
 * @property {TeamLogMemberSpaceLimitsChangeStatusDetails}
 * [member_space_limits_change_status_details] - Available if .tag is
 * member_space_limits_change_status_details.
 * @property {TeamLogMemberSpaceLimitsRemoveCustomQuotaDetails}
 * [member_space_limits_remove_custom_quota_details] - Available if .tag is
 * member_space_limits_remove_custom_quota_details.
 * @property {TeamLogMemberSuggestDetails} [member_suggest_details] - Available
 * if .tag is member_suggest_details.
 * @property {TeamLogMemberTransferAccountContentsDetails}
 * [member_transfer_account_contents_details] - Available if .tag is
 * member_transfer_account_contents_details.
 * @property {TeamLogSecondaryMailsPolicyChangedDetails}
 * [secondary_mails_policy_changed_details] - Available if .tag is
 * secondary_mails_policy_changed_details.
 * @property {TeamLogPaperContentAddMemberDetails}
 * [paper_content_add_member_details] - Available if .tag is
 * paper_content_add_member_details.
 * @property {TeamLogPaperContentAddToFolderDetails}
 * [paper_content_add_to_folder_details] - Available if .tag is
 * paper_content_add_to_folder_details.
 * @property {TeamLogPaperContentArchiveDetails} [paper_content_archive_details]
 * - Available if .tag is paper_content_archive_details.
 * @property {TeamLogPaperContentCreateDetails} [paper_content_create_details] -
 * Available if .tag is paper_content_create_details.
 * @property {TeamLogPaperContentPermanentlyDeleteDetails}
 * [paper_content_permanently_delete_details] - Available if .tag is
 * paper_content_permanently_delete_details.
 * @property {TeamLogPaperContentRemoveFromFolderDetails}
 * [paper_content_remove_from_folder_details] - Available if .tag is
 * paper_content_remove_from_folder_details.
 * @property {TeamLogPaperContentRemoveMemberDetails}
 * [paper_content_remove_member_details] - Available if .tag is
 * paper_content_remove_member_details.
 * @property {TeamLogPaperContentRenameDetails} [paper_content_rename_details] -
 * Available if .tag is paper_content_rename_details.
 * @property {TeamLogPaperContentRestoreDetails} [paper_content_restore_details]
 * - Available if .tag is paper_content_restore_details.
 * @property {TeamLogPaperDocAddCommentDetails} [paper_doc_add_comment_details]
 * - Available if .tag is paper_doc_add_comment_details.
 * @property {TeamLogPaperDocChangeMemberRoleDetails}
 * [paper_doc_change_member_role_details] - Available if .tag is
 * paper_doc_change_member_role_details.
 * @property {TeamLogPaperDocChangeSharingPolicyDetails}
 * [paper_doc_change_sharing_policy_details] - Available if .tag is
 * paper_doc_change_sharing_policy_details.
 * @property {TeamLogPaperDocChangeSubscriptionDetails}
 * [paper_doc_change_subscription_details] - Available if .tag is
 * paper_doc_change_subscription_details.
 * @property {TeamLogPaperDocDeletedDetails} [paper_doc_deleted_details] -
 * Available if .tag is paper_doc_deleted_details.
 * @property {TeamLogPaperDocDeleteCommentDetails}
 * [paper_doc_delete_comment_details] - Available if .tag is
 * paper_doc_delete_comment_details.
 * @property {TeamLogPaperDocDownloadDetails} [paper_doc_download_details] -
 * Available if .tag is paper_doc_download_details.
 * @property {TeamLogPaperDocEditDetails} [paper_doc_edit_details] - Available
 * if .tag is paper_doc_edit_details.
 * @property {TeamLogPaperDocEditCommentDetails}
 * [paper_doc_edit_comment_details] - Available if .tag is
 * paper_doc_edit_comment_details.
 * @property {TeamLogPaperDocFollowedDetails} [paper_doc_followed_details] -
 * Available if .tag is paper_doc_followed_details.
 * @property {TeamLogPaperDocMentionDetails} [paper_doc_mention_details] -
 * Available if .tag is paper_doc_mention_details.
 * @property {TeamLogPaperDocOwnershipChangedDetails}
 * [paper_doc_ownership_changed_details] - Available if .tag is
 * paper_doc_ownership_changed_details.
 * @property {TeamLogPaperDocRequestAccessDetails}
 * [paper_doc_request_access_details] - Available if .tag is
 * paper_doc_request_access_details.
 * @property {TeamLogPaperDocResolveCommentDetails}
 * [paper_doc_resolve_comment_details] - Available if .tag is
 * paper_doc_resolve_comment_details.
 * @property {TeamLogPaperDocRevertDetails} [paper_doc_revert_details] -
 * Available if .tag is paper_doc_revert_details.
 * @property {TeamLogPaperDocSlackShareDetails} [paper_doc_slack_share_details]
 * - Available if .tag is paper_doc_slack_share_details.
 * @property {TeamLogPaperDocTeamInviteDetails} [paper_doc_team_invite_details]
 * - Available if .tag is paper_doc_team_invite_details.
 * @property {TeamLogPaperDocTrashedDetails} [paper_doc_trashed_details] -
 * Available if .tag is paper_doc_trashed_details.
 * @property {TeamLogPaperDocUnresolveCommentDetails}
 * [paper_doc_unresolve_comment_details] - Available if .tag is
 * paper_doc_unresolve_comment_details.
 * @property {TeamLogPaperDocUntrashedDetails} [paper_doc_untrashed_details] -
 * Available if .tag is paper_doc_untrashed_details.
 * @property {TeamLogPaperDocViewDetails} [paper_doc_view_details] - Available
 * if .tag is paper_doc_view_details.
 * @property {TeamLogPaperExternalViewAllowDetails}
 * [paper_external_view_allow_details] - Available if .tag is
 * paper_external_view_allow_details.
 * @property {TeamLogPaperExternalViewDefaultTeamDetails}
 * [paper_external_view_default_team_details] - Available if .tag is
 * paper_external_view_default_team_details.
 * @property {TeamLogPaperExternalViewForbidDetails}
 * [paper_external_view_forbid_details] - Available if .tag is
 * paper_external_view_forbid_details.
 * @property {TeamLogPaperFolderChangeSubscriptionDetails}
 * [paper_folder_change_subscription_details] - Available if .tag is
 * paper_folder_change_subscription_details.
 * @property {TeamLogPaperFolderDeletedDetails} [paper_folder_deleted_details] -
 * Available if .tag is paper_folder_deleted_details.
 * @property {TeamLogPaperFolderFollowedDetails} [paper_folder_followed_details]
 * - Available if .tag is paper_folder_followed_details.
 * @property {TeamLogPaperFolderTeamInviteDetails}
 * [paper_folder_team_invite_details] - Available if .tag is
 * paper_folder_team_invite_details.
 * @property {TeamLogPaperPublishedLinkCreateDetails}
 * [paper_published_link_create_details] - Available if .tag is
 * paper_published_link_create_details.
 * @property {TeamLogPaperPublishedLinkDisabledDetails}
 * [paper_published_link_disabled_details] - Available if .tag is
 * paper_published_link_disabled_details.
 * @property {TeamLogPaperPublishedLinkViewDetails}
 * [paper_published_link_view_details] - Available if .tag is
 * paper_published_link_view_details.
 * @property {TeamLogPasswordChangeDetails} [password_change_details] -
 * Available if .tag is password_change_details.
 * @property {TeamLogPasswordResetDetails} [password_reset_details] - Available
 * if .tag is password_reset_details.
 * @property {TeamLogPasswordResetAllDetails} [password_reset_all_details] -
 * Available if .tag is password_reset_all_details.
 * @property {TeamLogEmmCreateExceptionsReportDetails}
 * [emm_create_exceptions_report_details] - Available if .tag is
 * emm_create_exceptions_report_details.
 * @property {TeamLogEmmCreateUsageReportDetails}
 * [emm_create_usage_report_details] - Available if .tag is
 * emm_create_usage_report_details.
 * @property {TeamLogExportMembersReportDetails} [export_members_report_details]
 * - Available if .tag is export_members_report_details.
 * @property {TeamLogPaperAdminExportStartDetails}
 * [paper_admin_export_start_details] - Available if .tag is
 * paper_admin_export_start_details.
 * @property {TeamLogSmartSyncCreateAdminPrivilegeReportDetails}
 * [smart_sync_create_admin_privilege_report_details] - Available if .tag is
 * smart_sync_create_admin_privilege_report_details.
 * @property {TeamLogTeamActivityCreateReportDetails}
 * [team_activity_create_report_details] - Available if .tag is
 * team_activity_create_report_details.
 * @property {TeamLogTeamActivityCreateReportFailDetails}
 * [team_activity_create_report_fail_details] - Available if .tag is
 * team_activity_create_report_fail_details.
 * @property {TeamLogCollectionShareDetails} [collection_share_details] -
 * Available if .tag is collection_share_details.
 * @property {TeamLogNoteAclInviteOnlyDetails} [note_acl_invite_only_details] -
 * Available if .tag is note_acl_invite_only_details.
 * @property {TeamLogNoteAclLinkDetails} [note_acl_link_details] - Available if
 * .tag is note_acl_link_details.
 * @property {TeamLogNoteAclTeamLinkDetails} [note_acl_team_link_details] -
 * Available if .tag is note_acl_team_link_details.
 * @property {TeamLogNoteSharedDetails} [note_shared_details] - Available if
 * .tag is note_shared_details.
 * @property {TeamLogNoteShareReceiveDetails} [note_share_receive_details] -
 * Available if .tag is note_share_receive_details.
 * @property {TeamLogOpenNoteSharedDetails} [open_note_shared_details] -
 * Available if .tag is open_note_shared_details.
 * @property {TeamLogSfAddGroupDetails} [sf_add_group_details] - Available if
 * .tag is sf_add_group_details.
 * @property {TeamLogSfAllowNonMembersToViewSharedLinksDetails}
 * [sf_allow_non_members_to_view_shared_links_details] - Available if .tag is
 * sf_allow_non_members_to_view_shared_links_details.
 * @property {TeamLogSfExternalInviteWarnDetails}
 * [sf_external_invite_warn_details] - Available if .tag is
 * sf_external_invite_warn_details.
 * @property {TeamLogSfFbInviteDetails} [sf_fb_invite_details] - Available if
 * .tag is sf_fb_invite_details.
 * @property {TeamLogSfFbInviteChangeRoleDetails}
 * [sf_fb_invite_change_role_details] - Available if .tag is
 * sf_fb_invite_change_role_details.
 * @property {TeamLogSfFbUninviteDetails} [sf_fb_uninvite_details] - Available
 * if .tag is sf_fb_uninvite_details.
 * @property {TeamLogSfInviteGroupDetails} [sf_invite_group_details] - Available
 * if .tag is sf_invite_group_details.
 * @property {TeamLogSfTeamGrantAccessDetails} [sf_team_grant_access_details] -
 * Available if .tag is sf_team_grant_access_details.
 * @property {TeamLogSfTeamInviteDetails} [sf_team_invite_details] - Available
 * if .tag is sf_team_invite_details.
 * @property {TeamLogSfTeamInviteChangeRoleDetails}
 * [sf_team_invite_change_role_details] - Available if .tag is
 * sf_team_invite_change_role_details.
 * @property {TeamLogSfTeamJoinDetails} [sf_team_join_details] - Available if
 * .tag is sf_team_join_details.
 * @property {TeamLogSfTeamJoinFromOobLinkDetails}
 * [sf_team_join_from_oob_link_details] - Available if .tag is
 * sf_team_join_from_oob_link_details.
 * @property {TeamLogSfTeamUninviteDetails} [sf_team_uninvite_details] -
 * Available if .tag is sf_team_uninvite_details.
 * @property {TeamLogSharedContentAddInviteesDetails}
 * [shared_content_add_invitees_details] - Available if .tag is
 * shared_content_add_invitees_details.
 * @property {TeamLogSharedContentAddLinkExpiryDetails}
 * [shared_content_add_link_expiry_details] - Available if .tag is
 * shared_content_add_link_expiry_details.
 * @property {TeamLogSharedContentAddLinkPasswordDetails}
 * [shared_content_add_link_password_details] - Available if .tag is
 * shared_content_add_link_password_details.
 * @property {TeamLogSharedContentAddMemberDetails}
 * [shared_content_add_member_details] - Available if .tag is
 * shared_content_add_member_details.
 * @property {TeamLogSharedContentChangeDownloadsPolicyDetails}
 * [shared_content_change_downloads_policy_details] - Available if .tag is
 * shared_content_change_downloads_policy_details.
 * @property {TeamLogSharedContentChangeInviteeRoleDetails}
 * [shared_content_change_invitee_role_details] - Available if .tag is
 * shared_content_change_invitee_role_details.
 * @property {TeamLogSharedContentChangeLinkAudienceDetails}
 * [shared_content_change_link_audience_details] - Available if .tag is
 * shared_content_change_link_audience_details.
 * @property {TeamLogSharedContentChangeLinkExpiryDetails}
 * [shared_content_change_link_expiry_details] - Available if .tag is
 * shared_content_change_link_expiry_details.
 * @property {TeamLogSharedContentChangeLinkPasswordDetails}
 * [shared_content_change_link_password_details] - Available if .tag is
 * shared_content_change_link_password_details.
 * @property {TeamLogSharedContentChangeMemberRoleDetails}
 * [shared_content_change_member_role_details] - Available if .tag is
 * shared_content_change_member_role_details.
 * @property {TeamLogSharedContentChangeViewerInfoPolicyDetails}
 * [shared_content_change_viewer_info_policy_details] - Available if .tag is
 * shared_content_change_viewer_info_policy_details.
 * @property {TeamLogSharedContentClaimInvitationDetails}
 * [shared_content_claim_invitation_details] - Available if .tag is
 * shared_content_claim_invitation_details.
 * @property {TeamLogSharedContentCopyDetails} [shared_content_copy_details] -
 * Available if .tag is shared_content_copy_details.
 * @property {TeamLogSharedContentDownloadDetails}
 * [shared_content_download_details] - Available if .tag is
 * shared_content_download_details.
 * @property {TeamLogSharedContentRelinquishMembershipDetails}
 * [shared_content_relinquish_membership_details] - Available if .tag is
 * shared_content_relinquish_membership_details.
 * @property {TeamLogSharedContentRemoveInviteesDetails}
 * [shared_content_remove_invitees_details] - Available if .tag is
 * shared_content_remove_invitees_details.
 * @property {TeamLogSharedContentRemoveLinkExpiryDetails}
 * [shared_content_remove_link_expiry_details] - Available if .tag is
 * shared_content_remove_link_expiry_details.
 * @property {TeamLogSharedContentRemoveLinkPasswordDetails}
 * [shared_content_remove_link_password_details] - Available if .tag is
 * shared_content_remove_link_password_details.
 * @property {TeamLogSharedContentRemoveMemberDetails}
 * [shared_content_remove_member_details] - Available if .tag is
 * shared_content_remove_member_details.
 * @property {TeamLogSharedContentRequestAccessDetails}
 * [shared_content_request_access_details] - Available if .tag is
 * shared_content_request_access_details.
 * @property {TeamLogSharedContentUnshareDetails}
 * [shared_content_unshare_details] - Available if .tag is
 * shared_content_unshare_details.
 * @property {TeamLogSharedContentViewDetails} [shared_content_view_details] -
 * Available if .tag is shared_content_view_details.
 * @property {TeamLogSharedFolderChangeLinkPolicyDetails}
 * [shared_folder_change_link_policy_details] - Available if .tag is
 * shared_folder_change_link_policy_details.
 * @property {TeamLogSharedFolderChangeMembersInheritancePolicyDetails}
 * [shared_folder_change_members_inheritance_policy_details] - Available if .tag
 * is shared_folder_change_members_inheritance_policy_details.
 * @property {TeamLogSharedFolderChangeMembersManagementPolicyDetails}
 * [shared_folder_change_members_management_policy_details] - Available if .tag
 * is shared_folder_change_members_management_policy_details.
 * @property {TeamLogSharedFolderChangeMembersPolicyDetails}
 * [shared_folder_change_members_policy_details] - Available if .tag is
 * shared_folder_change_members_policy_details.
 * @property {TeamLogSharedFolderCreateDetails} [shared_folder_create_details] -
 * Available if .tag is shared_folder_create_details.
 * @property {TeamLogSharedFolderDeclineInvitationDetails}
 * [shared_folder_decline_invitation_details] - Available if .tag is
 * shared_folder_decline_invitation_details.
 * @property {TeamLogSharedFolderMountDetails} [shared_folder_mount_details] -
 * Available if .tag is shared_folder_mount_details.
 * @property {TeamLogSharedFolderNestDetails} [shared_folder_nest_details] -
 * Available if .tag is shared_folder_nest_details.
 * @property {TeamLogSharedFolderTransferOwnershipDetails}
 * [shared_folder_transfer_ownership_details] - Available if .tag is
 * shared_folder_transfer_ownership_details.
 * @property {TeamLogSharedFolderUnmountDetails} [shared_folder_unmount_details]
 * - Available if .tag is shared_folder_unmount_details.
 * @property {TeamLogSharedLinkAddExpiryDetails}
 * [shared_link_add_expiry_details] - Available if .tag is
 * shared_link_add_expiry_details.
 * @property {TeamLogSharedLinkChangeExpiryDetails}
 * [shared_link_change_expiry_details] - Available if .tag is
 * shared_link_change_expiry_details.
 * @property {TeamLogSharedLinkChangeVisibilityDetails}
 * [shared_link_change_visibility_details] - Available if .tag is
 * shared_link_change_visibility_details.
 * @property {TeamLogSharedLinkCopyDetails} [shared_link_copy_details] -
 * Available if .tag is shared_link_copy_details.
 * @property {TeamLogSharedLinkCreateDetails} [shared_link_create_details] -
 * Available if .tag is shared_link_create_details.
 * @property {TeamLogSharedLinkDisableDetails} [shared_link_disable_details] -
 * Available if .tag is shared_link_disable_details.
 * @property {TeamLogSharedLinkDownloadDetails} [shared_link_download_details] -
 * Available if .tag is shared_link_download_details.
 * @property {TeamLogSharedLinkRemoveExpiryDetails}
 * [shared_link_remove_expiry_details] - Available if .tag is
 * shared_link_remove_expiry_details.
 * @property {TeamLogSharedLinkShareDetails} [shared_link_share_details] -
 * Available if .tag is shared_link_share_details.
 * @property {TeamLogSharedLinkViewDetails} [shared_link_view_details] -
 * Available if .tag is shared_link_view_details.
 * @property {TeamLogSharedNoteOpenedDetails} [shared_note_opened_details] -
 * Available if .tag is shared_note_opened_details.
 * @property {TeamLogShmodelGroupShareDetails} [shmodel_group_share_details] -
 * Available if .tag is shmodel_group_share_details.
 * @property {TeamLogShowcaseAccessGrantedDetails}
 * [showcase_access_granted_details] - Available if .tag is
 * showcase_access_granted_details.
 * @property {TeamLogShowcaseAddMemberDetails} [showcase_add_member_details] -
 * Available if .tag is showcase_add_member_details.
 * @property {TeamLogShowcaseArchivedDetails} [showcase_archived_details] -
 * Available if .tag is showcase_archived_details.
 * @property {TeamLogShowcaseCreatedDetails} [showcase_created_details] -
 * Available if .tag is showcase_created_details.
 * @property {TeamLogShowcaseDeleteCommentDetails}
 * [showcase_delete_comment_details] - Available if .tag is
 * showcase_delete_comment_details.
 * @property {TeamLogShowcaseEditedDetails} [showcase_edited_details] -
 * Available if .tag is showcase_edited_details.
 * @property {TeamLogShowcaseEditCommentDetails} [showcase_edit_comment_details]
 * - Available if .tag is showcase_edit_comment_details.
 * @property {TeamLogShowcaseFileAddedDetails} [showcase_file_added_details] -
 * Available if .tag is showcase_file_added_details.
 * @property {TeamLogShowcaseFileDownloadDetails}
 * [showcase_file_download_details] - Available if .tag is
 * showcase_file_download_details.
 * @property {TeamLogShowcaseFileRemovedDetails} [showcase_file_removed_details]
 * - Available if .tag is showcase_file_removed_details.
 * @property {TeamLogShowcaseFileViewDetails} [showcase_file_view_details] -
 * Available if .tag is showcase_file_view_details.
 * @property {TeamLogShowcasePermanentlyDeletedDetails}
 * [showcase_permanently_deleted_details] - Available if .tag is
 * showcase_permanently_deleted_details.
 * @property {TeamLogShowcasePostCommentDetails} [showcase_post_comment_details]
 * - Available if .tag is showcase_post_comment_details.
 * @property {TeamLogShowcaseRemoveMemberDetails}
 * [showcase_remove_member_details] - Available if .tag is
 * showcase_remove_member_details.
 * @property {TeamLogShowcaseRenamedDetails} [showcase_renamed_details] -
 * Available if .tag is showcase_renamed_details.
 * @property {TeamLogShowcaseRequestAccessDetails}
 * [showcase_request_access_details] - Available if .tag is
 * showcase_request_access_details.
 * @property {TeamLogShowcaseResolveCommentDetails}
 * [showcase_resolve_comment_details] - Available if .tag is
 * showcase_resolve_comment_details.
 * @property {TeamLogShowcaseRestoredDetails} [showcase_restored_details] -
 * Available if .tag is showcase_restored_details.
 * @property {TeamLogShowcaseTrashedDetails} [showcase_trashed_details] -
 * Available if .tag is showcase_trashed_details.
 * @property {TeamLogShowcaseTrashedDeprecatedDetails}
 * [showcase_trashed_deprecated_details] - Available if .tag is
 * showcase_trashed_deprecated_details.
 * @property {TeamLogShowcaseUnresolveCommentDetails}
 * [showcase_unresolve_comment_details] - Available if .tag is
 * showcase_unresolve_comment_details.
 * @property {TeamLogShowcaseUntrashedDetails} [showcase_untrashed_details] -
 * Available if .tag is showcase_untrashed_details.
 * @property {TeamLogShowcaseUntrashedDeprecatedDetails}
 * [showcase_untrashed_deprecated_details] - Available if .tag is
 * showcase_untrashed_deprecated_details.
 * @property {TeamLogShowcaseViewDetails} [showcase_view_details] - Available if
 * .tag is showcase_view_details.
 * @property {TeamLogSsoAddCertDetails} [sso_add_cert_details] - Available if
 * .tag is sso_add_cert_details.
 * @property {TeamLogSsoAddLoginUrlDetails} [sso_add_login_url_details] -
 * Available if .tag is sso_add_login_url_details.
 * @property {TeamLogSsoAddLogoutUrlDetails} [sso_add_logout_url_details] -
 * Available if .tag is sso_add_logout_url_details.
 * @property {TeamLogSsoChangeCertDetails} [sso_change_cert_details] - Available
 * if .tag is sso_change_cert_details.
 * @property {TeamLogSsoChangeLoginUrlDetails} [sso_change_login_url_details] -
 * Available if .tag is sso_change_login_url_details.
 * @property {TeamLogSsoChangeLogoutUrlDetails} [sso_change_logout_url_details]
 * - Available if .tag is sso_change_logout_url_details.
 * @property {TeamLogSsoChangeSamlIdentityModeDetails}
 * [sso_change_saml_identity_mode_details] - Available if .tag is
 * sso_change_saml_identity_mode_details.
 * @property {TeamLogSsoRemoveCertDetails} [sso_remove_cert_details] - Available
 * if .tag is sso_remove_cert_details.
 * @property {TeamLogSsoRemoveLoginUrlDetails} [sso_remove_login_url_details] -
 * Available if .tag is sso_remove_login_url_details.
 * @property {TeamLogSsoRemoveLogoutUrlDetails} [sso_remove_logout_url_details]
 * - Available if .tag is sso_remove_logout_url_details.
 * @property {TeamLogTeamFolderChangeStatusDetails}
 * [team_folder_change_status_details] - Available if .tag is
 * team_folder_change_status_details.
 * @property {TeamLogTeamFolderCreateDetails} [team_folder_create_details] -
 * Available if .tag is team_folder_create_details.
 * @property {TeamLogTeamFolderDowngradeDetails} [team_folder_downgrade_details]
 * - Available if .tag is team_folder_downgrade_details.
 * @property {TeamLogTeamFolderPermanentlyDeleteDetails}
 * [team_folder_permanently_delete_details] - Available if .tag is
 * team_folder_permanently_delete_details.
 * @property {TeamLogTeamFolderRenameDetails} [team_folder_rename_details] -
 * Available if .tag is team_folder_rename_details.
 * @property {TeamLogTeamSelectiveSyncSettingsChangedDetails}
 * [team_selective_sync_settings_changed_details] - Available if .tag is
 * team_selective_sync_settings_changed_details.
 * @property {TeamLogAccountCaptureChangePolicyDetails}
 * [account_capture_change_policy_details] - Available if .tag is
 * account_capture_change_policy_details.
 * @property {TeamLogAllowDownloadDisabledDetails}
 * [allow_download_disabled_details] - Available if .tag is
 * allow_download_disabled_details.
 * @property {TeamLogAllowDownloadEnabledDetails}
 * [allow_download_enabled_details] - Available if .tag is
 * allow_download_enabled_details.
 * @property {TeamLogCameraUploadsPolicyChangedDetails}
 * [camera_uploads_policy_changed_details] - Available if .tag is
 * camera_uploads_policy_changed_details.
 * @property {TeamLogDataPlacementRestrictionChangePolicyDetails}
 * [data_placement_restriction_change_policy_details] - Available if .tag is
 * data_placement_restriction_change_policy_details.
 * @property {TeamLogDataPlacementRestrictionSatisfyPolicyDetails}
 * [data_placement_restriction_satisfy_policy_details] - Available if .tag is
 * data_placement_restriction_satisfy_policy_details.
 * @property {TeamLogDeviceApprovalsChangeDesktopPolicyDetails}
 * [device_approvals_change_desktop_policy_details] - Available if .tag is
 * device_approvals_change_desktop_policy_details.
 * @property {TeamLogDeviceApprovalsChangeMobilePolicyDetails}
 * [device_approvals_change_mobile_policy_details] - Available if .tag is
 * device_approvals_change_mobile_policy_details.
 * @property {TeamLogDeviceApprovalsChangeOverageActionDetails}
 * [device_approvals_change_overage_action_details] - Available if .tag is
 * device_approvals_change_overage_action_details.
 * @property {TeamLogDeviceApprovalsChangeUnlinkActionDetails}
 * [device_approvals_change_unlink_action_details] - Available if .tag is
 * device_approvals_change_unlink_action_details.
 * @property {TeamLogDirectoryRestrictionsAddMembersDetails}
 * [directory_restrictions_add_members_details] - Available if .tag is
 * directory_restrictions_add_members_details.
 * @property {TeamLogDirectoryRestrictionsRemoveMembersDetails}
 * [directory_restrictions_remove_members_details] - Available if .tag is
 * directory_restrictions_remove_members_details.
 * @property {TeamLogEmmAddExceptionDetails} [emm_add_exception_details] -
 * Available if .tag is emm_add_exception_details.
 * @property {TeamLogEmmChangePolicyDetails} [emm_change_policy_details] -
 * Available if .tag is emm_change_policy_details.
 * @property {TeamLogEmmRemoveExceptionDetails} [emm_remove_exception_details] -
 * Available if .tag is emm_remove_exception_details.
 * @property {TeamLogExtendedVersionHistoryChangePolicyDetails}
 * [extended_version_history_change_policy_details] - Available if .tag is
 * extended_version_history_change_policy_details.
 * @property {TeamLogFileCommentsChangePolicyDetails}
 * [file_comments_change_policy_details] - Available if .tag is
 * file_comments_change_policy_details.
 * @property {TeamLogFileRequestsChangePolicyDetails}
 * [file_requests_change_policy_details] - Available if .tag is
 * file_requests_change_policy_details.
 * @property {TeamLogFileRequestsEmailsEnabledDetails}
 * [file_requests_emails_enabled_details] - Available if .tag is
 * file_requests_emails_enabled_details.
 * @property {TeamLogFileRequestsEmailsRestrictedToTeamOnlyDetails}
 * [file_requests_emails_restricted_to_team_only_details] - Available if .tag is
 * file_requests_emails_restricted_to_team_only_details.
 * @property {TeamLogGoogleSsoChangePolicyDetails}
 * [google_sso_change_policy_details] - Available if .tag is
 * google_sso_change_policy_details.
 * @property {TeamLogGroupUserManagementChangePolicyDetails}
 * [group_user_management_change_policy_details] - Available if .tag is
 * group_user_management_change_policy_details.
 * @property {TeamLogIntegrationPolicyChangedDetails}
 * [integration_policy_changed_details] - Available if .tag is
 * integration_policy_changed_details.
 * @property {TeamLogMemberRequestsChangePolicyDetails}
 * [member_requests_change_policy_details] - Available if .tag is
 * member_requests_change_policy_details.
 * @property {TeamLogMemberSpaceLimitsAddExceptionDetails}
 * [member_space_limits_add_exception_details] - Available if .tag is
 * member_space_limits_add_exception_details.
 * @property {TeamLogMemberSpaceLimitsChangeCapsTypePolicyDetails}
 * [member_space_limits_change_caps_type_policy_details] - Available if .tag is
 * member_space_limits_change_caps_type_policy_details.
 * @property {TeamLogMemberSpaceLimitsChangePolicyDetails}
 * [member_space_limits_change_policy_details] - Available if .tag is
 * member_space_limits_change_policy_details.
 * @property {TeamLogMemberSpaceLimitsRemoveExceptionDetails}
 * [member_space_limits_remove_exception_details] - Available if .tag is
 * member_space_limits_remove_exception_details.
 * @property {TeamLogMemberSuggestionsChangePolicyDetails}
 * [member_suggestions_change_policy_details] - Available if .tag is
 * member_suggestions_change_policy_details.
 * @property {TeamLogMicrosoftOfficeAddinChangePolicyDetails}
 * [microsoft_office_addin_change_policy_details] - Available if .tag is
 * microsoft_office_addin_change_policy_details.
 * @property {TeamLogNetworkControlChangePolicyDetails}
 * [network_control_change_policy_details] - Available if .tag is
 * network_control_change_policy_details.
 * @property {TeamLogPaperChangeDeploymentPolicyDetails}
 * [paper_change_deployment_policy_details] - Available if .tag is
 * paper_change_deployment_policy_details.
 * @property {TeamLogPaperChangeMemberLinkPolicyDetails}
 * [paper_change_member_link_policy_details] - Available if .tag is
 * paper_change_member_link_policy_details.
 * @property {TeamLogPaperChangeMemberPolicyDetails}
 * [paper_change_member_policy_details] - Available if .tag is
 * paper_change_member_policy_details.
 * @property {TeamLogPaperChangePolicyDetails} [paper_change_policy_details] -
 * Available if .tag is paper_change_policy_details.
 * @property {TeamLogPaperDefaultFolderPolicyChangedDetails}
 * [paper_default_folder_policy_changed_details] - Available if .tag is
 * paper_default_folder_policy_changed_details.
 * @property {TeamLogPaperDesktopPolicyChangedDetails}
 * [paper_desktop_policy_changed_details] - Available if .tag is
 * paper_desktop_policy_changed_details.
 * @property {TeamLogPaperEnabledUsersGroupAdditionDetails}
 * [paper_enabled_users_group_addition_details] - Available if .tag is
 * paper_enabled_users_group_addition_details.
 * @property {TeamLogPaperEnabledUsersGroupRemovalDetails}
 * [paper_enabled_users_group_removal_details] - Available if .tag is
 * paper_enabled_users_group_removal_details.
 * @property {TeamLogPermanentDeleteChangePolicyDetails}
 * [permanent_delete_change_policy_details] - Available if .tag is
 * permanent_delete_change_policy_details.
 * @property {TeamLogResellerSupportChangePolicyDetails}
 * [reseller_support_change_policy_details] - Available if .tag is
 * reseller_support_change_policy_details.
 * @property {TeamLogSharingChangeFolderJoinPolicyDetails}
 * [sharing_change_folder_join_policy_details] - Available if .tag is
 * sharing_change_folder_join_policy_details.
 * @property {TeamLogSharingChangeLinkPolicyDetails}
 * [sharing_change_link_policy_details] - Available if .tag is
 * sharing_change_link_policy_details.
 * @property {TeamLogSharingChangeMemberPolicyDetails}
 * [sharing_change_member_policy_details] - Available if .tag is
 * sharing_change_member_policy_details.
 * @property {TeamLogShowcaseChangeDownloadPolicyDetails}
 * [showcase_change_download_policy_details] - Available if .tag is
 * showcase_change_download_policy_details.
 * @property {TeamLogShowcaseChangeEnabledPolicyDetails}
 * [showcase_change_enabled_policy_details] - Available if .tag is
 * showcase_change_enabled_policy_details.
 * @property {TeamLogShowcaseChangeExternalSharingPolicyDetails}
 * [showcase_change_external_sharing_policy_details] - Available if .tag is
 * showcase_change_external_sharing_policy_details.
 * @property {TeamLogSmartSyncChangePolicyDetails}
 * [smart_sync_change_policy_details] - Available if .tag is
 * smart_sync_change_policy_details.
 * @property {TeamLogSmartSyncNotOptOutDetails} [smart_sync_not_opt_out_details]
 * - Available if .tag is smart_sync_not_opt_out_details.
 * @property {TeamLogSmartSyncOptOutDetails} [smart_sync_opt_out_details] -
 * Available if .tag is smart_sync_opt_out_details.
 * @property {TeamLogSsoChangePolicyDetails} [sso_change_policy_details] -
 * Available if .tag is sso_change_policy_details.
 * @property {TeamLogTeamExtensionsPolicyChangedDetails}
 * [team_extensions_policy_changed_details] - Available if .tag is
 * team_extensions_policy_changed_details.
 * @property {TeamLogTeamSelectiveSyncPolicyChangedDetails}
 * [team_selective_sync_policy_changed_details] - Available if .tag is
 * team_selective_sync_policy_changed_details.
 * @property {TeamLogTfaChangePolicyDetails} [tfa_change_policy_details] -
 * Available if .tag is tfa_change_policy_details.
 * @property {TeamLogTwoAccountChangePolicyDetails}
 * [two_account_change_policy_details] - Available if .tag is
 * two_account_change_policy_details.
 * @property {TeamLogViewerInfoPolicyChangedDetails}
 * [viewer_info_policy_changed_details] - Available if .tag is
 * viewer_info_policy_changed_details.
 * @property {TeamLogWebSessionsChangeFixedLengthPolicyDetails}
 * [web_sessions_change_fixed_length_policy_details] - Available if .tag is
 * web_sessions_change_fixed_length_policy_details.
 * @property {TeamLogWebSessionsChangeIdleLengthPolicyDetails}
 * [web_sessions_change_idle_length_policy_details] - Available if .tag is
 * web_sessions_change_idle_length_policy_details.
 * @property {TeamLogTeamMergeFromDetails} [team_merge_from_details] - Available
 * if .tag is team_merge_from_details.
 * @property {TeamLogTeamMergeToDetails} [team_merge_to_details] - Available if
 * .tag is team_merge_to_details.
 * @property {TeamLogTeamProfileAddLogoDetails} [team_profile_add_logo_details]
 * - Available if .tag is team_profile_add_logo_details.
 * @property {TeamLogTeamProfileChangeDefaultLanguageDetails}
 * [team_profile_change_default_language_details] - Available if .tag is
 * team_profile_change_default_language_details.
 * @property {TeamLogTeamProfileChangeLogoDetails}
 * [team_profile_change_logo_details] - Available if .tag is
 * team_profile_change_logo_details.
 * @property {TeamLogTeamProfileChangeNameDetails}
 * [team_profile_change_name_details] - Available if .tag is
 * team_profile_change_name_details.
 * @property {TeamLogTeamProfileRemoveLogoDetails}
 * [team_profile_remove_logo_details] - Available if .tag is
 * team_profile_remove_logo_details.
 * @property {TeamLogTfaAddBackupPhoneDetails} [tfa_add_backup_phone_details] -
 * Available if .tag is tfa_add_backup_phone_details.
 * @property {TeamLogTfaAddSecurityKeyDetails} [tfa_add_security_key_details] -
 * Available if .tag is tfa_add_security_key_details.
 * @property {TeamLogTfaChangeBackupPhoneDetails}
 * [tfa_change_backup_phone_details] - Available if .tag is
 * tfa_change_backup_phone_details.
 * @property {TeamLogTfaChangeStatusDetails} [tfa_change_status_details] -
 * Available if .tag is tfa_change_status_details.
 * @property {TeamLogTfaRemoveBackupPhoneDetails}
 * [tfa_remove_backup_phone_details] - Available if .tag is
 * tfa_remove_backup_phone_details.
 * @property {TeamLogTfaRemoveSecurityKeyDetails}
 * [tfa_remove_security_key_details] - Available if .tag is
 * tfa_remove_security_key_details.
 * @property {TeamLogTfaResetDetails} [tfa_reset_details] - Available if .tag is
 * tfa_reset_details.
 * @property {TeamLogGuestAdminChangeStatusDetails}
 * [guest_admin_change_status_details] - Available if .tag is
 * guest_admin_change_status_details.
 * @property {TeamLogTeamMergeRequestAcceptedDetails}
 * [team_merge_request_accepted_details] - Available if .tag is
 * team_merge_request_accepted_details.
 * @property {TeamLogTeamMergeRequestAcceptedShownToPrimaryTeamDetails}
 * [team_merge_request_accepted_shown_to_primary_team_details] - Available if
 * .tag is team_merge_request_accepted_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestAcceptedShownToSecondaryTeamDetails}
 * [team_merge_request_accepted_shown_to_secondary_team_details] - Available if
 * .tag is team_merge_request_accepted_shown_to_secondary_team_details.
 * @property {TeamLogTeamMergeRequestAutoCanceledDetails}
 * [team_merge_request_auto_canceled_details] - Available if .tag is
 * team_merge_request_auto_canceled_details.
 * @property {TeamLogTeamMergeRequestCanceledDetails}
 * [team_merge_request_canceled_details] - Available if .tag is
 * team_merge_request_canceled_details.
 * @property {TeamLogTeamMergeRequestCanceledShownToPrimaryTeamDetails}
 * [team_merge_request_canceled_shown_to_primary_team_details] - Available if
 * .tag is team_merge_request_canceled_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestCanceledShownToSecondaryTeamDetails}
 * [team_merge_request_canceled_shown_to_secondary_team_details] - Available if
 * .tag is team_merge_request_canceled_shown_to_secondary_team_details.
 * @property {TeamLogTeamMergeRequestExpiredDetails}
 * [team_merge_request_expired_details] - Available if .tag is
 * team_merge_request_expired_details.
 * @property {TeamLogTeamMergeRequestExpiredShownToPrimaryTeamDetails}
 * [team_merge_request_expired_shown_to_primary_team_details] - Available if
 * .tag is team_merge_request_expired_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestExpiredShownToSecondaryTeamDetails}
 * [team_merge_request_expired_shown_to_secondary_team_details] - Available if
 * .tag is team_merge_request_expired_shown_to_secondary_team_details.
 * @property {TeamLogTeamMergeRequestRejectedShownToPrimaryTeamDetails}
 * [team_merge_request_rejected_shown_to_primary_team_details] - Available if
 * .tag is team_merge_request_rejected_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestRejectedShownToSecondaryTeamDetails}
 * [team_merge_request_rejected_shown_to_secondary_team_details] - Available if
 * .tag is team_merge_request_rejected_shown_to_secondary_team_details.
 * @property {TeamLogTeamMergeRequestReminderDetails}
 * [team_merge_request_reminder_details] - Available if .tag is
 * team_merge_request_reminder_details.
 * @property {TeamLogTeamMergeRequestReminderShownToPrimaryTeamDetails}
 * [team_merge_request_reminder_shown_to_primary_team_details] - Available if
 * .tag is team_merge_request_reminder_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestReminderShownToSecondaryTeamDetails}
 * [team_merge_request_reminder_shown_to_secondary_team_details] - Available if
 * .tag is team_merge_request_reminder_shown_to_secondary_team_details.
 * @property {TeamLogTeamMergeRequestRevokedDetails}
 * [team_merge_request_revoked_details] - Available if .tag is
 * team_merge_request_revoked_details.
 * @property {TeamLogTeamMergeRequestSentShownToPrimaryTeamDetails}
 * [team_merge_request_sent_shown_to_primary_team_details] - Available if .tag
 * is team_merge_request_sent_shown_to_primary_team_details.
 * @property {TeamLogTeamMergeRequestSentShownToSecondaryTeamDetails}
 * [team_merge_request_sent_shown_to_secondary_team_details] - Available if .tag
 * is team_merge_request_sent_shown_to_secondary_team_details.
 * @property {TeamLogMissingDetails} [missing_details] - Available if .tag is
 * missing_details. Hints that this event was returned with missing details due
 * to an internal error.
 * @property {('app_link_team_details'|'app_link_user_details'|'app_unlink_team_details'|'app_unlink_user_details'|'integration_connected_details'|'integration_disconnected_details'|'file_add_comment_details'|'file_change_comment_subscription_details'|'file_delete_comment_details'|'file_edit_comment_details'|'file_like_comment_details'|'file_resolve_comment_details'|'file_unlike_comment_details'|'file_unresolve_comment_details'|'device_change_ip_desktop_details'|'device_change_ip_mobile_details'|'device_change_ip_web_details'|'device_delete_on_unlink_fail_details'|'device_delete_on_unlink_success_details'|'device_link_fail_details'|'device_link_success_details'|'device_management_disabled_details'|'device_management_enabled_details'|'device_unlink_details'|'emm_refresh_auth_token_details'|'account_capture_change_availability_details'|'account_capture_migrate_account_details'|'account_capture_notification_emails_sent_details'|'account_capture_relinquish_account_details'|'disabled_domain_invites_details'|'domain_invites_approve_request_to_join_team_details'|'domain_invites_decline_request_to_join_team_details'|'domain_invites_email_existing_users_details'|'domain_invites_request_to_join_team_details'|'domain_invites_set_invite_new_user_pref_to_no_details'|'domain_invites_set_invite_new_user_pref_to_yes_details'|'domain_verification_add_domain_fail_details'|'domain_verification_add_domain_success_details'|'domain_verification_remove_domain_details'|'enabled_domain_invites_details'|'create_folder_details'|'file_add_details'|'file_copy_details'|'file_delete_details'|'file_download_details'|'file_edit_details'|'file_get_copy_reference_details'|'file_move_details'|'file_permanently_delete_details'|'file_preview_details'|'file_rename_details'|'file_restore_details'|'file_revert_details'|'file_rollback_changes_details'|'file_save_copy_reference_details'|'file_request_change_details'|'file_request_close_details'|'file_request_create_details'|'file_request_delete_details'|'file_request_receive_file_details'|'group_add_external_id_details'|'group_add_member_details'|'group_change_external_id_details'|'group_change_management_type_details'|'group_change_member_role_details'|'group_create_details'|'group_delete_details'|'group_description_updated_details'|'group_join_policy_updated_details'|'group_moved_details'|'group_remove_external_id_details'|'group_remove_member_details'|'group_rename_details'|'emm_error_details'|'guest_admin_signed_in_via_trusted_teams_details'|'guest_admin_signed_out_via_trusted_teams_details'|'login_fail_details'|'login_success_details'|'logout_details'|'reseller_support_session_end_details'|'reseller_support_session_start_details'|'sign_in_as_session_end_details'|'sign_in_as_session_start_details'|'sso_error_details'|'member_add_external_id_details'|'member_add_name_details'|'member_change_admin_role_details'|'member_change_email_details'|'member_change_external_id_details'|'member_change_membership_type_details'|'member_change_name_details'|'member_change_status_details'|'member_delete_manual_contacts_details'|'member_permanently_delete_account_contents_details'|'member_remove_external_id_details'|'member_space_limits_add_custom_quota_details'|'member_space_limits_change_custom_quota_details'|'member_space_limits_change_status_details'|'member_space_limits_remove_custom_quota_details'|'member_suggest_details'|'member_transfer_account_contents_details'|'secondary_mails_policy_changed_details'|'paper_content_add_member_details'|'paper_content_add_to_folder_details'|'paper_content_archive_details'|'paper_content_create_details'|'paper_content_permanently_delete_details'|'paper_content_remove_from_folder_details'|'paper_content_remove_member_details'|'paper_content_rename_details'|'paper_content_restore_details'|'paper_doc_add_comment_details'|'paper_doc_change_member_role_details'|'paper_doc_change_sharing_policy_details'|'paper_doc_change_subscription_details'|'paper_doc_deleted_details'|'paper_doc_delete_comment_details'|'paper_doc_download_details'|'paper_doc_edit_details'|'paper_doc_edit_comment_details'|'paper_doc_followed_details'|'paper_doc_mention_details'|'paper_doc_ownership_changed_details'|'paper_doc_request_access_details'|'paper_doc_resolve_comment_details'|'paper_doc_revert_details'|'paper_doc_slack_share_details'|'paper_doc_team_invite_details'|'paper_doc_trashed_details'|'paper_doc_unresolve_comment_details'|'paper_doc_untrashed_details'|'paper_doc_view_details'|'paper_external_view_allow_details'|'paper_external_view_default_team_details'|'paper_external_view_forbid_details'|'paper_folder_change_subscription_details'|'paper_folder_deleted_details'|'paper_folder_followed_details'|'paper_folder_team_invite_details'|'paper_published_link_create_details'|'paper_published_link_disabled_details'|'paper_published_link_view_details'|'password_change_details'|'password_reset_details'|'password_reset_all_details'|'emm_create_exceptions_report_details'|'emm_create_usage_report_details'|'export_members_report_details'|'paper_admin_export_start_details'|'smart_sync_create_admin_privilege_report_details'|'team_activity_create_report_details'|'team_activity_create_report_fail_details'|'collection_share_details'|'note_acl_invite_only_details'|'note_acl_link_details'|'note_acl_team_link_details'|'note_shared_details'|'note_share_receive_details'|'open_note_shared_details'|'sf_add_group_details'|'sf_allow_non_members_to_view_shared_links_details'|'sf_external_invite_warn_details'|'sf_fb_invite_details'|'sf_fb_invite_change_role_details'|'sf_fb_uninvite_details'|'sf_invite_group_details'|'sf_team_grant_access_details'|'sf_team_invite_details'|'sf_team_invite_change_role_details'|'sf_team_join_details'|'sf_team_join_from_oob_link_details'|'sf_team_uninvite_details'|'shared_content_add_invitees_details'|'shared_content_add_link_expiry_details'|'shared_content_add_link_password_details'|'shared_content_add_member_details'|'shared_content_change_downloads_policy_details'|'shared_content_change_invitee_role_details'|'shared_content_change_link_audience_details'|'shared_content_change_link_expiry_details'|'shared_content_change_link_password_details'|'shared_content_change_member_role_details'|'shared_content_change_viewer_info_policy_details'|'shared_content_claim_invitation_details'|'shared_content_copy_details'|'shared_content_download_details'|'shared_content_relinquish_membership_details'|'shared_content_remove_invitees_details'|'shared_content_remove_link_expiry_details'|'shared_content_remove_link_password_details'|'shared_content_remove_member_details'|'shared_content_request_access_details'|'shared_content_unshare_details'|'shared_content_view_details'|'shared_folder_change_link_policy_details'|'shared_folder_change_members_inheritance_policy_details'|'shared_folder_change_members_management_policy_details'|'shared_folder_change_members_policy_details'|'shared_folder_create_details'|'shared_folder_decline_invitation_details'|'shared_folder_mount_details'|'shared_folder_nest_details'|'shared_folder_transfer_ownership_details'|'shared_folder_unmount_details'|'shared_link_add_expiry_details'|'shared_link_change_expiry_details'|'shared_link_change_visibility_details'|'shared_link_copy_details'|'shared_link_create_details'|'shared_link_disable_details'|'shared_link_download_details'|'shared_link_remove_expiry_details'|'shared_link_share_details'|'shared_link_view_details'|'shared_note_opened_details'|'shmodel_group_share_details'|'showcase_access_granted_details'|'showcase_add_member_details'|'showcase_archived_details'|'showcase_created_details'|'showcase_delete_comment_details'|'showcase_edited_details'|'showcase_edit_comment_details'|'showcase_file_added_details'|'showcase_file_download_details'|'showcase_file_removed_details'|'showcase_file_view_details'|'showcase_permanently_deleted_details'|'showcase_post_comment_details'|'showcase_remove_member_details'|'showcase_renamed_details'|'showcase_request_access_details'|'showcase_resolve_comment_details'|'showcase_restored_details'|'showcase_trashed_details'|'showcase_trashed_deprecated_details'|'showcase_unresolve_comment_details'|'showcase_untrashed_details'|'showcase_untrashed_deprecated_details'|'showcase_view_details'|'sso_add_cert_details'|'sso_add_login_url_details'|'sso_add_logout_url_details'|'sso_change_cert_details'|'sso_change_login_url_details'|'sso_change_logout_url_details'|'sso_change_saml_identity_mode_details'|'sso_remove_cert_details'|'sso_remove_login_url_details'|'sso_remove_logout_url_details'|'team_folder_change_status_details'|'team_folder_create_details'|'team_folder_downgrade_details'|'team_folder_permanently_delete_details'|'team_folder_rename_details'|'team_selective_sync_settings_changed_details'|'account_capture_change_policy_details'|'allow_download_disabled_details'|'allow_download_enabled_details'|'camera_uploads_policy_changed_details'|'data_placement_restriction_change_policy_details'|'data_placement_restriction_satisfy_policy_details'|'device_approvals_change_desktop_policy_details'|'device_approvals_change_mobile_policy_details'|'device_approvals_change_overage_action_details'|'device_approvals_change_unlink_action_details'|'directory_restrictions_add_members_details'|'directory_restrictions_remove_members_details'|'emm_add_exception_details'|'emm_change_policy_details'|'emm_remove_exception_details'|'extended_version_history_change_policy_details'|'file_comments_change_policy_details'|'file_requests_change_policy_details'|'file_requests_emails_enabled_details'|'file_requests_emails_restricted_to_team_only_details'|'google_sso_change_policy_details'|'group_user_management_change_policy_details'|'integration_policy_changed_details'|'member_requests_change_policy_details'|'member_space_limits_add_exception_details'|'member_space_limits_change_caps_type_policy_details'|'member_space_limits_change_policy_details'|'member_space_limits_remove_exception_details'|'member_suggestions_change_policy_details'|'microsoft_office_addin_change_policy_details'|'network_control_change_policy_details'|'paper_change_deployment_policy_details'|'paper_change_member_link_policy_details'|'paper_change_member_policy_details'|'paper_change_policy_details'|'paper_default_folder_policy_changed_details'|'paper_desktop_policy_changed_details'|'paper_enabled_users_group_addition_details'|'paper_enabled_users_group_removal_details'|'permanent_delete_change_policy_details'|'reseller_support_change_policy_details'|'sharing_change_folder_join_policy_details'|'sharing_change_link_policy_details'|'sharing_change_member_policy_details'|'showcase_change_download_policy_details'|'showcase_change_enabled_policy_details'|'showcase_change_external_sharing_policy_details'|'smart_sync_change_policy_details'|'smart_sync_not_opt_out_details'|'smart_sync_opt_out_details'|'sso_change_policy_details'|'team_extensions_policy_changed_details'|'team_selective_sync_policy_changed_details'|'tfa_change_policy_details'|'two_account_change_policy_details'|'viewer_info_policy_changed_details'|'web_sessions_change_fixed_length_policy_details'|'web_sessions_change_idle_length_policy_details'|'team_merge_from_details'|'team_merge_to_details'|'team_profile_add_logo_details'|'team_profile_change_default_language_details'|'team_profile_change_logo_details'|'team_profile_change_name_details'|'team_profile_remove_logo_details'|'tfa_add_backup_phone_details'|'tfa_add_security_key_details'|'tfa_change_backup_phone_details'|'tfa_change_status_details'|'tfa_remove_backup_phone_details'|'tfa_remove_security_key_details'|'tfa_reset_details'|'guest_admin_change_status_details'|'team_merge_request_accepted_details'|'team_merge_request_accepted_shown_to_primary_team_details'|'team_merge_request_accepted_shown_to_secondary_team_details'|'team_merge_request_auto_canceled_details'|'team_merge_request_canceled_details'|'team_merge_request_canceled_shown_to_primary_team_details'|'team_merge_request_canceled_shown_to_secondary_team_details'|'team_merge_request_expired_details'|'team_merge_request_expired_shown_to_primary_team_details'|'team_merge_request_expired_shown_to_secondary_team_details'|'team_merge_request_rejected_shown_to_primary_team_details'|'team_merge_request_rejected_shown_to_secondary_team_details'|'team_merge_request_reminder_details'|'team_merge_request_reminder_shown_to_primary_team_details'|'team_merge_request_reminder_shown_to_secondary_team_details'|'team_merge_request_revoked_details'|'team_merge_request_sent_shown_to_primary_team_details'|'team_merge_request_sent_shown_to_secondary_team_details'|'missing_details'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The type of the event.
 * @typedef {Object} TeamLogEventType
 * @property {TeamLogAppLinkTeamType} [app_link_team] - Available if .tag is
 * app_link_team. (apps) Linked app for team
 * @property {TeamLogAppLinkUserType} [app_link_user] - Available if .tag is
 * app_link_user. (apps) Linked app for member
 * @property {TeamLogAppUnlinkTeamType} [app_unlink_team] - Available if .tag is
 * app_unlink_team. (apps) Unlinked app for team
 * @property {TeamLogAppUnlinkUserType} [app_unlink_user] - Available if .tag is
 * app_unlink_user. (apps) Unlinked app for member
 * @property {TeamLogIntegrationConnectedType} [integration_connected] -
 * Available if .tag is integration_connected. (apps) Connected integration for
 * member
 * @property {TeamLogIntegrationDisconnectedType} [integration_disconnected] -
 * Available if .tag is integration_disconnected. (apps) Disconnected
 * integration for member
 * @property {TeamLogFileAddCommentType} [file_add_comment] - Available if .tag
 * is file_add_comment. (comments) Added file comment
 * @property {TeamLogFileChangeCommentSubscriptionType}
 * [file_change_comment_subscription] - Available if .tag is
 * file_change_comment_subscription. (comments) Subscribed to or unsubscribed
 * from comment notifications for file
 * @property {TeamLogFileDeleteCommentType} [file_delete_comment] - Available if
 * .tag is file_delete_comment. (comments) Deleted file comment
 * @property {TeamLogFileEditCommentType} [file_edit_comment] - Available if
 * .tag is file_edit_comment. (comments) Edited file comment
 * @property {TeamLogFileLikeCommentType} [file_like_comment] - Available if
 * .tag is file_like_comment. (comments) Liked file comment (deprecated, no
 * longer logged)
 * @property {TeamLogFileResolveCommentType} [file_resolve_comment] - Available
 * if .tag is file_resolve_comment. (comments) Resolved file comment
 * @property {TeamLogFileUnlikeCommentType} [file_unlike_comment] - Available if
 * .tag is file_unlike_comment. (comments) Unliked file comment (deprecated, no
 * longer logged)
 * @property {TeamLogFileUnresolveCommentType} [file_unresolve_comment] -
 * Available if .tag is file_unresolve_comment. (comments) Unresolved file
 * comment
 * @property {TeamLogDeviceChangeIpDesktopType} [device_change_ip_desktop] -
 * Available if .tag is device_change_ip_desktop. (devices) Changed IP address
 * associated with active desktop session
 * @property {TeamLogDeviceChangeIpMobileType} [device_change_ip_mobile] -
 * Available if .tag is device_change_ip_mobile. (devices) Changed IP address
 * associated with active mobile session
 * @property {TeamLogDeviceChangeIpWebType} [device_change_ip_web] - Available
 * if .tag is device_change_ip_web. (devices) Changed IP address associated with
 * active web session
 * @property {TeamLogDeviceDeleteOnUnlinkFailType}
 * [device_delete_on_unlink_fail] - Available if .tag is
 * device_delete_on_unlink_fail. (devices) Failed to delete all files from
 * unlinked device
 * @property {TeamLogDeviceDeleteOnUnlinkSuccessType}
 * [device_delete_on_unlink_success] - Available if .tag is
 * device_delete_on_unlink_success. (devices) Deleted all files from unlinked
 * device
 * @property {TeamLogDeviceLinkFailType} [device_link_fail] - Available if .tag
 * is device_link_fail. (devices) Failed to link device
 * @property {TeamLogDeviceLinkSuccessType} [device_link_success] - Available if
 * .tag is device_link_success. (devices) Linked device
 * @property {TeamLogDeviceManagementDisabledType} [device_management_disabled]
 * - Available if .tag is device_management_disabled. (devices) Disabled device
 * management (deprecated, no longer logged)
 * @property {TeamLogDeviceManagementEnabledType} [device_management_enabled] -
 * Available if .tag is device_management_enabled. (devices) Enabled device
 * management (deprecated, no longer logged)
 * @property {TeamLogDeviceUnlinkType} [device_unlink] - Available if .tag is
 * device_unlink. (devices) Disconnected device
 * @property {TeamLogEmmRefreshAuthTokenType} [emm_refresh_auth_token] -
 * Available if .tag is emm_refresh_auth_token. (devices) Refreshed auth token
 * used for setting up EMM
 * @property {TeamLogAccountCaptureChangeAvailabilityType}
 * [account_capture_change_availability] - Available if .tag is
 * account_capture_change_availability. (domains) Granted/revoked option to
 * enable account capture on team domains
 * @property {TeamLogAccountCaptureMigrateAccountType}
 * [account_capture_migrate_account] - Available if .tag is
 * account_capture_migrate_account. (domains) Account-captured user migrated
 * account to team
 * @property {TeamLogAccountCaptureNotificationEmailsSentType}
 * [account_capture_notification_emails_sent] - Available if .tag is
 * account_capture_notification_emails_sent. (domains) Sent proactive account
 * capture email to all unmanaged members
 * @property {TeamLogAccountCaptureRelinquishAccountType}
 * [account_capture_relinquish_account] - Available if .tag is
 * account_capture_relinquish_account. (domains) Account-captured user changed
 * account email to personal email
 * @property {TeamLogDisabledDomainInvitesType} [disabled_domain_invites] -
 * Available if .tag is disabled_domain_invites. (domains) Disabled domain
 * invites (deprecated, no longer logged)
 * @property {TeamLogDomainInvitesApproveRequestToJoinTeamType}
 * [domain_invites_approve_request_to_join_team] - Available if .tag is
 * domain_invites_approve_request_to_join_team. (domains) Approved user's
 * request to join team
 * @property {TeamLogDomainInvitesDeclineRequestToJoinTeamType}
 * [domain_invites_decline_request_to_join_team] - Available if .tag is
 * domain_invites_decline_request_to_join_team. (domains) Declined user's
 * request to join team
 * @property {TeamLogDomainInvitesEmailExistingUsersType}
 * [domain_invites_email_existing_users] - Available if .tag is
 * domain_invites_email_existing_users. (domains) Sent domain invites to
 * existing domain accounts (deprecated, no longer logged)
 * @property {TeamLogDomainInvitesRequestToJoinTeamType}
 * [domain_invites_request_to_join_team] - Available if .tag is
 * domain_invites_request_to_join_team. (domains) Requested to join team
 * @property {TeamLogDomainInvitesSetInviteNewUserPrefToNoType}
 * [domain_invites_set_invite_new_user_pref_to_no] - Available if .tag is
 * domain_invites_set_invite_new_user_pref_to_no. (domains) Disabled
 * "Automatically invite new users" (deprecated, no longer logged)
 * @property {TeamLogDomainInvitesSetInviteNewUserPrefToYesType}
 * [domain_invites_set_invite_new_user_pref_to_yes] - Available if .tag is
 * domain_invites_set_invite_new_user_pref_to_yes. (domains) Enabled
 * "Automatically invite new users" (deprecated, no longer logged)
 * @property {TeamLogDomainVerificationAddDomainFailType}
 * [domain_verification_add_domain_fail] - Available if .tag is
 * domain_verification_add_domain_fail. (domains) Failed to verify team domain
 * @property {TeamLogDomainVerificationAddDomainSuccessType}
 * [domain_verification_add_domain_success] - Available if .tag is
 * domain_verification_add_domain_success. (domains) Verified team domain
 * @property {TeamLogDomainVerificationRemoveDomainType}
 * [domain_verification_remove_domain] - Available if .tag is
 * domain_verification_remove_domain. (domains) Removed domain from list of
 * verified team domains
 * @property {TeamLogEnabledDomainInvitesType} [enabled_domain_invites] -
 * Available if .tag is enabled_domain_invites. (domains) Enabled domain invites
 * (deprecated, no longer logged)
 * @property {TeamLogCreateFolderType} [create_folder] - Available if .tag is
 * create_folder. (file_operations) Created folders (deprecated, no longer
 * logged)
 * @property {TeamLogFileAddType} [file_add] - Available if .tag is file_add.
 * (file_operations) Added files and/or folders
 * @property {TeamLogFileCopyType} [file_copy] - Available if .tag is file_copy.
 * (file_operations) Copied files and/or folders
 * @property {TeamLogFileDeleteType} [file_delete] - Available if .tag is
 * file_delete. (file_operations) Deleted files and/or folders
 * @property {TeamLogFileDownloadType} [file_download] - Available if .tag is
 * file_download. (file_operations) Downloaded files and/or folders
 * @property {TeamLogFileEditType} [file_edit] - Available if .tag is file_edit.
 * (file_operations) Edited files
 * @property {TeamLogFileGetCopyReferenceType} [file_get_copy_reference] -
 * Available if .tag is file_get_copy_reference. (file_operations) Created copy
 * reference to file/folder
 * @property {TeamLogFileMoveType} [file_move] - Available if .tag is file_move.
 * (file_operations) Moved files and/or folders
 * @property {TeamLogFilePermanentlyDeleteType} [file_permanently_delete] -
 * Available if .tag is file_permanently_delete. (file_operations) Permanently
 * deleted files and/or folders
 * @property {TeamLogFilePreviewType} [file_preview] - Available if .tag is
 * file_preview. (file_operations) Previewed files and/or folders
 * @property {TeamLogFileRenameType} [file_rename] - Available if .tag is
 * file_rename. (file_operations) Renamed files and/or folders
 * @property {TeamLogFileRestoreType} [file_restore] - Available if .tag is
 * file_restore. (file_operations) Restored deleted files and/or folders
 * @property {TeamLogFileRevertType} [file_revert] - Available if .tag is
 * file_revert. (file_operations) Reverted files to previous version
 * @property {TeamLogFileRollbackChangesType} [file_rollback_changes] -
 * Available if .tag is file_rollback_changes. (file_operations) Rolled back
 * file actions
 * @property {TeamLogFileSaveCopyReferenceType} [file_save_copy_reference] -
 * Available if .tag is file_save_copy_reference. (file_operations) Saved
 * file/folder using copy reference
 * @property {TeamLogFileRequestChangeType} [file_request_change] - Available if
 * .tag is file_request_change. (file_requests) Changed file request
 * @property {TeamLogFileRequestCloseType} [file_request_close] - Available if
 * .tag is file_request_close. (file_requests) Closed file request
 * @property {TeamLogFileRequestCreateType} [file_request_create] - Available if
 * .tag is file_request_create. (file_requests) Created file request
 * @property {TeamLogFileRequestDeleteType} [file_request_delete] - Available if
 * .tag is file_request_delete. (file_requests) Delete file request
 * @property {TeamLogFileRequestReceiveFileType} [file_request_receive_file] -
 * Available if .tag is file_request_receive_file. (file_requests) Received
 * files for file request
 * @property {TeamLogGroupAddExternalIdType} [group_add_external_id] - Available
 * if .tag is group_add_external_id. (groups) Added external ID for group
 * @property {TeamLogGroupAddMemberType} [group_add_member] - Available if .tag
 * is group_add_member. (groups) Added team members to group
 * @property {TeamLogGroupChangeExternalIdType} [group_change_external_id] -
 * Available if .tag is group_change_external_id. (groups) Changed external ID
 * for group
 * @property {TeamLogGroupChangeManagementTypeType}
 * [group_change_management_type] - Available if .tag is
 * group_change_management_type. (groups) Changed group management type
 * @property {TeamLogGroupChangeMemberRoleType} [group_change_member_role] -
 * Available if .tag is group_change_member_role. (groups) Changed manager
 * permissions of group member
 * @property {TeamLogGroupCreateType} [group_create] - Available if .tag is
 * group_create. (groups) Created group
 * @property {TeamLogGroupDeleteType} [group_delete] - Available if .tag is
 * group_delete. (groups) Deleted group
 * @property {TeamLogGroupDescriptionUpdatedType} [group_description_updated] -
 * Available if .tag is group_description_updated. (groups) Updated group
 * (deprecated, no longer logged)
 * @property {TeamLogGroupJoinPolicyUpdatedType} [group_join_policy_updated] -
 * Available if .tag is group_join_policy_updated. (groups) Updated group join
 * policy (deprecated, no longer logged)
 * @property {TeamLogGroupMovedType} [group_moved] - Available if .tag is
 * group_moved. (groups) Moved group (deprecated, no longer logged)
 * @property {TeamLogGroupRemoveExternalIdType} [group_remove_external_id] -
 * Available if .tag is group_remove_external_id. (groups) Removed external ID
 * for group
 * @property {TeamLogGroupRemoveMemberType} [group_remove_member] - Available if
 * .tag is group_remove_member. (groups) Removed team members from group
 * @property {TeamLogGroupRenameType} [group_rename] - Available if .tag is
 * group_rename. (groups) Renamed group
 * @property {TeamLogEmmErrorType} [emm_error] - Available if .tag is emm_error.
 * (logins) Failed to sign in via EMM (deprecated, replaced by 'Failed to sign
 * in')
 * @property {TeamLogGuestAdminSignedInViaTrustedTeamsType}
 * [guest_admin_signed_in_via_trusted_teams] - Available if .tag is
 * guest_admin_signed_in_via_trusted_teams. (logins) Started trusted team admin
 * session
 * @property {TeamLogGuestAdminSignedOutViaTrustedTeamsType}
 * [guest_admin_signed_out_via_trusted_teams] - Available if .tag is
 * guest_admin_signed_out_via_trusted_teams. (logins) Ended trusted team admin
 * session
 * @property {TeamLogLoginFailType} [login_fail] - Available if .tag is
 * login_fail. (logins) Failed to sign in
 * @property {TeamLogLoginSuccessType} [login_success] - Available if .tag is
 * login_success. (logins) Signed in
 * @property {TeamLogLogoutType} [logout] - Available if .tag is logout.
 * (logins) Signed out
 * @property {TeamLogResellerSupportSessionEndType}
 * [reseller_support_session_end] - Available if .tag is
 * reseller_support_session_end. (logins) Ended reseller support session
 * @property {TeamLogResellerSupportSessionStartType}
 * [reseller_support_session_start] - Available if .tag is
 * reseller_support_session_start. (logins) Started reseller support session
 * @property {TeamLogSignInAsSessionEndType} [sign_in_as_session_end] -
 * Available if .tag is sign_in_as_session_end. (logins) Ended admin sign-in-as
 * session
 * @property {TeamLogSignInAsSessionStartType} [sign_in_as_session_start] -
 * Available if .tag is sign_in_as_session_start. (logins) Started admin
 * sign-in-as session
 * @property {TeamLogSsoErrorType} [sso_error] - Available if .tag is sso_error.
 * (logins) Failed to sign in via SSO (deprecated, replaced by 'Failed to sign
 * in')
 * @property {TeamLogMemberAddExternalIdType} [member_add_external_id] -
 * Available if .tag is member_add_external_id. (members) Added an external ID
 * for team member
 * @property {TeamLogMemberAddNameType} [member_add_name] - Available if .tag is
 * member_add_name. (members) Added team member name
 * @property {TeamLogMemberChangeAdminRoleType} [member_change_admin_role] -
 * Available if .tag is member_change_admin_role. (members) Changed team member
 * admin role
 * @property {TeamLogMemberChangeEmailType} [member_change_email] - Available if
 * .tag is member_change_email. (members) Changed team member email
 * @property {TeamLogMemberChangeExternalIdType} [member_change_external_id] -
 * Available if .tag is member_change_external_id. (members) Changed the
 * external ID for team member
 * @property {TeamLogMemberChangeMembershipTypeType}
 * [member_change_membership_type] - Available if .tag is
 * member_change_membership_type. (members) Changed membership type
 * (limited/full) of member (deprecated, no longer logged)
 * @property {TeamLogMemberChangeNameType} [member_change_name] - Available if
 * .tag is member_change_name. (members) Changed team member name
 * @property {TeamLogMemberChangeStatusType} [member_change_status] - Available
 * if .tag is member_change_status. (members) Changed member status (invited,
 * joined, suspended, etc.)
 * @property {TeamLogMemberDeleteManualContactsType}
 * [member_delete_manual_contacts] - Available if .tag is
 * member_delete_manual_contacts. (members) Cleared manually added contacts
 * @property {TeamLogMemberPermanentlyDeleteAccountContentsType}
 * [member_permanently_delete_account_contents] - Available if .tag is
 * member_permanently_delete_account_contents. (members) Permanently deleted
 * contents of deleted team member account
 * @property {TeamLogMemberRemoveExternalIdType} [member_remove_external_id] -
 * Available if .tag is member_remove_external_id. (members) Removed the
 * external ID for team member
 * @property {TeamLogMemberSpaceLimitsAddCustomQuotaType}
 * [member_space_limits_add_custom_quota] - Available if .tag is
 * member_space_limits_add_custom_quota. (members) Set custom member space limit
 * @property {TeamLogMemberSpaceLimitsChangeCustomQuotaType}
 * [member_space_limits_change_custom_quota] - Available if .tag is
 * member_space_limits_change_custom_quota. (members) Changed custom member
 * space limit
 * @property {TeamLogMemberSpaceLimitsChangeStatusType}
 * [member_space_limits_change_status] - Available if .tag is
 * member_space_limits_change_status. (members) Changed space limit status
 * @property {TeamLogMemberSpaceLimitsRemoveCustomQuotaType}
 * [member_space_limits_remove_custom_quota] - Available if .tag is
 * member_space_limits_remove_custom_quota. (members) Removed custom member
 * space limit
 * @property {TeamLogMemberSuggestType} [member_suggest] - Available if .tag is
 * member_suggest. (members) Suggested person to add to team
 * @property {TeamLogMemberTransferAccountContentsType}
 * [member_transfer_account_contents] - Available if .tag is
 * member_transfer_account_contents. (members) Transferred contents of deleted
 * member account to another member
 * @property {TeamLogSecondaryMailsPolicyChangedType}
 * [secondary_mails_policy_changed] - Available if .tag is
 * secondary_mails_policy_changed. (members) Secondary mails policy changed
 * @property {TeamLogPaperContentAddMemberType} [paper_content_add_member] -
 * Available if .tag is paper_content_add_member. (paper) Added team member to
 * Paper doc/folder
 * @property {TeamLogPaperContentAddToFolderType} [paper_content_add_to_folder]
 * - Available if .tag is paper_content_add_to_folder. (paper) Added Paper
 * doc/folder to folder
 * @property {TeamLogPaperContentArchiveType} [paper_content_archive] -
 * Available if .tag is paper_content_archive. (paper) Archived Paper doc/folder
 * @property {TeamLogPaperContentCreateType} [paper_content_create] - Available
 * if .tag is paper_content_create. (paper) Created Paper doc/folder
 * @property {TeamLogPaperContentPermanentlyDeleteType}
 * [paper_content_permanently_delete] - Available if .tag is
 * paper_content_permanently_delete. (paper) Permanently deleted Paper
 * doc/folder
 * @property {TeamLogPaperContentRemoveFromFolderType}
 * [paper_content_remove_from_folder] - Available if .tag is
 * paper_content_remove_from_folder. (paper) Removed Paper doc/folder from
 * folder
 * @property {TeamLogPaperContentRemoveMemberType} [paper_content_remove_member]
 * - Available if .tag is paper_content_remove_member. (paper) Removed team
 * member from Paper doc/folder
 * @property {TeamLogPaperContentRenameType} [paper_content_rename] - Available
 * if .tag is paper_content_rename. (paper) Renamed Paper doc/folder
 * @property {TeamLogPaperContentRestoreType} [paper_content_restore] -
 * Available if .tag is paper_content_restore. (paper) Restored archived Paper
 * doc/folder
 * @property {TeamLogPaperDocAddCommentType} [paper_doc_add_comment] - Available
 * if .tag is paper_doc_add_comment. (paper) Added Paper doc comment
 * @property {TeamLogPaperDocChangeMemberRoleType}
 * [paper_doc_change_member_role] - Available if .tag is
 * paper_doc_change_member_role. (paper) Changed team member permissions for
 * Paper doc
 * @property {TeamLogPaperDocChangeSharingPolicyType}
 * [paper_doc_change_sharing_policy] - Available if .tag is
 * paper_doc_change_sharing_policy. (paper) Changed sharing setting for Paper
 * doc
 * @property {TeamLogPaperDocChangeSubscriptionType}
 * [paper_doc_change_subscription] - Available if .tag is
 * paper_doc_change_subscription. (paper) Followed/unfollowed Paper doc
 * @property {TeamLogPaperDocDeletedType} [paper_doc_deleted] - Available if
 * .tag is paper_doc_deleted. (paper) Archived Paper doc (deprecated, no longer
 * logged)
 * @property {TeamLogPaperDocDeleteCommentType} [paper_doc_delete_comment] -
 * Available if .tag is paper_doc_delete_comment. (paper) Deleted Paper doc
 * comment
 * @property {TeamLogPaperDocDownloadType} [paper_doc_download] - Available if
 * .tag is paper_doc_download. (paper) Downloaded Paper doc in specific format
 * @property {TeamLogPaperDocEditType} [paper_doc_edit] - Available if .tag is
 * paper_doc_edit. (paper) Edited Paper doc
 * @property {TeamLogPaperDocEditCommentType} [paper_doc_edit_comment] -
 * Available if .tag is paper_doc_edit_comment. (paper) Edited Paper doc comment
 * @property {TeamLogPaperDocFollowedType} [paper_doc_followed] - Available if
 * .tag is paper_doc_followed. (paper) Followed Paper doc (deprecated, replaced
 * by 'Followed/unfollowed Paper doc')
 * @property {TeamLogPaperDocMentionType} [paper_doc_mention] - Available if
 * .tag is paper_doc_mention. (paper) Mentioned team member in Paper doc
 * @property {TeamLogPaperDocOwnershipChangedType} [paper_doc_ownership_changed]
 * - Available if .tag is paper_doc_ownership_changed. (paper) Transferred
 * ownership of Paper doc
 * @property {TeamLogPaperDocRequestAccessType} [paper_doc_request_access] -
 * Available if .tag is paper_doc_request_access. (paper) Requested access to
 * Paper doc
 * @property {TeamLogPaperDocResolveCommentType} [paper_doc_resolve_comment] -
 * Available if .tag is paper_doc_resolve_comment. (paper) Resolved Paper doc
 * comment
 * @property {TeamLogPaperDocRevertType} [paper_doc_revert] - Available if .tag
 * is paper_doc_revert. (paper) Restored Paper doc to previous version
 * @property {TeamLogPaperDocSlackShareType} [paper_doc_slack_share] - Available
 * if .tag is paper_doc_slack_share. (paper) Shared Paper doc via Slack
 * @property {TeamLogPaperDocTeamInviteType} [paper_doc_team_invite] - Available
 * if .tag is paper_doc_team_invite. (paper) Shared Paper doc with team member
 * (deprecated, no longer logged)
 * @property {TeamLogPaperDocTrashedType} [paper_doc_trashed] - Available if
 * .tag is paper_doc_trashed. (paper) Deleted Paper doc
 * @property {TeamLogPaperDocUnresolveCommentType} [paper_doc_unresolve_comment]
 * - Available if .tag is paper_doc_unresolve_comment. (paper) Unresolved Paper
 * doc comment
 * @property {TeamLogPaperDocUntrashedType} [paper_doc_untrashed] - Available if
 * .tag is paper_doc_untrashed. (paper) Restored Paper doc
 * @property {TeamLogPaperDocViewType} [paper_doc_view] - Available if .tag is
 * paper_doc_view. (paper) Viewed Paper doc
 * @property {TeamLogPaperExternalViewAllowType} [paper_external_view_allow] -
 * Available if .tag is paper_external_view_allow. (paper) Changed Paper
 * external sharing setting to anyone (deprecated, no longer logged)
 * @property {TeamLogPaperExternalViewDefaultTeamType}
 * [paper_external_view_default_team] - Available if .tag is
 * paper_external_view_default_team. (paper) Changed Paper external sharing
 * setting to default team (deprecated, no longer logged)
 * @property {TeamLogPaperExternalViewForbidType} [paper_external_view_forbid] -
 * Available if .tag is paper_external_view_forbid. (paper) Changed Paper
 * external sharing setting to team-only (deprecated, no longer logged)
 * @property {TeamLogPaperFolderChangeSubscriptionType}
 * [paper_folder_change_subscription] - Available if .tag is
 * paper_folder_change_subscription. (paper) Followed/unfollowed Paper folder
 * @property {TeamLogPaperFolderDeletedType} [paper_folder_deleted] - Available
 * if .tag is paper_folder_deleted. (paper) Archived Paper folder (deprecated,
 * no longer logged)
 * @property {TeamLogPaperFolderFollowedType} [paper_folder_followed] -
 * Available if .tag is paper_folder_followed. (paper) Followed Paper folder
 * (deprecated, replaced by 'Followed/unfollowed Paper folder')
 * @property {TeamLogPaperFolderTeamInviteType} [paper_folder_team_invite] -
 * Available if .tag is paper_folder_team_invite. (paper) Shared Paper folder
 * with member (deprecated, no longer logged)
 * @property {TeamLogPaperPublishedLinkCreateType} [paper_published_link_create]
 * - Available if .tag is paper_published_link_create. (paper) Published doc
 * @property {TeamLogPaperPublishedLinkDisabledType}
 * [paper_published_link_disabled] - Available if .tag is
 * paper_published_link_disabled. (paper) Unpublished doc
 * @property {TeamLogPaperPublishedLinkViewType} [paper_published_link_view] -
 * Available if .tag is paper_published_link_view. (paper) Viewed published doc
 * @property {TeamLogPasswordChangeType} [password_change] - Available if .tag
 * is password_change. (passwords) Changed password
 * @property {TeamLogPasswordResetType} [password_reset] - Available if .tag is
 * password_reset. (passwords) Reset password
 * @property {TeamLogPasswordResetAllType} [password_reset_all] - Available if
 * .tag is password_reset_all. (passwords) Reset all team member passwords
 * @property {TeamLogEmmCreateExceptionsReportType}
 * [emm_create_exceptions_report] - Available if .tag is
 * emm_create_exceptions_report. (reports) Created EMM-excluded users report
 * @property {TeamLogEmmCreateUsageReportType} [emm_create_usage_report] -
 * Available if .tag is emm_create_usage_report. (reports) Created EMM mobile
 * app usage report
 * @property {TeamLogExportMembersReportType} [export_members_report] -
 * Available if .tag is export_members_report. (reports) Created member data
 * report
 * @property {TeamLogPaperAdminExportStartType} [paper_admin_export_start] -
 * Available if .tag is paper_admin_export_start. (reports) Exported all team
 * Paper docs
 * @property {TeamLogSmartSyncCreateAdminPrivilegeReportType}
 * [smart_sync_create_admin_privilege_report] - Available if .tag is
 * smart_sync_create_admin_privilege_report. (reports) Created Smart Sync
 * non-admin devices report
 * @property {TeamLogTeamActivityCreateReportType} [team_activity_create_report]
 * - Available if .tag is team_activity_create_report. (reports) Created team
 * activity report
 * @property {TeamLogTeamActivityCreateReportFailType}
 * [team_activity_create_report_fail] - Available if .tag is
 * team_activity_create_report_fail. (reports) Couldn't generate team activity
 * report
 * @property {TeamLogCollectionShareType} [collection_share] - Available if .tag
 * is collection_share. (sharing) Shared album
 * @property {TeamLogNoteAclInviteOnlyType} [note_acl_invite_only] - Available
 * if .tag is note_acl_invite_only. (sharing) Changed Paper doc to invite-only
 * (deprecated, no longer logged)
 * @property {TeamLogNoteAclLinkType} [note_acl_link] - Available if .tag is
 * note_acl_link. (sharing) Changed Paper doc to link-accessible (deprecated, no
 * longer logged)
 * @property {TeamLogNoteAclTeamLinkType} [note_acl_team_link] - Available if
 * .tag is note_acl_team_link. (sharing) Changed Paper doc to link-accessible
 * for team (deprecated, no longer logged)
 * @property {TeamLogNoteSharedType} [note_shared] - Available if .tag is
 * note_shared. (sharing) Shared Paper doc (deprecated, no longer logged)
 * @property {TeamLogNoteShareReceiveType} [note_share_receive] - Available if
 * .tag is note_share_receive. (sharing) Shared received Paper doc (deprecated,
 * no longer logged)
 * @property {TeamLogOpenNoteSharedType} [open_note_shared] - Available if .tag
 * is open_note_shared. (sharing) Opened shared Paper doc (deprecated, no longer
 * logged)
 * @property {TeamLogSfAddGroupType} [sf_add_group] - Available if .tag is
 * sf_add_group. (sharing) Added team to shared folder (deprecated, no longer
 * logged)
 * @property {TeamLogSfAllowNonMembersToViewSharedLinksType}
 * [sf_allow_non_members_to_view_shared_links] - Available if .tag is
 * sf_allow_non_members_to_view_shared_links. (sharing) Allowed
 * non-collaborators to view links to files in shared folder (deprecated, no
 * longer logged)
 * @property {TeamLogSfExternalInviteWarnType} [sf_external_invite_warn] -
 * Available if .tag is sf_external_invite_warn. (sharing) Set team members to
 * see warning before sharing folders outside team (deprecated, no longer
 * logged)
 * @property {TeamLogSfFbInviteType} [sf_fb_invite] - Available if .tag is
 * sf_fb_invite. (sharing) Invited Facebook users to shared folder (deprecated,
 * no longer logged)
 * @property {TeamLogSfFbInviteChangeRoleType} [sf_fb_invite_change_role] -
 * Available if .tag is sf_fb_invite_change_role. (sharing) Changed Facebook
 * user's role in shared folder (deprecated, no longer logged)
 * @property {TeamLogSfFbUninviteType} [sf_fb_uninvite] - Available if .tag is
 * sf_fb_uninvite. (sharing) Uninvited Facebook user from shared folder
 * (deprecated, no longer logged)
 * @property {TeamLogSfInviteGroupType} [sf_invite_group] - Available if .tag is
 * sf_invite_group. (sharing) Invited group to shared folder (deprecated, no
 * longer logged)
 * @property {TeamLogSfTeamGrantAccessType} [sf_team_grant_access] - Available
 * if .tag is sf_team_grant_access. (sharing) Granted access to shared folder
 * (deprecated, no longer logged)
 * @property {TeamLogSfTeamInviteType} [sf_team_invite] - Available if .tag is
 * sf_team_invite. (sharing) Invited team members to shared folder (deprecated,
 * replaced by 'Invited user to Dropbox and added them to shared file/folder')
 * @property {TeamLogSfTeamInviteChangeRoleType} [sf_team_invite_change_role] -
 * Available if .tag is sf_team_invite_change_role. (sharing) Changed team
 * member's role in shared folder (deprecated, no longer logged)
 * @property {TeamLogSfTeamJoinType} [sf_team_join] - Available if .tag is
 * sf_team_join. (sharing) Joined team member's shared folder (deprecated, no
 * longer logged)
 * @property {TeamLogSfTeamJoinFromOobLinkType} [sf_team_join_from_oob_link] -
 * Available if .tag is sf_team_join_from_oob_link. (sharing) Joined team
 * member's shared folder from link (deprecated, no longer logged)
 * @property {TeamLogSfTeamUninviteType} [sf_team_uninvite] - Available if .tag
 * is sf_team_uninvite. (sharing) Unshared folder with team member (deprecated,
 * replaced by 'Removed invitee from shared file/folder before invite was
 * accepted')
 * @property {TeamLogSharedContentAddInviteesType} [shared_content_add_invitees]
 * - Available if .tag is shared_content_add_invitees. (sharing) Invited user to
 * Dropbox and added them to shared file/folder
 * @property {TeamLogSharedContentAddLinkExpiryType}
 * [shared_content_add_link_expiry] - Available if .tag is
 * shared_content_add_link_expiry. (sharing) Added expiration date to link for
 * shared file/folder
 * @property {TeamLogSharedContentAddLinkPasswordType}
 * [shared_content_add_link_password] - Available if .tag is
 * shared_content_add_link_password. (sharing) Added password to link for shared
 * file/folder
 * @property {TeamLogSharedContentAddMemberType} [shared_content_add_member] -
 * Available if .tag is shared_content_add_member. (sharing) Added users and/or
 * groups to shared file/folder
 * @property {TeamLogSharedContentChangeDownloadsPolicyType}
 * [shared_content_change_downloads_policy] - Available if .tag is
 * shared_content_change_downloads_policy. (sharing) Changed whether members can
 * download shared file/folder
 * @property {TeamLogSharedContentChangeInviteeRoleType}
 * [shared_content_change_invitee_role] - Available if .tag is
 * shared_content_change_invitee_role. (sharing) Changed access type of invitee
 * to shared file/folder before invite was accepted
 * @property {TeamLogSharedContentChangeLinkAudienceType}
 * [shared_content_change_link_audience] - Available if .tag is
 * shared_content_change_link_audience. (sharing) Changed link audience of
 * shared file/folder
 * @property {TeamLogSharedContentChangeLinkExpiryType}
 * [shared_content_change_link_expiry] - Available if .tag is
 * shared_content_change_link_expiry. (sharing) Changed link expiration of
 * shared file/folder
 * @property {TeamLogSharedContentChangeLinkPasswordType}
 * [shared_content_change_link_password] - Available if .tag is
 * shared_content_change_link_password. (sharing) Changed link password of
 * shared file/folder
 * @property {TeamLogSharedContentChangeMemberRoleType}
 * [shared_content_change_member_role] - Available if .tag is
 * shared_content_change_member_role. (sharing) Changed access type of shared
 * file/folder member
 * @property {TeamLogSharedContentChangeViewerInfoPolicyType}
 * [shared_content_change_viewer_info_policy] - Available if .tag is
 * shared_content_change_viewer_info_policy. (sharing) Changed whether members
 * can see who viewed shared file/folder
 * @property {TeamLogSharedContentClaimInvitationType}
 * [shared_content_claim_invitation] - Available if .tag is
 * shared_content_claim_invitation. (sharing) Acquired membership of shared
 * file/folder by accepting invite
 * @property {TeamLogSharedContentCopyType} [shared_content_copy] - Available if
 * .tag is shared_content_copy. (sharing) Copied shared file/folder to own
 * Dropbox
 * @property {TeamLogSharedContentDownloadType} [shared_content_download] -
 * Available if .tag is shared_content_download. (sharing) Downloaded shared
 * file/folder
 * @property {TeamLogSharedContentRelinquishMembershipType}
 * [shared_content_relinquish_membership] - Available if .tag is
 * shared_content_relinquish_membership. (sharing) Left shared file/folder
 * @property {TeamLogSharedContentRemoveInviteesType}
 * [shared_content_remove_invitees] - Available if .tag is
 * shared_content_remove_invitees. (sharing) Removed invitee from shared
 * file/folder before invite was accepted
 * @property {TeamLogSharedContentRemoveLinkExpiryType}
 * [shared_content_remove_link_expiry] - Available if .tag is
 * shared_content_remove_link_expiry. (sharing) Removed link expiration date of
 * shared file/folder
 * @property {TeamLogSharedContentRemoveLinkPasswordType}
 * [shared_content_remove_link_password] - Available if .tag is
 * shared_content_remove_link_password. (sharing) Removed link password of
 * shared file/folder
 * @property {TeamLogSharedContentRemoveMemberType}
 * [shared_content_remove_member] - Available if .tag is
 * shared_content_remove_member. (sharing) Removed user/group from shared
 * file/folder
 * @property {TeamLogSharedContentRequestAccessType}
 * [shared_content_request_access] - Available if .tag is
 * shared_content_request_access. (sharing) Requested access to shared
 * file/folder
 * @property {TeamLogSharedContentUnshareType} [shared_content_unshare] -
 * Available if .tag is shared_content_unshare. (sharing) Unshared file/folder
 * by clearing membership and turning off link
 * @property {TeamLogSharedContentViewType} [shared_content_view] - Available if
 * .tag is shared_content_view. (sharing) Previewed shared file/folder
 * @property {TeamLogSharedFolderChangeLinkPolicyType}
 * [shared_folder_change_link_policy] - Available if .tag is
 * shared_folder_change_link_policy. (sharing) Changed who can access shared
 * folder via link
 * @property {TeamLogSharedFolderChangeMembersInheritancePolicyType}
 * [shared_folder_change_members_inheritance_policy] - Available if .tag is
 * shared_folder_change_members_inheritance_policy. (sharing) Changed whether
 * shared folder inherits members from parent folder
 * @property {TeamLogSharedFolderChangeMembersManagementPolicyType}
 * [shared_folder_change_members_management_policy] - Available if .tag is
 * shared_folder_change_members_management_policy. (sharing) Changed who can
 * add/remove members of shared folder
 * @property {TeamLogSharedFolderChangeMembersPolicyType}
 * [shared_folder_change_members_policy] - Available if .tag is
 * shared_folder_change_members_policy. (sharing) Changed who can become member
 * of shared folder
 * @property {TeamLogSharedFolderCreateType} [shared_folder_create] - Available
 * if .tag is shared_folder_create. (sharing) Created shared folder
 * @property {TeamLogSharedFolderDeclineInvitationType}
 * [shared_folder_decline_invitation] - Available if .tag is
 * shared_folder_decline_invitation. (sharing) Declined team member's invite to
 * shared folder
 * @property {TeamLogSharedFolderMountType} [shared_folder_mount] - Available if
 * .tag is shared_folder_mount. (sharing) Added shared folder to own Dropbox
 * @property {TeamLogSharedFolderNestType} [shared_folder_nest] - Available if
 * .tag is shared_folder_nest. (sharing) Changed parent of shared folder
 * @property {TeamLogSharedFolderTransferOwnershipType}
 * [shared_folder_transfer_ownership] - Available if .tag is
 * shared_folder_transfer_ownership. (sharing) Transferred ownership of shared
 * folder to another member
 * @property {TeamLogSharedFolderUnmountType} [shared_folder_unmount] -
 * Available if .tag is shared_folder_unmount. (sharing) Deleted shared folder
 * from Dropbox
 * @property {TeamLogSharedLinkAddExpiryType} [shared_link_add_expiry] -
 * Available if .tag is shared_link_add_expiry. (sharing) Added shared link
 * expiration date
 * @property {TeamLogSharedLinkChangeExpiryType} [shared_link_change_expiry] -
 * Available if .tag is shared_link_change_expiry. (sharing) Changed shared link
 * expiration date
 * @property {TeamLogSharedLinkChangeVisibilityType}
 * [shared_link_change_visibility] - Available if .tag is
 * shared_link_change_visibility. (sharing) Changed visibility of shared link
 * @property {TeamLogSharedLinkCopyType} [shared_link_copy] - Available if .tag
 * is shared_link_copy. (sharing) Added file/folder to Dropbox from shared link
 * @property {TeamLogSharedLinkCreateType} [shared_link_create] - Available if
 * .tag is shared_link_create. (sharing) Created shared link
 * @property {TeamLogSharedLinkDisableType} [shared_link_disable] - Available if
 * .tag is shared_link_disable. (sharing) Removed shared link
 * @property {TeamLogSharedLinkDownloadType} [shared_link_download] - Available
 * if .tag is shared_link_download. (sharing) Downloaded file/folder from shared
 * link
 * @property {TeamLogSharedLinkRemoveExpiryType} [shared_link_remove_expiry] -
 * Available if .tag is shared_link_remove_expiry. (sharing) Removed shared link
 * expiration date
 * @property {TeamLogSharedLinkShareType} [shared_link_share] - Available if
 * .tag is shared_link_share. (sharing) Added members as audience of shared link
 * @property {TeamLogSharedLinkViewType} [shared_link_view] - Available if .tag
 * is shared_link_view. (sharing) Opened shared link
 * @property {TeamLogSharedNoteOpenedType} [shared_note_opened] - Available if
 * .tag is shared_note_opened. (sharing) Opened shared Paper doc (deprecated, no
 * longer logged)
 * @property {TeamLogShmodelGroupShareType} [shmodel_group_share] - Available if
 * .tag is shmodel_group_share. (sharing) Shared link with group (deprecated, no
 * longer logged)
 * @property {TeamLogShowcaseAccessGrantedType} [showcase_access_granted] -
 * Available if .tag is showcase_access_granted. (showcase) Granted access to
 * showcase
 * @property {TeamLogShowcaseAddMemberType} [showcase_add_member] - Available if
 * .tag is showcase_add_member. (showcase) Added member to showcase
 * @property {TeamLogShowcaseArchivedType} [showcase_archived] - Available if
 * .tag is showcase_archived. (showcase) Archived showcase
 * @property {TeamLogShowcaseCreatedType} [showcase_created] - Available if .tag
 * is showcase_created. (showcase) Created showcase
 * @property {TeamLogShowcaseDeleteCommentType} [showcase_delete_comment] -
 * Available if .tag is showcase_delete_comment. (showcase) Deleted showcase
 * comment
 * @property {TeamLogShowcaseEditedType} [showcase_edited] - Available if .tag
 * is showcase_edited. (showcase) Edited showcase
 * @property {TeamLogShowcaseEditCommentType} [showcase_edit_comment] -
 * Available if .tag is showcase_edit_comment. (showcase) Edited showcase
 * comment
 * @property {TeamLogShowcaseFileAddedType} [showcase_file_added] - Available if
 * .tag is showcase_file_added. (showcase) Added file to showcase
 * @property {TeamLogShowcaseFileDownloadType} [showcase_file_download] -
 * Available if .tag is showcase_file_download. (showcase) Downloaded file from
 * showcase
 * @property {TeamLogShowcaseFileRemovedType} [showcase_file_removed] -
 * Available if .tag is showcase_file_removed. (showcase) Removed file from
 * showcase
 * @property {TeamLogShowcaseFileViewType} [showcase_file_view] - Available if
 * .tag is showcase_file_view. (showcase) Viewed file in showcase
 * @property {TeamLogShowcasePermanentlyDeletedType}
 * [showcase_permanently_deleted] - Available if .tag is
 * showcase_permanently_deleted. (showcase) Permanently deleted showcase
 * @property {TeamLogShowcasePostCommentType} [showcase_post_comment] -
 * Available if .tag is showcase_post_comment. (showcase) Added showcase comment
 * @property {TeamLogShowcaseRemoveMemberType} [showcase_remove_member] -
 * Available if .tag is showcase_remove_member. (showcase) Removed member from
 * showcase
 * @property {TeamLogShowcaseRenamedType} [showcase_renamed] - Available if .tag
 * is showcase_renamed. (showcase) Renamed showcase
 * @property {TeamLogShowcaseRequestAccessType} [showcase_request_access] -
 * Available if .tag is showcase_request_access. (showcase) Requested access to
 * showcase
 * @property {TeamLogShowcaseResolveCommentType} [showcase_resolve_comment] -
 * Available if .tag is showcase_resolve_comment. (showcase) Resolved showcase
 * comment
 * @property {TeamLogShowcaseRestoredType} [showcase_restored] - Available if
 * .tag is showcase_restored. (showcase) Unarchived showcase
 * @property {TeamLogShowcaseTrashedType} [showcase_trashed] - Available if .tag
 * is showcase_trashed. (showcase) Deleted showcase
 * @property {TeamLogShowcaseTrashedDeprecatedType}
 * [showcase_trashed_deprecated] - Available if .tag is
 * showcase_trashed_deprecated. (showcase) Deleted showcase (old version)
 * (deprecated, replaced by 'Deleted showcase')
 * @property {TeamLogShowcaseUnresolveCommentType} [showcase_unresolve_comment]
 * - Available if .tag is showcase_unresolve_comment. (showcase) Unresolved
 * showcase comment
 * @property {TeamLogShowcaseUntrashedType} [showcase_untrashed] - Available if
 * .tag is showcase_untrashed. (showcase) Restored showcase
 * @property {TeamLogShowcaseUntrashedDeprecatedType}
 * [showcase_untrashed_deprecated] - Available if .tag is
 * showcase_untrashed_deprecated. (showcase) Restored showcase (old version)
 * (deprecated, replaced by 'Restored showcase')
 * @property {TeamLogShowcaseViewType} [showcase_view] - Available if .tag is
 * showcase_view. (showcase) Viewed showcase
 * @property {TeamLogSsoAddCertType} [sso_add_cert] - Available if .tag is
 * sso_add_cert. (sso) Added X.509 certificate for SSO
 * @property {TeamLogSsoAddLoginUrlType} [sso_add_login_url] - Available if .tag
 * is sso_add_login_url. (sso) Added sign-in URL for SSO
 * @property {TeamLogSsoAddLogoutUrlType} [sso_add_logout_url] - Available if
 * .tag is sso_add_logout_url. (sso) Added sign-out URL for SSO
 * @property {TeamLogSsoChangeCertType} [sso_change_cert] - Available if .tag is
 * sso_change_cert. (sso) Changed X.509 certificate for SSO
 * @property {TeamLogSsoChangeLoginUrlType} [sso_change_login_url] - Available
 * if .tag is sso_change_login_url. (sso) Changed sign-in URL for SSO
 * @property {TeamLogSsoChangeLogoutUrlType} [sso_change_logout_url] - Available
 * if .tag is sso_change_logout_url. (sso) Changed sign-out URL for SSO
 * @property {TeamLogSsoChangeSamlIdentityModeType}
 * [sso_change_saml_identity_mode] - Available if .tag is
 * sso_change_saml_identity_mode. (sso) Changed SAML identity mode for SSO
 * @property {TeamLogSsoRemoveCertType} [sso_remove_cert] - Available if .tag is
 * sso_remove_cert. (sso) Removed X.509 certificate for SSO
 * @property {TeamLogSsoRemoveLoginUrlType} [sso_remove_login_url] - Available
 * if .tag is sso_remove_login_url. (sso) Removed sign-in URL for SSO
 * @property {TeamLogSsoRemoveLogoutUrlType} [sso_remove_logout_url] - Available
 * if .tag is sso_remove_logout_url. (sso) Removed sign-out URL for SSO
 * @property {TeamLogTeamFolderChangeStatusType} [team_folder_change_status] -
 * Available if .tag is team_folder_change_status. (team_folders) Changed
 * archival status of team folder
 * @property {TeamLogTeamFolderCreateType} [team_folder_create] - Available if
 * .tag is team_folder_create. (team_folders) Created team folder in active
 * status
 * @property {TeamLogTeamFolderDowngradeType} [team_folder_downgrade] -
 * Available if .tag is team_folder_downgrade. (team_folders) Downgraded team
 * folder to regular shared folder
 * @property {TeamLogTeamFolderPermanentlyDeleteType}
 * [team_folder_permanently_delete] - Available if .tag is
 * team_folder_permanently_delete. (team_folders) Permanently deleted archived
 * team folder
 * @property {TeamLogTeamFolderRenameType} [team_folder_rename] - Available if
 * .tag is team_folder_rename. (team_folders) Renamed active/archived team
 * folder
 * @property {TeamLogTeamSelectiveSyncSettingsChangedType}
 * [team_selective_sync_settings_changed] - Available if .tag is
 * team_selective_sync_settings_changed. (team_folders) Changed sync default
 * @property {TeamLogAccountCaptureChangePolicyType}
 * [account_capture_change_policy] - Available if .tag is
 * account_capture_change_policy. (team_policies) Changed account capture
 * setting on team domain
 * @property {TeamLogAllowDownloadDisabledType} [allow_download_disabled] -
 * Available if .tag is allow_download_disabled. (team_policies) Disabled
 * downloads (deprecated, no longer logged)
 * @property {TeamLogAllowDownloadEnabledType} [allow_download_enabled] -
 * Available if .tag is allow_download_enabled. (team_policies) Enabled
 * downloads (deprecated, no longer logged)
 * @property {TeamLogCameraUploadsPolicyChangedType}
 * [camera_uploads_policy_changed] - Available if .tag is
 * camera_uploads_policy_changed. (team_policies) Changed camera uploads setting
 * for team
 * @property {TeamLogDataPlacementRestrictionChangePolicyType}
 * [data_placement_restriction_change_policy] - Available if .tag is
 * data_placement_restriction_change_policy. (team_policies) Set restrictions on
 * data center locations where team data resides
 * @property {TeamLogDataPlacementRestrictionSatisfyPolicyType}
 * [data_placement_restriction_satisfy_policy] - Available if .tag is
 * data_placement_restriction_satisfy_policy. (team_policies) Completed
 * restrictions on data center locations where team data resides
 * @property {TeamLogDeviceApprovalsChangeDesktopPolicyType}
 * [device_approvals_change_desktop_policy] - Available if .tag is
 * device_approvals_change_desktop_policy. (team_policies) Set/removed limit on
 * number of computers member can link to team Dropbox account
 * @property {TeamLogDeviceApprovalsChangeMobilePolicyType}
 * [device_approvals_change_mobile_policy] - Available if .tag is
 * device_approvals_change_mobile_policy. (team_policies) Set/removed limit on
 * number of mobile devices member can link to team Dropbox account
 * @property {TeamLogDeviceApprovalsChangeOverageActionType}
 * [device_approvals_change_overage_action] - Available if .tag is
 * device_approvals_change_overage_action. (team_policies) Changed device
 * approvals setting when member is over limit
 * @property {TeamLogDeviceApprovalsChangeUnlinkActionType}
 * [device_approvals_change_unlink_action] - Available if .tag is
 * device_approvals_change_unlink_action. (team_policies) Changed device
 * approvals setting when member unlinks approved device
 * @property {TeamLogDirectoryRestrictionsAddMembersType}
 * [directory_restrictions_add_members] - Available if .tag is
 * directory_restrictions_add_members. (team_policies) Added members to
 * directory restrictions list
 * @property {TeamLogDirectoryRestrictionsRemoveMembersType}
 * [directory_restrictions_remove_members] - Available if .tag is
 * directory_restrictions_remove_members. (team_policies) Removed members from
 * directory restrictions list
 * @property {TeamLogEmmAddExceptionType} [emm_add_exception] - Available if
 * .tag is emm_add_exception. (team_policies) Added members to EMM exception
 * list
 * @property {TeamLogEmmChangePolicyType} [emm_change_policy] - Available if
 * .tag is emm_change_policy. (team_policies) Enabled/disabled enterprise
 * mobility management for members
 * @property {TeamLogEmmRemoveExceptionType} [emm_remove_exception] - Available
 * if .tag is emm_remove_exception. (team_policies) Removed members from EMM
 * exception list
 * @property {TeamLogExtendedVersionHistoryChangePolicyType}
 * [extended_version_history_change_policy] - Available if .tag is
 * extended_version_history_change_policy. (team_policies) Accepted/opted out of
 * extended version history
 * @property {TeamLogFileCommentsChangePolicyType} [file_comments_change_policy]
 * - Available if .tag is file_comments_change_policy. (team_policies)
 * Enabled/disabled commenting on team files
 * @property {TeamLogFileRequestsChangePolicyType} [file_requests_change_policy]
 * - Available if .tag is file_requests_change_policy. (team_policies)
 * Enabled/disabled file requests
 * @property {TeamLogFileRequestsEmailsEnabledType}
 * [file_requests_emails_enabled] - Available if .tag is
 * file_requests_emails_enabled. (team_policies) Enabled file request emails for
 * everyone (deprecated, no longer logged)
 * @property {TeamLogFileRequestsEmailsRestrictedToTeamOnlyType}
 * [file_requests_emails_restricted_to_team_only] - Available if .tag is
 * file_requests_emails_restricted_to_team_only. (team_policies) Enabled file
 * request emails for team (deprecated, no longer logged)
 * @property {TeamLogGoogleSsoChangePolicyType} [google_sso_change_policy] -
 * Available if .tag is google_sso_change_policy. (team_policies)
 * Enabled/disabled Google single sign-on for team
 * @property {TeamLogGroupUserManagementChangePolicyType}
 * [group_user_management_change_policy] - Available if .tag is
 * group_user_management_change_policy. (team_policies) Changed who can create
 * groups
 * @property {TeamLogIntegrationPolicyChangedType} [integration_policy_changed]
 * - Available if .tag is integration_policy_changed. (team_policies) Changed
 * integration policy for team
 * @property {TeamLogMemberRequestsChangePolicyType}
 * [member_requests_change_policy] - Available if .tag is
 * member_requests_change_policy. (team_policies) Changed whether users can find
 * team when not invited
 * @property {TeamLogMemberSpaceLimitsAddExceptionType}
 * [member_space_limits_add_exception] - Available if .tag is
 * member_space_limits_add_exception. (team_policies) Added members to member
 * space limit exception list
 * @property {TeamLogMemberSpaceLimitsChangeCapsTypePolicyType}
 * [member_space_limits_change_caps_type_policy] - Available if .tag is
 * member_space_limits_change_caps_type_policy. (team_policies) Changed member
 * space limit type for team
 * @property {TeamLogMemberSpaceLimitsChangePolicyType}
 * [member_space_limits_change_policy] - Available if .tag is
 * member_space_limits_change_policy. (team_policies) Changed team default
 * member space limit
 * @property {TeamLogMemberSpaceLimitsRemoveExceptionType}
 * [member_space_limits_remove_exception] - Available if .tag is
 * member_space_limits_remove_exception. (team_policies) Removed members from
 * member space limit exception list
 * @property {TeamLogMemberSuggestionsChangePolicyType}
 * [member_suggestions_change_policy] - Available if .tag is
 * member_suggestions_change_policy. (team_policies) Enabled/disabled option for
 * team members to suggest people to add to team
 * @property {TeamLogMicrosoftOfficeAddinChangePolicyType}
 * [microsoft_office_addin_change_policy] - Available if .tag is
 * microsoft_office_addin_change_policy. (team_policies) Enabled/disabled
 * Microsoft Office add-in
 * @property {TeamLogNetworkControlChangePolicyType}
 * [network_control_change_policy] - Available if .tag is
 * network_control_change_policy. (team_policies) Enabled/disabled network
 * control
 * @property {TeamLogPaperChangeDeploymentPolicyType}
 * [paper_change_deployment_policy] - Available if .tag is
 * paper_change_deployment_policy. (team_policies) Changed whether Dropbox
 * Paper, when enabled, is deployed to all members or to specific members
 * @property {TeamLogPaperChangeMemberLinkPolicyType}
 * [paper_change_member_link_policy] - Available if .tag is
 * paper_change_member_link_policy. (team_policies) Changed whether non-members
 * can view Paper docs with link (deprecated, no longer logged)
 * @property {TeamLogPaperChangeMemberPolicyType} [paper_change_member_policy] -
 * Available if .tag is paper_change_member_policy. (team_policies) Changed
 * whether members can share Paper docs outside team, and if docs are accessible
 * only by team members or anyone by default
 * @property {TeamLogPaperChangePolicyType} [paper_change_policy] - Available if
 * .tag is paper_change_policy. (team_policies) Enabled/disabled Dropbox Paper
 * for team
 * @property {TeamLogPaperDefaultFolderPolicyChangedType}
 * [paper_default_folder_policy_changed] - Available if .tag is
 * paper_default_folder_policy_changed. (team_policies) Changed Paper Default
 * Folder Policy setting for team
 * @property {TeamLogPaperDesktopPolicyChangedType}
 * [paper_desktop_policy_changed] - Available if .tag is
 * paper_desktop_policy_changed. (team_policies) Enabled/disabled Paper Desktop
 * for team
 * @property {TeamLogPaperEnabledUsersGroupAdditionType}
 * [paper_enabled_users_group_addition] - Available if .tag is
 * paper_enabled_users_group_addition. (team_policies) Added users to
 * Paper-enabled users list
 * @property {TeamLogPaperEnabledUsersGroupRemovalType}
 * [paper_enabled_users_group_removal] - Available if .tag is
 * paper_enabled_users_group_removal. (team_policies) Removed users from
 * Paper-enabled users list
 * @property {TeamLogPermanentDeleteChangePolicyType}
 * [permanent_delete_change_policy] - Available if .tag is
 * permanent_delete_change_policy. (team_policies) Enabled/disabled ability of
 * team members to permanently delete content
 * @property {TeamLogResellerSupportChangePolicyType}
 * [reseller_support_change_policy] - Available if .tag is
 * reseller_support_change_policy. (team_policies) Enabled/disabled reseller
 * support
 * @property {TeamLogSharingChangeFolderJoinPolicyType}
 * [sharing_change_folder_join_policy] - Available if .tag is
 * sharing_change_folder_join_policy. (team_policies) Changed whether team
 * members can join shared folders owned outside team
 * @property {TeamLogSharingChangeLinkPolicyType} [sharing_change_link_policy] -
 * Available if .tag is sharing_change_link_policy. (team_policies) Changed
 * whether members can share links outside team, and if links are accessible
 * only by team members or anyone by default
 * @property {TeamLogSharingChangeMemberPolicyType}
 * [sharing_change_member_policy] - Available if .tag is
 * sharing_change_member_policy. (team_policies) Changed whether members can
 * share files/folders outside team
 * @property {TeamLogShowcaseChangeDownloadPolicyType}
 * [showcase_change_download_policy] - Available if .tag is
 * showcase_change_download_policy. (team_policies) Enabled/disabled downloading
 * files from Dropbox Showcase for team
 * @property {TeamLogShowcaseChangeEnabledPolicyType}
 * [showcase_change_enabled_policy] - Available if .tag is
 * showcase_change_enabled_policy. (team_policies) Enabled/disabled Dropbox
 * Showcase for team
 * @property {TeamLogShowcaseChangeExternalSharingPolicyType}
 * [showcase_change_external_sharing_policy] - Available if .tag is
 * showcase_change_external_sharing_policy. (team_policies) Enabled/disabled
 * sharing Dropbox Showcase externally for team
 * @property {TeamLogSmartSyncChangePolicyType} [smart_sync_change_policy] -
 * Available if .tag is smart_sync_change_policy. (team_policies) Changed
 * default Smart Sync setting for team members
 * @property {TeamLogSmartSyncNotOptOutType} [smart_sync_not_opt_out] -
 * Available if .tag is smart_sync_not_opt_out. (team_policies) Opted team into
 * Smart Sync
 * @property {TeamLogSmartSyncOptOutType} [smart_sync_opt_out] - Available if
 * .tag is smart_sync_opt_out. (team_policies) Opted team out of Smart Sync
 * @property {TeamLogSsoChangePolicyType} [sso_change_policy] - Available if
 * .tag is sso_change_policy. (team_policies) Changed single sign-on setting for
 * team
 * @property {TeamLogTeamExtensionsPolicyChangedType}
 * [team_extensions_policy_changed] - Available if .tag is
 * team_extensions_policy_changed. (team_policies) Changed App Integrations
 * setting for team
 * @property {TeamLogTeamSelectiveSyncPolicyChangedType}
 * [team_selective_sync_policy_changed] - Available if .tag is
 * team_selective_sync_policy_changed. (team_policies) Enabled/disabled Team
 * Selective Sync for team
 * @property {TeamLogTfaChangePolicyType} [tfa_change_policy] - Available if
 * .tag is tfa_change_policy. (team_policies) Changed two-step verification
 * setting for team
 * @property {TeamLogTwoAccountChangePolicyType} [two_account_change_policy] -
 * Available if .tag is two_account_change_policy. (team_policies)
 * Enabled/disabled option for members to link personal Dropbox account and team
 * account to same computer
 * @property {TeamLogViewerInfoPolicyChangedType} [viewer_info_policy_changed] -
 * Available if .tag is viewer_info_policy_changed. (team_policies) Changed team
 * policy for viewer info
 * @property {TeamLogWebSessionsChangeFixedLengthPolicyType}
 * [web_sessions_change_fixed_length_policy] - Available if .tag is
 * web_sessions_change_fixed_length_policy. (team_policies) Changed how long
 * members can stay signed in to Dropbox.com
 * @property {TeamLogWebSessionsChangeIdleLengthPolicyType}
 * [web_sessions_change_idle_length_policy] - Available if .tag is
 * web_sessions_change_idle_length_policy. (team_policies) Changed how long team
 * members can be idle while signed in to Dropbox.com
 * @property {TeamLogTeamMergeFromType} [team_merge_from] - Available if .tag is
 * team_merge_from. (team_profile) Merged another team into this team
 * @property {TeamLogTeamMergeToType} [team_merge_to] - Available if .tag is
 * team_merge_to. (team_profile) Merged this team into another team
 * @property {TeamLogTeamProfileAddLogoType} [team_profile_add_logo] - Available
 * if .tag is team_profile_add_logo. (team_profile) Added team logo to display
 * on shared link headers
 * @property {TeamLogTeamProfileChangeDefaultLanguageType}
 * [team_profile_change_default_language] - Available if .tag is
 * team_profile_change_default_language. (team_profile) Changed default language
 * for team
 * @property {TeamLogTeamProfileChangeLogoType} [team_profile_change_logo] -
 * Available if .tag is team_profile_change_logo. (team_profile) Changed team
 * logo displayed on shared link headers
 * @property {TeamLogTeamProfileChangeNameType} [team_profile_change_name] -
 * Available if .tag is team_profile_change_name. (team_profile) Changed team
 * name
 * @property {TeamLogTeamProfileRemoveLogoType} [team_profile_remove_logo] -
 * Available if .tag is team_profile_remove_logo. (team_profile) Removed team
 * logo displayed on shared link headers
 * @property {TeamLogTfaAddBackupPhoneType} [tfa_add_backup_phone] - Available
 * if .tag is tfa_add_backup_phone. (tfa) Added backup phone for two-step
 * verification
 * @property {TeamLogTfaAddSecurityKeyType} [tfa_add_security_key] - Available
 * if .tag is tfa_add_security_key. (tfa) Added security key for two-step
 * verification
 * @property {TeamLogTfaChangeBackupPhoneType} [tfa_change_backup_phone] -
 * Available if .tag is tfa_change_backup_phone. (tfa) Changed backup phone for
 * two-step verification
 * @property {TeamLogTfaChangeStatusType} [tfa_change_status] - Available if
 * .tag is tfa_change_status. (tfa) Enabled/disabled/changed two-step
 * verification setting
 * @property {TeamLogTfaRemoveBackupPhoneType} [tfa_remove_backup_phone] -
 * Available if .tag is tfa_remove_backup_phone. (tfa) Removed backup phone for
 * two-step verification
 * @property {TeamLogTfaRemoveSecurityKeyType} [tfa_remove_security_key] -
 * Available if .tag is tfa_remove_security_key. (tfa) Removed security key for
 * two-step verification
 * @property {TeamLogTfaResetType} [tfa_reset] - Available if .tag is tfa_reset.
 * (tfa) Reset two-step verification for team member
 * @property {TeamLogGuestAdminChangeStatusType} [guest_admin_change_status] -
 * Available if .tag is guest_admin_change_status. (trusted_teams) Changed guest
 * team admin status
 * @property {TeamLogTeamMergeRequestAcceptedType} [team_merge_request_accepted]
 * - Available if .tag is team_merge_request_accepted. (trusted_teams) Accepted
 * a team merge request
 * @property {TeamLogTeamMergeRequestAcceptedShownToPrimaryTeamType}
 * [team_merge_request_accepted_shown_to_primary_team] - Available if .tag is
 * team_merge_request_accepted_shown_to_primary_team. (trusted_teams) Accepted a
 * team merge request (deprecated, replaced by 'Accepted a team merge request')
 * @property {TeamLogTeamMergeRequestAcceptedShownToSecondaryTeamType}
 * [team_merge_request_accepted_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_accepted_shown_to_secondary_team. (trusted_teams) Accepted
 * a team merge request (deprecated, replaced by 'Accepted a team merge
 * request')
 * @property {TeamLogTeamMergeRequestAutoCanceledType}
 * [team_merge_request_auto_canceled] - Available if .tag is
 * team_merge_request_auto_canceled. (trusted_teams) Automatically canceled team
 * merge request
 * @property {TeamLogTeamMergeRequestCanceledType} [team_merge_request_canceled]
 * - Available if .tag is team_merge_request_canceled. (trusted_teams) Canceled
 * a team merge request
 * @property {TeamLogTeamMergeRequestCanceledShownToPrimaryTeamType}
 * [team_merge_request_canceled_shown_to_primary_team] - Available if .tag is
 * team_merge_request_canceled_shown_to_primary_team. (trusted_teams) Canceled a
 * team merge request (deprecated, replaced by 'Canceled a team merge request')
 * @property {TeamLogTeamMergeRequestCanceledShownToSecondaryTeamType}
 * [team_merge_request_canceled_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_canceled_shown_to_secondary_team. (trusted_teams) Canceled
 * a team merge request (deprecated, replaced by 'Canceled a team merge
 * request')
 * @property {TeamLogTeamMergeRequestExpiredType} [team_merge_request_expired] -
 * Available if .tag is team_merge_request_expired. (trusted_teams) Team merge
 * request expired
 * @property {TeamLogTeamMergeRequestExpiredShownToPrimaryTeamType}
 * [team_merge_request_expired_shown_to_primary_team] - Available if .tag is
 * team_merge_request_expired_shown_to_primary_team. (trusted_teams) Team merge
 * request expired (deprecated, replaced by 'Team merge request expired')
 * @property {TeamLogTeamMergeRequestExpiredShownToSecondaryTeamType}
 * [team_merge_request_expired_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_expired_shown_to_secondary_team. (trusted_teams) Team
 * merge request expired (deprecated, replaced by 'Team merge request expired')
 * @property {TeamLogTeamMergeRequestRejectedShownToPrimaryTeamType}
 * [team_merge_request_rejected_shown_to_primary_team] - Available if .tag is
 * team_merge_request_rejected_shown_to_primary_team. (trusted_teams) Rejected a
 * team merge request (deprecated, no longer logged)
 * @property {TeamLogTeamMergeRequestRejectedShownToSecondaryTeamType}
 * [team_merge_request_rejected_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_rejected_shown_to_secondary_team. (trusted_teams) Rejected
 * a team merge request (deprecated, no longer logged)
 * @property {TeamLogTeamMergeRequestReminderType} [team_merge_request_reminder]
 * - Available if .tag is team_merge_request_reminder. (trusted_teams) Sent a
 * team merge request reminder
 * @property {TeamLogTeamMergeRequestReminderShownToPrimaryTeamType}
 * [team_merge_request_reminder_shown_to_primary_team] - Available if .tag is
 * team_merge_request_reminder_shown_to_primary_team. (trusted_teams) Sent a
 * team merge request reminder (deprecated, replaced by 'Sent a team merge
 * request reminder')
 * @property {TeamLogTeamMergeRequestReminderShownToSecondaryTeamType}
 * [team_merge_request_reminder_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_reminder_shown_to_secondary_team. (trusted_teams) Sent a
 * team merge request reminder (deprecated, replaced by 'Sent a team merge
 * request reminder')
 * @property {TeamLogTeamMergeRequestRevokedType} [team_merge_request_revoked] -
 * Available if .tag is team_merge_request_revoked. (trusted_teams) Canceled the
 * team merge
 * @property {TeamLogTeamMergeRequestSentShownToPrimaryTeamType}
 * [team_merge_request_sent_shown_to_primary_team] - Available if .tag is
 * team_merge_request_sent_shown_to_primary_team. (trusted_teams) Requested to
 * merge their Dropbox team into yours
 * @property {TeamLogTeamMergeRequestSentShownToSecondaryTeamType}
 * [team_merge_request_sent_shown_to_secondary_team] - Available if .tag is
 * team_merge_request_sent_shown_to_secondary_team. (trusted_teams) Requested to
 * merge your team into another Dropbox team
 * @property {('app_link_team'|'app_link_user'|'app_unlink_team'|'app_unlink_user'|'integration_connected'|'integration_disconnected'|'file_add_comment'|'file_change_comment_subscription'|'file_delete_comment'|'file_edit_comment'|'file_like_comment'|'file_resolve_comment'|'file_unlike_comment'|'file_unresolve_comment'|'device_change_ip_desktop'|'device_change_ip_mobile'|'device_change_ip_web'|'device_delete_on_unlink_fail'|'device_delete_on_unlink_success'|'device_link_fail'|'device_link_success'|'device_management_disabled'|'device_management_enabled'|'device_unlink'|'emm_refresh_auth_token'|'account_capture_change_availability'|'account_capture_migrate_account'|'account_capture_notification_emails_sent'|'account_capture_relinquish_account'|'disabled_domain_invites'|'domain_invites_approve_request_to_join_team'|'domain_invites_decline_request_to_join_team'|'domain_invites_email_existing_users'|'domain_invites_request_to_join_team'|'domain_invites_set_invite_new_user_pref_to_no'|'domain_invites_set_invite_new_user_pref_to_yes'|'domain_verification_add_domain_fail'|'domain_verification_add_domain_success'|'domain_verification_remove_domain'|'enabled_domain_invites'|'create_folder'|'file_add'|'file_copy'|'file_delete'|'file_download'|'file_edit'|'file_get_copy_reference'|'file_move'|'file_permanently_delete'|'file_preview'|'file_rename'|'file_restore'|'file_revert'|'file_rollback_changes'|'file_save_copy_reference'|'file_request_change'|'file_request_close'|'file_request_create'|'file_request_delete'|'file_request_receive_file'|'group_add_external_id'|'group_add_member'|'group_change_external_id'|'group_change_management_type'|'group_change_member_role'|'group_create'|'group_delete'|'group_description_updated'|'group_join_policy_updated'|'group_moved'|'group_remove_external_id'|'group_remove_member'|'group_rename'|'emm_error'|'guest_admin_signed_in_via_trusted_teams'|'guest_admin_signed_out_via_trusted_teams'|'login_fail'|'login_success'|'logout'|'reseller_support_session_end'|'reseller_support_session_start'|'sign_in_as_session_end'|'sign_in_as_session_start'|'sso_error'|'member_add_external_id'|'member_add_name'|'member_change_admin_role'|'member_change_email'|'member_change_external_id'|'member_change_membership_type'|'member_change_name'|'member_change_status'|'member_delete_manual_contacts'|'member_permanently_delete_account_contents'|'member_remove_external_id'|'member_space_limits_add_custom_quota'|'member_space_limits_change_custom_quota'|'member_space_limits_change_status'|'member_space_limits_remove_custom_quota'|'member_suggest'|'member_transfer_account_contents'|'secondary_mails_policy_changed'|'paper_content_add_member'|'paper_content_add_to_folder'|'paper_content_archive'|'paper_content_create'|'paper_content_permanently_delete'|'paper_content_remove_from_folder'|'paper_content_remove_member'|'paper_content_rename'|'paper_content_restore'|'paper_doc_add_comment'|'paper_doc_change_member_role'|'paper_doc_change_sharing_policy'|'paper_doc_change_subscription'|'paper_doc_deleted'|'paper_doc_delete_comment'|'paper_doc_download'|'paper_doc_edit'|'paper_doc_edit_comment'|'paper_doc_followed'|'paper_doc_mention'|'paper_doc_ownership_changed'|'paper_doc_request_access'|'paper_doc_resolve_comment'|'paper_doc_revert'|'paper_doc_slack_share'|'paper_doc_team_invite'|'paper_doc_trashed'|'paper_doc_unresolve_comment'|'paper_doc_untrashed'|'paper_doc_view'|'paper_external_view_allow'|'paper_external_view_default_team'|'paper_external_view_forbid'|'paper_folder_change_subscription'|'paper_folder_deleted'|'paper_folder_followed'|'paper_folder_team_invite'|'paper_published_link_create'|'paper_published_link_disabled'|'paper_published_link_view'|'password_change'|'password_reset'|'password_reset_all'|'emm_create_exceptions_report'|'emm_create_usage_report'|'export_members_report'|'paper_admin_export_start'|'smart_sync_create_admin_privilege_report'|'team_activity_create_report'|'team_activity_create_report_fail'|'collection_share'|'note_acl_invite_only'|'note_acl_link'|'note_acl_team_link'|'note_shared'|'note_share_receive'|'open_note_shared'|'sf_add_group'|'sf_allow_non_members_to_view_shared_links'|'sf_external_invite_warn'|'sf_fb_invite'|'sf_fb_invite_change_role'|'sf_fb_uninvite'|'sf_invite_group'|'sf_team_grant_access'|'sf_team_invite'|'sf_team_invite_change_role'|'sf_team_join'|'sf_team_join_from_oob_link'|'sf_team_uninvite'|'shared_content_add_invitees'|'shared_content_add_link_expiry'|'shared_content_add_link_password'|'shared_content_add_member'|'shared_content_change_downloads_policy'|'shared_content_change_invitee_role'|'shared_content_change_link_audience'|'shared_content_change_link_expiry'|'shared_content_change_link_password'|'shared_content_change_member_role'|'shared_content_change_viewer_info_policy'|'shared_content_claim_invitation'|'shared_content_copy'|'shared_content_download'|'shared_content_relinquish_membership'|'shared_content_remove_invitees'|'shared_content_remove_link_expiry'|'shared_content_remove_link_password'|'shared_content_remove_member'|'shared_content_request_access'|'shared_content_unshare'|'shared_content_view'|'shared_folder_change_link_policy'|'shared_folder_change_members_inheritance_policy'|'shared_folder_change_members_management_policy'|'shared_folder_change_members_policy'|'shared_folder_create'|'shared_folder_decline_invitation'|'shared_folder_mount'|'shared_folder_nest'|'shared_folder_transfer_ownership'|'shared_folder_unmount'|'shared_link_add_expiry'|'shared_link_change_expiry'|'shared_link_change_visibility'|'shared_link_copy'|'shared_link_create'|'shared_link_disable'|'shared_link_download'|'shared_link_remove_expiry'|'shared_link_share'|'shared_link_view'|'shared_note_opened'|'shmodel_group_share'|'showcase_access_granted'|'showcase_add_member'|'showcase_archived'|'showcase_created'|'showcase_delete_comment'|'showcase_edited'|'showcase_edit_comment'|'showcase_file_added'|'showcase_file_download'|'showcase_file_removed'|'showcase_file_view'|'showcase_permanently_deleted'|'showcase_post_comment'|'showcase_remove_member'|'showcase_renamed'|'showcase_request_access'|'showcase_resolve_comment'|'showcase_restored'|'showcase_trashed'|'showcase_trashed_deprecated'|'showcase_unresolve_comment'|'showcase_untrashed'|'showcase_untrashed_deprecated'|'showcase_view'|'sso_add_cert'|'sso_add_login_url'|'sso_add_logout_url'|'sso_change_cert'|'sso_change_login_url'|'sso_change_logout_url'|'sso_change_saml_identity_mode'|'sso_remove_cert'|'sso_remove_login_url'|'sso_remove_logout_url'|'team_folder_change_status'|'team_folder_create'|'team_folder_downgrade'|'team_folder_permanently_delete'|'team_folder_rename'|'team_selective_sync_settings_changed'|'account_capture_change_policy'|'allow_download_disabled'|'allow_download_enabled'|'camera_uploads_policy_changed'|'data_placement_restriction_change_policy'|'data_placement_restriction_satisfy_policy'|'device_approvals_change_desktop_policy'|'device_approvals_change_mobile_policy'|'device_approvals_change_overage_action'|'device_approvals_change_unlink_action'|'directory_restrictions_add_members'|'directory_restrictions_remove_members'|'emm_add_exception'|'emm_change_policy'|'emm_remove_exception'|'extended_version_history_change_policy'|'file_comments_change_policy'|'file_requests_change_policy'|'file_requests_emails_enabled'|'file_requests_emails_restricted_to_team_only'|'google_sso_change_policy'|'group_user_management_change_policy'|'integration_policy_changed'|'member_requests_change_policy'|'member_space_limits_add_exception'|'member_space_limits_change_caps_type_policy'|'member_space_limits_change_policy'|'member_space_limits_remove_exception'|'member_suggestions_change_policy'|'microsoft_office_addin_change_policy'|'network_control_change_policy'|'paper_change_deployment_policy'|'paper_change_member_link_policy'|'paper_change_member_policy'|'paper_change_policy'|'paper_default_folder_policy_changed'|'paper_desktop_policy_changed'|'paper_enabled_users_group_addition'|'paper_enabled_users_group_removal'|'permanent_delete_change_policy'|'reseller_support_change_policy'|'sharing_change_folder_join_policy'|'sharing_change_link_policy'|'sharing_change_member_policy'|'showcase_change_download_policy'|'showcase_change_enabled_policy'|'showcase_change_external_sharing_policy'|'smart_sync_change_policy'|'smart_sync_not_opt_out'|'smart_sync_opt_out'|'sso_change_policy'|'team_extensions_policy_changed'|'team_selective_sync_policy_changed'|'tfa_change_policy'|'two_account_change_policy'|'viewer_info_policy_changed'|'web_sessions_change_fixed_length_policy'|'web_sessions_change_idle_length_policy'|'team_merge_from'|'team_merge_to'|'team_profile_add_logo'|'team_profile_change_default_language'|'team_profile_change_logo'|'team_profile_change_name'|'team_profile_remove_logo'|'tfa_add_backup_phone'|'tfa_add_security_key'|'tfa_change_backup_phone'|'tfa_change_status'|'tfa_remove_backup_phone'|'tfa_remove_security_key'|'tfa_reset'|'guest_admin_change_status'|'team_merge_request_accepted'|'team_merge_request_accepted_shown_to_primary_team'|'team_merge_request_accepted_shown_to_secondary_team'|'team_merge_request_auto_canceled'|'team_merge_request_canceled'|'team_merge_request_canceled_shown_to_primary_team'|'team_merge_request_canceled_shown_to_secondary_team'|'team_merge_request_expired'|'team_merge_request_expired_shown_to_primary_team'|'team_merge_request_expired_shown_to_secondary_team'|'team_merge_request_rejected_shown_to_primary_team'|'team_merge_request_rejected_shown_to_secondary_team'|'team_merge_request_reminder'|'team_merge_request_reminder_shown_to_primary_team'|'team_merge_request_reminder_shown_to_secondary_team'|'team_merge_request_revoked'|'team_merge_request_sent_shown_to_primary_team'|'team_merge_request_sent_shown_to_secondary_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Created member data report.
 * @typedef {Object} TeamLogExportMembersReportDetails
 */

/**
 * @typedef {Object} TeamLogExportMembersReportType
 * @property {string} description
 */

/**
 * Accepted/opted out of extended version history.
 * @typedef {Object} TeamLogExtendedVersionHistoryChangePolicyDetails
 * @property {TeamLogExtendedVersionHistoryPolicy} new_value - New extended
 * version history policy.
 * @property {TeamLogExtendedVersionHistoryPolicy} [previous_value] - Previous
 * extended version history policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogExtendedVersionHistoryChangePolicyType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogExtendedVersionHistoryPolicy
 * @property {('explicitly_limited'|'explicitly_unlimited'|'implicitly_limited'|'implicitly_unlimited'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * A user without a Dropbox account.
 * @typedef {Object} TeamLogExternalUserLogInfo
 * @property {string} user_identifier - An external user identifier.
 * @property {TeamLogIdentifierType} identifier_type - Identifier type.
 */

/**
 * Provides details about a failure
 * @typedef {Object} TeamLogFailureDetailsLogInfo
 * @property {string} [user_friendly_message] - A user friendly explanation of
 * the error. Might be missing due to historical data gap.
 * @property {string} [technical_error_message] - A technical explanation of the
 * error. This is relevant for some errors.
 */

/**
 * Added file comment.
 * @typedef {Object} TeamLogFileAddCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileAddCommentType
 * @property {string} description
 */

/**
 * Added files and/or folders.
 * @typedef {Object} TeamLogFileAddDetails
 */

/**
 * @typedef {Object} TeamLogFileAddType
 * @property {string} description
 */

/**
 * Subscribed to or unsubscribed from comment notifications for file.
 * @typedef {Object} TeamLogFileChangeCommentSubscriptionDetails
 * @property {TeamLogFileCommentNotificationPolicy} new_value - New file comment
 * subscription.
 * @property {TeamLogFileCommentNotificationPolicy} [previous_value] - Previous
 * file comment subscription. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileChangeCommentSubscriptionType
 * @property {string} description
 */

/**
 * Enable or disable file comments notifications
 * @typedef {Object} TeamLogFileCommentNotificationPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Enabled/disabled commenting on team files.
 * @typedef {Object} TeamLogFileCommentsChangePolicyDetails
 * @property {TeamLogFileCommentsPolicy} new_value - New commenting on team
 * files policy.
 * @property {TeamLogFileCommentsPolicy} [previous_value] - Previous commenting
 * on team files policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileCommentsChangePolicyType
 * @property {string} description
 */

/**
 * File comments policy
 * @typedef {Object} TeamLogFileCommentsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Copied files and/or folders.
 * @typedef {Object} TeamLogFileCopyDetails
 * @property {Array.<TeamLogRelocateAssetReferencesLogInfo>}
 * relocate_action_details - Relocate action details.
 */

/**
 * @typedef {Object} TeamLogFileCopyType
 * @property {string} description
 */

/**
 * Deleted file comment.
 * @typedef {Object} TeamLogFileDeleteCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileDeleteCommentType
 * @property {string} description
 */

/**
 * Deleted files and/or folders.
 * @typedef {Object} TeamLogFileDeleteDetails
 */

/**
 * @typedef {Object} TeamLogFileDeleteType
 * @property {string} description
 */

/**
 * Downloaded files and/or folders.
 * @typedef {Object} TeamLogFileDownloadDetails
 */

/**
 * @typedef {Object} TeamLogFileDownloadType
 * @property {string} description
 */

/**
 * Edited file comment.
 * @typedef {Object} TeamLogFileEditCommentDetails
 * @property {string} previous_comment_text - Previous comment text.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileEditCommentType
 * @property {string} description
 */

/**
 * Edited files.
 * @typedef {Object} TeamLogFileEditDetails
 */

/**
 * @typedef {Object} TeamLogFileEditType
 * @property {string} description
 */

/**
 * Created copy reference to file/folder.
 * @typedef {Object} TeamLogFileGetCopyReferenceDetails
 */

/**
 * @typedef {Object} TeamLogFileGetCopyReferenceType
 * @property {string} description
 */

/**
 * Liked file comment.
 * @typedef {Object} TeamLogFileLikeCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileLikeCommentType
 * @property {string} description
 */

/**
 * File's logged information.
 * @typedef {Object} TeamLogFileLogInfo
 * @property {TeamLogPathLogInfo} path - Path relative to event context.
 * @property {string} [display_name] - Display name. Might be missing due to
 * historical data gap.
 * @property {string} [file_id] - Unique ID. Might be missing due to historical
 * data gap.
 */

/**
 * Moved files and/or folders.
 * @typedef {Object} TeamLogFileMoveDetails
 * @property {Array.<TeamLogRelocateAssetReferencesLogInfo>}
 * relocate_action_details - Relocate action details.
 */

/**
 * @typedef {Object} TeamLogFileMoveType
 * @property {string} description
 */

/**
 * Generic information relevant both for files and folders
 * @typedef {Object} TeamLogFileOrFolderLogInfo
 * @property {TeamLogPathLogInfo} path - Path relative to event context.
 * @property {string} [display_name] - Display name. Might be missing due to
 * historical data gap.
 * @property {string} [file_id] - Unique ID. Might be missing due to historical
 * data gap.
 */

/**
 * Permanently deleted files and/or folders.
 * @typedef {Object} TeamLogFilePermanentlyDeleteDetails
 */

/**
 * @typedef {Object} TeamLogFilePermanentlyDeleteType
 * @property {string} description
 */

/**
 * Previewed files and/or folders.
 * @typedef {Object} TeamLogFilePreviewDetails
 */

/**
 * @typedef {Object} TeamLogFilePreviewType
 * @property {string} description
 */

/**
 * Renamed files and/or folders.
 * @typedef {Object} TeamLogFileRenameDetails
 * @property {Array.<TeamLogRelocateAssetReferencesLogInfo>}
 * relocate_action_details - Relocate action details.
 */

/**
 * @typedef {Object} TeamLogFileRenameType
 * @property {string} description
 */

/**
 * Changed file request.
 * @typedef {Object} TeamLogFileRequestChangeDetails
 * @property {TeamLogFileRequestDetails} new_details - New file request details.
 * @property {string} [file_request_id] - File request id. Might be missing due
 * to historical data gap.
 * @property {TeamLogFileRequestDetails} [previous_details] - Previous file
 * request details. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestChangeType
 * @property {string} description
 */

/**
 * Closed file request.
 * @typedef {Object} TeamLogFileRequestCloseDetails
 * @property {string} [file_request_id] - File request id. Might be missing due
 * to historical data gap.
 * @property {TeamLogFileRequestDetails} [previous_details] - Previous file
 * request details. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestCloseType
 * @property {string} description
 */

/**
 * Created file request.
 * @typedef {Object} TeamLogFileRequestCreateDetails
 * @property {string} [file_request_id] - File request id. Might be missing due
 * to historical data gap.
 * @property {TeamLogFileRequestDetails} [request_details] - File request
 * details. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestCreateType
 * @property {string} description
 */

/**
 * File request deadline
 * @typedef {Object} TeamLogFileRequestDeadline
 * @property {Timestamp} [deadline] - The deadline for this file request. Might
 * be missing due to historical data gap.
 * @property {string} [allow_late_uploads] - If set, allow uploads after the
 * deadline has passed. Might be missing due to historical data gap.
 */

/**
 * Delete file request.
 * @typedef {Object} TeamLogFileRequestDeleteDetails
 * @property {string} [file_request_id] - File request id. Might be missing due
 * to historical data gap.
 * @property {TeamLogFileRequestDetails} [previous_details] - Previous file
 * request details. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestDeleteType
 * @property {string} description
 */

/**
 * File request details
 * @typedef {Object} TeamLogFileRequestDetails
 * @property {number} asset_index - Asset position in the Assets list.
 * @property {TeamLogFileRequestDeadline} [deadline] - File request deadline.
 * Might be missing due to historical data gap.
 */

/**
 * Received files for file request.
 * @typedef {Object} TeamLogFileRequestReceiveFileDetails
 * @property {Array.<string>} submitted_file_names - Submitted file names.
 * @property {string} [file_request_id] - File request id. Might be missing due
 * to historical data gap.
 * @property {TeamLogFileRequestDetails} [file_request_details] - File request
 * details. Might be missing due to historical data gap.
 * @property {string} [submitter_name] - The name as provided by the submitter.
 * Might be missing due to historical data gap.
 * @property {string} [submitter_email] - The email as provided by the
 * submitter. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestReceiveFileType
 * @property {string} description
 */

/**
 * Enabled/disabled file requests.
 * @typedef {Object} TeamLogFileRequestsChangePolicyDetails
 * @property {TeamLogFileRequestsPolicy} new_value - New file requests policy.
 * @property {TeamLogFileRequestsPolicy} [previous_value] - Previous file
 * requests policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileRequestsChangePolicyType
 * @property {string} description
 */

/**
 * Enabled file request emails for everyone.
 * @typedef {Object} TeamLogFileRequestsEmailsEnabledDetails
 */

/**
 * @typedef {Object} TeamLogFileRequestsEmailsEnabledType
 * @property {string} description
 */

/**
 * Enabled file request emails for team.
 * @typedef {Object} TeamLogFileRequestsEmailsRestrictedToTeamOnlyDetails
 */

/**
 * @typedef {Object} TeamLogFileRequestsEmailsRestrictedToTeamOnlyType
 * @property {string} description
 */

/**
 * File requests policy
 * @typedef {Object} TeamLogFileRequestsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Resolved file comment.
 * @typedef {Object} TeamLogFileResolveCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileResolveCommentType
 * @property {string} description
 */

/**
 * Restored deleted files and/or folders.
 * @typedef {Object} TeamLogFileRestoreDetails
 */

/**
 * @typedef {Object} TeamLogFileRestoreType
 * @property {string} description
 */

/**
 * Reverted files to previous version.
 * @typedef {Object} TeamLogFileRevertDetails
 */

/**
 * @typedef {Object} TeamLogFileRevertType
 * @property {string} description
 */

/**
 * Rolled back file actions.
 * @typedef {Object} TeamLogFileRollbackChangesDetails
 */

/**
 * @typedef {Object} TeamLogFileRollbackChangesType
 * @property {string} description
 */

/**
 * Saved file/folder using copy reference.
 * @typedef {Object} TeamLogFileSaveCopyReferenceDetails
 * @property {Array.<TeamLogRelocateAssetReferencesLogInfo>}
 * relocate_action_details - Relocate action details.
 */

/**
 * @typedef {Object} TeamLogFileSaveCopyReferenceType
 * @property {string} description
 */

/**
 * Unliked file comment.
 * @typedef {Object} TeamLogFileUnlikeCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileUnlikeCommentType
 * @property {string} description
 */

/**
 * Unresolved file comment.
 * @typedef {Object} TeamLogFileUnresolveCommentDetails
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogFileUnresolveCommentType
 * @property {string} description
 */

/**
 * Folder's logged information.
 * @typedef {Object} TeamLogFolderLogInfo
 * @property {TeamLogPathLogInfo} path - Path relative to event context.
 * @property {string} [display_name] - Display name. Might be missing due to
 * historical data gap.
 * @property {string} [file_id] - Unique ID. Might be missing due to historical
 * data gap.
 */

/**
 * Geographic location details.
 * @typedef {Object} TeamLogGeoLocationLogInfo
 * @property {string} ip_address - IP address.
 * @property {string} [city] - City name.
 * @property {string} [region] - Region name.
 * @property {string} [country] - Country code.
 */

/**
 * @typedef {Object} TeamLogGetTeamEventsArg
 * @property {number} limit - The maximal number of results to return per call.
 * Note that some calls may not return limit number of events, and may even
 * return no events, even with `has_more` set to true. In this case, callers
 * should fetch again using get_events/continue.
 * @property {string} [account_id] - Filter the events by account ID. Return ony
 * events with this account_id as either Actor, Context, or Participants.
 * @property {TeamCommonTimeRange} [time] - Filter by time range.
 * @property {TeamLogEventCategory} [category] - Filter the returned events to a
 * single category.
 */

/**
 * @typedef {Object} TeamLogGetTeamEventsContinueArg
 * @property {string} cursor - Indicates from what point to get the next set of
 * events.
 */

/**
 * Errors that can be raised when calling get_events/continue.
 * @typedef {Object} TeamLogGetTeamEventsContinueError
 * @property {Timestamp} [reset] - Available if .tag is reset. Cursors are
 * intended to be used quickly. Individual cursor values are normally valid for
 * days, but in rare cases may be reset sooner. Cursor reset errors should be
 * handled by fetching a new cursor from :route:`get_events`. The associated
 * value is the approximate timestamp of the most recent event returned by the
 * cursor. This should be used as a resumption point when calling
 * :route:`get_events` to obtain a new cursor.
 * @property {('bad_cursor'|'reset'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Errors that can be raised when calling get_events.
 * @typedef {Object} TeamLogGetTeamEventsError
 * @property {('account_id_not_found'|'invalid_time_range'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogGetTeamEventsResult
 * @property {Array.<TeamLogTeamEvent>} events - List of events. Note that
 * events are not guaranteed to be sorted by their timestamp value.
 * @property {string} cursor - Pass the cursor into get_events/continue to
 * obtain additional events. The value of cursor may change for each response
 * from get_events/continue, regardless of the value of has_more; older cursor
 * strings may expire. Thus, callers should ensure that they update their cursor
 * based on the latest value of cursor after each call, and poll regularly if
 * they wish to poll for new events. Callers should handle reset exceptions for
 * expired cursors.
 * @property {boolean} has_more - Is true if there may be additional events that
 * have not been returned yet. An additional call to get_events/continue can
 * retrieve them. Note that has_more may be true, even if events is empty.
 */

/**
 * Enabled/disabled Google single sign-on for team.
 * @typedef {Object} TeamLogGoogleSsoChangePolicyDetails
 * @property {TeamLogGoogleSsoPolicy} new_value - New Google single sign-on
 * policy.
 * @property {TeamLogGoogleSsoPolicy} [previous_value] - Previous Google single
 * sign-on policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogGoogleSsoChangePolicyType
 * @property {string} description
 */

/**
 * Google SSO policy
 * @typedef {Object} TeamLogGoogleSsoPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added external ID for group.
 * @typedef {Object} TeamLogGroupAddExternalIdDetails
 * @property {string} new_value - Current external id.
 */

/**
 * @typedef {Object} TeamLogGroupAddExternalIdType
 * @property {string} description
 */

/**
 * Added team members to group.
 * @typedef {Object} TeamLogGroupAddMemberDetails
 * @property {boolean} is_group_owner - Is group owner.
 */

/**
 * @typedef {Object} TeamLogGroupAddMemberType
 * @property {string} description
 */

/**
 * Changed external ID for group.
 * @typedef {Object} TeamLogGroupChangeExternalIdDetails
 * @property {string} new_value - Current external id.
 * @property {string} previous_value - Old external id.
 */

/**
 * @typedef {Object} TeamLogGroupChangeExternalIdType
 * @property {string} description
 */

/**
 * Changed group management type.
 * @typedef {Object} TeamLogGroupChangeManagementTypeDetails
 * @property {TeamCommonGroupManagementType} new_value - New group management
 * type.
 * @property {TeamCommonGroupManagementType} [previous_value] - Previous group
 * management type. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogGroupChangeManagementTypeType
 * @property {string} description
 */

/**
 * Changed manager permissions of group member.
 * @typedef {Object} TeamLogGroupChangeMemberRoleDetails
 * @property {boolean} is_group_owner - Is group owner.
 */

/**
 * @typedef {Object} TeamLogGroupChangeMemberRoleType
 * @property {string} description
 */

/**
 * Created group.
 * @typedef {Object} TeamLogGroupCreateDetails
 * @property {boolean} [is_company_managed] - Is company managed group. Might be
 * missing due to historical data gap.
 * @property {TeamLogGroupJoinPolicy} [join_policy] - Group join policy.
 */

/**
 * @typedef {Object} TeamLogGroupCreateType
 * @property {string} description
 */

/**
 * Deleted group.
 * @typedef {Object} TeamLogGroupDeleteDetails
 * @property {boolean} [is_company_managed] - Is company managed group. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogGroupDeleteType
 * @property {string} description
 */

/**
 * Updated group.
 * @typedef {Object} TeamLogGroupDescriptionUpdatedDetails
 */

/**
 * @typedef {Object} TeamLogGroupDescriptionUpdatedType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogGroupJoinPolicy
 * @property {('open'|'request_to_join'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Updated group join policy.
 * @typedef {Object} TeamLogGroupJoinPolicyUpdatedDetails
 * @property {boolean} [is_company_managed] - Is company managed group. Might be
 * missing due to historical data gap.
 * @property {TeamLogGroupJoinPolicy} [join_policy] - Group join policy.
 */

/**
 * @typedef {Object} TeamLogGroupJoinPolicyUpdatedType
 * @property {string} description
 */

/**
 * Group's logged information.
 * @typedef {Object} TeamLogGroupLogInfo
 * @property {string} display_name - The name of this group.
 * @property {string} [group_id] - The unique id of this group. Might be missing
 * due to historical data gap.
 * @property {string} [external_id] - External group ID. Might be missing due to
 * historical data gap.
 */

/**
 * Moved group.
 * @typedef {Object} TeamLogGroupMovedDetails
 */

/**
 * @typedef {Object} TeamLogGroupMovedType
 * @property {string} description
 */

/**
 * Removed external ID for group.
 * @typedef {Object} TeamLogGroupRemoveExternalIdDetails
 * @property {string} previous_value - Old external id.
 */

/**
 * @typedef {Object} TeamLogGroupRemoveExternalIdType
 * @property {string} description
 */

/**
 * Removed team members from group.
 * @typedef {Object} TeamLogGroupRemoveMemberDetails
 */

/**
 * @typedef {Object} TeamLogGroupRemoveMemberType
 * @property {string} description
 */

/**
 * Renamed group.
 * @typedef {Object} TeamLogGroupRenameDetails
 * @property {string} previous_value - Previous display name.
 * @property {string} new_value - New display name.
 */

/**
 * @typedef {Object} TeamLogGroupRenameType
 * @property {string} description
 */

/**
 * Changed who can create groups.
 * @typedef {Object} TeamLogGroupUserManagementChangePolicyDetails
 * @property {TeamPoliciesGroupCreation} new_value - New group users management
 * policy.
 * @property {TeamPoliciesGroupCreation} [previous_value] - Previous group users
 * management policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogGroupUserManagementChangePolicyType
 * @property {string} description
 */

/**
 * Changed guest team admin status.
 * @typedef {Object} TeamLogGuestAdminChangeStatusDetails
 * @property {boolean} is_guest - True for guest, false for host.
 * @property {TeamLogTrustedTeamsRequestState} previous_value - Previous request
 * state.
 * @property {TeamLogTrustedTeamsRequestState} new_value - New request state.
 * @property {TeamLogTrustedTeamsRequestAction} action_details - Action details.
 * @property {string} [guest_team_name] - The name of the guest team.
 * @property {string} [host_team_name] - The name of the host team.
 */

/**
 * @typedef {Object} TeamLogGuestAdminChangeStatusType
 * @property {string} description
 */

/**
 * Started trusted team admin session.
 * @typedef {Object} TeamLogGuestAdminSignedInViaTrustedTeamsDetails
 * @property {string} [team_name] - Host team name.
 * @property {string} [trusted_team_name] - Trusted team name.
 */

/**
 * @typedef {Object} TeamLogGuestAdminSignedInViaTrustedTeamsType
 * @property {string} description
 */

/**
 * Ended trusted team admin session.
 * @typedef {Object} TeamLogGuestAdminSignedOutViaTrustedTeamsDetails
 * @property {string} [team_name] - Host team name.
 * @property {string} [trusted_team_name] - Trusted team name.
 */

/**
 * @typedef {Object} TeamLogGuestAdminSignedOutViaTrustedTeamsType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogIdentifierType
 * @property {('email'|'facebook_profile_name'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Connected integration for member.
 * @typedef {Object} TeamLogIntegrationConnectedDetails
 * @property {string} integration_name - Name of the third-party integration.
 */

/**
 * @typedef {Object} TeamLogIntegrationConnectedType
 * @property {string} description
 */

/**
 * Disconnected integration for member.
 * @typedef {Object} TeamLogIntegrationDisconnectedDetails
 * @property {string} integration_name - Name of the third-party integration.
 */

/**
 * @typedef {Object} TeamLogIntegrationDisconnectedType
 * @property {string} description
 */

/**
 * Policy for controlling whether a service integration is enabled for the team.
 * @typedef {Object} TeamLogIntegrationPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed integration policy for team.
 * @typedef {Object} TeamLogIntegrationPolicyChangedDetails
 * @property {string} integration_name - Name of the third-party integration.
 * @property {TeamLogIntegrationPolicy} new_value - New integration policy.
 * @property {TeamLogIntegrationPolicy} previous_value - Previous integration
 * policy.
 */

/**
 * @typedef {Object} TeamLogIntegrationPolicyChangedType
 * @property {string} description
 */

/**
 * Additional information relevant when a new member joins the team.
 * @typedef {Object} TeamLogJoinTeamDetails
 * @property {Array.<TeamLogUserLinkedAppLogInfo>} linked_apps - Linked
 * applications.
 * @property {Array.<TeamLogLinkedDeviceLogInfo>} linked_devices - Linked
 * devices.
 * @property {Array.<TeamLogFolderLogInfo>} linked_shared_folders - Linked
 * shared folders.
 */

/**
 * Information on sessions, in legacy format
 * @typedef {Object} TeamLogLegacyDeviceSessionLogInfo
@property {'legacy_device_session'} [.tag] - Tag identifying this subtype
variant. This field is only present when needed to discriminate between multiple
possible subtypes.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {Timestamp} [created] - The time this session was created. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session. Might be missing due to historical data gap.
 * @property
 * {(TeamLogWebSessionLogInfo|TeamLogDesktopSessionLogInfo|TeamLogMobileSessionLogInfo|TeamLogSessionLogInfo)}
 * [session_info] - Session unique id. Might be missing due to historical data
 * gap.
 * @property {string} [display_name] - The device name. Might be missing due to
 * historical data gap.
 * @property {boolean} [is_emm_managed] - Is device managed by emm. Might be
 * missing due to historical data gap.
 * @property {string} [platform] - Information on the hosting platform. Might be
 * missing due to historical data gap.
 * @property {string} [mac_address] - The mac address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {string} [os_version] - The hosting OS version. Might be missing
 * due to historical data gap.
 * @property {string} [device_type] - Information on the hosting device type.
 * Might be missing due to historical data gap.
 * @property {string} [client_version] - The Dropbox client version. Might be
 * missing due to historical data gap.
 * @property {string} [legacy_uniq_id] - Alternative unique device session id,
 * instead of session id field. Might be missing due to historical data gap.
 */

/**
 * The device sessions that user is linked to.
 * @typedef {Object} TeamLogLinkedDeviceLogInfo
 * @property {TeamLogMobileDeviceSessionLogInfo} [mobile_device_session] -
 * Available if .tag is mobile_device_session. mobile device session's details.
 * @property {TeamLogDesktopDeviceSessionLogInfo} [desktop_device_session] -
 * Available if .tag is desktop_device_session. desktop device session's
 * details.
 * @property {TeamLogWebDeviceSessionLogInfo} [web_device_session] - Available
 * if .tag is web_device_session. web device session's details.
 * @property {TeamLogLegacyDeviceSessionLogInfo} [legacy_device_session] -
 * Available if .tag is legacy_device_session. legacy device session's details.
 * @property {('mobile_device_session'|'desktop_device_session'|'web_device_session'|'legacy_device_session'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Failed to sign in.
 * @typedef {Object} TeamLogLoginFailDetails
 * @property {TeamLogLoginMethod} login_method - Login method.
 * @property {TeamLogFailureDetailsLogInfo} error_details - Error details.
 * @property {boolean} [is_emm_managed] - Tells if the login device is EMM
 * managed. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogLoginFailType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogLoginMethod
 * @property {('password'|'two_factor_authentication'|'saml'|'google_oauth'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Signed in.
 * @typedef {Object} TeamLogLoginSuccessDetails
 * @property {TeamLogLoginMethod} login_method - Login method.
 * @property {boolean} [is_emm_managed] - Tells if the login device is EMM
 * managed. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogLoginSuccessType
 * @property {string} description
 */

/**
 * Signed out.
 * @typedef {Object} TeamLogLogoutDetails
 */

/**
 * @typedef {Object} TeamLogLogoutType
 * @property {string} description
 */

/**
 * Added an external ID for team member.
 * @typedef {Object} TeamLogMemberAddExternalIdDetails
 * @property {string} new_value - Current external id.
 */

/**
 * @typedef {Object} TeamLogMemberAddExternalIdType
 * @property {string} description
 */

/**
 * Added team member name.
 * @typedef {Object} TeamLogMemberAddNameDetails
 * @property {TeamLogUserNameLogInfo} new_value - New user's name.
 */

/**
 * @typedef {Object} TeamLogMemberAddNameType
 * @property {string} description
 */

/**
 * Changed team member admin role.
 * @typedef {Object} TeamLogMemberChangeAdminRoleDetails
 * @property {TeamLogAdminRole} [new_value] - New admin role. This field is
 * relevant when the admin role is changed or whenthe user role changes from no
 * admin rights to with admin rights.
 * @property {TeamLogAdminRole} [previous_value] - Previous admin role. This
 * field is relevant when the admin role is changed or when the admin role is
 * removed.
 */

/**
 * @typedef {Object} TeamLogMemberChangeAdminRoleType
 * @property {string} description
 */

/**
 * Changed team member email.
 * @typedef {Object} TeamLogMemberChangeEmailDetails
 * @property {string} new_value - New email.
 * @property {string} [previous_value] - Previous email. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogMemberChangeEmailType
 * @property {string} description
 */

/**
 * Changed the external ID for team member.
 * @typedef {Object} TeamLogMemberChangeExternalIdDetails
 * @property {string} new_value - Current external id.
 * @property {string} previous_value - Old external id.
 */

/**
 * @typedef {Object} TeamLogMemberChangeExternalIdType
 * @property {string} description
 */

/**
 * Changed membership type (limited/full) of member.
 * @typedef {Object} TeamLogMemberChangeMembershipTypeDetails
 * @property {TeamLogTeamMembershipType} prev_value - Previous membership type.
 * @property {TeamLogTeamMembershipType} new_value - New membership type.
 */

/**
 * @typedef {Object} TeamLogMemberChangeMembershipTypeType
 * @property {string} description
 */

/**
 * Changed team member name.
 * @typedef {Object} TeamLogMemberChangeNameDetails
 * @property {TeamLogUserNameLogInfo} new_value - New user's name.
 * @property {TeamLogUserNameLogInfo} [previous_value] - Previous user's name.
 * Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogMemberChangeNameType
 * @property {string} description
 */

/**
 * Changed member status (invited, joined, suspended, etc.).
 * @typedef {Object} TeamLogMemberChangeStatusDetails
 * @property {TeamLogMemberStatus} new_value - New member status.
 * @property {TeamLogMemberStatus} [previous_value] - Previous member status.
 * Might be missing due to historical data gap.
 * @property {TeamLogActionDetails} [action] - Additional information indicating
 * the action taken that caused status change.
 */

/**
 * @typedef {Object} TeamLogMemberChangeStatusType
 * @property {string} description
 */

/**
 * Cleared manually added contacts.
 * @typedef {Object} TeamLogMemberDeleteManualContactsDetails
 */

/**
 * @typedef {Object} TeamLogMemberDeleteManualContactsType
 * @property {string} description
 */

/**
 * Permanently deleted contents of deleted team member account.
 * @typedef {Object} TeamLogMemberPermanentlyDeleteAccountContentsDetails
 */

/**
 * @typedef {Object} TeamLogMemberPermanentlyDeleteAccountContentsType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogMemberRemoveActionType
 * @property {('delete'|'offboard'|'leave'|'offboard_and_retain_team_folders'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Removed the external ID for team member.
 * @typedef {Object} TeamLogMemberRemoveExternalIdDetails
 * @property {string} previous_value - Old external id.
 */

/**
 * @typedef {Object} TeamLogMemberRemoveExternalIdType
 * @property {string} description
 */

/**
 * Changed whether users can find team when not invited.
 * @typedef {Object} TeamLogMemberRequestsChangePolicyDetails
 * @property {TeamLogMemberRequestsPolicy} new_value - New member change
 * requests policy.
 * @property {TeamLogMemberRequestsPolicy} [previous_value] - Previous member
 * change requests policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogMemberRequestsChangePolicyType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogMemberRequestsPolicy
 * @property {('auto_accept'|'disabled'|'require_approval'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Set custom member space limit.
 * @typedef {Object} TeamLogMemberSpaceLimitsAddCustomQuotaDetails
 * @property {number} new_value - New custom quota value in bytes.
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsAddCustomQuotaType
 * @property {string} description
 */

/**
 * Added members to member space limit exception list.
 * @typedef {Object} TeamLogMemberSpaceLimitsAddExceptionDetails
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsAddExceptionType
 * @property {string} description
 */

/**
 * Changed member space limit type for team.
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeCapsTypePolicyDetails
 * @property {TeamLogSpaceCapsType} previous_value - Previous space limit type.
 * @property {TeamLogSpaceCapsType} new_value - New space limit type.
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeCapsTypePolicyType
 * @property {string} description
 */

/**
 * Changed custom member space limit.
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeCustomQuotaDetails
 * @property {number} previous_value - Previous custom quota value in bytes.
 * @property {number} new_value - New custom quota value in bytes.
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeCustomQuotaType
 * @property {string} description
 */

/**
 * Changed team default member space limit.
 * @typedef {Object} TeamLogMemberSpaceLimitsChangePolicyDetails
 * @property {number} [previous_value] - Previous team default limit value in
 * bytes. Might be missing due to historical data gap.
 * @property {number} [new_value] - New team default limit value in bytes. Might
 * be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsChangePolicyType
 * @property {string} description
 */

/**
 * Changed space limit status.
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeStatusDetails
 * @property {TeamLogSpaceLimitsStatus} previous_value - Previous storage quota
 * status.
 * @property {TeamLogSpaceLimitsStatus} new_value - New storage quota status.
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsChangeStatusType
 * @property {string} description
 */

/**
 * Removed custom member space limit.
 * @typedef {Object} TeamLogMemberSpaceLimitsRemoveCustomQuotaDetails
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsRemoveCustomQuotaType
 * @property {string} description
 */

/**
 * Removed members from member space limit exception list.
 * @typedef {Object} TeamLogMemberSpaceLimitsRemoveExceptionDetails
 */

/**
 * @typedef {Object} TeamLogMemberSpaceLimitsRemoveExceptionType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogMemberStatus
 * @property {('not_joined'|'invited'|'active'|'suspended'|'removed'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Suggested person to add to team.
 * @typedef {Object} TeamLogMemberSuggestDetails
 * @property {Array.<Object>} suggested_members - suggested users emails.
 */

/**
 * @typedef {Object} TeamLogMemberSuggestType
 * @property {string} description
 */

/**
 * Enabled/disabled option for team members to suggest people to add to team.
 * @typedef {Object} TeamLogMemberSuggestionsChangePolicyDetails
 * @property {TeamLogMemberSuggestionsPolicy} new_value - New team member
 * suggestions policy.
 * @property {TeamLogMemberSuggestionsPolicy} [previous_value] - Previous team
 * member suggestions policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogMemberSuggestionsChangePolicyType
 * @property {string} description
 */

/**
 * Member suggestions policy
 * @typedef {Object} TeamLogMemberSuggestionsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Transferred contents of deleted member account to another member.
 * @typedef {Object} TeamLogMemberTransferAccountContentsDetails
 */

/**
 * @typedef {Object} TeamLogMemberTransferAccountContentsType
 * @property {string} description
 */

/**
 * Enabled/disabled Microsoft Office add-in.
 * @typedef {Object} TeamLogMicrosoftOfficeAddinChangePolicyDetails
 * @property {TeamLogMicrosoftOfficeAddinPolicy} new_value - New Microsoft
 * Office addin policy.
 * @property {TeamLogMicrosoftOfficeAddinPolicy} [previous_value] - Previous
 * Microsoft Office addin policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogMicrosoftOfficeAddinChangePolicyType
 * @property {string} description
 */

/**
 * Microsoft Office addin policy
 * @typedef {Object} TeamLogMicrosoftOfficeAddinPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * An indication that an error occurred while retrieving the event. Some
 * attributes of the event may be omitted as a result.
 * @typedef {Object} TeamLogMissingDetails
 * @property {string} [source_event_fields] - All the data that could be
 * retrieved and converted from the source event.
 */

/**
 * Information about linked Dropbox mobile client sessions
 * @typedef {Object} TeamLogMobileDeviceSessionLogInfo
@property {'mobile_device_session'} [.tag] - Tag identifying this subtype
variant. This field is only present when needed to discriminate between multiple
possible subtypes.
 * @property {string} device_name - The device name.
 * @property {TeamMobileClientPlatform} client_type - The mobile application
 * type.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {Timestamp} [created] - The time this session was created. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session. Might be missing due to historical data gap.
 * @property {TeamLogMobileSessionLogInfo} [session_info] - Mobile session
 * unique id. Might be missing due to historical data gap.
 * @property {string} [client_version] - The Dropbox client version.
 * @property {string} [os_version] - The hosting OS version.
 * @property {string} [last_carrier] - last carrier used by the device.
 */

/**
 * Mobile session.
 * @typedef {Object} TeamLogMobileSessionLogInfo
@property {'mobile'} [.tag] - Tag identifying this subtype variant. This field
is only present when needed to discriminate between multiple possible subtypes.
 * @property {string} [session_id] - Session ID. Might be missing due to
 * historical data gap.
 */

/**
 * Namespace relative path details.
 * @typedef {Object} TeamLogNamespaceRelativePathLogInfo
 * @property {string} [ns_id] - Namespace ID. Might be missing due to historical
 * data gap.
 * @property {string} [relative_path] - A path relative to the specified
 * namespace ID. Might be missing due to historical data gap.
 */

/**
 * Enabled/disabled network control.
 * @typedef {Object} TeamLogNetworkControlChangePolicyDetails
 * @property {TeamLogNetworkControlPolicy} new_value - New network control
 * policy.
 * @property {TeamLogNetworkControlPolicy} [previous_value] - Previous network
 * control policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogNetworkControlChangePolicyType
 * @property {string} description
 */

/**
 * Network control policy
 * @typedef {Object} TeamLogNetworkControlPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Non team member's logged information.
 * @typedef {Object} TeamLogNonTeamMemberLogInfo
@property {'non_team_member'} [.tag] - Tag identifying this subtype variant.
This field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} [account_id] - User unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - User display name. Might be missing due
 * to historical data gap.
 * @property {string} [email] - User email address. Might be missing due to
 * historical data gap.
 */

/**
 * Changed Paper doc to invite-only.
 * @typedef {Object} TeamLogNoteAclInviteOnlyDetails
 */

/**
 * @typedef {Object} TeamLogNoteAclInviteOnlyType
 * @property {string} description
 */

/**
 * Changed Paper doc to link-accessible.
 * @typedef {Object} TeamLogNoteAclLinkDetails
 */

/**
 * @typedef {Object} TeamLogNoteAclLinkType
 * @property {string} description
 */

/**
 * Changed Paper doc to link-accessible for team.
 * @typedef {Object} TeamLogNoteAclTeamLinkDetails
 */

/**
 * @typedef {Object} TeamLogNoteAclTeamLinkType
 * @property {string} description
 */

/**
 * Shared received Paper doc.
 * @typedef {Object} TeamLogNoteShareReceiveDetails
 */

/**
 * @typedef {Object} TeamLogNoteShareReceiveType
 * @property {string} description
 */

/**
 * Shared Paper doc.
 * @typedef {Object} TeamLogNoteSharedDetails
 */

/**
 * @typedef {Object} TeamLogNoteSharedType
 * @property {string} description
 */

/**
 * Opened shared Paper doc.
 * @typedef {Object} TeamLogOpenNoteSharedDetails
 */

/**
 * @typedef {Object} TeamLogOpenNoteSharedType
 * @property {string} description
 */

/**
 * The origin from which the actor performed the action.
 * @typedef {Object} TeamLogOriginLogInfo
 * @property {TeamLogAccessMethodLogInfo} access_method - The method that was
 * used to perform the action.
 * @property {TeamLogGeoLocationLogInfo} [geo_location] - Geographic location
 * details.
 */

/**
 * @typedef {Object} TeamLogPaperAccessType
 * @property {('viewer'|'commenter'|'editor'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Exported all team Paper docs.
 * @typedef {Object} TeamLogPaperAdminExportStartDetails
 */

/**
 * @typedef {Object} TeamLogPaperAdminExportStartType
 * @property {string} description
 */

/**
 * Changed whether Dropbox Paper, when enabled, is deployed to all members or to
 * specific members.
 * @typedef {Object} TeamLogPaperChangeDeploymentPolicyDetails
 * @property {TeamPoliciesPaperDeploymentPolicy} new_value - New Dropbox Paper
 * deployment policy.
 * @property {TeamPoliciesPaperDeploymentPolicy} [previous_value] - Previous
 * Dropbox Paper deployment policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperChangeDeploymentPolicyType
 * @property {string} description
 */

/**
 * Changed whether non-members can view Paper docs with link.
 * @typedef {Object} TeamLogPaperChangeMemberLinkPolicyDetails
 * @property {TeamLogPaperMemberPolicy} new_value - New paper external link
 * accessibility policy.
 */

/**
 * @typedef {Object} TeamLogPaperChangeMemberLinkPolicyType
 * @property {string} description
 */

/**
 * Changed whether members can share Paper docs outside team, and if docs are
 * accessible only by team members or anyone by default.
 * @typedef {Object} TeamLogPaperChangeMemberPolicyDetails
 * @property {TeamLogPaperMemberPolicy} new_value - New paper external
 * accessibility policy.
 * @property {TeamLogPaperMemberPolicy} [previous_value] - Previous paper
 * external accessibility policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperChangeMemberPolicyType
 * @property {string} description
 */

/**
 * Enabled/disabled Dropbox Paper for team.
 * @typedef {Object} TeamLogPaperChangePolicyDetails
 * @property {TeamPoliciesPaperEnabledPolicy} new_value - New Dropbox Paper
 * policy.
 * @property {TeamPoliciesPaperEnabledPolicy} [previous_value] - Previous
 * Dropbox Paper policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperChangePolicyType
 * @property {string} description
 */

/**
 * Added team member to Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentAddMemberDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentAddMemberType
 * @property {string} description
 */

/**
 * Added Paper doc/folder to folder.
 * @typedef {Object} TeamLogPaperContentAddToFolderDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {number} parent_asset_index - Parent asset position in the Assets
 * list.
 */

/**
 * @typedef {Object} TeamLogPaperContentAddToFolderType
 * @property {string} description
 */

/**
 * Archived Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentArchiveDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentArchiveType
 * @property {string} description
 */

/**
 * Created Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentCreateDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentCreateType
 * @property {string} description
 */

/**
 * Permanently deleted Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentPermanentlyDeleteDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentPermanentlyDeleteType
 * @property {string} description
 */

/**
 * Removed Paper doc/folder from folder.
 * @typedef {Object} TeamLogPaperContentRemoveFromFolderDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {number} parent_asset_index - Parent asset position in the Assets
 * list.
 */

/**
 * @typedef {Object} TeamLogPaperContentRemoveFromFolderType
 * @property {string} description
 */

/**
 * Removed team member from Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentRemoveMemberDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentRemoveMemberType
 * @property {string} description
 */

/**
 * Renamed Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentRenameDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentRenameType
 * @property {string} description
 */

/**
 * Restored archived Paper doc/folder.
 * @typedef {Object} TeamLogPaperContentRestoreDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperContentRestoreType
 * @property {string} description
 */

/**
 * Policy to set default access for newly created Paper folders.
 * @typedef {Object} TeamLogPaperDefaultFolderPolicy
 * @property {('everyone_in_team'|'invite_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed Paper Default Folder Policy setting for team.
 * @typedef {Object} TeamLogPaperDefaultFolderPolicyChangedDetails
 * @property {TeamLogPaperDefaultFolderPolicy} new_value - New Paper Default
 * Folder Policy.
 * @property {TeamLogPaperDefaultFolderPolicy} previous_value - Previous Paper
 * Default Folder Policy.
 */

/**
 * @typedef {Object} TeamLogPaperDefaultFolderPolicyChangedType
 * @property {string} description
 */

/**
 * Policy for controlling if team members can use Paper Desktop
 * @typedef {Object} TeamLogPaperDesktopPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Enabled/disabled Paper Desktop for team.
 * @typedef {Object} TeamLogPaperDesktopPolicyChangedDetails
 * @property {TeamLogPaperDesktopPolicy} new_value - New Paper Desktop policy.
 * @property {TeamLogPaperDesktopPolicy} previous_value - Previous Paper Desktop
 * policy.
 */

/**
 * @typedef {Object} TeamLogPaperDesktopPolicyChangedType
 * @property {string} description
 */

/**
 * Added Paper doc comment.
 * @typedef {Object} TeamLogPaperDocAddCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocAddCommentType
 * @property {string} description
 */

/**
 * Changed team member permissions for Paper doc.
 * @typedef {Object} TeamLogPaperDocChangeMemberRoleDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {TeamLogPaperAccessType} access_type - Paper doc access type.
 */

/**
 * @typedef {Object} TeamLogPaperDocChangeMemberRoleType
 * @property {string} description
 */

/**
 * Changed sharing setting for Paper doc.
 * @typedef {Object} TeamLogPaperDocChangeSharingPolicyDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [public_sharing_policy] - Sharing policy with external
 * users. Might be missing due to historical data gap.
 * @property {string} [team_sharing_policy] - Sharing policy with team. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocChangeSharingPolicyType
 * @property {string} description
 */

/**
 * Followed/unfollowed Paper doc.
 * @typedef {Object} TeamLogPaperDocChangeSubscriptionDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} new_subscription_level - New doc subscription level.
 * @property {string} [previous_subscription_level] - Previous doc subscription
 * level. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocChangeSubscriptionType
 * @property {string} description
 */

/**
 * Deleted Paper doc comment.
 * @typedef {Object} TeamLogPaperDocDeleteCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocDeleteCommentType
 * @property {string} description
 */

/**
 * Archived Paper doc.
 * @typedef {Object} TeamLogPaperDocDeletedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocDeletedType
 * @property {string} description
 */

/**
 * Downloaded Paper doc in specific format.
 * @typedef {Object} TeamLogPaperDocDownloadDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {TeamLogPaperDownloadFormat} export_file_format - Export file
 * format.
 */

/**
 * @typedef {Object} TeamLogPaperDocDownloadType
 * @property {string} description
 */

/**
 * Edited Paper doc comment.
 * @typedef {Object} TeamLogPaperDocEditCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocEditCommentType
 * @property {string} description
 */

/**
 * Edited Paper doc.
 * @typedef {Object} TeamLogPaperDocEditDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocEditType
 * @property {string} description
 */

/**
 * Followed Paper doc.
 * @typedef {Object} TeamLogPaperDocFollowedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocFollowedType
 * @property {string} description
 */

/**
 * Mentioned team member in Paper doc.
 * @typedef {Object} TeamLogPaperDocMentionDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocMentionType
 * @property {string} description
 */

/**
 * Transferred ownership of Paper doc.
 * @typedef {Object} TeamLogPaperDocOwnershipChangedDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} new_owner_user_id - New owner.
 * @property {string} [old_owner_user_id] - Previous owner.
 */

/**
 * @typedef {Object} TeamLogPaperDocOwnershipChangedType
 * @property {string} description
 */

/**
 * Requested access to Paper doc.
 * @typedef {Object} TeamLogPaperDocRequestAccessDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocRequestAccessType
 * @property {string} description
 */

/**
 * Resolved Paper doc comment.
 * @typedef {Object} TeamLogPaperDocResolveCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocResolveCommentType
 * @property {string} description
 */

/**
 * Restored Paper doc to previous version.
 * @typedef {Object} TeamLogPaperDocRevertDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocRevertType
 * @property {string} description
 */

/**
 * Shared Paper doc via Slack.
 * @typedef {Object} TeamLogPaperDocSlackShareDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocSlackShareType
 * @property {string} description
 */

/**
 * Shared Paper doc with team member.
 * @typedef {Object} TeamLogPaperDocTeamInviteDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocTeamInviteType
 * @property {string} description
 */

/**
 * Deleted Paper doc.
 * @typedef {Object} TeamLogPaperDocTrashedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocTrashedType
 * @property {string} description
 */

/**
 * Unresolved Paper doc comment.
 * @typedef {Object} TeamLogPaperDocUnresolveCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperDocUnresolveCommentType
 * @property {string} description
 */

/**
 * Restored Paper doc.
 * @typedef {Object} TeamLogPaperDocUntrashedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocUntrashedType
 * @property {string} description
 */

/**
 * Viewed Paper doc.
 * @typedef {Object} TeamLogPaperDocViewDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperDocViewType
 * @property {string} description
 */

/**
 * Paper document's logged information.
 * @typedef {Object} TeamLogPaperDocumentLogInfo
 * @property {string} doc_id - Papers document Id.
 * @property {string} doc_title - Paper document title.
 */

/**
 * @typedef {Object} TeamLogPaperDownloadFormat
 * @property {('docx'|'html'|'markdown'|'pdf'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added users to Paper-enabled users list.
 * @typedef {Object} TeamLogPaperEnabledUsersGroupAdditionDetails
 */

/**
 * @typedef {Object} TeamLogPaperEnabledUsersGroupAdditionType
 * @property {string} description
 */

/**
 * Removed users from Paper-enabled users list.
 * @typedef {Object} TeamLogPaperEnabledUsersGroupRemovalDetails
 */

/**
 * @typedef {Object} TeamLogPaperEnabledUsersGroupRemovalType
 * @property {string} description
 */

/**
 * Changed Paper external sharing setting to anyone.
 * @typedef {Object} TeamLogPaperExternalViewAllowDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperExternalViewAllowType
 * @property {string} description
 */

/**
 * Changed Paper external sharing setting to default team.
 * @typedef {Object} TeamLogPaperExternalViewDefaultTeamDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperExternalViewDefaultTeamType
 * @property {string} description
 */

/**
 * Changed Paper external sharing setting to team-only.
 * @typedef {Object} TeamLogPaperExternalViewForbidDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperExternalViewForbidType
 * @property {string} description
 */

/**
 * Followed/unfollowed Paper folder.
 * @typedef {Object} TeamLogPaperFolderChangeSubscriptionDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} new_subscription_level - New folder subscription level.
 * @property {string} [previous_subscription_level] - Previous folder
 * subscription level. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPaperFolderChangeSubscriptionType
 * @property {string} description
 */

/**
 * Archived Paper folder.
 * @typedef {Object} TeamLogPaperFolderDeletedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperFolderDeletedType
 * @property {string} description
 */

/**
 * Followed Paper folder.
 * @typedef {Object} TeamLogPaperFolderFollowedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperFolderFollowedType
 * @property {string} description
 */

/**
 * Paper folder's logged information.
 * @typedef {Object} TeamLogPaperFolderLogInfo
 * @property {string} folder_id - Papers folder Id.
 * @property {string} folder_name - Paper folder name.
 */

/**
 * Shared Paper folder with member.
 * @typedef {Object} TeamLogPaperFolderTeamInviteDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperFolderTeamInviteType
 * @property {string} description
 */

/**
 * Policy for controlling if team members can share Paper documents externally.
 * @typedef {Object} TeamLogPaperMemberPolicy
 * @property {('anyone_with_link'|'only_team'|'team_and_explicitly_shared'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Published doc.
 * @typedef {Object} TeamLogPaperPublishedLinkCreateDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperPublishedLinkCreateType
 * @property {string} description
 */

/**
 * Unpublished doc.
 * @typedef {Object} TeamLogPaperPublishedLinkDisabledDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperPublishedLinkDisabledType
 * @property {string} description
 */

/**
 * Viewed published doc.
 * @typedef {Object} TeamLogPaperPublishedLinkViewDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogPaperPublishedLinkViewType
 * @property {string} description
 */

/**
 * A user or group
 * @typedef {Object} TeamLogParticipantLogInfo
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [user] - Available if .tag is user. A user with a Dropbox account.
 * @property {TeamLogGroupLogInfo} [group] - Available if .tag is group. Group
 * details.
 * @property {('user'|'group'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogPassPolicy
 * @property {('enabled'|'allow'|'disabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed password.
 * @typedef {Object} TeamLogPasswordChangeDetails
 */

/**
 * @typedef {Object} TeamLogPasswordChangeType
 * @property {string} description
 */

/**
 * Reset all team member passwords.
 * @typedef {Object} TeamLogPasswordResetAllDetails
 */

/**
 * @typedef {Object} TeamLogPasswordResetAllType
 * @property {string} description
 */

/**
 * Reset password.
 * @typedef {Object} TeamLogPasswordResetDetails
 */

/**
 * @typedef {Object} TeamLogPasswordResetType
 * @property {string} description
 */

/**
 * Path's details.
 * @typedef {Object} TeamLogPathLogInfo
 * @property {TeamLogNamespaceRelativePathLogInfo} namespace_relative - Path
 * relative to the namespace containing the content.
 * @property {string} [contextual] - Fully qualified path relative to event's
 * context. Might be missing due to historical data gap.
 */

/**
 * Enabled/disabled ability of team members to permanently delete content.
 * @typedef {Object} TeamLogPermanentDeleteChangePolicyDetails
 * @property {TeamLogContentPermanentDeletePolicy} new_value - New permanent
 * delete content policy.
 * @property {TeamLogContentPermanentDeletePolicy} [previous_value] - Previous
 * permanent delete content policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogPermanentDeleteChangePolicyType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogPlacementRestriction
 * @property {('australia_only'|'europe_only'|'japan_only'|'none'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Team merge request acceptance details shown to the primary team
 * @typedef {Object} TeamLogPrimaryTeamRequestAcceptedDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * Team merge request cancellation details shown to the primary team
 * @typedef {Object} TeamLogPrimaryTeamRequestCanceledDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * Team merge request expiration details shown to the primary team
 * @typedef {Object} TeamLogPrimaryTeamRequestExpiredDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * Team merge request reminder details shown to the primary team
 * @typedef {Object} TeamLogPrimaryTeamRequestReminderDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_to - The name of the primary team admin the request
 * was sent to.
 */

/**
 * Quick action type.
 * @typedef {Object} TeamLogQuickActionType
 * @property {('delete_shared_link'|'reset_password'|'restore_file_or_folder'|'unlink_app'|'unlink_session'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Provides the indices of the source asset and the destination asset for a
 * relocate action.
 * @typedef {Object} TeamLogRelocateAssetReferencesLogInfo
 * @property {number} src_asset_index - Source asset position in the Assets
 * list.
 * @property {number} dest_asset_index - Destination asset position in the
 * Assets list.
 */

/**
 * Reseller information.
 * @typedef {Object} TeamLogResellerLogInfo
 * @property {string} reseller_name - Reseller name.
 * @property {string} reseller_email - Reseller email.
 */

/**
 * Enabled/disabled reseller support.
 * @typedef {Object} TeamLogResellerSupportChangePolicyDetails
 * @property {TeamLogResellerSupportPolicy} new_value - New Reseller support
 * policy.
 * @property {TeamLogResellerSupportPolicy} previous_value - Previous Reseller
 * support policy.
 */

/**
 * @typedef {Object} TeamLogResellerSupportChangePolicyType
 * @property {string} description
 */

/**
 * Policy for controlling if reseller can access the admin console as
 * administrator
 * @typedef {Object} TeamLogResellerSupportPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Ended reseller support session.
 * @typedef {Object} TeamLogResellerSupportSessionEndDetails
 */

/**
 * @typedef {Object} TeamLogResellerSupportSessionEndType
 * @property {string} description
 */

/**
 * Started reseller support session.
 * @typedef {Object} TeamLogResellerSupportSessionStartDetails
 */

/**
 * @typedef {Object} TeamLogResellerSupportSessionStartType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogSecondaryMailsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Secondary mails policy changed.
 * @typedef {Object} TeamLogSecondaryMailsPolicyChangedDetails
 * @property {TeamLogSecondaryMailsPolicy} previous_value - Previous secondary
 * mails policy.
 * @property {TeamLogSecondaryMailsPolicy} new_value - New secondary mails
 * policy.
 */

/**
 * @typedef {Object} TeamLogSecondaryMailsPolicyChangedType
 * @property {string} description
 */

/**
 * Team merge request acceptance details shown to the secondary team
 * @typedef {Object} TeamLogSecondaryTeamRequestAcceptedDetails
 * @property {string} primary_team - The primary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * Team merge request cancellation details shown to the secondary team
 * @typedef {Object} TeamLogSecondaryTeamRequestCanceledDetails
 * @property {string} sent_to - The email of the primary team admin that the
 * request was sent to.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * Team merge request expiration details shown to the secondary team
 * @typedef {Object} TeamLogSecondaryTeamRequestExpiredDetails
 * @property {string} sent_to - The email of the primary team admin the request
 * was sent to.
 */

/**
 * Team merge request reminder details shown to the secondary team
 * @typedef {Object} TeamLogSecondaryTeamRequestReminderDetails
 * @property {string} sent_to - The email of the primary team admin the request
 * was sent to.
 */

/**
 * Session's logged information.
 * @typedef {Object} TeamLogSessionLogInfo
@property {("web"|"desktop"|"mobile")} .tag - Tag identifying the subtype
variant.
 * @property {string} [session_id] - Session ID. Might be missing due to
 * historical data gap.
 */

/**
 * Added team to shared folder.
 * @typedef {Object} TeamLogSfAddGroupDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} team_name - Team name.
 * @property {string} [sharing_permission] - Sharing permission. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfAddGroupType
 * @property {string} description
 */

/**
 * Allowed non-collaborators to view links to files in shared folder.
 * @typedef {Object} TeamLogSfAllowNonMembersToViewSharedLinksDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [shared_folder_type] - Shared folder type. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfAllowNonMembersToViewSharedLinksType
 * @property {string} description
 */

/**
 * Set team members to see warning before sharing folders outside team.
 * @typedef {Object} TeamLogSfExternalInviteWarnDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [new_sharing_permission] - New sharing permission. Might
 * be missing due to historical data gap.
 * @property {string} [previous_sharing_permission] - Previous sharing
 * permission. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfExternalInviteWarnType
 * @property {string} description
 */

/**
 * Changed Facebook user's role in shared folder.
 * @typedef {Object} TeamLogSfFbInviteChangeRoleDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [previous_sharing_permission] - Previous sharing
 * permission. Might be missing due to historical data gap.
 * @property {string} [new_sharing_permission] - New sharing permission. Might
 * be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfFbInviteChangeRoleType
 * @property {string} description
 */

/**
 * Invited Facebook users to shared folder.
 * @typedef {Object} TeamLogSfFbInviteDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [sharing_permission] - Sharing permission. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfFbInviteType
 * @property {string} description
 */

/**
 * Uninvited Facebook user from shared folder.
 * @typedef {Object} TeamLogSfFbUninviteDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 */

/**
 * @typedef {Object} TeamLogSfFbUninviteType
 * @property {string} description
 */

/**
 * Invited group to shared folder.
 * @typedef {Object} TeamLogSfInviteGroupDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 */

/**
 * @typedef {Object} TeamLogSfInviteGroupType
 * @property {string} description
 */

/**
 * Granted access to shared folder.
 * @typedef {Object} TeamLogSfTeamGrantAccessDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 */

/**
 * @typedef {Object} TeamLogSfTeamGrantAccessType
 * @property {string} description
 */

/**
 * Changed team member's role in shared folder.
 * @typedef {Object} TeamLogSfTeamInviteChangeRoleDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [new_sharing_permission] - New sharing permission. Might
 * be missing due to historical data gap.
 * @property {string} [previous_sharing_permission] - Previous sharing
 * permission. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfTeamInviteChangeRoleType
 * @property {string} description
 */

/**
 * Invited team members to shared folder.
 * @typedef {Object} TeamLogSfTeamInviteDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [sharing_permission] - Sharing permission. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfTeamInviteType
 * @property {string} description
 */

/**
 * Joined team member's shared folder.
 * @typedef {Object} TeamLogSfTeamJoinDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 */

/**
 * Joined team member's shared folder from link.
 * @typedef {Object} TeamLogSfTeamJoinFromOobLinkDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 * @property {string} [token_key] - Shared link token key.
 * @property {string} [sharing_permission] - Sharing permission. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSfTeamJoinFromOobLinkType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogSfTeamJoinType
 * @property {string} description
 */

/**
 * Unshared folder with team member.
 * @typedef {Object} TeamLogSfTeamUninviteDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 * @property {string} original_folder_name - Original shared folder name.
 */

/**
 * @typedef {Object} TeamLogSfTeamUninviteType
 * @property {string} description
 */

/**
 * Invited user to Dropbox and added them to shared file/folder.
 * @typedef {Object} TeamLogSharedContentAddInviteesDetails
 * @property {SharingAccessLevel} shared_content_access_level - Shared content
 * access level.
 * @property {Array.<Object>} invitees - A list of invitees.
 */

/**
 * @typedef {Object} TeamLogSharedContentAddInviteesType
 * @property {string} description
 */

/**
 * Added expiration date to link for shared file/folder.
 * @typedef {Object} TeamLogSharedContentAddLinkExpiryDetails
 * @property {Timestamp} [new_value] - New shared content link expiration date.
 * Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentAddLinkExpiryType
 * @property {string} description
 */

/**
 * Added password to link for shared file/folder.
 * @typedef {Object} TeamLogSharedContentAddLinkPasswordDetails
 */

/**
 * @typedef {Object} TeamLogSharedContentAddLinkPasswordType
 * @property {string} description
 */

/**
 * Added users and/or groups to shared file/folder.
 * @typedef {Object} TeamLogSharedContentAddMemberDetails
 * @property {SharingAccessLevel} shared_content_access_level - Shared content
 * access level.
 */

/**
 * @typedef {Object} TeamLogSharedContentAddMemberType
 * @property {string} description
 */

/**
 * Changed whether members can download shared file/folder.
 * @typedef {Object} TeamLogSharedContentChangeDownloadsPolicyDetails
 * @property {TeamLogDownloadPolicyType} new_value - New downloads policy.
 * @property {TeamLogDownloadPolicyType} [previous_value] - Previous downloads
 * policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeDownloadsPolicyType
 * @property {string} description
 */

/**
 * Changed access type of invitee to shared file/folder before invite was
 * accepted.
 * @typedef {Object} TeamLogSharedContentChangeInviteeRoleDetails
 * @property {SharingAccessLevel} new_access_level - New access level.
 * @property {string} invitee - The invitee whose role was changed.
 * @property {SharingAccessLevel} [previous_access_level] - Previous access
 * level. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeInviteeRoleType
 * @property {string} description
 */

/**
 * Changed link audience of shared file/folder.
 * @typedef {Object} TeamLogSharedContentChangeLinkAudienceDetails
 * @property {SharingLinkAudience} new_value - New link audience value.
 * @property {SharingLinkAudience} [previous_value] - Previous link audience
 * value.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeLinkAudienceType
 * @property {string} description
 */

/**
 * Changed link expiration of shared file/folder.
 * @typedef {Object} TeamLogSharedContentChangeLinkExpiryDetails
 * @property {Timestamp} [new_value] - New shared content link expiration date.
 * Might be missing due to historical data gap.
 * @property {Timestamp} [previous_value] - Previous shared content link
 * expiration date. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeLinkExpiryType
 * @property {string} description
 */

/**
 * Changed link password of shared file/folder.
 * @typedef {Object} TeamLogSharedContentChangeLinkPasswordDetails
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeLinkPasswordType
 * @property {string} description
 */

/**
 * Changed access type of shared file/folder member.
 * @typedef {Object} TeamLogSharedContentChangeMemberRoleDetails
 * @property {SharingAccessLevel} new_access_level - New access level.
 * @property {SharingAccessLevel} [previous_access_level] - Previous access
 * level. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeMemberRoleType
 * @property {string} description
 */

/**
 * Changed whether members can see who viewed shared file/folder.
 * @typedef {Object} TeamLogSharedContentChangeViewerInfoPolicyDetails
 * @property {SharingViewerInfoPolicy} new_value - New viewer info policy.
 * @property {SharingViewerInfoPolicy} [previous_value] - Previous view info
 * policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentChangeViewerInfoPolicyType
 * @property {string} description
 */

/**
 * Acquired membership of shared file/folder by accepting invite.
 * @typedef {Object} TeamLogSharedContentClaimInvitationDetails
 * @property {string} [shared_content_link] - Shared content link.
 */

/**
 * @typedef {Object} TeamLogSharedContentClaimInvitationType
 * @property {string} description
 */

/**
 * Copied shared file/folder to own Dropbox.
 * @typedef {Object} TeamLogSharedContentCopyDetails
 * @property {string} shared_content_link - Shared content link.
 * @property {SharingAccessLevel} shared_content_access_level - Shared content
 * access level.
 * @property {string} destination_path - The path where the member saved the
 * content.
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_content_owner] - The shared content owner.
 */

/**
 * @typedef {Object} TeamLogSharedContentCopyType
 * @property {string} description
 */

/**
 * Downloaded shared file/folder.
 * @typedef {Object} TeamLogSharedContentDownloadDetails
 * @property {string} shared_content_link - Shared content link.
 * @property {SharingAccessLevel} shared_content_access_level - Shared content
 * access level.
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_content_owner] - The shared content owner.
 */

/**
 * @typedef {Object} TeamLogSharedContentDownloadType
 * @property {string} description
 */

/**
 * Left shared file/folder.
 * @typedef {Object} TeamLogSharedContentRelinquishMembershipDetails
 */

/**
 * @typedef {Object} TeamLogSharedContentRelinquishMembershipType
 * @property {string} description
 */

/**
 * Removed invitee from shared file/folder before invite was accepted.
 * @typedef {Object} TeamLogSharedContentRemoveInviteesDetails
 * @property {Array.<Object>} invitees - A list of invitees.
 */

/**
 * @typedef {Object} TeamLogSharedContentRemoveInviteesType
 * @property {string} description
 */

/**
 * Removed link expiration date of shared file/folder.
 * @typedef {Object} TeamLogSharedContentRemoveLinkExpiryDetails
 * @property {Timestamp} [previous_value] - Previous shared content link
 * expiration date. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedContentRemoveLinkExpiryType
 * @property {string} description
 */

/**
 * Removed link password of shared file/folder.
 * @typedef {Object} TeamLogSharedContentRemoveLinkPasswordDetails
 */

/**
 * @typedef {Object} TeamLogSharedContentRemoveLinkPasswordType
 * @property {string} description
 */

/**
 * Removed user/group from shared file/folder.
 * @typedef {Object} TeamLogSharedContentRemoveMemberDetails
 * @property {SharingAccessLevel} [shared_content_access_level] - Shared content
 * access level.
 */

/**
 * @typedef {Object} TeamLogSharedContentRemoveMemberType
 * @property {string} description
 */

/**
 * Requested access to shared file/folder.
 * @typedef {Object} TeamLogSharedContentRequestAccessDetails
 * @property {string} [shared_content_link] - Shared content link.
 */

/**
 * @typedef {Object} TeamLogSharedContentRequestAccessType
 * @property {string} description
 */

/**
 * Unshared file/folder by clearing membership and turning off link.
 * @typedef {Object} TeamLogSharedContentUnshareDetails
 */

/**
 * @typedef {Object} TeamLogSharedContentUnshareType
 * @property {string} description
 */

/**
 * Previewed shared file/folder.
 * @typedef {Object} TeamLogSharedContentViewDetails
 * @property {string} shared_content_link - Shared content link.
 * @property {SharingAccessLevel} shared_content_access_level - Shared content
 * access level.
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_content_owner] - The shared content owner.
 */

/**
 * @typedef {Object} TeamLogSharedContentViewType
 * @property {string} description
 */

/**
 * Changed who can access shared folder via link.
 * @typedef {Object} TeamLogSharedFolderChangeLinkPolicyDetails
 * @property {SharingSharedLinkPolicy} new_value - New shared folder link
 * policy.
 * @property {SharingSharedLinkPolicy} [previous_value] - Previous shared folder
 * link policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderChangeLinkPolicyType
 * @property {string} description
 */

/**
 * Changed whether shared folder inherits members from parent folder.
 * @typedef {Object} TeamLogSharedFolderChangeMembersInheritancePolicyDetails
 * @property {TeamLogSharedFolderMembersInheritancePolicy} new_value - New
 * member inheritance policy.
 * @property {TeamLogSharedFolderMembersInheritancePolicy} [previous_value] -
 * Previous member inheritance policy. Might be missing due to historical data
 * gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderChangeMembersInheritancePolicyType
 * @property {string} description
 */

/**
 * Changed who can add/remove members of shared folder.
 * @typedef {Object} TeamLogSharedFolderChangeMembersManagementPolicyDetails
 * @property {SharingAclUpdatePolicy} new_value - New members management policy.
 * @property {SharingAclUpdatePolicy} [previous_value] - Previous members
 * management policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderChangeMembersManagementPolicyType
 * @property {string} description
 */

/**
 * Changed who can become member of shared folder.
 * @typedef {Object} TeamLogSharedFolderChangeMembersPolicyDetails
 * @property {SharingMemberPolicy} new_value - New external invite policy.
 * @property {SharingMemberPolicy} [previous_value] - Previous external invite
 * policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderChangeMembersPolicyType
 * @property {string} description
 */

/**
 * Created shared folder.
 * @typedef {Object} TeamLogSharedFolderCreateDetails
 * @property {string} [target_ns_id] - Target namespace ID. Might be missing due
 * to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderCreateType
 * @property {string} description
 */

/**
 * Declined team member's invite to shared folder.
 * @typedef {Object} TeamLogSharedFolderDeclineInvitationDetails
 */

/**
 * @typedef {Object} TeamLogSharedFolderDeclineInvitationType
 * @property {string} description
 */

/**
 * Specifies if a shared folder inherits its members from the parent folder.
 * @typedef {Object} TeamLogSharedFolderMembersInheritancePolicy
 * @property {('inherit_members'|'dont_inherit_members'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added shared folder to own Dropbox.
 * @typedef {Object} TeamLogSharedFolderMountDetails
 */

/**
 * @typedef {Object} TeamLogSharedFolderMountType
 * @property {string} description
 */

/**
 * Changed parent of shared folder.
 * @typedef {Object} TeamLogSharedFolderNestDetails
 * @property {string} [previous_parent_ns_id] - Previous parent namespace ID.
 * Might be missing due to historical data gap.
 * @property {string} [new_parent_ns_id] - New parent namespace ID. Might be
 * missing due to historical data gap.
 * @property {string} [previous_ns_path] - Previous namespace path. Might be
 * missing due to historical data gap.
 * @property {string} [new_ns_path] - New namespace path. Might be missing due
 * to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedFolderNestType
 * @property {string} description
 */

/**
 * Transferred ownership of shared folder to another member.
 * @typedef {Object} TeamLogSharedFolderTransferOwnershipDetails
 * @property {string} new_owner_email - The email address of the new shared
 * folder owner.
 * @property {string} [previous_owner_email] - The email address of the previous
 * shared folder owner.
 */

/**
 * @typedef {Object} TeamLogSharedFolderTransferOwnershipType
 * @property {string} description
 */

/**
 * Deleted shared folder from Dropbox.
 * @typedef {Object} TeamLogSharedFolderUnmountDetails
 */

/**
 * @typedef {Object} TeamLogSharedFolderUnmountType
 * @property {string} description
 */

/**
 * Shared link access level.
 * @typedef {Object} TeamLogSharedLinkAccessLevel
 * @property {('none'|'reader'|'writer'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added shared link expiration date.
 * @typedef {Object} TeamLogSharedLinkAddExpiryDetails
 * @property {Timestamp} new_value - New shared link expiration date.
 */

/**
 * @typedef {Object} TeamLogSharedLinkAddExpiryType
 * @property {string} description
 */

/**
 * Changed shared link expiration date.
 * @typedef {Object} TeamLogSharedLinkChangeExpiryDetails
 * @property {Timestamp} [new_value] - New shared link expiration date. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [previous_value] - Previous shared link expiration
 * date. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkChangeExpiryType
 * @property {string} description
 */

/**
 * Changed visibility of shared link.
 * @typedef {Object} TeamLogSharedLinkChangeVisibilityDetails
 * @property {TeamLogSharedLinkVisibility} new_value - New shared link
 * visibility.
 * @property {TeamLogSharedLinkVisibility} [previous_value] - Previous shared
 * link visibility. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkChangeVisibilityType
 * @property {string} description
 */

/**
 * Added file/folder to Dropbox from shared link.
 * @typedef {Object} TeamLogSharedLinkCopyDetails
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_link_owner] - Shared link owner details. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkCopyType
 * @property {string} description
 */

/**
 * Created shared link.
 * @typedef {Object} TeamLogSharedLinkCreateDetails
 * @property {TeamLogSharedLinkAccessLevel} [shared_link_access_level] - Defines
 * who can access the shared link. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkCreateType
 * @property {string} description
 */

/**
 * Removed shared link.
 * @typedef {Object} TeamLogSharedLinkDisableDetails
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_link_owner] - Shared link owner details. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkDisableType
 * @property {string} description
 */

/**
 * Downloaded file/folder from shared link.
 * @typedef {Object} TeamLogSharedLinkDownloadDetails
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_link_owner] - Shared link owner details. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkDownloadType
 * @property {string} description
 */

/**
 * Removed shared link expiration date.
 * @typedef {Object} TeamLogSharedLinkRemoveExpiryDetails
 * @property {Timestamp} [previous_value] - Previous shared link expiration
 * date. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkRemoveExpiryType
 * @property {string} description
 */

/**
 * Added members as audience of shared link.
 * @typedef {Object} TeamLogSharedLinkShareDetails
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_link_owner] - Shared link owner details. Might be missing due to
 * historical data gap.
 * @property {Array.<TeamLogExternalUserLogInfo>} [external_users] - Users
 * without a Dropbox account that were added as shared link audience.
 */

/**
 * @typedef {Object} TeamLogSharedLinkShareType
 * @property {string} description
 */

/**
 * Opened shared link.
 * @typedef {Object} TeamLogSharedLinkViewDetails
 * @property
 * {(TeamLogTeamMemberLogInfo|TeamLogTrustedNonTeamMemberLogInfo|TeamLogNonTeamMemberLogInfo|TeamLogUserLogInfo)}
 * [shared_link_owner] - Shared link owner details. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharedLinkViewType
 * @property {string} description
 */

/**
 * Defines who has access to a shared link.
 * @typedef {Object} TeamLogSharedLinkVisibility
 * @property {('password'|'public'|'team_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Opened shared Paper doc.
 * @typedef {Object} TeamLogSharedNoteOpenedDetails
 */

/**
 * @typedef {Object} TeamLogSharedNoteOpenedType
 * @property {string} description
 */

/**
 * Changed whether team members can join shared folders owned outside team.
 * @typedef {Object} TeamLogSharingChangeFolderJoinPolicyDetails
 * @property {TeamLogSharingFolderJoinPolicy} new_value - New external join
 * policy.
 * @property {TeamLogSharingFolderJoinPolicy} [previous_value] - Previous
 * external join policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharingChangeFolderJoinPolicyType
 * @property {string} description
 */

/**
 * Changed whether members can share links outside team, and if links are
 * accessible only by team members or anyone by default.
 * @typedef {Object} TeamLogSharingChangeLinkPolicyDetails
 * @property {TeamLogSharingLinkPolicy} new_value - New external link
 * accessibility policy.
 * @property {TeamLogSharingLinkPolicy} [previous_value] - Previous external
 * link accessibility policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharingChangeLinkPolicyType
 * @property {string} description
 */

/**
 * Changed whether members can share files/folders outside team.
 * @typedef {Object} TeamLogSharingChangeMemberPolicyDetails
 * @property {TeamLogSharingMemberPolicy} new_value - New external invite
 * policy.
 * @property {TeamLogSharingMemberPolicy} [previous_value] - Previous external
 * invite policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSharingChangeMemberPolicyType
 * @property {string} description
 */

/**
 * Policy for controlling if team members can join shared folders owned by non
 * team members.
 * @typedef {Object} TeamLogSharingFolderJoinPolicy
 * @property {('from_anyone'|'from_team_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policy for controlling if team members can share links externally
 * @typedef {Object} TeamLogSharingLinkPolicy
 * @property {('default_private'|'default_public'|'only_private'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * External sharing policy
 * @typedef {Object} TeamLogSharingMemberPolicy
 * @property {('allow'|'forbid'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Shared link with group.
 * @typedef {Object} TeamLogShmodelGroupShareDetails
 */

/**
 * @typedef {Object} TeamLogShmodelGroupShareType
 * @property {string} description
 */

/**
 * Granted access to showcase.
 * @typedef {Object} TeamLogShowcaseAccessGrantedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseAccessGrantedType
 * @property {string} description
 */

/**
 * Added member to showcase.
 * @typedef {Object} TeamLogShowcaseAddMemberDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseAddMemberType
 * @property {string} description
 */

/**
 * Archived showcase.
 * @typedef {Object} TeamLogShowcaseArchivedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseArchivedType
 * @property {string} description
 */

/**
 * Enabled/disabled downloading files from Dropbox Showcase for team.
 * @typedef {Object} TeamLogShowcaseChangeDownloadPolicyDetails
 * @property {TeamLogShowcaseDownloadPolicy} new_value - New Dropbox Showcase
 * download policy.
 * @property {TeamLogShowcaseDownloadPolicy} previous_value - Previous Dropbox
 * Showcase download policy.
 */

/**
 * @typedef {Object} TeamLogShowcaseChangeDownloadPolicyType
 * @property {string} description
 */

/**
 * Enabled/disabled Dropbox Showcase for team.
 * @typedef {Object} TeamLogShowcaseChangeEnabledPolicyDetails
 * @property {TeamLogShowcaseEnabledPolicy} new_value - New Dropbox Showcase
 * policy.
 * @property {TeamLogShowcaseEnabledPolicy} previous_value - Previous Dropbox
 * Showcase policy.
 */

/**
 * @typedef {Object} TeamLogShowcaseChangeEnabledPolicyType
 * @property {string} description
 */

/**
 * Enabled/disabled sharing Dropbox Showcase externally for team.
 * @typedef {Object} TeamLogShowcaseChangeExternalSharingPolicyDetails
 * @property {TeamLogShowcaseExternalSharingPolicy} new_value - New Dropbox
 * Showcase external sharing policy.
 * @property {TeamLogShowcaseExternalSharingPolicy} previous_value - Previous
 * Dropbox Showcase external sharing policy.
 */

/**
 * @typedef {Object} TeamLogShowcaseChangeExternalSharingPolicyType
 * @property {string} description
 */

/**
 * Created showcase.
 * @typedef {Object} TeamLogShowcaseCreatedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseCreatedType
 * @property {string} description
 */

/**
 * Deleted showcase comment.
 * @typedef {Object} TeamLogShowcaseDeleteCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text.
 */

/**
 * @typedef {Object} TeamLogShowcaseDeleteCommentType
 * @property {string} description
 */

/**
 * Showcase document's logged information.
 * @typedef {Object} TeamLogShowcaseDocumentLogInfo
 * @property {string} showcase_id - Showcase document Id.
 * @property {string} showcase_title - Showcase document title.
 */

/**
 * Policy for controlling if files can be downloaded from Showcases by team
 * members
 * @typedef {Object} TeamLogShowcaseDownloadPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Edited showcase comment.
 * @typedef {Object} TeamLogShowcaseEditCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text.
 */

/**
 * @typedef {Object} TeamLogShowcaseEditCommentType
 * @property {string} description
 */

/**
 * Edited showcase.
 * @typedef {Object} TeamLogShowcaseEditedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseEditedType
 * @property {string} description
 */

/**
 * Policy for controlling whether Showcase is enabled.
 * @typedef {Object} TeamLogShowcaseEnabledPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policy for controlling if team members can share Showcases externally.
 * @typedef {Object} TeamLogShowcaseExternalSharingPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added file to showcase.
 * @typedef {Object} TeamLogShowcaseFileAddedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseFileAddedType
 * @property {string} description
 */

/**
 * Downloaded file from showcase.
 * @typedef {Object} TeamLogShowcaseFileDownloadDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} download_type - Showcase download type.
 */

/**
 * @typedef {Object} TeamLogShowcaseFileDownloadType
 * @property {string} description
 */

/**
 * Removed file from showcase.
 * @typedef {Object} TeamLogShowcaseFileRemovedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseFileRemovedType
 * @property {string} description
 */

/**
 * Viewed file in showcase.
 * @typedef {Object} TeamLogShowcaseFileViewDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseFileViewType
 * @property {string} description
 */

/**
 * Permanently deleted showcase.
 * @typedef {Object} TeamLogShowcasePermanentlyDeletedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcasePermanentlyDeletedType
 * @property {string} description
 */

/**
 * Added showcase comment.
 * @typedef {Object} TeamLogShowcasePostCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text.
 */

/**
 * @typedef {Object} TeamLogShowcasePostCommentType
 * @property {string} description
 */

/**
 * Removed member from showcase.
 * @typedef {Object} TeamLogShowcaseRemoveMemberDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseRemoveMemberType
 * @property {string} description
 */

/**
 * Renamed showcase.
 * @typedef {Object} TeamLogShowcaseRenamedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseRenamedType
 * @property {string} description
 */

/**
 * Requested access to showcase.
 * @typedef {Object} TeamLogShowcaseRequestAccessDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseRequestAccessType
 * @property {string} description
 */

/**
 * Resolved showcase comment.
 * @typedef {Object} TeamLogShowcaseResolveCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text.
 */

/**
 * @typedef {Object} TeamLogShowcaseResolveCommentType
 * @property {string} description
 */

/**
 * Unarchived showcase.
 * @typedef {Object} TeamLogShowcaseRestoredDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseRestoredType
 * @property {string} description
 */

/**
 * Deleted showcase (old version).
 * @typedef {Object} TeamLogShowcaseTrashedDeprecatedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseTrashedDeprecatedType
 * @property {string} description
 */

/**
 * Deleted showcase.
 * @typedef {Object} TeamLogShowcaseTrashedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseTrashedType
 * @property {string} description
 */

/**
 * Unresolved showcase comment.
 * @typedef {Object} TeamLogShowcaseUnresolveCommentDetails
 * @property {string} event_uuid - Event unique identifier.
 * @property {string} [comment_text] - Comment text.
 */

/**
 * @typedef {Object} TeamLogShowcaseUnresolveCommentType
 * @property {string} description
 */

/**
 * Restored showcase (old version).
 * @typedef {Object} TeamLogShowcaseUntrashedDeprecatedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseUntrashedDeprecatedType
 * @property {string} description
 */

/**
 * Restored showcase.
 * @typedef {Object} TeamLogShowcaseUntrashedDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseUntrashedType
 * @property {string} description
 */

/**
 * Viewed showcase.
 * @typedef {Object} TeamLogShowcaseViewDetails
 * @property {string} event_uuid - Event unique identifier.
 */

/**
 * @typedef {Object} TeamLogShowcaseViewType
 * @property {string} description
 */

/**
 * Ended admin sign-in-as session.
 * @typedef {Object} TeamLogSignInAsSessionEndDetails
 */

/**
 * @typedef {Object} TeamLogSignInAsSessionEndType
 * @property {string} description
 */

/**
 * Started admin sign-in-as session.
 * @typedef {Object} TeamLogSignInAsSessionStartDetails
 */

/**
 * @typedef {Object} TeamLogSignInAsSessionStartType
 * @property {string} description
 */

/**
 * Changed default Smart Sync setting for team members.
 * @typedef {Object} TeamLogSmartSyncChangePolicyDetails
 * @property {TeamPoliciesSmartSyncPolicy} [new_value] - New smart sync policy.
 * @property {TeamPoliciesSmartSyncPolicy} [previous_value] - Previous smart
 * sync policy.
 */

/**
 * @typedef {Object} TeamLogSmartSyncChangePolicyType
 * @property {string} description
 */

/**
 * Created Smart Sync non-admin devices report.
 * @typedef {Object} TeamLogSmartSyncCreateAdminPrivilegeReportDetails
 */

/**
 * @typedef {Object} TeamLogSmartSyncCreateAdminPrivilegeReportType
 * @property {string} description
 */

/**
 * Opted team into Smart Sync.
 * @typedef {Object} TeamLogSmartSyncNotOptOutDetails
 * @property {TeamLogSmartSyncOptOutPolicy} previous_value - Previous Smart Sync
 * opt out policy.
 * @property {TeamLogSmartSyncOptOutPolicy} new_value - New Smart Sync opt out
 * policy.
 */

/**
 * @typedef {Object} TeamLogSmartSyncNotOptOutType
 * @property {string} description
 */

/**
 * Opted team out of Smart Sync.
 * @typedef {Object} TeamLogSmartSyncOptOutDetails
 * @property {TeamLogSmartSyncOptOutPolicy} previous_value - Previous Smart Sync
 * opt out policy.
 * @property {TeamLogSmartSyncOptOutPolicy} new_value - New Smart Sync opt out
 * policy.
 */

/**
 * @typedef {Object} TeamLogSmartSyncOptOutPolicy
 * @property {('default'|'opted_out'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogSmartSyncOptOutType
 * @property {string} description
 */

/**
 * Space limit alert policy
 * @typedef {Object} TeamLogSpaceCapsType
 * @property {('hard'|'off'|'soft'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogSpaceLimitsStatus
 * @property {('within_quota'|'near_quota'|'over_quota'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Added X.509 certificate for SSO.
 * @typedef {Object} TeamLogSsoAddCertDetails
 * @property {TeamLogCertificate} certificate_details - SSO certificate details.
 */

/**
 * @typedef {Object} TeamLogSsoAddCertType
 * @property {string} description
 */

/**
 * Added sign-in URL for SSO.
 * @typedef {Object} TeamLogSsoAddLoginUrlDetails
 * @property {string} new_value - New single sign-on login URL.
 */

/**
 * @typedef {Object} TeamLogSsoAddLoginUrlType
 * @property {string} description
 */

/**
 * Added sign-out URL for SSO.
 * @typedef {Object} TeamLogSsoAddLogoutUrlDetails
 * @property {string} [new_value] - New single sign-on logout URL. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSsoAddLogoutUrlType
 * @property {string} description
 */

/**
 * Changed X.509 certificate for SSO.
 * @typedef {Object} TeamLogSsoChangeCertDetails
 * @property {TeamLogCertificate} new_certificate_details - New SSO certificate
 * details.
 * @property {TeamLogCertificate} [previous_certificate_details] - Previous SSO
 * certificate details. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSsoChangeCertType
 * @property {string} description
 */

/**
 * Changed sign-in URL for SSO.
 * @typedef {Object} TeamLogSsoChangeLoginUrlDetails
 * @property {string} previous_value - Previous single sign-on login URL.
 * @property {string} new_value - New single sign-on login URL.
 */

/**
 * @typedef {Object} TeamLogSsoChangeLoginUrlType
 * @property {string} description
 */

/**
 * Changed sign-out URL for SSO.
 * @typedef {Object} TeamLogSsoChangeLogoutUrlDetails
 * @property {string} [previous_value] - Previous single sign-on logout URL.
 * Might be missing due to historical data gap.
 * @property {string} [new_value] - New single sign-on logout URL. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSsoChangeLogoutUrlType
 * @property {string} description
 */

/**
 * Changed single sign-on setting for team.
 * @typedef {Object} TeamLogSsoChangePolicyDetails
 * @property {TeamPoliciesSsoPolicy} new_value - New single sign-on policy.
 * @property {TeamPoliciesSsoPolicy} [previous_value] - Previous single sign-on
 * policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogSsoChangePolicyType
 * @property {string} description
 */

/**
 * Changed SAML identity mode for SSO.
 * @typedef {Object} TeamLogSsoChangeSamlIdentityModeDetails
 * @property {number} previous_value - Previous single sign-on identity mode.
 * @property {number} new_value - New single sign-on identity mode.
 */

/**
 * @typedef {Object} TeamLogSsoChangeSamlIdentityModeType
 * @property {string} description
 */

/**
 * Failed to sign in via SSO.
 * @typedef {Object} TeamLogSsoErrorDetails
 * @property {TeamLogFailureDetailsLogInfo} error_details - Error details.
 */

/**
 * @typedef {Object} TeamLogSsoErrorType
 * @property {string} description
 */

/**
 * Removed X.509 certificate for SSO.
 * @typedef {Object} TeamLogSsoRemoveCertDetails
 */

/**
 * @typedef {Object} TeamLogSsoRemoveCertType
 * @property {string} description
 */

/**
 * Removed sign-in URL for SSO.
 * @typedef {Object} TeamLogSsoRemoveLoginUrlDetails
 * @property {string} previous_value - Previous single sign-on login URL.
 */

/**
 * @typedef {Object} TeamLogSsoRemoveLoginUrlType
 * @property {string} description
 */

/**
 * Removed sign-out URL for SSO.
 * @typedef {Object} TeamLogSsoRemoveLogoutUrlDetails
 * @property {string} previous_value - Previous single sign-on logout URL.
 */

/**
 * @typedef {Object} TeamLogSsoRemoveLogoutUrlType
 * @property {string} description
 */

/**
 * Created team activity report.
 * @typedef {Object} TeamLogTeamActivityCreateReportDetails
 * @property {Timestamp} start_date - Report start date.
 * @property {Timestamp} end_date - Report end date.
 */

/**
 * Couldn't generate team activity report.
 * @typedef {Object} TeamLogTeamActivityCreateReportFailDetails
 * @property {TeamTeamReportFailureReason} failure_reason - Failure reason.
 */

/**
 * @typedef {Object} TeamLogTeamActivityCreateReportFailType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTeamActivityCreateReportType
 * @property {string} description
 */

/**
 * An audit log event.
 * @typedef {Object} TeamLogTeamEvent
 * @property {Timestamp} timestamp - The Dropbox timestamp representing when the
 * action was taken.
 * @property {TeamLogEventCategory} event_category - The category that this type
 * of action belongs to.
 * @property {TeamLogEventType} event_type - The particular type of action
 * taken.
 * @property {TeamLogEventDetails} details - The variable event schema
 * applicable to this type of action, instantiated with respect to this
 * particular action.
 * @property {TeamLogActorLogInfo} [actor] - The entity who actually performed
 * the action. Might be missing due to historical data gap.
 * @property {TeamLogOriginLogInfo} [origin] - The origin from which the actor
 * performed the action including information about host, ip address, location,
 * session, etc. If the action was performed programmatically via the API the
 * origin represents the API client.
 * @property {boolean} [involve_non_team_member] - True if the action involved a
 * non team member either as the actor or as one of the affected users. Might be
 * missing due to historical data gap.
 * @property {TeamLogContextLogInfo} [context] - The user or team on whose
 * behalf the actor performed the action. Might be missing due to historical
 * data gap.
 * @property {Array.<TeamLogParticipantLogInfo>} [participants] - Zero or more
 * users and/or groups that are affected by the action. Note that this list
 * doesn't include any actors or users in context.
 * @property {Array.<TeamLogAssetLogInfo>} [assets] - Zero or more content
 * assets involved in the action. Currently these include Dropbox files and
 * folders but in the future we might add other asset types such as Paper
 * documents, folders, projects, etc.
 */

/**
 * Policy for controlling whether App Integrations are enabled for the team.
 * @typedef {Object} TeamLogTeamExtensionsPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Changed App Integrations setting for team.
 * @typedef {Object} TeamLogTeamExtensionsPolicyChangedDetails
 * @property {TeamLogTeamExtensionsPolicy} new_value - New Extensions policy.
 * @property {TeamLogTeamExtensionsPolicy} previous_value - Previous Extensions
 * policy.
 */

/**
 * @typedef {Object} TeamLogTeamExtensionsPolicyChangedType
 * @property {string} description
 */

/**
 * Changed archival status of team folder.
 * @typedef {Object} TeamLogTeamFolderChangeStatusDetails
 * @property {TeamTeamFolderStatus} new_value - New team folder status.
 * @property {TeamTeamFolderStatus} [previous_value] - Previous team folder
 * status. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogTeamFolderChangeStatusType
 * @property {string} description
 */

/**
 * Created team folder in active status.
 * @typedef {Object} TeamLogTeamFolderCreateDetails
 */

/**
 * @typedef {Object} TeamLogTeamFolderCreateType
 * @property {string} description
 */

/**
 * Downgraded team folder to regular shared folder.
 * @typedef {Object} TeamLogTeamFolderDowngradeDetails
 * @property {number} target_asset_index - Target asset position in the Assets
 * list.
 */

/**
 * @typedef {Object} TeamLogTeamFolderDowngradeType
 * @property {string} description
 */

/**
 * Permanently deleted archived team folder.
 * @typedef {Object} TeamLogTeamFolderPermanentlyDeleteDetails
 */

/**
 * @typedef {Object} TeamLogTeamFolderPermanentlyDeleteType
 * @property {string} description
 */

/**
 * Renamed active/archived team folder.
 * @typedef {Object} TeamLogTeamFolderRenameDetails
 * @property {string} previous_folder_name - Previous folder name.
 * @property {string} new_folder_name - New folder name.
 */

/**
 * @typedef {Object} TeamLogTeamFolderRenameType
 * @property {string} description
 */

/**
 * Team linked app
 * @typedef {Object} TeamLogTeamLinkedAppLogInfo
@property {'team_linked_app'} [.tag] - Tag identifying this subtype variant.
This field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} [app_id] - App unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - App display name. Might be missing due to
 * historical data gap.
 */

/**
 * Team member's logged information.
 * @typedef {Object} TeamLogTeamMemberLogInfo
@property {'team_member'} [.tag] - Tag identifying this subtype variant. This
field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} [account_id] - User unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - User display name. Might be missing due
 * to historical data gap.
 * @property {string} [email] - User email address. Might be missing due to
 * historical data gap.
 * @property {string} [team_member_id] - Team member ID. Might be missing due to
 * historical data gap.
 * @property {string} [member_external_id] - Team member external ID.
 */

/**
 * @typedef {Object} TeamLogTeamMembershipType
 * @property {('free'|'full'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Merged another team into this team.
 * @typedef {Object} TeamLogTeamMergeFromDetails
 * @property {string} team_name - The name of the team that was merged into this
 * team.
 */

/**
 * @typedef {Object} TeamLogTeamMergeFromType
 * @property {string} description
 */

/**
 * Accepted a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedDetails
 * @property {TeamLogTeamMergeRequestAcceptedExtraDetails}
 * request_accepted_details - Team merge request acceptance details.
 */

/**
 * Team merge request acceptance details
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedExtraDetails
 * @property {TeamLogPrimaryTeamRequestAcceptedDetails} [primary_team] -
 * Available if .tag is primary_team. Team merge request accepted details shown
 * to the primary team.
 * @property {TeamLogSecondaryTeamRequestAcceptedDetails} [secondary_team] -
 * Available if .tag is secondary_team. Team merge request accepted details
 * shown to the secondary team.
 * @property {('primary_team'|'secondary_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Accepted a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Accepted a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedShownToSecondaryTeamDetails
 * @property {string} primary_team - The primary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestAcceptedType
 * @property {string} description
 */

/**
 * Automatically canceled team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestAutoCanceledDetails
 * @property {string} [details] - The cancellation reason.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestAutoCanceledType
 * @property {string} description
 */

/**
 * Canceled a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestCanceledDetails
 * @property {TeamLogTeamMergeRequestCanceledExtraDetails}
 * request_canceled_details - Team merge request cancellation details.
 */

/**
 * Team merge request cancellation details
 * @typedef {Object} TeamLogTeamMergeRequestCanceledExtraDetails
 * @property {TeamLogPrimaryTeamRequestCanceledDetails} [primary_team] -
 * Available if .tag is primary_team. Team merge request cancellation details
 * shown to the primary team.
 * @property {TeamLogSecondaryTeamRequestCanceledDetails} [secondary_team] -
 * Available if .tag is secondary_team. Team merge request cancellation details
 * shown to the secondary team.
 * @property {('primary_team'|'secondary_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Canceled a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestCanceledShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestCanceledShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Canceled a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestCanceledShownToSecondaryTeamDetails
 * @property {string} sent_to - The email of the primary team admin that the
 * request was sent to.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestCanceledShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestCanceledType
 * @property {string} description
 */

/**
 * Team merge request expired.
 * @typedef {Object} TeamLogTeamMergeRequestExpiredDetails
 * @property {TeamLogTeamMergeRequestExpiredExtraDetails}
 * request_expired_details - Team merge request expiration details.
 */

/**
 * Team merge request expiration details
 * @typedef {Object} TeamLogTeamMergeRequestExpiredExtraDetails
 * @property {TeamLogPrimaryTeamRequestExpiredDetails} [primary_team] -
 * Available if .tag is primary_team. Team merge request canceled details shown
 * to the primary team.
 * @property {TeamLogSecondaryTeamRequestExpiredDetails} [secondary_team] -
 * Available if .tag is secondary_team. Team merge request canceled details
 * shown to the secondary team.
 * @property {('primary_team'|'secondary_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Team merge request expired.
 * @typedef {Object} TeamLogTeamMergeRequestExpiredShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestExpiredShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Team merge request expired.
 * @typedef {Object} TeamLogTeamMergeRequestExpiredShownToSecondaryTeamDetails
 * @property {string} sent_to - The email of the primary team admin the request
 * was sent to.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestExpiredShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestExpiredType
 * @property {string} description
 */

/**
 * Rejected a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestRejectedShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestRejectedShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Rejected a team merge request.
 * @typedef {Object} TeamLogTeamMergeRequestRejectedShownToSecondaryTeamDetails
 * @property {string} sent_by - The name of the secondary team admin who sent
 * the request originally.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestRejectedShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * Sent a team merge request reminder.
 * @typedef {Object} TeamLogTeamMergeRequestReminderDetails
 * @property {TeamLogTeamMergeRequestReminderExtraDetails}
 * request_reminder_details - Team merge request reminder details.
 */

/**
 * Team merge request reminder details
 * @typedef {Object} TeamLogTeamMergeRequestReminderExtraDetails
 * @property {TeamLogPrimaryTeamRequestReminderDetails} [primary_team] -
 * Available if .tag is primary_team. Team merge request reminder details shown
 * to the primary team.
 * @property {TeamLogSecondaryTeamRequestReminderDetails} [secondary_team] -
 * Available if .tag is secondary_team. Team merge request reminder details
 * shown to the secondary team.
 * @property {('primary_team'|'secondary_team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Sent a team merge request reminder.
 * @typedef {Object} TeamLogTeamMergeRequestReminderShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_to - The name of the primary team admin the request
 * was sent to.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestReminderShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Sent a team merge request reminder.
 * @typedef {Object} TeamLogTeamMergeRequestReminderShownToSecondaryTeamDetails
 * @property {string} sent_to - The email of the primary team admin the request
 * was sent to.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestReminderShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestReminderType
 * @property {string} description
 */

/**
 * Canceled the team merge.
 * @typedef {Object} TeamLogTeamMergeRequestRevokedDetails
 * @property {string} team - The name of the other team.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestRevokedType
 * @property {string} description
 */

/**
 * Requested to merge their Dropbox team into yours.
 * @typedef {Object} TeamLogTeamMergeRequestSentShownToPrimaryTeamDetails
 * @property {string} secondary_team - The secondary team name.
 * @property {string} sent_to - The name of the primary team admin the request
 * was sent to.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestSentShownToPrimaryTeamType
 * @property {string} description
 */

/**
 * Requested to merge your team into another Dropbox team.
 * @typedef {Object} TeamLogTeamMergeRequestSentShownToSecondaryTeamDetails
 * @property {string} sent_to - The email of the primary team admin the request
 * was sent to.
 */

/**
 * @typedef {Object} TeamLogTeamMergeRequestSentShownToSecondaryTeamType
 * @property {string} description
 */

/**
 * Merged this team into another team.
 * @typedef {Object} TeamLogTeamMergeToDetails
 * @property {string} team_name - The name of the team that this team was merged
 * into.
 */

/**
 * @typedef {Object} TeamLogTeamMergeToType
 * @property {string} description
 */

/**
 * Team name details
 * @typedef {Object} TeamLogTeamName
 * @property {string} team_display_name - Team's display name.
 * @property {string} team_legal_name - Team's legal name.
 */

/**
 * Added team logo to display on shared link headers.
 * @typedef {Object} TeamLogTeamProfileAddLogoDetails
 */

/**
 * @typedef {Object} TeamLogTeamProfileAddLogoType
 * @property {string} description
 */

/**
 * Changed default language for team.
 * @typedef {Object} TeamLogTeamProfileChangeDefaultLanguageDetails
 * @property {string} new_value - New team's default language.
 * @property {string} previous_value - Previous team's default language.
 */

/**
 * @typedef {Object} TeamLogTeamProfileChangeDefaultLanguageType
 * @property {string} description
 */

/**
 * Changed team logo displayed on shared link headers.
 * @typedef {Object} TeamLogTeamProfileChangeLogoDetails
 */

/**
 * @typedef {Object} TeamLogTeamProfileChangeLogoType
 * @property {string} description
 */

/**
 * Changed team name.
 * @typedef {Object} TeamLogTeamProfileChangeNameDetails
 * @property {TeamLogTeamName} new_value - New team name.
 * @property {TeamLogTeamName} [previous_value] - Previous teams name. Might be
 * missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogTeamProfileChangeNameType
 * @property {string} description
 */

/**
 * Removed team logo displayed on shared link headers.
 * @typedef {Object} TeamLogTeamProfileRemoveLogoDetails
 */

/**
 * @typedef {Object} TeamLogTeamProfileRemoveLogoType
 * @property {string} description
 */

/**
 * Policy for controlling whether team selective sync is enabled for team.
 * @typedef {Object} TeamLogTeamSelectiveSyncPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Enabled/disabled Team Selective Sync for team.
 * @typedef {Object} TeamLogTeamSelectiveSyncPolicyChangedDetails
 * @property {TeamLogTeamSelectiveSyncPolicy} new_value - New Team Selective
 * Sync policy.
 * @property {TeamLogTeamSelectiveSyncPolicy} previous_value - Previous Team
 * Selective Sync policy.
 */

/**
 * @typedef {Object} TeamLogTeamSelectiveSyncPolicyChangedType
 * @property {string} description
 */

/**
 * Changed sync default.
 * @typedef {Object} TeamLogTeamSelectiveSyncSettingsChangedDetails
 * @property {FilesSyncSetting} previous_value - Previous value.
 * @property {FilesSyncSetting} new_value - New value.
 */

/**
 * @typedef {Object} TeamLogTeamSelectiveSyncSettingsChangedType
 * @property {string} description
 */

/**
 * Added backup phone for two-step verification.
 * @typedef {Object} TeamLogTfaAddBackupPhoneDetails
 */

/**
 * @typedef {Object} TeamLogTfaAddBackupPhoneType
 * @property {string} description
 */

/**
 * Added security key for two-step verification.
 * @typedef {Object} TeamLogTfaAddSecurityKeyDetails
 */

/**
 * @typedef {Object} TeamLogTfaAddSecurityKeyType
 * @property {string} description
 */

/**
 * Changed backup phone for two-step verification.
 * @typedef {Object} TeamLogTfaChangeBackupPhoneDetails
 */

/**
 * @typedef {Object} TeamLogTfaChangeBackupPhoneType
 * @property {string} description
 */

/**
 * Changed two-step verification setting for team.
 * @typedef {Object} TeamLogTfaChangePolicyDetails
 * @property {TeamPoliciesTwoStepVerificationPolicy} new_value - New change
 * policy.
 * @property {TeamPoliciesTwoStepVerificationPolicy} [previous_value] - Previous
 * change policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogTfaChangePolicyType
 * @property {string} description
 */

/**
 * Enabled/disabled/changed two-step verification setting.
 * @typedef {Object} TeamLogTfaChangeStatusDetails
 * @property {TeamLogTfaConfiguration} new_value - The new two factor
 * authentication configuration.
 * @property {TeamLogTfaConfiguration} [previous_value] - The previous two
 * factor authentication configuration. Might be missing due to historical data
 * gap.
 * @property {boolean} [used_rescue_code] - Used two factor authentication
 * rescue code. This flag is relevant when the two factor authentication
 * configuration is disabled.
 */

/**
 * @typedef {Object} TeamLogTfaChangeStatusType
 * @property {string} description
 */

/**
 * Two factor authentication configuration. Note: the enabled option is
 * deprecated.
 * @typedef {Object} TeamLogTfaConfiguration
 * @property {('disabled'|'enabled'|'sms'|'authenticator'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Removed backup phone for two-step verification.
 * @typedef {Object} TeamLogTfaRemoveBackupPhoneDetails
 */

/**
 * @typedef {Object} TeamLogTfaRemoveBackupPhoneType
 * @property {string} description
 */

/**
 * Removed security key for two-step verification.
 * @typedef {Object} TeamLogTfaRemoveSecurityKeyDetails
 */

/**
 * @typedef {Object} TeamLogTfaRemoveSecurityKeyType
 * @property {string} description
 */

/**
 * Reset two-step verification for team member.
 * @typedef {Object} TeamLogTfaResetDetails
 */

/**
 * @typedef {Object} TeamLogTfaResetType
 * @property {string} description
 */

/**
 * @typedef {Object} TeamLogTimeUnit
 * @property {('milliseconds'|'seconds'|'minutes'|'hours'|'days'|'weeks'|'months'|'years'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User that is not a member of the team but considered trusted.
 * @typedef {Object} TeamLogTrustedNonTeamMemberLogInfo
@property {'trusted_non_team_member'} [.tag] - Tag identifying this subtype
variant. This field is only present when needed to discriminate between multiple
possible subtypes.
 * @property {TeamLogTrustedNonTeamMemberType} trusted_non_team_member_type -
 * Indicates the type of the trusted non team member user.
 * @property {string} [account_id] - User unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - User display name. Might be missing due
 * to historical data gap.
 * @property {string} [email] - User email address. Might be missing due to
 * historical data gap.
 */

/**
 * @typedef {Object} TeamLogTrustedNonTeamMemberType
 * @property {('multi_instance_admin'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogTrustedTeamsRequestAction
 * @property {('invited'|'expired'|'revoked'|'accepted'|'declined'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamLogTrustedTeamsRequestState
 * @property {('invited'|'linked'|'unlinked'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Enabled/disabled option for members to link personal Dropbox account and team
 * account to same computer.
 * @typedef {Object} TeamLogTwoAccountChangePolicyDetails
 * @property {TeamLogTwoAccountPolicy} new_value - New two account policy.
 * @property {TeamLogTwoAccountPolicy} [previous_value] - Previous two account
 * policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogTwoAccountChangePolicyType
 * @property {string} description
 */

/**
 * Policy for pairing personal account to work account
 * @typedef {Object} TeamLogTwoAccountPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * User linked app
 * @typedef {Object} TeamLogUserLinkedAppLogInfo
@property {'user_linked_app'} [.tag] - Tag identifying this subtype variant.
This field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} [app_id] - App unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - App display name. Might be missing due to
 * historical data gap.
 */

/**
 * User's logged information.
 * @typedef {Object} TeamLogUserLogInfo
@property {("team_member"|"trusted_non_team_member"|"non_team_member")} .tag -
Tag identifying the subtype variant.
 * @property {string} [account_id] - User unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - User display name. Might be missing due
 * to historical data gap.
 * @property {string} [email] - User email address. Might be missing due to
 * historical data gap.
 */

/**
 * User's name logged information
 * @typedef {Object} TeamLogUserNameLogInfo
 * @property {string} given_name - Given name.
 * @property {string} surname - Surname.
 * @property {string} [locale] - Locale. Might be missing due to historical data
 * gap.
 */

/**
 * User or team linked app. Used when linked type is missing due to historical
 * data gap.
 * @typedef {Object} TeamLogUserOrTeamLinkedAppLogInfo
@property {'user_or_team_linked_app'} [.tag] - Tag identifying this subtype
variant. This field is only present when needed to discriminate between multiple
possible subtypes.
 * @property {string} [app_id] - App unique ID. Might be missing due to
 * historical data gap.
 * @property {string} [display_name] - App display name. Might be missing due to
 * historical data gap.
 */

/**
 * Changed team policy for viewer info.
 * @typedef {Object} TeamLogViewerInfoPolicyChangedDetails
 * @property {TeamLogPassPolicy} previous_value - Previous Viewer Info policy.
 * @property {TeamLogPassPolicy} new_value - New Viewer Info policy.
 */

/**
 * @typedef {Object} TeamLogViewerInfoPolicyChangedType
 * @property {string} description
 */

/**
 * Information on active web sessions
 * @typedef {Object} TeamLogWebDeviceSessionLogInfo
@property {'web_device_session'} [.tag] - Tag identifying this subtype variant.
This field is only present when needed to discriminate between multiple possible
subtypes.
 * @property {string} user_agent - Information on the hosting device.
 * @property {string} os - Information on the hosting operating system.
 * @property {string} browser - Information on the browser used for this web
 * session.
 * @property {string} [ip_address] - The IP address of the last activity from
 * this session. Might be missing due to historical data gap.
 * @property {Timestamp} [created] - The time this session was created. Might be
 * missing due to historical data gap.
 * @property {Timestamp} [updated] - The time of the last activity from this
 * session. Might be missing due to historical data gap.
 * @property {TeamLogWebSessionLogInfo} [session_info] - Web session unique id.
 * Might be missing due to historical data gap.
 */

/**
 * Web session.
 * @typedef {Object} TeamLogWebSessionLogInfo
@property {'web'} [.tag] - Tag identifying this subtype variant. This field is
only present when needed to discriminate between multiple possible subtypes.
 * @property {string} [session_id] - Session ID. Might be missing due to
 * historical data gap.
 */

/**
 * Changed how long members can stay signed in to Dropbox.com.
 * @typedef {Object} TeamLogWebSessionsChangeFixedLengthPolicyDetails
 * @property {TeamLogWebSessionsFixedLengthPolicy} [new_value] - New session
 * length policy. Might be missing due to historical data gap.
 * @property {TeamLogWebSessionsFixedLengthPolicy} [previous_value] - Previous
 * session length policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogWebSessionsChangeFixedLengthPolicyType
 * @property {string} description
 */

/**
 * Changed how long team members can be idle while signed in to Dropbox.com.
 * @typedef {Object} TeamLogWebSessionsChangeIdleLengthPolicyDetails
 * @property {TeamLogWebSessionsIdleLengthPolicy} [new_value] - New idle length
 * policy. Might be missing due to historical data gap.
 * @property {TeamLogWebSessionsIdleLengthPolicy} [previous_value] - Previous
 * idle length policy. Might be missing due to historical data gap.
 */

/**
 * @typedef {Object} TeamLogWebSessionsChangeIdleLengthPolicyType
 * @property {string} description
 */

/**
 * Web sessions fixed length policy.
 * @typedef {Object} TeamLogWebSessionsFixedLengthPolicy
 * @property {TeamLogDurationLogInfo} [defined] - Available if .tag is defined.
 * Defined fixed session length.
 * @property {('defined'|'undefined'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Web sessions idle length policy.
 * @typedef {Object} TeamLogWebSessionsIdleLengthPolicy
 * @property {TeamLogDurationLogInfo} [defined] - Available if .tag is defined.
 * Defined idle session length.
 * @property {('defined'|'undefined'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesCameraUploadsPolicyState
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesEmmState
 * @property {('disabled'|'optional'|'required'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesGroupCreation
 * @property {('admins_and_members'|'admins_only')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesOfficeAddInPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesPaperDefaultFolderPolicy
 * @property {('everyone_in_team'|'invite_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesPaperDeploymentPolicy
 * @property {('full'|'partial'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesPaperDesktopPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesPaperEnabledPolicy
 * @property {('disabled'|'enabled'|'unspecified'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesPasswordStrengthPolicy
 * @property {('minimal_requirements'|'moderate_password'|'strong_password'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesRolloutMethod
 * @property {('unlink_all'|'unlink_most_inactive'|'add_member_to_exceptions')} .tag - Tag identifying the union variant.
 */

/**
 * Policy governing which shared folders a team member can join.
 * @typedef {Object} TeamPoliciesSharedFolderJoinPolicy
 * @property {('from_team_only'|'from_anyone'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policy governing who can be a member of a folder shared by a team member.
 * @typedef {Object} TeamPoliciesSharedFolderMemberPolicy
 * @property {('team'|'anyone'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policy governing the visibility of shared links. This policy can apply to
 * newly created shared links, or all shared links.
 * @typedef {Object} TeamPoliciesSharedLinkCreatePolicy
 * @property {('default_public'|'default_team_only'|'team_only'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesShowcaseDownloadPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesShowcaseEnabledPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesShowcaseExternalSharingPolicy
 * @property {('disabled'|'enabled'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesSmartSyncPolicy
 * @property {('local'|'on_demand'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesSsoPolicy
 * @property {('disabled'|'optional'|'required'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Policies governing team members.
 * @typedef {Object} TeamPoliciesTeamMemberPolicies
 * @property {TeamPoliciesTeamSharingPolicies} sharing - Policies governing
 * sharing.
 * @property {TeamPoliciesEmmState} emm_state - This describes the Enterprise
 * Mobility Management (EMM) state for this team. This information can be used
 * to understand if an organization is integrating with a third-party EMM vendor
 * to further manage and apply restrictions upon the team's Dropbox usage on
 * mobile devices. This is a new feature and in the future we'll be adding more
 * new fields and additional documentation.
 * @property {TeamPoliciesOfficeAddInPolicy} office_addin - The admin policy
 * around the Dropbox Office Add-In for this team.
 */

/**
 * Policies governing sharing within and outside of the team.
 * @typedef {Object} TeamPoliciesTeamSharingPolicies
 * @property {TeamPoliciesSharedFolderMemberPolicy} shared_folder_member_policy
 * - Who can join folders shared by team members.
 * @property {TeamPoliciesSharedFolderJoinPolicy} shared_folder_join_policy -
 * Which shared folders team members can join.
 * @property {TeamPoliciesSharedLinkCreatePolicy} shared_link_create_policy -
 * Who can view shared links owned by team members.
 */

/**
 * @typedef {Object} TeamPoliciesTwoStepVerificationPolicy
 * @property {('require_tfa_enable'|'require_tfa_disable'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} TeamPoliciesTwoStepVerificationState
 * @property {('required'|'optional'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * The amount of detail revealed about an account depends on the user being
 * queried and the user making the query.
 * @typedef {Object} UsersAccount
 * @property {string} account_id - The user's unique Dropbox ID.
 * @property {UsersName} name - Details of a user's name.
 * @property {string} email - The user's e-mail address. Do not rely on this
 * without checking the email_verified field. Even then, it's possible that the
 * user has since lost access to their e-mail.
 * @property {boolean} email_verified - Whether the user has verified their
 * e-mail address.
 * @property {boolean} disabled - Whether the user has been disabled.
 * @property {string} [profile_photo_url] - URL for the photo representing the
 * user, if one is set.
 */

/**
 * Basic information about any account.
 * @typedef {Object} UsersBasicAccount
 * @property {string} account_id - The user's unique Dropbox ID.
 * @property {UsersName} name - Details of a user's name.
 * @property {string} email - The user's e-mail address. Do not rely on this
 * without checking the email_verified field. Even then, it's possible that the
 * user has since lost access to their e-mail.
 * @property {boolean} email_verified - Whether the user has verified their
 * e-mail address.
 * @property {boolean} disabled - Whether the user has been disabled.
 * @property {boolean} is_teammate - Whether this user is a teammate of the
 * current user. If this account is the current user's account, then this will
 * be true.
 * @property {string} [profile_photo_url] - URL for the photo representing the
 * user, if one is set.
 * @property {string} [team_member_id] - The user's unique team member id. This
 * field will only be present if the user is part of a team and is_teammate is
 * true.
 */

/**
 * Detailed information about the current user's account.
 * @typedef {Object} UsersFullAccount
 * @property {string} account_id - The user's unique Dropbox ID.
 * @property {UsersName} name - Details of a user's name.
 * @property {string} email - The user's e-mail address. Do not rely on this
 * without checking the email_verified field. Even then, it's possible that the
 * user has since lost access to their e-mail.
 * @property {boolean} email_verified - Whether the user has verified their
 * e-mail address.
 * @property {boolean} disabled - Whether the user has been disabled.
 * @property {string} locale - The language that the user specified. Locale tags
 * will be IETF language tags http://en.wikipedia.org/wiki/IETF_language_tag.
 * @property {string} referral_link - The user's referral link
 * https://www.dropbox.com/referrals.
 * @property {boolean} is_paired - Whether the user has a personal and work
 * account. If the current account is personal, then team will always be null,
 * but is_paired will indicate if a work account is linked.
 * @property {UsersCommonAccountType} account_type - What type of account this
 * user has.
 * @property {(CommonTeamRootInfo|CommonUserRootInfo|CommonRootInfo)} root_info
 * - The root info for this account.
 * @property {string} [profile_photo_url] - URL for the photo representing the
 * user, if one is set.
 * @property {string} [country] - The user's two-letter country code, if
 * available. Country codes are based on ISO 3166-1
 * http://en.wikipedia.org/wiki/ISO_3166-1.
 * @property {UsersFullTeam} [team] - If this account is a member of a team,
 * information about that team.
 * @property {string} [team_member_id] - This account's unique team member id.
 * This field will only be present if team is present.
 */

/**
 * Detailed information about a team.
 * @typedef {Object} UsersFullTeam
 * @property {string} id - The team's unique ID.
 * @property {string} name - The name of the team.
 * @property {TeamPoliciesTeamSharingPolicies} sharing_policies - Team policies
 * governing sharing.
 * @property {TeamPoliciesOfficeAddInPolicy} office_addin_policy - Team policy
 * governing the use of the Office Add-In.
 */

/**
 * @typedef {Object} UsersGetAccountArg
 * @property {string} account_id - A user's account identifier.
 */

/**
 * @typedef {Object} UsersGetAccountBatchArg
 * @property {Array.<Object>} account_ids - List of user account identifiers.
 * Should not contain any duplicate account IDs.
 */

/**
 * @typedef {Object} UsersGetAccountBatchError
 * @property {string} [no_account] - Available if .tag is no_account. The value
 * is an account ID specified in :field:`GetAccountBatchArg.account_ids` that
 * does not exist.
 * @property {('no_account'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} UsersGetAccountError
 * @property {('no_account'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * @typedef {Object} UsersIndividualSpaceAllocation
 * @property {number} allocated - The total space allocated to the user's
 * account (bytes).
 */

/**
 * Representations for a person's name to assist with internationalization.
 * @typedef {Object} UsersName
 * @property {string} given_name - Also known as a first name.
 * @property {string} surname - Also known as a last name or family name.
 * @property {string} familiar_name - Locale-dependent name. In the US, a
 * person's familiar name is their given_name, but elsewhere, it could be any
 * combination of a person's given_name and surname.
 * @property {string} display_name - A name that can be used directly to
 * represent the name of a user's Dropbox account.
 * @property {string} abbreviated_name - An abbreviated form of the person's
 * name. Their initials in most locales.
 */

/**
 * Space is allocated differently based on the type of account.
 * @typedef {Object} UsersSpaceAllocation
 * @property {UsersIndividualSpaceAllocation} [individual] - Available if .tag
 * is individual. The user's space allocation applies only to their individual
 * account.
 * @property {UsersTeamSpaceAllocation} [team] - Available if .tag is team. The
 * user shares space with other members of their team.
 * @property {('individual'|'team'|'other')} .tag - Tag identifying the union variant.
 */

/**
 * Information about a user's space usage and quota.
 * @typedef {Object} UsersSpaceUsage
 * @property {number} used - The user's total space usage (bytes).
 * @property {UsersSpaceAllocation} allocation - The user's space allocation.
 */

/**
 * Information about a team.
 * @typedef {Object} UsersTeam
 * @property {string} id - The team's unique ID.
 * @property {string} name - The name of the team.
 */

/**
 * @typedef {Object} UsersTeamSpaceAllocation
 * @property {number} used - The total space currently used by the user's team
 * (bytes).
 * @property {number} allocated - The total space allocated to the user's team
 * (bytes).
 * @property {number} user_within_team_space_allocated - The total space
 * allocated to the user within its team allocated space (0 means that no
 * restriction is imposed on the user's quota within its team).
 * @property {TeamCommonMemberSpaceLimitType} user_within_team_space_limit_type
 * - The type of the space limit imposed on the team member (off, alert_only,
 * stop_sync).
 */

/**
 * What type of account this user has.
 * @typedef {Object} UsersCommonAccountType
 * @property {('basic'|'pro'|'business')} .tag - Tag identifying the union variant.
 */
